/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.multi.qrcode.detector;

import java.util.ArrayList;
import java.util.Map;
import oz.util.barcode.DecodeHintType;
import oz.util.barcode.NotFoundException;
import oz.util.barcode.ReaderException;
import oz.util.barcode.ResultPointCallback;
import oz.util.barcode.common.BitMatrix;
import oz.util.barcode.common.DetectorResult;
import oz.util.barcode.multi.qrcode.detector.MultiFinderPatternFinder;
import oz.util.barcode.qrcode.detector.Detector;
import oz.util.barcode.qrcode.detector.FinderPatternInfo;

public final class MultiDetector
extends Detector {
    private static final DetectorResult[] EMPTY_DETECTOR_RESULTS = new DetectorResult[0];

    public MultiDetector(BitMatrix bitMatrix) {
        super(bitMatrix);
    }

    public DetectorResult[] detectMulti(Map map) {
        ResultPointCallback resultPointCallback;
        BitMatrix bitMatrix = this.getImage();
        MultiFinderPatternFinder multiFinderPatternFinder = new MultiFinderPatternFinder(bitMatrix, resultPointCallback = map == null ? null : (ResultPointCallback)map.get((Object)DecodeHintType.NEED_RESULT_POINT_CALLBACK));
        FinderPatternInfo[] finderPatternInfoArray = multiFinderPatternFinder.findMulti(map);
        if (finderPatternInfoArray.length == 0) {
            throw NotFoundException.getNotFoundInstance();
        }
        ArrayList<DetectorResult> arrayList = new ArrayList<DetectorResult>();
        FinderPatternInfo[] finderPatternInfoArray2 = finderPatternInfoArray;
        int n = finderPatternInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            FinderPatternInfo finderPatternInfo = finderPatternInfoArray2[n2];
            try {
                arrayList.add(this.processFinderPatternInfo(finderPatternInfo));
            }
            catch (ReaderException readerException) {
                // empty catch block
            }
            ++n2;
        }
        if (arrayList.isEmpty()) {
            return EMPTY_DETECTOR_RESULTS;
        }
        return arrayList.toArray(new DetectorResult[arrayList.size()]);
    }
}

