/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.oned;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import oz.util.barcode.BarcodeFormat;
import oz.util.barcode.common.BitMatrix;
import oz.util.barcode.oned.Code128Reader;
import oz.util.barcode.oned.OneDimensionalCodeWriter;

public final class Code128Writer
extends OneDimensionalCodeWriter {
    private static final int CODE_START_B = 104;
    private static final int CODE_START_C = 105;
    private static final int CODE_CODE_B = 100;
    private static final int CODE_CODE_C = 99;
    private static final int CODE_STOP = 106;
    private static final char ESCAPE_FNC_1 = '\u00f1';
    private static final char ESCAPE_FNC_2 = '\u00f2';
    private static final char ESCAPE_FNC_3 = '\u00f3';
    private static final char ESCAPE_FNC_4 = '\u00f4';
    private static final int CODE_FNC_1 = 102;
    private static final int CODE_FNC_2 = 97;
    private static final int CODE_FNC_3 = 96;
    private static final int CODE_FNC_4_B = 100;

    @Override
    public BitMatrix encode(String string, BarcodeFormat barcodeFormat, int n, int n2, Map map) {
        if (barcodeFormat != BarcodeFormat.CODE_128) {
            throw new IllegalArgumentException("Can only encode CODE_128, but got " + (Object)((Object)barcodeFormat));
        }
        return super.encode(string, barcodeFormat, n, n2, map);
    }

    @Override
    public boolean[] encode(String string) {
        int n;
        int n2;
        int n3 = string.length();
        if (n3 < 1 || n3 > 80) {
            throw new IllegalArgumentException("Contents length should be between 1 and 80 characters, but got " + n3);
        }
        int n4 = 0;
        while (n4 < n3) {
            n2 = string.charAt(n4);
            if (n2 < 32 || n2 > 126) {
                switch (n2) {
                    case 241: 
                    case 242: 
                    case 243: 
                    case 244: {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Bad character in input: " + (char)n2);
                    }
                }
            }
            ++n4;
        }
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        n2 = 0;
        int n5 = 1;
        int n6 = 0;
        int n7 = 0;
        while (n7 < n3) {
            int n8;
            n = n6 == 99 ? 2 : 4;
            int n9 = Code128Writer.isDigits(string, n7, n) ? 99 : 100;
            if (n9 == n6) {
                if (n6 == 100) {
                    n8 = string.charAt(n7) - 32;
                    ++n7;
                } else {
                    switch (string.charAt(n7)) {
                        case '\u00f1': {
                            n8 = 102;
                            ++n7;
                            break;
                        }
                        case '\u00f2': {
                            n8 = 97;
                            ++n7;
                            break;
                        }
                        case '\u00f3': {
                            n8 = 96;
                            ++n7;
                            break;
                        }
                        case '\u00f4': {
                            n8 = 100;
                            ++n7;
                            break;
                        }
                        default: {
                            n8 = Integer.parseInt(string.substring(n7, n7 + 2));
                            n7 += 2;
                            break;
                        }
                    }
                }
            } else {
                n8 = n6 == 0 ? (n9 == 100 ? 104 : 105) : n9;
                n6 = n9;
            }
            arrayList.add(Code128Reader.CODE_PATTERNS[n8]);
            n2 += n8 * n5;
            if (n7 == 0) continue;
            ++n5;
        }
        arrayList.add(Code128Reader.CODE_PATTERNS[n2 %= 103]);
        arrayList.add(Code128Reader.CODE_PATTERNS[106]);
        n = 0;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            int[] nArray;
            int[] nArray2 = nArray = (int[])iterator.next();
            int n10 = nArray.length;
            int n11 = 0;
            while (n11 < n10) {
                int n12 = nArray2[n11];
                n += n12;
                ++n11;
            }
        }
        boolean[] blArray = new boolean[n];
        int n13 = 0;
        for (int[] nArray : arrayList) {
            n13 += Code128Writer.appendPattern(blArray, n13, nArray, true);
        }
        return blArray;
    }

    private static boolean isDigits(CharSequence charSequence, int n, int n2) {
        int n3 = n + n2;
        int n4 = charSequence.length();
        int n5 = n;
        while (n5 < n3 && n5 < n4) {
            char c2 = charSequence.charAt(n5);
            if (c2 < '0' || c2 > '9') {
                if (c2 != '\u00f1') {
                    return false;
                }
                ++n3;
            }
            ++n5;
        }
        return n3 <= n4;
    }
}

