/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.oned;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import oz.util.barcode.BarcodeFormat;
import oz.util.barcode.DecodeHintType;
import oz.util.barcode.NotFoundException;
import oz.util.barcode.ReaderException;
import oz.util.barcode.Result;
import oz.util.barcode.common.BitArray;
import oz.util.barcode.oned.CodaBarReader;
import oz.util.barcode.oned.Code128Reader;
import oz.util.barcode.oned.Code39Reader;
import oz.util.barcode.oned.Code93Reader;
import oz.util.barcode.oned.ITFReader;
import oz.util.barcode.oned.MultiFormatUPCEANReader;
import oz.util.barcode.oned.OneDReader;
import oz.util.barcode.oned.rss.RSS14Reader;
import oz.util.barcode.oned.rss.expanded.RSSExpandedReader;

public final class MultiFormatOneDReader
extends OneDReader {
    private final OneDReader[] readers;

    public MultiFormatOneDReader(Map map) {
        Collection collection = map == null ? null : (Collection)map.get((Object)DecodeHintType.POSSIBLE_FORMATS);
        boolean bl = map != null && map.get((Object)DecodeHintType.ASSUME_CODE_39_CHECK_DIGIT) != null;
        ArrayList<OneDReader> arrayList = new ArrayList<OneDReader>();
        if (collection != null) {
            if (collection.contains((Object)BarcodeFormat.EAN_13) || collection.contains((Object)BarcodeFormat.UPC_A) || collection.contains((Object)BarcodeFormat.EAN_8) || collection.contains((Object)BarcodeFormat.UPC_E)) {
                arrayList.add(new MultiFormatUPCEANReader(map));
            }
            if (collection.contains((Object)BarcodeFormat.CODE_39)) {
                arrayList.add(new Code39Reader(bl));
            }
            if (collection.contains((Object)BarcodeFormat.CODE_93)) {
                arrayList.add(new Code93Reader());
            }
            if (collection.contains((Object)BarcodeFormat.CODE_128)) {
                arrayList.add(new Code128Reader());
            }
            if (collection.contains((Object)BarcodeFormat.ITF)) {
                arrayList.add(new ITFReader());
            }
            if (collection.contains((Object)BarcodeFormat.CODABAR)) {
                arrayList.add(new CodaBarReader());
            }
            if (collection.contains((Object)BarcodeFormat.RSS_14)) {
                arrayList.add(new RSS14Reader());
            }
            if (collection.contains((Object)BarcodeFormat.RSS_EXPANDED)) {
                arrayList.add(new RSSExpandedReader());
            }
        }
        if (arrayList.isEmpty()) {
            arrayList.add(new MultiFormatUPCEANReader(map));
            arrayList.add(new Code39Reader());
            arrayList.add(new CodaBarReader());
            arrayList.add(new Code93Reader());
            arrayList.add(new Code128Reader());
            arrayList.add(new ITFReader());
            arrayList.add(new RSS14Reader());
            arrayList.add(new RSSExpandedReader());
        }
        this.readers = arrayList.toArray(new OneDReader[arrayList.size()]);
    }

    @Override
    public Result decodeRow(int n, BitArray bitArray, Map map) {
        OneDReader[] oneDReaderArray = this.readers;
        int n2 = this.readers.length;
        int n3 = 0;
        while (n3 < n2) {
            OneDReader oneDReader = oneDReaderArray[n3];
            try {
                return oneDReader.decodeRow(n, bitArray, map);
            }
            catch (ReaderException readerException) {
                ++n3;
            }
        }
        throw NotFoundException.getNotFoundInstance();
    }

    @Override
    public void reset() {
        OneDReader[] oneDReaderArray = this.readers;
        int n = this.readers.length;
        int n2 = 0;
        while (n2 < n) {
            OneDReader oneDReader = oneDReaderArray[n2];
            oneDReader.reset();
            ++n2;
        }
    }
}

