/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.qrcode.decoder;

import oz.util.barcode.FormatException;
import oz.util.barcode.common.BitMatrix;
import oz.util.barcode.qrcode.decoder.DataMask;
import oz.util.barcode.qrcode.decoder.FormatInformation;
import oz.util.barcode.qrcode.decoder.Version;

final class BitMatrixParser {
    private final BitMatrix bitMatrix;
    private Version parsedVersion;
    private FormatInformation parsedFormatInfo;
    private boolean mirror;

    BitMatrixParser(BitMatrix bitMatrix) {
        int n = bitMatrix.getHeight();
        if (n < 21 || (n & 3) != 1) {
            throw FormatException.getFormatInstance();
        }
        this.bitMatrix = bitMatrix;
    }

    FormatInformation readFormatInformation() {
        if (this.parsedFormatInfo != null) {
            return this.parsedFormatInfo;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < 6) {
            n = this.copyBit(n2, 8, n);
            ++n2;
        }
        n = this.copyBit(7, 8, n);
        n = this.copyBit(8, 8, n);
        n = this.copyBit(8, 7, n);
        n2 = 5;
        while (n2 >= 0) {
            n = this.copyBit(8, n2, n);
            --n2;
        }
        n2 = this.bitMatrix.getHeight();
        int n3 = 0;
        int n4 = n2 - 7;
        int n5 = n2 - 1;
        while (n5 >= n4) {
            n3 = this.copyBit(8, n5, n3);
            --n5;
        }
        n5 = n2 - 8;
        while (n5 < n2) {
            n3 = this.copyBit(n5, 8, n3);
            ++n5;
        }
        this.parsedFormatInfo = FormatInformation.decodeFormatInformation(n, n3);
        if (this.parsedFormatInfo != null) {
            return this.parsedFormatInfo;
        }
        throw FormatException.getFormatInstance();
    }

    Version readVersion() {
        int n;
        if (this.parsedVersion != null) {
            return this.parsedVersion;
        }
        int n2 = this.bitMatrix.getHeight();
        int n3 = (n2 - 17) / 4;
        if (n3 <= 6) {
            return Version.getVersionForNumber(n3);
        }
        int n4 = 0;
        int n5 = n2 - 11;
        int n6 = 5;
        while (n6 >= 0) {
            n = n2 - 9;
            while (n >= n5) {
                n4 = this.copyBit(n, n6, n4);
                --n;
            }
            --n6;
        }
        Version version = Version.decodeVersionInformation(n4);
        if (version != null && version.getDimensionForVersion() == n2) {
            this.parsedVersion = version;
            return version;
        }
        n4 = 0;
        n = 5;
        while (n >= 0) {
            int n7 = n2 - 9;
            while (n7 >= n5) {
                n4 = this.copyBit(n, n7, n4);
                --n7;
            }
            --n;
        }
        version = Version.decodeVersionInformation(n4);
        if (version != null && version.getDimensionForVersion() == n2) {
            this.parsedVersion = version;
            return version;
        }
        throw FormatException.getFormatInstance();
    }

    private int copyBit(int n, int n2, int n3) {
        boolean bl = this.mirror ? this.bitMatrix.get(n2, n) : this.bitMatrix.get(n, n2);
        return bl ? n3 << 1 | 1 : n3 << 1;
    }

    byte[] readCodewords() {
        FormatInformation formatInformation = this.readFormatInformation();
        Version version = this.readVersion();
        DataMask dataMask = DataMask.forReference(formatInformation.getDataMask());
        int n = this.bitMatrix.getHeight();
        dataMask.unmaskBitMatrix(this.bitMatrix, n);
        BitMatrix bitMatrix = version.buildFunctionPattern();
        boolean bl = true;
        byte[] byArray = new byte[version.getTotalCodewords()];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = n - 1;
        while (n5 > 0) {
            if (n5 == 6) {
                --n5;
            }
            int n6 = 0;
            while (n6 < n) {
                int n7 = bl ? n - 1 - n6 : n6;
                int n8 = 0;
                while (n8 < 2) {
                    if (!bitMatrix.get(n5 - n8, n7)) {
                        ++n4;
                        n3 <<= 1;
                        if (this.bitMatrix.get(n5 - n8, n7)) {
                            n3 |= 1;
                        }
                        if (n4 == 8) {
                            byArray[n2++] = (byte)n3;
                            n4 = 0;
                            n3 = 0;
                        }
                    }
                    ++n8;
                }
                ++n6;
            }
            bl ^= true;
            n5 -= 2;
        }
        if (n2 != version.getTotalCodewords()) {
            throw FormatException.getFormatInstance();
        }
        return byArray;
    }

    void remask() {
        if (this.parsedFormatInfo == null) {
            return;
        }
        DataMask dataMask = DataMask.forReference(this.parsedFormatInfo.getDataMask());
        int n = this.bitMatrix.getHeight();
        dataMask.unmaskBitMatrix(this.bitMatrix, n);
    }

    void setMirror(boolean bl) {
        this.parsedVersion = null;
        this.parsedFormatInfo = null;
        this.mirror = bl;
    }

    void mirror() {
        int n = 0;
        while (n < this.bitMatrix.getWidth()) {
            int n2 = n + 1;
            while (n2 < this.bitMatrix.getHeight()) {
                if (this.bitMatrix.get(n, n2) != this.bitMatrix.get(n2, n)) {
                    this.bitMatrix.flip(n2, n);
                    this.bitMatrix.flip(n, n2);
                }
                ++n2;
            }
            ++n;
        }
    }
}

