/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.qrcode.decoder;

import oz.util.barcode.qrcode.decoder.Version;

public enum Mode {
    TERMINATOR(new int[3], 0),
    NUMERIC(new int[]{10, 12, 14}, 1),
    ALPHANUMERIC(new int[]{9, 11, 13}, 2),
    STRUCTURED_APPEND(new int[3], 3),
    BYTE(new int[]{8, 16, 16}, 4),
    ECI(new int[3], 7),
    KANJI(new int[]{8, 10, 12}, 8),
    FNC1_FIRST_POSITION(new int[3], 5),
    FNC1_SECOND_POSITION(new int[3], 9),
    HANZI(new int[]{8, 10, 12}, 13);

    private final int[] characterCountBitsForVersions;
    private final int bits;

    /*
     * WARNING - void declaration
     */
    private Mode() {
        void var4_1;
        void var3_2;
        this.characterCountBitsForVersions = var3_2;
        this.bits = var4_1;
    }

    public static Mode forBits(int n) {
        switch (n) {
            case 0: {
                return TERMINATOR;
            }
            case 1: {
                return NUMERIC;
            }
            case 2: {
                return ALPHANUMERIC;
            }
            case 3: {
                return STRUCTURED_APPEND;
            }
            case 4: {
                return BYTE;
            }
            case 5: {
                return FNC1_FIRST_POSITION;
            }
            case 7: {
                return ECI;
            }
            case 8: {
                return KANJI;
            }
            case 9: {
                return FNC1_SECOND_POSITION;
            }
            case 13: {
                return HANZI;
            }
        }
        throw new IllegalArgumentException();
    }

    public int getCharacterCountBits(Version version) {
        int n = version.getVersionNumber();
        int n2 = n <= 9 ? 0 : (n <= 26 ? 1 : 2);
        return this.characterCountBitsForVersions[n2];
    }

    public int getBits() {
        return this.bits;
    }
}

