/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.df.view;

import android.content.Context;
import android.util.DisplayMetrics;
import android.util.SparseArray;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.TranslateAnimation;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import java.util.LinkedList;
import oz.viewer.ui.df.view.BubbleTextLayout$BubbleInfo;
import oz.viewer.ui.df.view.BubbleTextLayout$BubbleInfoExtend;
import oz.viewer.ui.df.view.BubbleTextLayout$BubbleInfoViewMaker;
import oz.viewer.ui.df.view.BubbleTextLayout$BubbleTextLayoutHandler;
import oz.viewer.ui.df.view.BubbleTextLayout$ContainerLinearLayout;

public class BubbleTextLayout
extends RelativeLayout {
    public static final int DEFAULT_ANIMATION_DURATION = 200;
    private static final float SCALE_REMOVE_ANIMATION_DURATION = 0.5f;
    private static final int DEFAULT_MAXIMUM = 500;
    private static final int DP_REMOVE_TRANSLATE = 50;
    private static final int START_ID = 1;
    private static final int END_ID = 65534;
    private static final int A_FADE_IN = 0;
    private static final int A_FADE_OUT = 1;
    private static final int A_TRANSLATION_INSERT = 2;
    private static final int A_TRANSLATION_REMOVE = 3;
    private static final int A_COUNT = 4;
    private BubbleTextLayout$BubbleInfoViewMaker mMaker;
    private SparseArray mAnimationCache;
    private BubbleTextLayout$BubbleTextLayoutHandler mHandler;
    private LinkedList mInfo;
    private LinearLayout mContainer;
    private LinearLayout mFirstContainer;
    private int mAniDuration;
    private int mMaximum;
    private long mUniqueID;
    private boolean mUseFixedInsertAnimation;
    private static final int MSG_UPDATE = 1;
    private static final int MSG_REMOVE = 2;
    private static final int MSG_AUTO_REMOVE = 3;
    private static final int MSG_UPDATE_ANIMATE_COMPLETE = 4;
    private static final int ARGS_ANIMATE_FLAG = 1;
    private static final int ARGS_UPDATE_FLAG = 2;

    public BubbleTextLayout(Context context) {
        super(context);
        this.init();
    }

    private void init() {
        this.mUseFixedInsertAnimation = false;
        this.setLayoutMode(1);
        this.mHandler = new BubbleTextLayout$BubbleTextLayoutHandler(this, null);
        this.mInfo = new LinkedList();
        this.mAnimationCache = new SparseArray(4);
        this.mAniDuration = 200;
        this.mMaximum = 500;
        this.mUniqueID = 0L;
        this.initDummy();
        this.initContainer();
    }

    private void initDummy() {
        LinearLayout linearLayout = new LinearLayout(this.getContext());
        linearLayout.setId(65534);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(0, 0);
        layoutParams.addRule(12);
        this.addView((View)linearLayout, (ViewGroup.LayoutParams)layoutParams);
    }

    private void initContainer() {
        this.mFirstContainer = new BubbleTextLayout$ContainerLinearLayout(this, this.getContext());
        this.mFirstContainer.setGravity(81);
        this.mFirstContainer.setOrientation(1);
        this.mFirstContainer.setLayoutMode(1);
        this.mFirstContainer.setId(65535);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        layoutParams.addRule(2, 65534);
        layoutParams.addRule(14);
        this.addView((View)this.mFirstContainer, (ViewGroup.LayoutParams)layoutParams);
        this.mContainer = new BubbleTextLayout$ContainerLinearLayout(this, this.getContext());
        this.mContainer.setGravity(81);
        this.mContainer.setOrientation(1);
        this.mContainer.setLayoutMode(1);
        layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        layoutParams.addRule(2, 65535);
        layoutParams.addRule(14);
        this.addView((View)this.mContainer, (ViewGroup.LayoutParams)layoutParams);
    }

    private int nextID() {
        return this.mInfo.isEmpty() ? 1 : this.nextID(((BubbleTextLayout$BubbleInfoExtend)this.mInfo.getFirst()).viewID);
    }

    private long nextUniqueID() {
        return ++this.mUniqueID;
    }

    private int nextID(int n) {
        if (n >= 65534) {
            return 1;
        }
        return n + 1;
    }

    public void setViewMaker(BubbleTextLayout$BubbleInfoViewMaker bubbleTextLayout$BubbleInfoViewMaker) {
        this.mMaker = bubbleTextLayout$BubbleInfoViewMaker;
    }

    public int size() {
        return this.mInfo.size();
    }

    public void setMaximumSize(int n) {
        this.mMaximum = n;
        this.checkMaximum(false);
    }

    public void clear(boolean bl) {
        if (!this.mInfo.isEmpty()) {
            if (bl) {
                for (BubbleTextLayout$BubbleInfoExtend bubbleTextLayout$BubbleInfoExtend : this.mInfo) {
                    this.remove(bubbleTextLayout$BubbleInfoExtend, bl);
                }
            } else {
                for (BubbleTextLayout$BubbleInfoExtend bubbleTextLayout$BubbleInfoExtend : this.mInfo) {
                    bubbleTextLayout$BubbleInfoExtend.remove();
                }
            }
            this.mInfo.clear();
        }
    }

    private AlphaAnimation getFadeInAnimation() {
        AlphaAnimation alphaAnimation = (AlphaAnimation)this.mAnimationCache.get(1);
        if (alphaAnimation == null) {
            alphaAnimation = new AlphaAnimation(0.0f, 1.0f);
            alphaAnimation.setDuration((long)this.mAniDuration);
            alphaAnimation.setFillEnabled(true);
            alphaAnimation.setFillBefore(true);
            alphaAnimation.setFillAfter(true);
            this.mAnimationCache.put(0, (Object)alphaAnimation);
        }
        return alphaAnimation;
    }

    private AlphaAnimation getFadeOutAnimation() {
        AlphaAnimation alphaAnimation = (AlphaAnimation)this.mAnimationCache.get(1);
        if (alphaAnimation == null) {
            alphaAnimation = new AlphaAnimation(1.0f, 0.0f);
            alphaAnimation.setDuration((long)this.mAniDuration);
            alphaAnimation.setFillEnabled(true);
            alphaAnimation.setFillBefore(true);
            alphaAnimation.setFillAfter(true);
            this.mAnimationCache.put(1, (Object)alphaAnimation);
        }
        return alphaAnimation;
    }

    private TranslateAnimation getInsertTranslateAnimation(int n) {
        TranslateAnimation translateAnimation;
        TranslateAnimation translateAnimation2 = translateAnimation = this.mUseFixedInsertAnimation ? (TranslateAnimation)this.mAnimationCache.get(2) : null;
        if (translateAnimation == null) {
            translateAnimation = new TranslateAnimation(0.0f, 0.0f, (float)n, 0.0f);
            translateAnimation.setDuration((long)((float)this.mAniDuration * 0.5f));
            translateAnimation.setFillEnabled(true);
            translateAnimation.setFillBefore(true);
            translateAnimation.setFillAfter(true);
            if (this.mUseFixedInsertAnimation) {
                this.mAnimationCache.put(2, (Object)translateAnimation);
            }
        }
        return translateAnimation;
    }

    private TranslateAnimation getRemoveTranslateAnimation() {
        TranslateAnimation translateAnimation = (TranslateAnimation)this.mAnimationCache.get(3);
        if (translateAnimation == null) {
            translateAnimation = new TranslateAnimation(0.0f, 0.0f, 0.0f, -TypedValue.applyDimension((int)1, (float)50.0f, (DisplayMetrics)this.getResources().getDisplayMetrics()));
            translateAnimation.setDuration((long)((float)this.mAniDuration * 0.5f));
            translateAnimation.setFillEnabled(true);
            translateAnimation.setFillBefore(true);
            translateAnimation.setFillAfter(true);
            this.mAnimationCache.put(3, (Object)translateAnimation);
        }
        return translateAnimation;
    }

    private AnimationSet getAddAnimation(int n) {
        AnimationSet animationSet = new AnimationSet(true);
        animationSet.setDuration((long)this.mAniDuration);
        animationSet.addAnimation((Animation)this.getFadeInAnimation());
        animationSet.addAnimation((Animation)this.getInsertTranslateAnimation(n));
        return animationSet;
    }

    private AnimationSet getRemoveAnimation() {
        AnimationSet animationSet = new AnimationSet(true);
        animationSet.setDuration((long)this.mAniDuration);
        animationSet.addAnimation((Animation)this.getFadeOutAnimation());
        animationSet.addAnimation((Animation)this.getRemoveTranslateAnimation());
        return animationSet;
    }

    private void checkMaximum(boolean bl) {
        if (this.mMaximum > 0) {
            while (this.mInfo.size() > this.mMaximum) {
                this.removeLast(bl);
            }
        }
    }

    public void insert(BubbleTextLayout$BubbleInfo bubbleTextLayout$BubbleInfo, boolean bl) {
        if (bubbleTextLayout$BubbleInfo != null) {
            BubbleTextLayout$BubbleInfoExtend bubbleTextLayout$BubbleInfoExtend = new BubbleTextLayout$BubbleInfoExtend(bubbleTextLayout$BubbleInfo);
            bubbleTextLayout$BubbleInfoExtend.viewID = this.nextID();
            bubbleTextLayout$BubbleInfoExtend.uniqueID = this.nextUniqueID();
            bubbleTextLayout$BubbleInfoExtend.lastUpdateTime = System.currentTimeMillis();
            this.mInfo.push(bubbleTextLayout$BubbleInfoExtend);
            this.checkMaximum(bl);
            this.mHandler.sendMessage(this.mHandler.obtainMessage(1, bl ? 1 : 0, 0, bubbleTextLayout$BubbleInfoExtend));
        }
    }

    public void update(BubbleTextLayout$BubbleInfo bubbleTextLayout$BubbleInfo) {
        if (bubbleTextLayout$BubbleInfo != null) {
            if (this.mInfo.isEmpty()) {
                this.insert(bubbleTextLayout$BubbleInfo, true);
            } else {
                BubbleTextLayout$BubbleInfoExtend bubbleTextLayout$BubbleInfoExtend = (BubbleTextLayout$BubbleInfoExtend)this.mInfo.getFirst();
                bubbleTextLayout$BubbleInfoExtend.copyFrom(bubbleTextLayout$BubbleInfo);
                bubbleTextLayout$BubbleInfoExtend.lastUpdateTime = System.currentTimeMillis();
                if (!this.mHandler.hasMessages(1, bubbleTextLayout$BubbleInfoExtend)) {
                    this.mHandler.removeMessages(3, bubbleTextLayout$BubbleInfoExtend);
                    this.mHandler.sendMessage(this.mHandler.obtainMessage(1, 2, 0, bubbleTextLayout$BubbleInfoExtend));
                }
            }
        }
    }

    private void remove(BubbleTextLayout$BubbleInfoExtend bubbleTextLayout$BubbleInfoExtend, boolean bl) {
        if (bubbleTextLayout$BubbleInfoExtend != null) {
            this.mHandler.removeMessages(1, bubbleTextLayout$BubbleInfoExtend);
            this.mHandler.removeMessages(3, bubbleTextLayout$BubbleInfoExtend);
            this.mHandler.removeMessages(2, bubbleTextLayout$BubbleInfoExtend);
            this.mHandler.sendMessage(this.mHandler.obtainMessage(2, bl ? 1 : 0, 0, bubbleTextLayout$BubbleInfoExtend));
        }
    }

    public void removeLast(boolean bl) {
        if (!this.mInfo.isEmpty()) {
            BubbleTextLayout$BubbleInfoExtend bubbleTextLayout$BubbleInfoExtend = (BubbleTextLayout$BubbleInfoExtend)this.mInfo.removeLast();
            this.remove(bubbleTextLayout$BubbleInfoExtend, bl);
        }
    }

    public int getFirstItemID() {
        if (this.size() > 0) {
            return ((BubbleTextLayout$BubbleInfoExtend)this.mInfo.getFirst()).id;
        }
        return -1;
    }

    static /* synthetic */ LinearLayout access$100(BubbleTextLayout bubbleTextLayout) {
        return bubbleTextLayout.mFirstContainer;
    }

    static /* synthetic */ LinearLayout access$200(BubbleTextLayout bubbleTextLayout) {
        return bubbleTextLayout.mContainer;
    }

    static /* synthetic */ LinkedList access$300(BubbleTextLayout bubbleTextLayout) {
        return bubbleTextLayout.mInfo;
    }

    static /* synthetic */ AnimationSet access$400(BubbleTextLayout bubbleTextLayout, int n) {
        return bubbleTextLayout.getAddAnimation(n);
    }

    static /* synthetic */ int access$500(BubbleTextLayout bubbleTextLayout) {
        return bubbleTextLayout.mAniDuration;
    }

    static /* synthetic */ AnimationSet access$600(BubbleTextLayout bubbleTextLayout) {
        return bubbleTextLayout.getRemoveAnimation();
    }

    static /* synthetic */ BubbleTextLayout$BubbleInfoViewMaker access$700(BubbleTextLayout bubbleTextLayout) {
        return bubbleTextLayout.mMaker;
    }

    static /* synthetic */ void access$800(BubbleTextLayout bubbleTextLayout, int n, int n2) {
        bubbleTextLayout.setMeasuredDimension(n, n2);
    }
}

