/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.df.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.Base64;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import oz.util.view.camera.ImagePickerView;
import oz.util.view.camera.ImagePickerView$OnTakePictureListener;
import oz.viewer.ui.df.view.DFInputCompImageBase;
import oz.viewer.ui.df.view.DFInputCompImageBase$DFImageInterface;

public class DFInputCompImagePicker
extends DFInputCompImageBase
implements View.OnClickListener,
ImagePickerView$OnTakePictureListener {
    private ImagePickerView mImagePickerView;

    public DFInputCompImagePicker(Context context, DFInputCompImageBase$DFImageInterface dFInputCompImageBase$DFImageInterface) {
        super(context, dFInputCompImageBase$DFImageInterface);
    }

    FrameLayout getImagePickerView() {
        if (this.mImagePickerView == null) {
            this.mImagePickerView = new ImagePickerView(this.getContext());
        }
        this.mImagePickerView.setPictureRatio(this.getInterface().getCompRatio());
        this.mImagePickerView.setProperty(this.getInterface().isCameraShowToolbar(), this.getInterface().isCameraToolbarFlash(), this.getInterface().isCameraToolbarFacing(), this.getInterface().getFlashMode(), this.getInterface().getFacingMode());
        return this.mImagePickerView;
    }

    void setOnClickListener() {
        this.mImagePickerView.setOnTakePictureListener(this);
        this.mResetButton.setOnClickListener((View.OnClickListener)this);
        this.mImagePickerView.setOnTouchListener(this.DFOnTouchListener);
    }

    protected void create(int n, int n2) {
        this.addView((View)this.getContentLayout());
        if (this.getValue() == null || this.getValue().toString().isEmpty()) {
            this.mResetButton.setVisibility(4);
        }
    }

    protected void updateSizeChanged(int n, int n2) {
        this.mImagePickerView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(n, n2, 17));
    }

    protected void updateInternal(boolean bl) {
        if (this.isValueChanged()) {
            int n;
            String string;
            Object object = this.getValue();
            Bitmap bitmap = null;
            if (object != null && (string = object.toString()).length() > 12 && string.startsWith("data:") && (n = string.indexOf("base64,")) > -1) {
                String string2 = string.substring(n + 7);
                try {
                    byte[] byArray = Base64.decode((String)string2, (int)2);
                    if (byArray != null) {
                        bitmap = BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            this.mImagePickerView.setImageBitmap(bitmap);
        }
    }

    protected void disposeInternal(boolean bl) {
        super.disposeInternal(bl);
        if (bl && this.mImagePickerView != null) {
            this.mImagePickerView.dismiss();
        }
    }

    public void OnTakePicture(Bitmap bitmap) {
        if (bitmap != null && this.mResetButton.getVisibility() == 4) {
            this.mResetButton.setVisibility(0);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.JPEG, this.getInterface().getJPGQuality(), (OutputStream)byteArrayOutputStream);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        byArray = this.getInterface().applyImageFilter(byArray);
        byte[] byArray2 = Base64.encode((byte[])byArray, (int)2);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("data:image/jpg;base64,");
        stringBuilder.append(new String(byArray2));
        this.setValue(stringBuilder.toString());
        Bitmap bitmap2 = BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length);
        this.mImagePickerView.setImageBitmap(bitmap2);
    }

    public void OnStopSpeech() {
        this.getInterface().stopSpeech();
    }

    public void onClick(View view) {
        if (view == this.mImageLayout) {
            this.mResetButton.setVisibility(0);
        } else if (view == this.mResetButton) {
            this.setValue(null, true);
            this.update(false);
            this.mResetButton.setVisibility(4);
        }
    }

    public void OnSetImagePickerFlashModeOpt(int n) {
        this.getInterface().setImagePickerFlashModeOpt(n);
    }

    public void OnSetImagePickerFacingModeOpt(int n) {
        this.getInterface().setImagePickerFlashModeOpt(n);
    }

    public void setFlashMode(int n) {
        this.getInterface().setImagePickerFlashModeOpt(n);
    }

    public void setFacingMode(int n) {
        this.getInterface().setImagePickerFacingModeOpt(n);
    }
}

