/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.df.view;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.StateListDrawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import oz.viewer.ui.df.DFUtils;
import oz.viewer.ui.df.view.DFCheckView;
import oz.viewer.ui.df.view.DFRoundRectFrameLayout;

public class DFSelectItemView
extends DFRoundRectFrameLayout {
    private static final int COLOR_RECT = 0;
    private static final int COLOR_RECT_SELECTED = 0x19FFFFFF;
    private static final int COLOR_BORDER = -1711276033;
    private static final int COLOR_BORDER_SELECTED = -1;
    private static final int COLOR_TEXT = -1;
    private static final int COLOR_DISABLED_TEXT = -3355444;
    private static final int COLOR_DISABLED = 0x55000000;
    private static final int ALPHA_DESELECT = 153;
    private static final float DP_BODER_WIDTH = 1.0f;
    private static final float DP_BODER_SELECTED_WIDTH = 2.0f;
    private static final int DP_PADDING = 12;
    private static final int SP_TEXT_SIZE = 20;
    private boolean mHasImage;
    private LinearLayout mLayout;
    private TextView mTextView;
    private int mRectSelectedColor;
    private float mRectBorderSelectedWidth;
    private int mRectBorderSelectedColor;
    private DFCheckView mCheckView;

    public DFSelectItemView(Context context) {
        super(context, null);
        this.mHasImage = false;
    }

    public DFSelectItemView(Context context, int n) {
        super(context, n);
        this.mHasImage = true;
    }

    public DFSelectItemView(Context context, Drawable drawable2) {
        super(context, drawable2);
        this.mHasImage = true;
    }

    protected void addImageView(ImageView imageView) {
        this.mLayout = new LinearLayout(this.getContext());
        this.mLayout.setOrientation(0);
        this.mLayout.setGravity(19);
        int n = DFUtils.toDP(this.getContext(), 12.0f);
        this.mLayout.setPadding(n, n, n, n);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-2, -2);
        this.mLayout.addView((View)imageView, (ViewGroup.LayoutParams)layoutParams);
        this.mTextView = new TextView(this.getContext());
        this.mTextView.setTextSize(20.0f);
        this.mTextView.setTextColor(-1);
        this.mCheckView = new DFCheckView(this.getContext());
        this.mLayout.addView((View)this.mTextView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -2, 10.0f));
        this.mLayout.addView((View)this.mCheckView);
        this.addView((View)this.mLayout);
        this.updateMargin();
    }

    public void setRectSelectColor(int n) {
        this.mRectSelectedColor = n;
    }

    public void setBorderSelectedColor(int n) {
        this.mRectBorderSelectedColor = n;
    }

    public void setBorderSelectedWidth(float f2) {
        this.mRectBorderSelectedWidth = f2;
    }

    public void setImageViewSize(int n) {
        this.setImageViewSize(n, n);
    }

    public void setImageViewSize(int n, int n2) {
        LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)this.getImageView().getLayoutParams();
        if (n > 0) {
            layoutParams.width = n;
        }
        if (n2 > 0) {
            layoutParams.height = n2;
        }
        this.requestLayout();
    }

    private void updateMargin() {
        int n;
        LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)this.getImageView().getLayoutParams();
        layoutParams.rightMargin = this.mHasImage && this.mTextView.getText().length() > 0 ? (n = DFUtils.toDP(this.getContext(), 12.0f)) : 0;
    }

    protected void initExtra() {
        super.initExtra();
        this.setRectColor(0);
        this.setRectSelectColor(0x19FFFFFF);
        this.setBorderColor(-1711276033);
        this.setBorderSelectedColor(-1);
        this.setBorderWidth(1.0f);
        this.setBorderSelectedWidth(2.0f);
    }

    protected Drawable createDrawable() {
        Drawable drawable2 = this.createSelectedDrawable();
        Drawable drawable3 = this.createDeselectedDrawable();
        Drawable drawable4 = this.createDisabledDrawable();
        StateListDrawable stateListDrawable = new StateListDrawable();
        stateListDrawable.addState(new int[]{-16842910}, drawable4);
        stateListDrawable.addState(new int[]{16842919}, drawable2);
        stateListDrawable.addState(new int[]{-16842913}, drawable3);
        stateListDrawable.addState(new int[]{0x10100A1}, drawable2);
        return stateListDrawable;
    }

    protected Drawable createDeselectedDrawable() {
        return super.createDrawable();
    }

    protected Drawable createSelectedDrawable() {
        return DFSelectItemView.getGDNormalFrame(this.getContext(), this.mRectSelectedColor, this.mRectBorderSelectedColor, this.mRectBorderSelectedWidth, this.getRad());
    }

    protected Drawable createDisabledDrawable() {
        GradientDrawable gradientDrawable = (GradientDrawable)this.createDeselectedDrawable();
        gradientDrawable.setColor(0x55000000);
        return gradientDrawable;
    }

    public void setInnerLayoutGravity(int n) {
        this.mLayout.setGravity(n);
    }

    public void setText(String string) {
        this.mTextView.setText((CharSequence)string);
        this.updateMargin();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.mTextView.setEnabled(bl);
        this.updateTextViewColor();
    }

    private void updateTextViewColor() {
        this.mTextView.setTextColor(this.mTextView.isEnabled() ? -1 : -3355444);
    }

    public void setSelected(boolean bl, boolean bl2) {
        if (bl && bl2 && this.mCheckView != null) {
            this.mCheckView.requestPlay();
        } else {
            this.mCheckView.requestPause();
        }
        super.setSelected(bl);
    }

    public void setOnlyUseImageButton(boolean bl) {
        if (bl) {
            if (this.mCheckView != null) {
                this.mTextView.setVisibility(0);
                this.mCheckView.setVisibility(0);
            }
        } else if (this.mCheckView != null) {
            this.mTextView.setVisibility(8);
            this.mCheckView.setVisibility(8);
        }
    }
}

