/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.edit;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.RectF;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import java.io.IOException;
import java.io.InputStream;
import oz.main.OZStorage;
import oz.viewer.ui.edit.ACanvasImageView$OZGestureListener;
import oz.viewer.ui.edit.ACanvasObjectView;
import oz.viewer.ui.edit.AControllerImage;
import oz.viewer.ui.edit.AEditableBaseView;
import oz.viewer.ui.edit.AEditableConst$Size;
import oz.viewer.ui.edit.UIViewLayout$LayoutParams;

public class ACanvasImageView
extends ACanvasObjectView {
    Bitmap m_bitmap;
    Bitmap m_rotated_bitmap;
    float m_rotated_bitmap_degree;
    boolean _isDraw = false;
    public float m_degrees;
    public float m_realDegrees;
    public float m_borderDegrees;
    public float m_oldDegrees;
    public float m_preDegrees;
    public RectF m_borderRect;
    public RectF m_zeroRotate_rect;
    public float m_borderRect_last_degree;
    public float m_borderRect_last_real_degree;
    public final int TOP_1 = 4;
    public final int TOP_2 = 5;
    public final int TOP_3 = 6;
    public float m_start_width;
    public float m_start_height;
    public boolean m_isRotated;
    public RectF m_old_rect_forRotate;
    Matrix _matrix;
    RectF _realRect;
    ImageView m_iv = null;
    int _sizeWidth = 0;
    int _sizeHeight = 0;

    public ACanvasImageView(Context context, Bitmap bitmap, AEditableBaseView aEditableBaseView, AControllerImage aControllerImage, Matrix matrix, RectF rectF) {
        super(context, aEditableBaseView, aControllerImage);
        this.m_bitmap = bitmap;
        this._matrix = new Matrix(matrix);
        this._realRect = new RectF(rectF);
        this.getBaseView().m_imageEditor_middle_Layout.setCanvasScale(1.0f);
        this.mGestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new ACanvasImageView$OZGestureListener(this, null), null, false);
        AEditableBaseView.m_selectedObject = this;
        this.m_old_rect_forRotate = new RectF(0.0f, 0.0f, 0.0f, 0.0f);
        this.m_zeroRotate_rect = new RectF(0.0f, 0.0f, 0.0f, 0.0f);
        this.initBitmap();
        this.setWillNotDraw(false);
        this.invalidate();
    }

    public ACanvasImageView(Context context, Bitmap bitmap, AEditableBaseView aEditableBaseView, AControllerImage aControllerImage) {
        super(context, aEditableBaseView, aControllerImage);
        this.m_bitmap = bitmap;
        this._matrix = null;
        this._realRect = null;
        this.getBaseView().m_imageEditor_middle_Layout.setCanvasScale(1.0f);
        this.mGestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new ACanvasImageView$OZGestureListener(this, null), null, false);
        AEditableBaseView.m_selectedObject = this;
        this.m_old_rect_forRotate = new RectF(0.0f, 0.0f, 0.0f, 0.0f);
        this.m_zeroRotate_rect = new RectF(0.0f, 0.0f, 0.0f, 0.0f);
        this.initBitmap();
        this.setWillNotDraw(false);
        this.invalidate();
    }

    public void clearView() {
        this._isDraw = false;
        this.invalidate();
    }

    public ImageView getView() {
        return this.m_iv;
    }

    public Matrix getImageMatrix() {
        return this.m_iv.getImageMatrix();
    }

    public void setImageMatrix(Matrix matrix) {
        this.m_iv.setImageMatrix(matrix);
    }

    public void setScale(float f2, float f3) {
        Matrix matrix = new Matrix();
        matrix.setTranslate((float)(-this.m_bitmap.getWidth()) / 2.0f, (float)(-this.m_bitmap.getHeight()) / 2.0f);
        matrix.postScale(f2, f3);
        matrix.preConcat(this.getImageMatrix());
        matrix.postTranslate((float)this.m_iv.getWidth() / 2.0f, (float)this.m_iv.getHeight() / 2.0f);
        this.setImageMatrix(matrix);
    }

    public void setRectWithSize(Rect rect) {
        super.setRect(rect);
        this._sizeWidth = rect.width();
        this._sizeHeight = rect.width();
    }

    private double deg2rad(double d2) {
        return d2 * Math.PI / 180.0;
    }

    public int[] getBoundingBox(double d2, int n, int n2) {
        float f2 = (float)this.deg2rad(d2);
        int n3 = (int)((double)n2 * Math.abs(Math.sin(f2)) + (double)n * Math.abs(Math.cos(f2)));
        int n4 = (int)((double)n2 * Math.abs(Math.cos(f2)) + (double)n * Math.abs(Math.sin(f2)));
        int[] nArray = new int[]{-(n3 / 2), -(n4 / 2), n3 / 2, n4 / 2};
        return nArray;
    }

    public Rect getBounds() {
        Rect rect = new Rect(0, 0, 0, 0);
        if (this.m_bitmap != null) {
            if (this.getRect().left == 0.0f && this.getRect().top == 0.0f && this.getRect().isEmpty()) {
                float f2 = this.getBaseView().getDstRect().width();
                float f3 = this.getBaseView().getDstRect().height();
                float f4 = this.getBaseView().getBorderRect().width();
                float f5 = this.getBaseView().getBorderRect().height();
                if (f4 == 0.0f || f5 == 0.0f) {
                    f4 = f2 + AEditableConst$Size.EDITABLE_GAP_5;
                    f5 = f3 + AEditableConst$Size.EDITABLE_GAP_5;
                }
                float f6 = this.getBaseView().m_canvasW;
                RectF rectF = new RectF(0.0f, 0.0f, f2, f3);
                if (f2 < f4 || f3 < f5) {
                    float f7;
                    if (f2 * f5 < f3 * f4) {
                        rectF.top = f7 = (f3 - f5 * f2 / f4) / 2.0f;
                        rectF.bottom -= f7;
                    } else {
                        rectF.left = f7 = (f2 - f4 * f3 / f5) / 2.0f;
                        rectF.right -= f7;
                    }
                    if (this.getController().getRect().width() != 0.0f && this.getController().getRect().height() != 0.0f) {
                        this.setRect(this.getController().getRect().left / f6 + this.getBaseView().getDstRect().left, this.getController().getRect().top / f6 + this.getBaseView().getDstRect().top, this.getController().getRect().right / f6 + this.getBaseView().getDstRect().left, this.getController().getRect().bottom / f6 + this.getBaseView().getDstRect().top);
                        this.m_degrees = (float)this.getController().getItemRotation();
                    } else {
                        f7 = (float)this.getBaseView().m_imageEditor_middle_Layout.getWidth() / 2.0f - (rectF.right - rectF.left) / 2.0f;
                        float f8 = (float)this.getBaseView().m_imageEditor_middle_Layout.getHeight() / 2.0f - (rectF.bottom - rectF.top) / 2.0f;
                        this.setRect(f7, f8, f7 + rectF.width(), f8 + rectF.height());
                    }
                } else if (this.getController().getRect().width() != 0.0f && this.getController().getRect().height() != 0.0f) {
                    this.setRect(this.getController().getRect().left / f6 + this.getBaseView().getDstRect().left, this.getController().getRect().top / f6 + this.getBaseView().getDstRect().top, this.getController().getRect().right / f6 + this.getBaseView().getDstRect().left, this.getController().getRect().bottom / f6 + this.getBaseView().getDstRect().top);
                    this.m_degrees = (float)this.getController().getItemRotation();
                } else {
                    float f9 = (float)this.getBaseView().getEditableViewWidth() / 2.0f - this.getBaseView().getBorderRect().width() / 2.0f;
                    float f10 = (float)this.getBaseView().getEditableViewHeight() / 2.0f - this.getBaseView().getBorderRect().height() / 2.0f;
                    this.setRect(f9, f10, f9 + f4, f10 + f5);
                }
                this.getImageController().setProperties(this.getRect(), this.m_degrees, this.m_bitmap);
            }
            rect = new Rect((int)this.getRect().left, (int)this.getRect().top, (int)this.getRect().right, (int)this.getRect().bottom);
        }
        return rect;
    }

    protected void onDraw(Canvas canvas) {
        Object object;
        Object object2;
        Paint paint;
        if (this.getWidth() != 0 && this.getHeight() != 0 && this.getBaseView().getDstRect().width() != 0.0f && this.getBaseView().getDstRect().height() != 0.0f && this.getRect().left == 0.0f && this.getRect().top == 0.0f && this.getRect().isEmpty()) {
            double d2;
            double d3;
            paint = this.getBounds();
            this._sizeWidth = paint.width();
            this._sizeHeight = paint.height();
            Matrix matrix = new Matrix();
            if (this._realRect != null) {
                float f2 = this.getBaseView().m_canvasW;
                this._realRect.left = (int)(this._realRect.left / f2 + this.getBaseView().getDstRect().left);
                this._realRect.top = (int)(this._realRect.top / f2 + this.getBaseView().getDstRect().top);
                this._realRect.right = (int)(this._realRect.right / f2 + this.getBaseView().getDstRect().left);
                this._realRect.bottom = (int)(this._realRect.bottom / f2 + this.getBaseView().getDstRect().top);
            }
            if (this._realRect == null) {
                d3 = (float)this._sizeWidth / (float)this.m_bitmap.getWidth();
                d2 = (float)this._sizeHeight / (float)this.m_bitmap.getHeight();
                matrix.postScale((float)d3, (float)d2);
            } else {
                d3 = this._realRect.width() / (float)this.m_bitmap.getWidth();
                d2 = this._realRect.height() / (float)this.m_bitmap.getHeight();
                matrix.postScale((float)d3, (float)d2);
            }
            Bitmap bitmap = Bitmap.createBitmap((Bitmap)this.m_bitmap, (int)0, (int)0, (int)this.m_bitmap.getWidth(), (int)this.m_bitmap.getHeight(), (Matrix)matrix, (boolean)true);
            this.m_bitmap = null;
            this.m_bitmap = bitmap;
            this.m_iv = new ImageView(this.getContext());
            this.m_iv.setBackgroundColor(0);
            this.m_iv.setImageBitmap(this.m_bitmap);
            this.m_iv.setScaleType(ImageView.ScaleType.MATRIX);
            this.m_iv.setAlpha(255);
            if (this._realRect == null) {
                object2 = new UIViewLayout$LayoutParams(this._sizeWidth, this._sizeHeight, paint.left, paint.top);
                this.m_iv.setLayoutParams((ViewGroup.LayoutParams)object2);
            } else {
                float f3 = (float)paint.left + (float)paint.width() / 2.0f - this._realRect.width() / 2.0f;
                float f4 = (float)paint.top + (float)paint.height() / 2.0f - this._realRect.height() / 2.0f;
                object = new UIViewLayout$LayoutParams((int)this._realRect.width(), (int)this._realRect.height(), (int)f3, (int)f4);
                this.m_iv.setLayoutParams((ViewGroup.LayoutParams)object);
            }
            this.addView((View)this.m_iv);
            if (this._matrix != null) {
                object2 = new float[9];
                this._matrix.getValues((float[])object2);
                Matrix matrix2 = new Matrix();
                matrix2.setTranslate((float)(-this.m_bitmap.getWidth()) / 2.0f, (float)(-this.m_bitmap.getHeight()) / 2.0f);
                matrix2.postConcat(this._matrix);
                matrix2.postTranslate(this._realRect.width() / 2.0f, this._realRect.height() / 2.0f);
                this.m_iv.setImageMatrix(matrix2);
            }
            this.setRect(paint.left, paint.top, paint.left + this._sizeWidth, paint.top + this._sizeHeight);
        }
        if (this._isDraw) {
            paint = new Paint();
            paint.setAntiAlias(true);
            paint.setFilterBitmap(true);
            paint.setDither(true);
            canvas.save();
            int n = (int)this.getRect().width();
            int n2 = (int)this.getRect().height();
            canvas.rotate(0.0f, this.getRect().left + (float)(n / 2), this.getRect().top + (float)(n2 / 2));
            object2 = new RectF(0.0f, 0.0f, (float)this._sizeWidth, (float)this._sizeHeight);
            RectF rectF = new RectF((float)this.m_iv.getLeft(), (float)this.m_iv.getTop(), (float)(this.m_iv.getLeft() + this._sizeWidth), (float)(this.m_iv.getTop() + this._sizeHeight));
            object = new Matrix();
            object.setRectToRect(object2, rectF, Matrix.ScaleToFit.CENTER);
            object.preConcat(this.getImageMatrix());
            canvas.drawBitmap(this.m_bitmap, object, paint);
            canvas.restore();
        }
        this._isDraw = true;
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        RectF rectF = new RectF(this.getRect());
        float f2 = motionEvent.getX();
        float f3 = motionEvent.getY();
        Point point = this.getBaseView().m_imageEditor_middle_Layout.getScaledTouch(f2, f3);
        f2 = point.x;
        f3 = point.y;
        int n = motionEvent.getPointerCount();
        if (n >= 2) {
            this.getBaseView().m_imageEditor_middle_Layout.onTouchEvent(motionEvent);
            return false;
        }
        if (AEditableBaseView.m_selectedObject == null) {
            ViewGroup viewGroup = (ViewGroup)this.getParent();
            viewGroup.onTouchEvent(motionEvent);
        }
        if (rectF.contains(f2, f3)) {
            this.mGestureDetector.onTouchEvent(motionEvent);
            return true;
        }
        return false;
    }

    private void initBitmap() {
        try {
            int n = OZStorage.getDrawable(this.getResources().getAssets().open(OZStorage.getImagePath("resource/tracker_rotate@2x.png"))).getIntrinsicHeight();
            InputStream inputStream = this.getContext().getAssets().open("resource/tracker_rotate@2x.png");
            this.m_bitmapRotate = BitmapFactory.decodeStream((InputStream)inputStream);
            this.m_bitmapRotate = Bitmap.createScaledBitmap((Bitmap)this.m_bitmapRotate, (int)n, (int)n, (boolean)true);
            inputStream = this.getContext().getAssets().open("resource/tracker_size@2x.png");
            this.m_bitmapSize = BitmapFactory.decodeStream((InputStream)inputStream);
            this.m_bitmapSize = Bitmap.createScaledBitmap((Bitmap)this.m_bitmapSize, (int)n, (int)n, (boolean)true);
            inputStream = this.getContext().getAssets().open("resource/tracker_size_width@2x.png");
            this.m_bitmapSizeWidth = BitmapFactory.decodeStream((InputStream)inputStream);
            this.m_bitmapSizeWidth = Bitmap.createScaledBitmap((Bitmap)this.m_bitmapSizeWidth, (int)n, (int)n, (boolean)true);
            inputStream = this.getContext().getAssets().open("resource/tracker_size_height@2x.png");
            this.m_bitmapSizeHeight = BitmapFactory.decodeStream((InputStream)inputStream);
            this.m_bitmapSizeHeight = Bitmap.createScaledBitmap((Bitmap)this.m_bitmapSizeHeight, (int)n, (int)n, (boolean)true);
            inputStream = this.getContext().getAssets().open("resource/tracker_foreground@2x.png");
            this.m_bitmapForeground = BitmapFactory.decodeStream((InputStream)inputStream);
            this.m_bitmapForeground = Bitmap.createScaledBitmap((Bitmap)this.m_bitmapForeground, (int)(n * 3 / 4), (int)(n * 3 / 4), (boolean)true);
            inputStream = this.getContext().getAssets().open("resource/tracker_background@2x.png");
            this.m_bitmapBackground = BitmapFactory.decodeStream((InputStream)inputStream);
            this.m_bitmapBackground = Bitmap.createScaledBitmap((Bitmap)this.m_bitmapBackground, (int)(n * 3 / 4), (int)(n * 3 / 4), (boolean)true);
            inputStream = this.getContext().getAssets().open("resource/tracker_garbage@2x.png");
            this.m_bitmapDeleteImamge = BitmapFactory.decodeStream((InputStream)inputStream);
            this.m_bitmapDeleteImamge = Bitmap.createScaledBitmap((Bitmap)this.m_bitmapDeleteImamge, (int)(n * 3 / 4), (int)(n * 3 / 4), (boolean)true);
            this.m_icon_size = this.m_bitmapSize.getHeight();
            this.m_icon_size3_4 = this.m_bitmapForeground.getHeight();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public AControllerImage getImageController() {
        return (AControllerImage)this.getController();
    }
}

