/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.edit;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.view.View;
import android.view.ViewGroup;
import oz.main.OZStorage;
import oz.viewer.ui.edit.AEditableBaseView;
import oz.viewer.ui.edit.AEditableImageButton;
import oz.viewer.ui.edit.AEditableUtil;

public class APopupColorButton
extends AEditableImageButton
implements View.OnClickListener {
    private boolean mIsCustomBG;
    private Bitmap mBitmap;
    private int mColor;
    private Paint mPaint;
    private Rect mRect;
    private RectF mRectF;

    public APopupColorButton(Context context, String string, int n, int n2, AEditableBaseView aEditableBaseView) {
        super(context, aEditableBaseView);
        this.mIsCustomBG = true;
        this.mBitmap = AEditableUtil.getBitmapFromAssetPath(this.getContext(), string);
        this.init(n2, n);
    }

    public APopupColorButton(Context context, int n, int n2, int n3, AEditableBaseView aEditableBaseView) {
        super(context, aEditableBaseView);
        this.mIsCustomBG = false;
        this.mColor = n2;
        this.init(n3, n);
    }

    private void init(int n, int n2) {
        this.mPaint = new Paint(1);
        this.mPaint.setFilterBitmap(true);
        this.mRect = new Rect();
        this.mRectF = new RectF();
        this.setId(n);
        this.init_Padding();
        this.init_Background();
        this.init_Layout(n2);
        this.setOnClickListener(this);
    }

    protected void init_Padding() {
        AEditableUtil.setViewPadding((View)this, OZStorage.padding_5, OZStorage.padding_3);
    }

    protected void init_Background() {
        this.setBackgroundDrawable(null);
    }

    private void setSelectedIndex() {
        this.getBaseView().setSelectedPenIndex(this.getId());
    }

    private int getSelectedIndex() {
        int n = this.getBaseView().isCommentEraser() ? this.getBaseView().getCommentPreMode() : this.getBaseView().getCommentMode();
        return this.getBaseView().getPenIndex(n);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int n = this.getWidth();
        int n2 = this.getHeight();
        float f2 = (float)(n2 * 2) / 5.0f;
        canvas.translate((float)(n / 2), (float)(n2 / 2));
        this.mPaint.setAlpha(this.isEnabled() ? 255 : 128);
        int n3 = Color.argb((int)this.mPaint.getAlpha(), (int)255, (int)255, (int)255);
        if (this.mIsCustomBG) {
            if (this.mBitmap != null) {
                this.mRect.set(0, 0, this.mBitmap.getWidth(), this.mBitmap.getHeight());
                this.mRectF.set(0.0f, 0.0f, f2 * 2.0f, f2 * 2.0f);
                this.mRectF.offset(-f2, -f2);
                canvas.drawBitmap(this.mBitmap, this.mRect, this.mRectF, this.mPaint);
            }
        } else {
            this.mPaint.setColor(n3 & this.mColor);
            this.mPaint.setStyle(Paint.Style.FILL);
            canvas.drawCircle(0.0f, 0.0f, f2, this.mPaint);
        }
        if (this.getId() == this.getSelectedIndex()) {
            this.mPaint.setColor(n3 & 0xFF000000);
            this.mPaint.setStyle(Paint.Style.STROKE);
            this.mPaint.setStrokeWidth((float)OZStorage.padding_3 / 2.0f);
            canvas.drawCircle(0.0f, 0.0f, f2 + (float)OZStorage.padding_3, this.mPaint);
        }
    }

    public void onClick(View view) {
        this.setSelectedIndex();
        this.getBaseView().setButtonProperties((ViewGroup)this.getBaseView().getPopupParent(), true, false);
        if (this.getId() != 100000) {
            this.getBaseView().setSelectedPenColorFromIndex();
            this.getBaseView().refreshSeekBar();
        } else {
            this.getBaseView().openColorPicker();
        }
    }
}

