package jp.agentec.abook.abv.bl.acms.client.parameters;

import jp.agentec.abook.abv.bl.acms.type.AcmsApis;
import jp.agentec.adf.net.http.HttpParameterObject;

/**
 * ACMSのAPIに渡す共通的なパラメータを格納します。ACMSのAPIのパラメータ用クラスを作成するときはこのクラスを継承してください。<br>
 * ただし、このクラスはログイン状態の確認用として使われる {@link CreateRoomParameters#sid} を持っているため、ログイン用のパラメータ {@link MobileLoginParameters} は、このクラスを継承する必要はありません。
 * @author Taejin Hong
 * @version 1.0.0
 */
public class CreateRoomParameters extends HttpParameterObject {
	/**
	 * セッションID
	 * @since 1.0.0
	 */
	private String sid;
	private String cmd;
	private String roomType;
	private String inviteMemberIds;
	private String newRoomName;
	private String memberName;

	/**
	 * {@link CreateRoomParameters} のインスタンスを初期化します。
	 * @param sid ログインした時のセッションIDです。
	 * @since 1.0.0
	 */
	public CreateRoomParameters(String sid) {
		this.sid = sid;
	}

	/**
	 * {@link CreateRoomParameters} のインスタンスを初期化します。
	 * @param sid ログインした時のセッションIDです。
	 * @param cmd Apiリクエストに必要なコマンド（ABOOK COMM専用）。
	 * @since 1.0.0
	 */
	public CreateRoomParameters(String sid, String cmd, String roomType, String inviteMemberIds, String newRoomName, String memberName) {
		this.sid = sid;
		this.cmd = cmd;
		this.roomType = roomType;
		this.inviteMemberIds = inviteMemberIds;
		this.newRoomName = newRoomName;
		this.memberName = memberName;
	}

	/**
	 * セッションIDを返します。
	 * @return ログインした時のセッションIDです。
	 * @since 1.0.0
	 */
	public String getSid() {
		return sid;
	}

	/**
	 * コマンドを返します。
	 * @return ログインした時のセッションIDです。
	 * @since 1.0.0
	 */
	public String getCmd() {
		return cmd;
	}

	public String getRoomType() {
		return roomType;
	}

	public String getInviteMemberIds() {
		return inviteMemberIds;
	}

	public String getNewRoomName() {
		return newRoomName;
	}

	public String getMemberName() {
		return memberName;
	}
}
