package jp.agentec.abook.abv.bl.acms.client.parameters;

import jp.agentec.adf.net.http.HttpParameterObject;
import jp.agentec.adf.util.StringUtil;

/**
 * サーバ時間取得用のパラメータです。
 * @author Taejin Hong
 * @version 1.0.0
 */
public class ServerTimeParameters extends HttpParameterObject {
	private String key;
	
	public ServerTimeParameters(String key) {
		if (StringUtil.isNullOrWhiteSpace(key)) {
			throw new IllegalArgumentException("argument key not allowed null or white space.");
		}
		
		this.key = key;
	}

	/**
	 * サーバに送信するキーを返します。
	 * @return　サーバに送信するキーです。
	 * @since 1.0.0
	 */
	public String getKey() {
		return key; 
	}
}
