package jp.agentec.abook.abv.bl.acms.type;

public enum ContentSortingType {
	ContentName(0),
	ContentNameKana(1),
	DeliveryStartDate(2),
	DownloadDate(3),
	ReadingCount(4),
	ReadingDate(5),
	ContentSize(6),
	ContentId(7);

	private final int contentSorting;
	
	ContentSortingType(int contentSorting) {
		this.contentSorting = contentSorting;
	}
	
	/**
	 * 検索をかける項目の番号を返します。
	 * @return　検索をかける項目の番号です。
	 * @since 1.0.0
	 */
	public int type() {
		return contentSorting;
	}

	/**
	 * 指定した数字に対応するSecurityPolicyCodeの値を返します。
	 * @param contentSorting 数字のコードです。
	 * @return　指定した数字に対応するSearchDivisionTypeの値です。
	 * @since 1.0.0
	 */
	public static ContentSortingType parse(int contentSorting) {
		ContentSortingType sortingType;
		
		switch (contentSorting) {
		case 0:
			sortingType = ContentSortingType.ContentName;
			break;
		case 1:
			sortingType = ContentSortingType.ContentNameKana;
			break;
		case 2:
			sortingType = ContentSortingType.DeliveryStartDate;
			break;
		case 3:
			sortingType = ContentSortingType.DownloadDate;
			break;
		case 4:
			sortingType = ContentSortingType.ReadingCount;
			break;
		case 5:
			sortingType = ContentSortingType.ReadingDate;
			break;
		case 6:
			sortingType = ContentSortingType.ContentSize;
			break;
		case 7:
			sortingType = ContentSortingType.ContentId;
			break;
		default:
			sortingType = ContentSortingType.DownloadDate;
			break;
		}
		
		return sortingType;
	}
	
}
