package jp.agentec.abook.abv.bl.acms.type;

import jp.agentec.abook.abv.bl.logic.AbstractLogic;
import jp.agentec.abook.abv.bl.logic.ContractLogic;

/**
 * パスワードを変更する必要があるかどうかを示します。
 * @author Taejin Hong
 * @version　1.0.0 
 */
public enum RequirePasswordChangeCode {
	/**
	 * 変更不要
	 * @since 1.0.0
	 */
	None("0"),
	/**
	 * 初回ログイン
	 * @since 1.0.0
	 */
	FirstTime("1"),
	/**
	 * 定期変更
	 * @since 1.0.0
	 */
	Required("2");
	
	private final String code;
	
	RequirePasswordChangeCode(String code) {
		this.code = code;
	}
	
	public String code() {
		return code;
	}
	
	public static RequirePasswordChangeCode parse(String code) {
		RequirePasswordChangeCode[] codes = RequirePasswordChangeCode.values();
		
		for (RequirePasswordChangeCode requirePasswordChangeCode : codes) {
			if (requirePasswordChangeCode.code.equals(code)) {
				return requirePasswordChangeCode;
			}
		}
		
		return null;
	}

	public static int getRequirePasswordChangeType(RequirePasswordChangeCode rpcc) {
		ContractLogic contractLogic = AbstractLogic.getLogic(ContractLogic.class);
		int rpccType = RequirePasswordChangeType.NONE;
		if (rpcc != null) {
			switch (rpcc) {
			case None:
				rpccType = RequirePasswordChangeType.NONE;
				break;
			case FirstTime: //初回ログイン
				switch (contractLogic.getForcePwChangeOnLogin()) {
				case None:
					rpccType = RequirePasswordChangeType.NONE;
					break;
				case Reminder: //パスワード変更催促
					rpccType = RequirePasswordChangeType.NEWLOGIN_REMINDER;
					break;
				case Enforcement: //強制パスワード変更
					rpccType = RequirePasswordChangeType.NEWLOGIN_ENFORCEMENT;
					break;
				}
				break;
			case Required: //定期変更
				switch (contractLogic.getForcePwChangePeriodically()) {
				case None:
					rpccType = RequirePasswordChangeType.NONE;
					break;
				case Reminder: //パスワード変更催促
					rpccType = RequirePasswordChangeType.REMINDER;
					break;
				case Enforcement: //強制パスワード変更
					rpccType = RequirePasswordChangeType.REMINDER_ENFORCEMENT;
					break;
				}
				break;
			}
		}
		return rpccType;
	}
}