package jp.agentec.abook.abv.bl.acms.type;

public interface ServiceOption {
	interface ServiceOptionId {
		/**
		 * 公開終了時のDL済コンテンツ強制削除
		 */
		int UndeliverableDelete = 13;
		/**
		 * 権限喪失,非公開,削除時のDL済コンテンツ強制削除
		 */
		int NoauthDelete = 14;
		/**
		 * Office使用可
		 */
		int Office2pdf = 19;
		/**
		 * 初回ログイン時パスワード強制変更
		 */
		int ForcePwChangeOnLogin = 21;
		/**
		 * 定期ログイン時パスワード強制変更
		 */
		int ForcePwChangePeriodically = 22;
		/**
		 * 強制ログイン促し
		 */
		int ForceLoginPeriodically = 23;
		/**
		 * UseridUdidOverwrite
		 */
		int UseridUdidOverwrite = 26;
		/**
		 * PDFLink背景色設定
		 */
		int PdfLinkDisp = 32;
		/**
		 * マーキング機能使用
		 */
		int Marking = 33;
		/**
		 * 連動機能使用
		 */
		int ViewerSync = 34;
		/**
		 * コンテンツ警告
		 */
		int ContentAlert = 37;
		/**
		 * PDF_Text copy Option
		 */
		int PdfTextCopy = 42;
		
		/**
		 * アンケート
		 */
		int Enquete = 45;
		
		/**
		 * コンテンツコンテナ
		 */
		int ContentContainer = 54;
		/**
		 * 強制ログアウト
		 */
		int ForceOfflineLogout = 58;
		/**
		 * 強制ログアウト タイムアウト日数
		 */
		int ForceOfflineWait = 59;
		/**
		 * サイネージ
		 */
		int Signage = 67;
		/**
		 * その他コンテンツ使用可
		 */
		int OtherContent = 68;
		/**
		 * カタログエディション
		 */
		int CatalogEdition = 70;
		/**
		 * DiMallエディション
		 */
		int Publisher = 91;
		/**
		 * 閲覧ログGPS使用可
		 */
		int UsableReadinglogGps = 71;
		/**
		 * 閲覧ログ詳細ログ使用可
		 */
		int UsableReadinglogObject = 72;
		/**
		 * グループ表示
		 */
		int UseGroup = 99;
		/**
		 * ジャンル表示
		 */		
		int UseGenre = 100;

		/**
		 * オフライン時試験送信
		 */
		int TransmitExamAtOfflLine = 124;
		
		/**
		 * 試験
		 */
		int Exam = 128;
		
		/**
		 * クイズ
		 */
		int Quiz = 129;

		/**
		 * 360°動画
		 */
		int PanoMovie = 139;

		/**
		 * バーチャルツアー
		 */
		int PanoImage = 140;

		/**
		 * オブジェクト360
		 */
		int Objectvr = 154;

		/**
		 * ABookCheck
		 */
		int ABookCheck = 161;

		/**
		 * 作業報告フォームGPS利用
		 */
		int REPORT_GPS = 167;

        /**
         * 報告タイプ：N(通常)、Y(定期点検)
         */
        int OperationReportType = 171;

		/**
		 * 作業種別：N(通常）、Y（作業種別毎に絞り込み可能なボタン・画面表示）
		 */
		int OperationGroupMaster = 175;

		/**
		 * ユーザパスワードソルト付加
		 * 利用しない：N(通常）、利用する：Y
		 */
		int AddUserPasswordSalt = 181;

		/**
		 * チャット機能
		 * 利用しない：N(通常）、利用する：Y
		 */
		int Chat = 183;

		/**
		 * I/O帳票使用
		 * 利用しない：N(通常）、利用する：Y
		 */
		int UsableIOReport = 186;

		/**
		 * RFID・バーコード使用
		 * 利用しない：N(通常）、利用する：Y
		 */
		int UsableRFIDBarcodeScan = 190;

		/**
		 * アルコールチェッカーHW
		 * 利用しない：N(通常）、利用する：Y
		 */
		int AlcoholCheckerHw = 202;

		/**
		 * 規約同意
		 */
		int agrementToTerms = 203;
	}
}