package jp.agentec.abook.abv.bl.common.db;

public interface Cursor {
	void close();
	byte[] getBlob(int columnIndex);
	int getColumnCount();
	int getColumnIndex(String columnName);
	int getColumnIndexOrThrow(String columnName);
	String getColumnName(int columnIndex);
	String[] getColumnNames();
	int getCount();
	double getDouble(int columnIndex);
	float getFloat(int columnIndex);
	int getInt(int columnIndex);
	long getLong(int columnIndex);
	short getShort(int columnIndex);
	String getString(int columnIndex);
	int getType(int columnIndex);
	boolean isAfterLast();
	boolean isBeforeFirst();
	boolean isClosed();
	boolean isFirst();
	boolean isLast();
	boolean isNull(int columnIndex);
	boolean move(int offset);
	boolean moveToFirst();
	boolean moveToLast();
	boolean moveToNext();

}
