package jp.agentec.abook.abv.bl.common.exception;

import org.json.adf.JSONException;


/**
 * JSONパーシングに失敗したことを示します。
 * @author Taejin Hong
 * @version 1.0.0
 */
public class JSONValidationException extends Exception {
	private static final long serialVersionUID = -4603254520693478749L;
	
	private String jsonString;

	/**
	 * {@link JSONValidationException} クラスのインスタンスを初期化します。
	 * @param jsonString 処理中だったJSON文字列です。
	 * @param message　エラー内容です。
	 * @see Exception#Exception(String)
	 * @since 1.0.0
	 */
	public JSONValidationException(String jsonString, String message) {
		super(message);
		this.jsonString = jsonString;
	}
	
	public JSONValidationException(String jsonString, JSONException e) {
		super(e);
	}

	/**
	 * 処理中だったJSON文字列を返します。
	 * @return 処理中だったJSON文字列です。
	 * @since 1.0.0
	 */
	public String getJSONString() {
		return jsonString;
	}
	
	@Override
	public String toString() {
		return String.format("%s\r\nJSON string: %s", super.toString(), getJSONString());
	}
}
