package jp.agentec.abook.abv.bl.dto;

import java.util.Date;


/**
 * しおり情報を格納します。
 * @author Minhyuk Seok
 * @version　1.0.0
 */
public class ContentBookmarkDto extends AbstractDto {
	public long contentId;
	public int pageNum;
	public String pageText;
	public String pageThumbnailName;
	public Date insertDate;
	public Date updateDate;
	public boolean deleteFlg;
	
	public String pageThumbnailPath;
	public String contentName;

	public boolean checked = false;
	
	@Override
	public Object[] getInsertValues() {
		return new Object[]{contentId, pageNum, pageText, pageThumbnailName, insertDate, updateDate};
	}

	@Override
	public Object[] getUpdateValues() {
		return new Object[]{pageText, pageThumbnailName, updateDate, contentId, pageNum};
	}

	@Override
	public String[] getKeyValues() {
		return new String[]{""+ contentId,""+ pageNum};
	}
}
