import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

import jp.agentec.adf.util.FileUtil;
import jp.agentec.adf.util.StringUtil;


public class ColorCheck {
	private static final String HTML_PATH_STR = "colorCheck.html";
	private static final String STRINGS_XML = "colors.xml";
	private static final String bgcolor = "white";

	public static void main(String[] args) throws IOException {
		File current = new File(".");
		File baseDir = new File(FileUtil.getParentPath(FileUtil.getParentPath(current.getAbsolutePath())) + "ABVJE_Res_Default_Android\\res");

		execute(baseDir, STRINGS_XML, HTML_PATH_STR);
	}

	public static void execute(File baseDir, String xmlFile, String output) throws FileNotFoundException, IOException {
		StringBuffer sb = new StringBuffer();
		sb.append("<html>\n");
		sb.append("<head>\n");
		sb.append("</head>\n");
		sb.append("<body bgcolor=\"" + bgcolor + "\" \"><table border=1>\n");
		sb.append("<tr>");
		sb.append("<td>");
		sb.append("key");
		sb.append("</td>");
		sb.append("<td>");
		sb.append("color");
		sb.append("</td>");
		sb.append("</tr>\n");

		FileReader fr = new FileReader(baseDir + "\\values\\" + xmlFile);
		BufferedReader br = new BufferedReader(fr);
		String line;
		while ((line=br.readLine()) != null) {
			String name = StringUtil.extractRegexString(line, "name=\"(.*?)\"", 1);
			if (name != null) {
				String val = StringUtil.extractRegexString(line, ">(.*?)<\\/", 1);
				sb.append("<tr>");
				sb.append("<td>");
				sb.append(name);
				sb.append("</td>");
				int r;
				int g;
				int b;
				float alpha = 1.0f;
				if (val.length() == 9) {
					r = Integer.decode("0x" + val.substring(3, 5));
					g = Integer.decode("0x" + val.substring(5, 7));
					b = Integer.decode("0x" + val.substring(7, 9));
					alpha = Integer.decode("0x" + val.substring(1, 3)) / 255f;
				}
				else {
					r = Integer.decode("0x" + val.substring(1, 3));
					g = Integer.decode("0x" + val.substring(3, 5));
					b = Integer.decode("0x" + val.substring(5, 7));
				}
				
				sb.append("<td style=\"background: rgba(" + r + "," + g + "," + b + "," + alpha + ");\">");
				sb.append(val);
				sb.append("</td>");
				sb.append("</tr>\n");
			}
		}

		sb.append("</table></body></html>");

		FileWriter fw = new FileWriter(output);
		fw.write(sb.toString());
		fw.flush();
		fw.close();
	}

}
