import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import javax.imageio.ImageIO;

import jp.agentec.adf.util.FileUtil;


public class ResCheck {
	private static final String HTML_PATH = "resCheck.html";
	private static final String bgcolor = "white";

	public static void main(String[] args) throws IOException {
		File current = new File(".");
		File baseDir = new File(FileUtil.getParentPath(FileUtil.getParentPath(current.getAbsolutePath())) + "ABVJE_Res_Default_Android\\res");

		List<String> dirList = Arrays.asList(new String[]{
				"drawable-mdpi","drawable-hdpi","drawable-xhdpi","drawable-xxhdpi",
				"drawable-land-mdpi","drawable-land-hdpi","drawable-land-xhdpi",
				"drawable-port-hdpi","drawable-port-mdpi","drawable-port-xhdpi",
				"drawable-normal-mdpi","drawable-normal-hdpi","drawable-normal-xhdpi",
				"drawable-large-land","drawable-large-land-hdpi","drawable-large-land-xhdpi",
				"drawable-large-port","drawable-large-port-hdpi","drawable-large-port-xhdpi"});

		List<String> allFileList = new ArrayList<String>();
		for (File file : baseDir.listFiles()) {
			if (file.getName().startsWith("drawable-")) {
				for (String child : file.list()) {
					if (!allFileList.contains(child)) {
						allFileList.add(child);
					}
				}
			}
		}
		Collections.sort(allFileList);

		StringBuffer sb = new StringBuffer();
		sb.append("<html>\n");
		sb.append("<head>\n");
		sb.append("<script type=\"text/javascript\">\n");
		sb.append("<!--\n");
		sb.append("var colorArray = new Array('pink','gray','orange','lightgreen','black','skyblue','white');\n");
		sb.append("var index=0;\n");
		sb.append("function changeBg(){\n");
		sb.append("index++;\n");
		sb.append("if (index>=colorArray.length) index=0;\n");
		sb.append("document.body.style.background=colorArray[index];\n");
		sb.append("}\n");
		sb.append("// -->\n");
		sb.append("</script>\n");
		sb.append("</head>\n");
		sb.append("<body bgcolor=\"" + bgcolor + "\" onclick=\"changeBg();\"><table border=1>\n");
		sb.append("<tr>");
		sb.append("<td>");
		sb.append("File");
		sb.append("</td>");
		for (String dir : dirList) {
			sb.append("<td>");
			sb.append(dir.substring("drawable-".length()));
			sb.append("</td>");
		}
		sb.append("</tr>\n");

		for (String target : allFileList) {
			sb.append("<tr>");
			sb.append("<td>");
			sb.append(target);
			sb.append("</td>");
			File[] listFiles = baseDir.listFiles();
			for (String dir : dirList) {
				for (File file : listFiles) {
					if (file.getName().equals(dir)) {
						sb.append("<td>");
						for (File child : file.listFiles()) {
							if (child.getName().equals(target)) {
								BufferedImage image = loadImage(child);
								if (image != null) {
									sb.append("<img src=\"");
									sb.append(child.getAbsolutePath());
									sb.append("\" width=50 height=50 title=\"" + image.getWidth() + "x" + image.getHeight() + "\">");
								}
								else {
									System.err.println("Image not found. " + child);
								}
							}
						}
						sb.append("</td>");
					}
				}
			}
			sb.append("</tr>\n");
		}

		sb.append("</table></body></html>");

		FileWriter fw = new FileWriter(HTML_PATH);
		fw.write(sb.toString());
		fw.flush();
		fw.close();
	}

	private static BufferedImage loadImage(File file) {
		try {
			FileInputStream in = new FileInputStream(file);
			BufferedImage rv = ImageIO.read(in);
			in.close();
			return rv;
		} catch(IOException e) {
			e.printStackTrace();
			return null;
		}
	}
}
