package jp.agentec.abook.abv.ui.viewer.activity;

import android.app.Dialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.database.Cursor;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkRequest;
import android.net.Uri;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiManager;
import android.net.wifi.WifiNetworkSpecifier;
import android.os.Build;
import android.os.Bundle;
import android.provider.BaseColumns;
import android.provider.MediaStore;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.GridView;
import android.widget.ListView;

import com.imagepicker.ImageInternalFetcher;
import com.theta.helper.ThetaHelper;
import com.theta.network.ThetaDeviceInfo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import jp.agentec.abook.abv.bl.common.Callback;
import jp.agentec.abook.abv.bl.common.Constant;
import jp.agentec.abook.abv.bl.common.constant.ABookKeys;
import jp.agentec.abook.abv.bl.common.constant.ABookValues;
import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.cl.environment.DeviceInfo;
import jp.agentec.abook.abv.cl.util.PreferenceUtil;
import jp.agentec.abook.abv.launcher.android.R;
import jp.agentec.abook.abv.ui.common.activity.ABVUIActivity;
import jp.agentec.abook.abv.ui.common.appinfo.AppDefType;
import jp.agentec.abook.abv.ui.common.util.AlertDialogUtil;
import jp.agentec.abook.abv.ui.common.util.PatternStringUtil;
import jp.agentec.abook.abv.ui.home.helper.ABookPermissionHelper;
import jp.agentec.abook.abv.ui.viewer.activity.theta.ThetaCameraActivity;
import jp.agentec.abook.abv.ui.viewer.activity.theta.task.DeviceInfoTask;
import jp.agentec.abook.abv.ui.viewer.adapter.ImageGalleryAdapter;
import jp.agentec.abook.abv.ui.viewer.adapter.WifiThetaConnectAdapter;
import jp.agentec.abook.abv.ui.viewer.helper.SceneSendHelper;
import jp.agentec.abook.abv.ui.viewer.view.CustomImage;

public class DeviceImageListActivity extends ABVUIActivity {
    private static final String TAG = "DeviceImageListActivity";

    //表示画像の解像度（低くなると画質が悪くなる）
    private static final int THUMBNAIL_SIZE = 700;
    //タブレットの１行最大表示数
    private static final int TABLET_COLUMNS = 4;
    //タブレットの縦表示時、１行最大表示数
    private static final int PHONE_COLUMNS_PORTRAIT = 3;
    //画像選択最大数
    private static final int IMAGE_SELECT_MAX_COUNT = 20;
    //登録完了後、100%プログレスバー表示のため、完了ダイアログ表示タイム
    public static final int SEND_FINISH_DIALOG_DELAY_MILLIS = 200;
    //THETAカメラWIFI接続後、切り替える時間が必要のため、カメラ情報取得ディレータイム
    private static final int GET_THETA_CAMERA_INFO_DELAY = 3000;
    //サムネイルの保存するとき、キャッシュの中のフォルダ名
    private static final String THUMB_IMAGE_CACHE_DIRECTORY_NAME = "thumb";

    //スマートフォン表示時、登録ボタンスケール
    private static final float PHONE_REGISTER_BUTTON_SCALE = 0.6f;
    //スマートフォン表示時、THETAボタンスケール
    private static final float PHONE_THETA_BUTTON_SCALE = 0.8f;

    GridView mGalleryGridView;

    ImageGalleryAdapter mGalleryAdapter;
    private ArrayList<String> mSelectedImages;
    private List<CustomImage>mLocalImageList;
    private Set<String>mLocalImageUriList;
    public ImageInternalFetcher mImageFetcher;
    private Button mRegistBtn;
    private Button mCameraBtn;
    private int mGridViewRowHeight;
    private boolean mIsOnResume;
    private Long mOperationId;
    private String mOperationName;
    private Dialog mThetaDeviceConnectDialog;
    private ListView notSavedListView;
    private ListView savedListView;
    private boolean mIsBaseSceneUpload = false;
    private boolean mIsBaseSceneUploadSuccess = true;

    protected ThetaHelper mThetaHelper = new ThetaHelper(this);
    private SceneSendHelper mSceneSendHelper = new SceneSendHelper(this);
    private WifiManager mWifiManager;

    private List<String> savedThetaList_ = new ArrayList<>();
    private boolean isStartCamera_ = false;     // THETAとの接続開始フラグ
    private ConnectivityManager.NetworkCallback networkCallback_ = null; // ネットワーク状態更新時のコールバック

    @Override
    public void onCreate(Bundle savedInstanceState) {
        Logger.i(TAG, "onCreate");
        super.onCreate(savedInstanceState);
        setContentView(R.layout.ac_device_image_list);

        Intent intent = getIntent();
        mIsBaseSceneUpload = intent.getBooleanExtra(ABookKeys.BASE_CONTENT_REGISTER, false);
        mOperationId = intent.getLongExtra(ABookKeys.OPERATION_ID, -1);
        mOperationName = intent.getStringExtra(ABookKeys.OPERATION_NAME);
        mSelectedImages = new ArrayList<>();
        mLocalImageList = new ArrayList<>();
        mLocalImageUriList = new HashSet<>();
        mIsOnResume = false;
        mIsBaseSceneUploadSuccess = false;
        mWifiManager =  (WifiManager)getApplicationContext().getSystemService(Context.WIFI_SERVICE);
        mImageFetcher = new ImageInternalFetcher(this, THUMBNAIL_SIZE);
        mImageFetcher.addImageCache(this, THUMB_IMAGE_CACHE_DIRECTORY_NAME);
        mImageFetcher.clearCache();

        mGalleryGridView = findViewById(R.id.gallery_grid);
        Button closeBtn = findViewById(R.id.close); // 閉じるボタン
        closeBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Logger.v(TAG, "CloseBtn.onClick");
                //キャッシュをクリア
                mImageFetcher.clearCache();
                activityClose();
            }
        });

        mRegistBtn = findViewById(R.id.regist);
        mRegistBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Logger.v(TAG, "RegistBtn.onClick");
                buttonDoubleTapControl(mRegistBtn);
                if (checkNetworkConnected()) {
                    AlertDialogUtil.showAlertDialog(DeviceImageListActivity.this, R.string.app_name, R.string.msg_image_select_send_comfirm, false, new DialogInterface.OnClickListener() {
                        @Override
                        public void onClick(DialogInterface dialog, int which) {
                            if (checkNetworkConnected()) {
                                sendImageList(mSelectedImages);
                            }
                        }
                    });
                }
            }
        });
        mRegistBtn.setEnabled(false);

        mCameraBtn = findViewById(R.id.theta_camera);
        mCameraBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Logger.v(TAG, "RegistBtn.onClick");
                buttonDoubleTapControl(mCameraBtn);
                if (deviceWifiEnable()) { //端末のWifi機能ON・OFFチェック
                    if (DeviceInfo.isDeviceLocationEnabled(DeviceImageListActivity.this)) { //端末の位置情報ON・OFFチェック
                        //位置情報権限チェック
                        ABookPermissionHelper helper = new ABookPermissionHelper(DeviceImageListActivity.this, Constant.ABookPermissionType.AccessFineLocation, null);
                        if (helper.checkMultiPermissions(true)) { //アプリの位置情報ON・OFFチェック
                            showThetaDeviceConnectDialog();
                        }
                    } else {
                        showSimpleAlertDialog(R.string.msg_device_location_off);
                    }
                }

            }
        });
        //スマートフォンの場合、「登録」「THETA」ボタンサイズ変更
        if (isNormalSize()) {
            ViewGroup.LayoutParams params = mRegistBtn.getLayoutParams();
            //サイズに変更
            params.width = (int) (params.width * PHONE_REGISTER_BUTTON_SCALE);
            mRegistBtn.setLayoutParams(params);

            params = mCameraBtn.getLayoutParams();
            params.width = (int) (params.width * PHONE_THETA_BUTTON_SCALE);
            mCameraBtn.setLayoutParams(params);
        }

        //表示中にストレージ権限がなくなった場合、シーン画像選択画面を非表示
        final Callback resultCallback = new Callback() {
            @Override
            public Object callback(Object ret) {
                finish();
                return null;
            }
        };
        ABookPermissionHelper helper = new ABookPermissionHelper(this, Constant.ABookPermissionType.ReadExternalStorage, resultCallback);
        if (!helper.checkMultiPermissions(true)) {
            if (!isNormalSize()) {
                //タブレットの場合、何も表示されないダイアログのサイズ調整
                Resources r = Resources.getSystem();
                Configuration config = r.getConfiguration();
                onConfigurationChanged(config);
            }
            return;
        }

        getDeviceGalleryImageList();

        //ダイアログサイズ調整
        Resources r = Resources.getSystem();
        Configuration config = r.getConfiguration();
        onConfigurationChanged(config);
    }

    @Override
    public void onResume() {
        super.onResume();
        //初回画面表示時にはよばれないようにする。
        if (mIsOnResume) {
            getDeviceGalleryImageList();
            displayGalleryGridView();
        }
        mIsOnResume = true;

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.Q) {
            // Android10の場合は、コールバック登録解除で、THETAとの接続が切れる
            if (networkCallback_ != null && isStartCamera_) {
                ConnectivityManager cm = (ConnectivityManager) getSystemService(Context.CONNECTIVITY_SERVICE);
                if (cm != null) {
                    cm.unregisterNetworkCallback(networkCallback_);
                    isStartCamera_ = false;
                }
            }
        }
    }

    //端末の戻るボタン禁止
    @Override
    public boolean dispatchKeyEvent(KeyEvent event) {
        Logger.v(TAG, "dispatchKeyEvent %s", event);
        if (event.getAction()==KeyEvent.ACTION_UP) { // 戻るボタンを抑止
            if (event.getKeyCode() == KeyEvent.KEYCODE_BACK) {
                return true;
            }
        }
        return super.dispatchKeyEvent(event);
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        int widthPixels = (int) (getResources().getDisplayMetrics().widthPixels * DIALOG_WINDOW_RESIZE_SCALE_09) ;
        int heightPixels = (int) (getResources().getDisplayMetrics().heightPixels * DIALOG_WINDOW_RESIZE_SCALE_09);
        int numColumn;
        if (isNormalSize()) { //スマートフォン
            numColumn = PHONE_COLUMNS_PORTRAIT;
        } else { //タブレット端末
            WindowManager.LayoutParams lp = getWindow().getAttributes();
            if (widthPixels > heightPixels) {
                lp.width = heightPixels;
                lp.height = heightPixels;
            } else {
                lp.width = widthPixels;
                lp.height = widthPixels;
            }
            getWindow().setAttributes(lp);
            numColumn = TABLET_COLUMNS;
            widthPixels = lp.width;
        }
        mGalleryGridView.setNumColumns(numColumn);
        mGridViewRowHeight = widthPixels / numColumn;
        //回転時、横・縦表示数が異なるため、スマートフォンだけ再描画する。
        if (isNormalSize()) { //スマートフォン
            displayGalleryGridView();
        } else {
            //回転時にはよばれないようにチェックし、初回表示時のみ実行（onCreateから呼ばれた時）
            if (!mIsOnResume) {
                displayGalleryGridView();
            }
        }
    }

    /**
     * 端末のギャラリーから画像情報を取得
     */
    private void getDeviceGalleryImageList() {
        if (mLocalImageList.size() != 0) {
            mLocalImageList.clear();
            mLocalImageUriList.clear();
        }

        final String[] columns = {MediaStore.MediaColumns.DATA, BaseColumns._ID,
                MediaStore.Images.ImageColumns.ORIENTATION, MediaStore.MediaColumns.DATE_ADDED};
        final String orderBy = BaseColumns._ID + " DESC";
        Cursor imageCursor = getContentResolver().query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, columns, null, null, orderBy);
        if (imageCursor != null) {
            while (imageCursor.moveToNext()) {
                String uriStr = imageCursor.getString(imageCursor.getColumnIndex(MediaStore.MediaColumns.DATA));
                Uri uri = Uri.parse(uriStr);
                int orientation = imageCursor.getInt(imageCursor.getColumnIndex(MediaStore.Images.ImageColumns.ORIENTATION));
                mLocalImageList.add(new CustomImage(uri, orientation));
                mLocalImageUriList.add(uriStr);
            }
            imageCursor.close();
        }

        //選択された画像情報から削除された画像情報削除
        if (mSelectedImages.size() > 0) {
            Iterator<String> it = mSelectedImages.iterator();
            while(it.hasNext()){
                String uriStr = it.next();
                if (!mLocalImageUriList.contains(uriStr)) {
                    it.remove();
                }
            }
            if (mSelectedImages.size() == 0) {
                mRegistBtn.setEnabled(false);
            }
        }
    }

    /**
     * 端末のギャラリーから画像情報を元にして、GridViewビューア描画
     */
    private void displayGalleryGridView() {
        mGalleryAdapter = new ImageGalleryAdapter(this, mLocalImageList, mGridViewRowHeight, mIsBaseSceneUpload);
        mGalleryGridView.setAdapter(mGalleryAdapter);
        mGalleryGridView.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            private boolean isClicked = false;
            @Override
            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                CustomImage customImage = mGalleryAdapter.getItem(i);
                if (containsCustomImageUri(customImage.mUri)) {
                    boolean isFirst = firstCustomImageUri(customImage.mUri);
                    mSelectedImages.remove(customImage.mUri.toString());
                    //ベースシーンが削除された場合、2番目に選択された画像がベースシーン選択状態にする
                    if (mIsBaseSceneUpload) {
                        if (isFirst) {
                            mGalleryAdapter.notifyDataSetChanged();
                            mRegistBtn.setEnabled(mSelectedImages.size() != 0);
                            return;
                        }
                    }
                } else {
                    //最大選択画像をチェック
                    if (mSelectedImages.size() + 1 > IMAGE_SELECT_MAX_COUNT) {
                        if (isClicked) {
                            return;
                        }
                        isClicked = true;

                        showSimpleAlertDialog(getResources().getString(R.string.app_name), String.format(getResources().getString(R.string.msg_image_select_max_count_over), String.valueOf(IMAGE_SELECT_MAX_COUNT)));
                        //連続タップ防止
                        handler.postDelayed(new Runnable() {
                            @Override
                            public void run() {
                                isClicked = false;
                            }
                        }, 1000);
                        return;
                    }
                    mSelectedImages.add(customImage.mUri.toString());
                }
                //refresh the view to
                mGalleryAdapter.getView(i, view, adapterView);
                mRegistBtn.setEnabled(mSelectedImages.size() != 0);
            }
        });
    }

    /**
     * チェック画像を表示するため、
     * 該当画像URIが保存されているデータに存在チェック
     * @param imageUri 対象画像情報
     * @return true:ある、false:ない
     */
    public boolean containsCustomImageUri(Uri imageUri){
        return mSelectedImages.contains(imageUri.toString());
    }

    /**
     * 選択画像配列から1番目かチェック
     * @param imageUri 画像ファイル情報
     * @return true:1番目、false:2番目以上
     */
    public boolean firstCustomImageUri(Uri imageUri){
        if (mIsBaseSceneUpload && mIsBaseSceneUploadSuccess) {
            return false;
        }
        return mSelectedImages.indexOf(imageUri.toString()) == 0;
    }

    /**
     * 選択されている画像をサーバ側に送信する。
     */
    private void sendImageList(final List<String> sendImages) {
        showProgressView(PatternStringUtil.patternToString(getApplicationContext(),
                R.string.msg_access_registing,
                getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)));
        mSceneSendHelper.setListener(new SceneSendHelper.DeviceImageListSendListener() {
            /**
             * シーン登録成功した後、ダイアログ表示
             */
            @Override
            public void sceneSendfinish() {
                handler.postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        //プログレスバー非表示
                        closeProgressPopup();
                        //成功ダイアログ表示
                        AlertDialogUtil.showAlertDialog(DeviceImageListActivity.this, R.string.app_name, R.string.msg_image_select_send_success, true, new DialogInterface.OnClickListener() {
                            @Override
                            public void onClick(DialogInterface dialog, int which) {
                                activityClose();
                            }
                        });
                    }
                }, SEND_FINISH_DIALOG_DELAY_MILLIS);
            }
            /**
             * インジケーターのプログレスバー更新
             * @param progress プログレスバー設定値
             */
            @Override
            public void changeProgress(final int progress) {
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        if (mIsBaseSceneUpload && !mIsBaseSceneUploadSuccess) {
                            mIsBaseSceneUploadSuccess = true;
                        }
                        progressDialogHorizontal.setProgress(progress);
                    }
                });
            }
            /**
             * サーバ通信失敗時に再度送信要求しない。
             * @param errorMessage エラーメッセージ
             */
            @Override
            public void sceneSendFail(final String errorMessage) {
                // シーン追加時、ロック状態である場合
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        closeProgressPopup();
                        if (mIsBaseSceneUpload) {
                            AlertDialogUtil.showAlertDialog(DeviceImageListActivity.this, getString(R.string.app_name), errorMessage, true, new DialogInterface.OnClickListener() {
                                @Override
                                public void onClick(DialogInterface dialog, int which) { //OKボタン
                                    activityClose();
                                }
                            });
                        } else {
                            showSimpleAlertDialog(errorMessage);
                        }
                    }
                });
            }

            /**
             * サーバ通信失敗時に再度送信要求する
             * @param sendImages 再送信画像FilePath配列
             */
            @Override
            public void sceneSendFailRetry(final List<String> sendImages) {
                handler.post(new Runnable() {
                    @Override
                    public void run() {
                        closeProgressPopup();
                        //ベースシーンアップロード時、ベースシーン登録完了の場合、Cancelでシーン画像選択画面非表示
                        if (mIsBaseSceneUpload) {
                            AlertDialogUtil.showAlertDialog(DeviceImageListActivity.this, R.string.app_name, R.string.msg_image_select_send_fail_retry, new DialogInterface.OnClickListener() {
                                @Override
                                public void onClick(DialogInterface dialog, int which) { //OKボタン
                                    if (checkNetworkConnected()) {
                                        sendImageList(sendImages);
                                    }
                                }
                            }, new DialogInterface.OnClickListener() { //Cancelボタン
                                @Override
                                public void onClick(DialogInterface dialog, int which) {
                                    activityClose();
                                }
                            });
                        } else {
                            AlertDialogUtil.showAlertDialog(DeviceImageListActivity.this, R.string.app_name, R.string.msg_image_select_send_fail_retry, false, new DialogInterface.OnClickListener() {
                                @Override
                                public void onClick(DialogInterface dialog, int which) { //OKボタン
                                    //インターネット非接続チェック
                                    if (checkNetworkConnected()) {
                                        sendImageList(sendImages);
                                    }
                                }
                            });
                        }
                    }
                });
            }
        });
        mSceneSendHelper.sendSceneImages(sendImages, mOperationId, mOperationName, mIsBaseSceneUpload, mIsBaseSceneUploadSuccess);
    }

    /**
     * THETAカメラ接続ダイアログを表示
     */
    private void showThetaDeviceConnectDialog() {
        if (mThetaDeviceConnectDialog == null) {
            mThetaDeviceConnectDialog = new Dialog(DeviceImageListActivity.this);
            mThetaDeviceConnectDialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
            mThetaDeviceConnectDialog.setCanceledOnTouchOutside(false);
            mThetaDeviceConnectDialog.setContentView(R.layout.theta_device_connect_dialog);
            mThetaDeviceConnectDialog.setCancelable(false);
        }

        //更新ボタン
        final Button registerButton = mThetaDeviceConnectDialog.findViewById(R.id.btn_theta_update);
        registerButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Logger.v(TAG,"registerButton.onClick");
                buttonDoubleTapControl(registerButton);
                if (deviceWifiEnable()) {
                    wifiScanStart();
                }
            }
        });

        //閉じるボタン
        final Button viewCloseButton = mThetaDeviceConnectDialog.findViewById(R.id.btn_close);
        viewCloseButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                buttonDoubleTapControl(viewCloseButton);
                mThetaDeviceConnectDialog.dismiss();
            }
        });

        //登録済みの端末リスト表示
        savedListView = mThetaDeviceConnectDialog.findViewById(R.id.lv_theta_wifi_saved);
        WifiThetaConnectAdapter wifiSavedAdapter = new WifiThetaConnectAdapter(this, new ArrayList<ThetaDeviceInfo>());
        savedListView.setAdapter(wifiSavedAdapter);
        savedListView.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                if (deviceWifiEnable()) {
                    ThetaDeviceInfo info = (ThetaDeviceInfo) parent.getItemAtPosition(position);
                    connectThetaWifi(info.getSSID(), info.getNetworkId());
                }
            }
        });

        //未登録の端末リスト表示
        notSavedListView = mThetaDeviceConnectDialog.findViewById(R.id.lv_theta_wifi_not_saved);
        WifiThetaConnectAdapter wifiNotSaveAdapter = new WifiThetaConnectAdapter(this, new ArrayList<ThetaDeviceInfo>());
        notSavedListView.setAdapter(wifiNotSaveAdapter);
        notSavedListView.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                if (deviceWifiEnable()) {
                    ThetaDeviceInfo info = (ThetaDeviceInfo) parent.getItemAtPosition(position);
                    connectThetaWifi(info.getSSID(), -1);
                }
            }
        });

        mThetaDeviceConnectDialog.show();
        wifiScanStart();
    }

    /**
     * ブロードキャスト リスナーを登録し、Wifiスキャンを開始する。
     */
    private void wifiScanStart() {
        Logger.v(TAG,"wifiScanStart");
        showProgressPopup();
        registerReceiver(wifiReceiver, new IntentFilter(WifiManager.SCAN_RESULTS_AVAILABLE_ACTION));
        mWifiManager.startScan();
    }

    /**
     * THETAカメラへ接続
     * @param ssid アクセスポイント
     * @param networkId 接続可能なネットワークID
     */
    private void connectThetaWifi(final String ssid, int networkId) {
        Logger.i(TAG,"connectThetaWifi ssid=%s, networdId=%s, Build.VERSION_CODE=%s", ssid, networkId, Build.VERSION.SDK_INT);
        showProgressPopup(getString(R.string.msg_wifi_connecting));

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.Q) {

            WifiNetworkSpecifier.Builder builder = new WifiNetworkSpecifier.Builder();
            builder.setSsid(ssid);
            String pass = mThetaHelper.getPassword(ssid);
            builder.setWpa2Passphrase(pass);

            WifiNetworkSpecifier wifiNetworkSpecifier = builder.build();
            NetworkRequest.Builder networkRequestBuilder = new NetworkRequest.Builder();
            networkRequestBuilder.addTransportType(NetworkCapabilities.TRANSPORT_WIFI);
            networkRequestBuilder.setNetworkSpecifier(wifiNetworkSpecifier);
            NetworkRequest networkRequest = networkRequestBuilder.build();

            ConnectivityManager cm = (ConnectivityManager) getSystemService(Context.CONNECTIVITY_SERVICE);
            if (cm != null) {
                networkCallback_ = new ConnectivityManager.NetworkCallback() {
                    @Override
                    public void onAvailable(Network network) {
                        super.onAvailable(network);
                        ConnectivityManager cm = (ConnectivityManager) getSystemService(Context.CONNECTIVITY_SERVICE);
                        if (cm != null) {
                            // 接続したら保存
                            addThetaSSID(ssid);
                            PreferenceUtil.put(getApplicationContext(), AppDefType.DefPrefKey.THETA_SSID_STRING, savedThetaList_.toArray(new String[savedThetaList_.size()]));

                            cm.bindProcessToNetwork(network);
                            handler.postDelayed(new Runnable() {
                                @Override
                                public void run() {
                                    new DeviceInfoTask(DeviceImageListActivity.this).execute();
                                }
                            }, GET_THETA_CAMERA_INFO_DELAY);
                        }
                    }
                    @Override
                    public void onLost(Network network) {
                        super.onLost(network);
                        closeProgressPopup();
                    }

                    @Override
                    public void onUnavailable() {
                        super.onUnavailable();
                        closeProgressPopup();
                    }
                };
                cm.requestNetwork(networkRequest, networkCallback_);
            }
        } else {

            if (networkId == -1) {
                networkId = mThetaHelper.saveThetaCameraWifi(ssid);
                if (networkId == -1) {
                    Logger.e(TAG, "saveThetaCameraWifi networkId -1");
                    closeProgressPopup();
                    showSimpleAlertDialog(getString(R.string.msg_fail_connect_theta_wifi));
                    return;
                }
            }
            boolean isSuccess = mThetaHelper.connectThetaCameraWifi(networkId);
            if (isSuccess) {
                handler.postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        new DeviceInfoTask(DeviceImageListActivity.this).execute();
                    }
                }, GET_THETA_CAMERA_INFO_DELAY);
            } else {
                Logger.e(TAG, "connectThetaCameraWifi fail");
                closeProgressPopup();
                AlertDialogUtil.showAlertDialog(this, R.string.app_name, R.string.msg_fail_connect_theta_wifi, true, new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        Logger.i(TAG, "---AlertDialogUtil.onClick");
                        wifiScanStart();
                    }
                });
            }
        }
    }

    /**
     * ActivityをFinishする
     */
    private void activityClose() {
        //ベースシーン登録成功後、新着更新させるため
        if (mIsBaseSceneUpload) {
            if (mIsBaseSceneUploadSuccess) {
                setResult(RESULT_OK);
            }
        }
        finish();
    }

    /**
     * THETAカメラ情報取得完了後、呼ばれる
     * 成功：利用するAPI情報保存後、THETAカメラ画面表示
     * 失敗：エラーアラート表示
     * @param deviceInfo THETAカメラ情報
     */
    public void thetaDeviceInfoTaskFinish(ThetaDeviceInfo deviceInfo) {
        closeProgressPopup();
        if (deviceInfo != null && deviceInfo.getModel().length() != 0) {
            if (deviceInfo.getModel().equals(ABookValues.THETA_MODEL_NAME_THETA_S) || deviceInfo.getModel().equals(ABookValues.THETA_MODEL_NAME_THETA_SC)) {
                putUserPref(ABookKeys.THETA_OLD_VERSION_FLG, true);
                Logger.d(TAG, "thetaDeviceInfoTaskFinish　use API2.0");
            } else {
                putUserPref(ABookKeys.THETA_OLD_VERSION_FLG, false);
                Logger.d(TAG, "thetaDeviceInfoTaskFinish use　API2.1");
            }

            if (mThetaDeviceConnectDialog != null && mThetaDeviceConnectDialog.isShowing()) {
                mThetaDeviceConnectDialog.dismiss();
            }

            //THETAカメラ画面表示
            Intent intent = new Intent();
            intent.setClassName(getPackageName(), ThetaCameraActivity.class.getName());
            startActivity(intent);
            isStartCamera_ = true;
        } else {
            AlertDialogUtil.showAlertDialog(this, R.string.app_name, R.string.msg_fail_connect_theta_wifi, true, new DialogInterface.OnClickListener() {
                @Override
                public void onClick(DialogInterface dialog, int which) {
                    wifiScanStart();
                }
            });
        }
    }

    /**
     * Wifiスキャンするブロードキャストリスナークラス
     */
    BroadcastReceiver wifiReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            unregisterReceiver(wifiReceiver);
            thetaWifiScanResult();
        }
    };

    /**
     * Wifiスキャン結果を処理
     * ①接続済みの場合、THETAカメラ遷移
     * ②登録済みの端末情報取得し、画面再描画
     * ③未登録の端末情報取得し、画面再描画
     */
    public void thetaWifiScanResult() {
        List<ScanResult> results = mWifiManager.getScanResults();
        boolean isConnected = false;
        List<ThetaDeviceInfo> scanWifiList = new ArrayList<>();
        List<ThetaDeviceInfo> scanSavedWifiList = new ArrayList<>();
        for (ScanResult scanResult : results) {
            String scanSSID = scanResult.SSID.replace("\"", "");
            Logger.d(TAG, "*****scanSSID = "+ scanSSID);
            if (scanSSID.length() != 0) {
                int index = scanSSID.indexOf(ABookValues.THETA_MODEL_NAME_THETA);
                ThetaDeviceInfo deviceInfo = new ThetaDeviceInfo();
                if (index != -1) {
                    int networkId = -1;
                    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.Q) {
                        deviceInfo.setSSID(scanSSID);
                        String[] ssid = PreferenceUtil.get(getApplicationContext(), AppDefType.DefPrefKey.THETA_SSID_STRING);
                        if (ssid != null) {
                            savedThetaList_ = new ArrayList<>(Arrays.asList(ssid));
                            if (findThetaSSID(scanSSID)) {
                                networkId = 0; // -1 だと未登録になるので
                                deviceInfo.setSSID(scanSSID);
                                deviceInfo.setNetworkId(networkId);
                            }
                        }
                    } else {
                        for (WifiConfiguration configuration : mWifiManager.getConfiguredNetworks()) {
                            // Android4.2以降よりダブルクォーテーションが付いてくるので除去
                            String configurationSSID = configuration.SSID.replace("\"", "");
                            if (configurationSSID.equals(scanSSID)) {
                                if (configuration.status == WifiConfiguration.Status.CURRENT) {
                                    isConnected = true;
                                } else {
                                    networkId = configuration.networkId;
                                    deviceInfo.setSSID(configurationSSID);
                                    deviceInfo.setNetworkId(networkId);
                                }
                                break;
                            }
                        }
                        if (isConnected) {
                            break;
                        }
                    }
                    if (networkId == -1) { //保存されてない
                        deviceInfo.setSSID(scanSSID);
                        scanWifiList.add(deviceInfo);
                    } else {
                        scanSavedWifiList.add(deviceInfo);
                    }
                }
            }
        }
        if (isConnected) {
            //THETA接続状態の場合、カメラ画面へ遷移
            changeProgressPopup(getString(R.string.msg_wifi_connecting));
            new DeviceInfoTask(DeviceImageListActivity.this).execute();
        } else {
            //カメラ選択画面再描画
            WifiThetaConnectAdapter savedAdapter = (WifiThetaConnectAdapter) savedListView.getAdapter();
            savedAdapter.setListItem(scanSavedWifiList);
            savedAdapter.notifyDataSetChanged();
            WifiThetaConnectAdapter notSaveAdapter = (WifiThetaConnectAdapter) notSavedListView.getAdapter();
            notSaveAdapter.setListItem(scanWifiList);
            notSaveAdapter.notifyDataSetChanged();
        }
        closeProgressPopup();
    }

    /**
     * savedThetaList_ に新しい ssidを追加する
     * @param ssid
     * @return ssidの追加された、あたらしいsavedThetaList_
     */
    private List<String> addThetaSSID(String ssid) {
        if (!findThetaSSID(ssid)) {
            savedThetaList_.add(ssid);
        }
        return savedThetaList_;
    }

    /**
     * savedThetaList_ に、すでにssidが存在するか？
     * @param ssid
     * @return　存在するならtrue
     */
    private boolean findThetaSSID(String ssid) {
        for (String id : savedThetaList_) {
            if (id.equals(ssid)) {
                return true;
            }
        }
        return false;
    }
}
