/*
 * Decompiled with CFR 0.152.
 */
package oz.api;

import android.app.Activity;
import android.content.ClipData;
import android.content.ContentResolver;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.drawable.BitmapDrawable;
import android.media.ExifInterface;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.Handler;
import android.os.ParcelFileDescriptor;
import android.os.StrictMode;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import android.provider.Settings;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.webkit.MimeTypeMap;
import android.webkit.WebView;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import oz.api.OZHighlightCustomViewListener;
import oz.api.OZRViewerCmd;
import oz.api.OZRViewerCmdImpl;
import oz.api.OZReportCommandListener;
import oz.api.OZReportCustomUICheckListener;
import oz.api.OZReportViewer;
import oz.api.OZReportViewerImpl$1;
import oz.api.OZReportViewerImpl$2;
import oz.api.OZReportViewerImpl$ActivityResultReturnData;
import oz.client.shape.ui.ICImagePickerWnd;
import oz.client.shape.ui.ICSignPadWnd;
import oz.client.shape.ui.OZInputComponent;
import oz.main.MainFrameView;
import oz.main.OZPageView;
import oz.main.OZStorage;
import oz.util.LinkedHashtable;
import oz.util.OZDirectByteBufferInputStream;
import oz.util.OZLocationManager;

public class OZReportViewerImpl
extends OZReportViewer {
    private ViewGroup _parentView = null;
    private OZReportCommandListener m_listener = null;
    private Handler m_handler = null;
    private boolean _disposed = false;
    LinkedHashtable m_exportMap;
    OZRViewerCmdImpl m_viewerCmd = null;

    protected void internalInit(ViewGroup viewGroup) {
        MainFrameView.s_context = viewGroup.getContext();
        LinearLayout linearLayout = new LinearLayout(viewGroup.getContext());
        LinearLayout linearLayout2 = new LinearLayout(viewGroup.getContext());
        linearLayout.setOrientation(1);
        linearLayout.addView((View)linearLayout2, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, 0, 1.0f));
        viewGroup.addView((View)linearLayout, new ViewGroup.LayoutParams(-1, -1));
        this._parentView = linearLayout2;
        this.mainThreadPolicy();
        this.storage();
        this.tempResourceCopy();
        this.initInstance();
    }

    protected String getClientDeviceInfoHash() {
        int n = Settings.Secure.getString((ContentResolver)this._parentView.getContext().getContentResolver(), (String)"android_id").hashCode();
        return Integer.toString(n);
    }

    private void mainThreadPolicy() {
        GenericDeclaration genericDeclaration;
        try {
            genericDeclaration = Class.forName("android.os.StrictMode", true, Thread.currentThread().getContextClassLoader());
            Class<?> clazz = Class.forName("android.os.StrictMode$ThreadPolicy", true, Thread.currentThread().getContextClassLoader());
            Class<?> clazz2 = Class.forName("android.os.StrictMode$ThreadPolicy$Builder", true, Thread.currentThread().getContextClassLoader());
            Method method = ((Class)genericDeclaration).getMethod("setThreadPolicy", clazz);
            Method method2 = clazz2.getMethod("permitDiskReads", new Class[0]);
            Method method3 = clazz2.getMethod("permitDiskWrites", new Class[0]);
            Method method4 = clazz2.getMethod("permitNetwork", new Class[0]);
            Method method5 = clazz2.getMethod("build", new Class[0]);
            Constructor<?> constructor = clazz2.getConstructor(new Class[0]);
            Object obj = constructor.newInstance(new Object[0]);
            Object object = method2.invoke(obj, new Object[0]);
            object = method3.invoke(object, new Object[0]);
            object = method4.invoke(object, new Object[0]);
            Object object2 = method5.invoke(object, new Object[0]);
            method.invoke((Object)genericDeclaration, object2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (Build.VERSION.SDK_INT >= 24) {
            try {
                genericDeclaration = StrictMode.class.getMethod("disableDeathOnFileUriExposure", new Class[0]);
                ((Method)genericDeclaration).invoke(null, new Object[0]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void setHelpURL(String string) {
        OZStorage.m_helpURL = string;
    }

    private void storage() {
        OZStorage.initEnv(this._parentView.getContext());
        this.tmpCacheDeleteFiles();
    }

    private void tmpCacheDeleteFiles() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tempResourceCopy() {
        String[] stringArray = null;
        try {
            Closeable closeable;
            String string;
            long l;
            Object object;
            PackageManager packageManager;
            String string2 = this.getCacheTmpDir() + "/OZReport Viewer/res";
            boolean bl = new File(string2).mkdirs();
            Log.d((String)"OZViewer", (String)("make Resource Dir is " + bl));
            File file = new File(string2 + "/resourcever.txt");
            Properties properties = new Properties();
            if (file.exists()) {
                packageManager = this._parentView.getContext().getPackageManager();
                object = null;
                l = 0L;
                try {
                    object = packageManager.getApplicationInfo(this._parentView.getContext().getPackageName(), 0);
                    string = object.sourceDir;
                    l = new File(string).lastModified();
                    closeable = new FileInputStream(file);
                    properties.load((InputStream)closeable);
                    ((FileInputStream)closeable).close();
                    String string3 = properties.getProperty("version", "-1");
                    if (string3.equals(l + "")) {
                        return;
                    }
                    properties.setProperty("version", l + "");
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    properties.store(fileOutputStream, "OZReport Viewer Resource Version");
                    fileOutputStream.close();
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    nameNotFoundException.printStackTrace();
                }
            } else {
                packageManager = this._parentView.getContext().getPackageManager();
                object = null;
                l = 0L;
                try {
                    object = packageManager.getApplicationInfo(this._parentView.getContext().getPackageName(), 0);
                    string = object.sourceDir;
                    l = new File(string).lastModified();
                    Log.d((String)"OZViewer", (String)("App Install time==" + l));
                    properties.setProperty("version", l + "");
                    closeable = new FileOutputStream(file);
                    properties.store((OutputStream)closeable, "OZReport Viewer Resource Version");
                    ((FileOutputStream)closeable).close();
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    nameNotFoundException.printStackTrace();
                }
            }
            stringArray = this._parentView.getContext().getResources().getAssets().list("resource/xml");
            if (stringArray != null) {
                for (int j = 0; j < stringArray.length; ++j) {
                    object = new File(string2 + "/" + stringArray[j].toLowerCase());
                    InputStream inputStream = null;
                    FileOutputStream fileOutputStream = null;
                    try {
                        inputStream = this._parentView.getContext().getResources().getAssets().open("resource/xml/" + stringArray[j]);
                        fileOutputStream = new FileOutputStream((File)object);
                        this.transfer(inputStream, fileOutputStream);
                        Log.d((String)"OZViewer", (String)("file [" + stringArray[j] + "] copy ok"));
                        continue;
                    }
                    catch (Exception exception) {
                        Log.e((String)"OZViewer", (String)"file copy error", (Throwable)exception);
                        continue;
                    }
                    finally {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                    }
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            Log.e((String)"OZViewer", (String)"file not founded.", (Throwable)iOException);
        }
    }

    private void transfer(InputStream inputStream, OutputStream outputStream) {
        byte[] byArray = new byte[2048];
        int n = 0;
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    public ViewGroup getParentView() {
        return this._parentView;
    }

    public String getCacheTmpDir() {
        String string = this._parentView.getContext().getExternalFilesDir(null).toString();
        Log.d((String)"OZViewer", (String)("temp folder = " + string));
        return string;
    }

    public String getPackageName() {
        return this._parentView.getContext().getPackageName();
    }

    public String getNativeLibraryFolder() {
        if (this._parentView != null) {
            return this._parentView.getContext().getApplicationInfo().nativeLibraryDir;
        }
        return "";
    }

    public String getPackageResourcePath() {
        if (this._parentView != null) {
            String string = null;
            string = Build.VERSION.SDK_INT < 21 ? Build.CPU_ABI : Build.SUPPORTED_ABIS[0];
            return this._parentView.getContext().getPackageResourcePath() + "!/lib/" + string;
        }
        return "";
    }

    public String getCacheTmpDirUrlCache() {
        String string = this._parentView.getContext().getCacheDir().getAbsolutePath();
        Log.d((String)"OZViewer", (String)("temp url cache folder = " + string));
        return string;
    }

    public String getDefaultLanguage() {
        return Locale.getDefault().getLanguage();
    }

    public String getDefaultCountry() {
        return Locale.getDefault().getCountry();
    }

    public int getTimezone() {
        return Calendar.getInstance().getTimeZone().getRawOffset();
    }

    public int getDaylight() {
        return Calendar.getInstance().getTimeZone().useDaylightTime() ? 1 : 0;
    }

    public void SetLangAndCountry(String string) {
        OZStorage.m_strLan = string;
    }

    public float getDensityDPI() {
        return OZStorage.getDensityDPI();
    }

    public float getScreenDPI() {
        return OZStorage.getScreenDPI();
    }

    public void dispose() {
        if (!this._disposed) {
            this._disposed = true;
            Log.d((String)"OZViewer", (String)"Call Dispose");
            if (OZLocationManager.getInstance(null) != null) {
                OZLocationManager.getInstance(null).reset();
            }
            if (this._parentView.getParent() != null && this._parentView.getParent().getParent() != null) {
                Log.d((String)"OZViewer", (String)"Remove from parent");
                ((ViewGroup)this._parentView.getParent().getParent()).removeAllViewsInLayout();
            }
            this.setListener(null);
            this.nativeSetListener();
            this.unbindImagePickerAndSignPadReferences(this._parentView);
            this.Script("closeall");
            this.nativeOnDispose();
            this.unbindReferences((View)this._parentView);
            System.clearProperty("OZ_HTTP_REQUEST_TIMEOUT");
            if (Build.VERSION.SDK_INT <= 23) {
                Runtime.getRuntime().gc();
                System.runFinalization();
                Handler handler = new Handler();
                handler.postDelayed((Runnable)new OZReportViewerImpl$1(this), 1000L);
            }
            this.setHighlightCustomViewListener(null);
            if (this.m_handler != null) {
                this.m_handler.removeCallbacksAndMessages(null);
                this.m_handler = null;
            }
        }
    }

    public void setListener(OZReportCommandListener oZReportCommandListener) {
        this.m_listener = oZReportCommandListener;
    }

    public OZReportCommandListener getListener() {
        return this.m_listener;
    }

    public void setCustomUICheckListener(OZReportCustomUICheckListener oZReportCustomUICheckListener) {
        this.nativeSetCustomUICheckListener(oZReportCustomUICheckListener);
    }

    public void setHighlightCustomViewListener(OZHighlightCustomViewListener oZHighlightCustomViewListener) {
        this.nativeSetHighlightCustomViewListener(oZHighlightCustomViewListener);
    }

    protected void finalize() {
        super.finalize();
        this.dispose();
    }

    protected native void initInstance();

    protected native void nativeOnDispose();

    protected native void nativeSetListener();

    protected native void nativeSetCustomUICheckListener(OZReportCustomUICheckListener var1);

    protected native void nativeSetHighlightCustomViewListener(OZHighlightCustomViewListener var1);

    public void CreateReport(String string) {
        this.CreateReportEx(string);
    }

    public void CreateReportEx(String string) {
        this.CreateReportEx(string, "\n");
    }

    public native void CreateReportEx(String var1, String var2);

    public native void NewReport(String var1, String var2);

    public native void SetUserOption(String var1, String var2);

    public native void SetImagePickerImage(boolean var1, byte[] var2, int var3, String var4, int var5, String var6);

    private native void DismissAttachmentDialog();

    private native boolean nativeAddAttachment(boolean var1, int var2, byte[] var3, int var4, String var5, String var6, int var7, int var8);

    private native void nativeSetAttachmentActivityResult(boolean var1, byte[] var2, String var3);

    private native boolean IsDialogueFlow();

    public void ReBind(int n, String string, String string2) {
        this.ReBind(n, string, string2, "\n", true);
    }

    public void ReBind(int n, String string, String string2, boolean bl) {
        this.ReBind(n, string, string2, "\n", bl);
    }

    public void ReBind(int n, String string, String string2, String string3) {
        this.ReBind(n, string, string2, string3, true);
    }

    public void ReBind(int n, String string, String string2, String string3, boolean bl) {
        if (this.m_handler == null) {
            this.m_handler = new Handler();
        }
        this.m_handler.postDelayed((Runnable)new OZReportViewerImpl$2(this, n, string, string2, string3, bl), 100L);
    }

    public native void nativeReBind(int var1, String var2, String var3, String var4, boolean var5);

    public native String GetInformation(String var1);

    public native void Script(String var1);

    public native int ScriptEx(String var1, String var2, String var3);

    protected native int ExportStream(String var1, String var2, String var3);

    protected native void copyExportedDirectBuffer(String var1, ByteBuffer var2, int var3);

    public Hashtable GetMemoryStreamByExport(String string, String string2) {
        if (this.m_exportMap != null) {
            this.m_exportMap.clear();
            this.m_exportMap = null;
        }
        this.m_exportMap = new LinkedHashtable();
        this.ExportStream("save", string, string2);
        return this.m_exportMap;
    }

    public void enumExportedStream(String string, int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n);
        this.copyExportedDirectBuffer(string, byteBuffer, n);
        this.m_exportMap.put(string, new OZDirectByteBufferInputStream(byteBuffer, 0, n));
    }

    public native void preLoadRepositoryAddItem(String var1, String var2);

    public native byte[] preLoadRepositoryStart();

    public native byte[] preLoadRepositoryResponse(byte[] var1);

    public native String preLoadRepositoryGetLastError();

    public native void preLoadRepositoryInitParam(String var1, String var2);

    public native boolean preLoadRepositoryDownload();

    public native void preLoadRepositoryAddBinary(String var1, InputStream var2, boolean var3);

    public native void nativeDocument(OZRViewerCmdImpl var1);

    public OZRViewerCmd Document() {
        if (this.m_viewerCmd == null) {
            this.m_viewerCmd = new OZRViewerCmdImpl();
            this.nativeDocument(this.m_viewerCmd);
        }
        return this.m_viewerCmd;
    }

    public void unbindReferences(View view) {
        try {
            if (view != null) {
                this.unbindViewReferences(view);
                if (view instanceof ViewGroup) {
                    this.unbindViewGroupReferences((ViewGroup)view);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void unbindImagePickerAndSignPadReferences(ViewGroup viewGroup) {
        InputMethodManager inputMethodManager = (InputMethodManager)this._parentView.getContext().getSystemService("input_method");
        inputMethodManager.hideSoftInputFromWindow(((Activity)this._parentView.getContext()).getWindow().getDecorView().getWindowToken(), 0);
        int n = viewGroup.getChildCount();
        for (int j = 0; j < n; ++j) {
            OZInputComponent oZInputComponent;
            View view = viewGroup.getChildAt(j);
            if (view instanceof ICImagePickerWnd) {
                oZInputComponent = (ICImagePickerWnd)view;
                ((ICImagePickerWnd)oZInputComponent).closeWindow(true);
                ((ICImagePickerWnd)oZInputComponent).removeAllObject();
                continue;
            }
            if (view instanceof ICSignPadWnd) {
                oZInputComponent = (ICSignPadWnd)view;
                ((ICSignPadWnd)oZInputComponent).closeWindow();
                continue;
            }
            if (!(view instanceof ViewGroup)) continue;
            this.unbindImagePickerAndSignPadReferences((ViewGroup)view);
        }
    }

    private void unbindViewGroupReferences(ViewGroup viewGroup) {
        int n = viewGroup.getChildCount();
        for (int j = 0; j < n; ++j) {
            View view = viewGroup.getChildAt(j);
            this.unbindViewReferences(view);
            if (!(view instanceof ViewGroup)) continue;
            this.unbindViewGroupReferences((ViewGroup)view);
        }
        try {
            viewGroup.removeAllViews();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void unbindViewReferences(View view) {
        FrameLayout frameLayout;
        try {
            if (view instanceof OZPageView) {
                frameLayout = (OZPageView)view;
                frameLayout.removeAllObject();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (view instanceof MainFrameView) {
                frameLayout = (MainFrameView)view;
                frameLayout.removeAllObject();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            view.setOnClickListener(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            view.setOnCreateContextMenuListener(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            view.setOnFocusChangeListener(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            view.setOnKeyListener(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            view.setOnLongClickListener(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            view.setOnClickListener(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            view.setTouchDelegate(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        frameLayout = view.getBackground();
        if (frameLayout != null) {
            try {
                frameLayout.setCallback(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (view instanceof ImageView) {
            ImageView imageView = (ImageView)view;
            frameLayout = imageView.getDrawable();
            if (frameLayout != null) {
                frameLayout.setCallback(null);
            }
            if (frameLayout instanceof BitmapDrawable) {
                Bitmap bitmap = ((BitmapDrawable)frameLayout).getBitmap();
                bitmap.recycle();
            }
            imageView.setImageDrawable(null);
        } else if (view instanceof WebView) {
            ((WebView)view).destroyDrawingCache();
            ((WebView)view).destroy();
        }
        try {
            view.setBackgroundDrawable(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            view.setAnimation(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            view.setContentDescription(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            view.setTag(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean Document_SetChartStyle(String string) {
        if (this.m_viewerCmd == null) {
            this.m_viewerCmd = new OZRViewerCmdImpl();
            this.nativeDocument(this.m_viewerCmd);
        }
        return this.m_viewerCmd.SetChartStyle(string);
    }

    public boolean Document_PingOZServer(String string) {
        if (this.m_viewerCmd == null) {
            this.m_viewerCmd = new OZRViewerCmdImpl();
            this.nativeDocument(this.m_viewerCmd);
        }
        return this.m_viewerCmd.PingOZServer(string);
    }

    public boolean Document_PingOZServer(String string, int n) {
        if (this.m_viewerCmd == null) {
            this.m_viewerCmd = new OZRViewerCmdImpl();
            this.nativeDocument(this.m_viewerCmd);
        }
        return this.m_viewerCmd.PingOZServer(string, n);
    }

    public Object Document_GetGlobal(String string) {
        if (this.m_viewerCmd == null) {
            this.m_viewerCmd = new OZRViewerCmdImpl();
            this.nativeDocument(this.m_viewerCmd);
        }
        return this.m_viewerCmd.GetGlobal(string);
    }

    public Object Document_GetGlobal(String string, int n) {
        if (this.m_viewerCmd == null) {
            this.m_viewerCmd = new OZRViewerCmdImpl();
            this.nativeDocument(this.m_viewerCmd);
        }
        return this.m_viewerCmd.GetGlobal(string, n);
    }

    public boolean Document_SetGlobal(String string, Object object) {
        if (this.m_viewerCmd == null) {
            this.m_viewerCmd = new OZRViewerCmdImpl();
            this.nativeDocument(this.m_viewerCmd);
        }
        return this.m_viewerCmd.SetGlobal(string, object);
    }

    public boolean Document_SetGlobal(String string, Object object, int n) {
        if (this.m_viewerCmd == null) {
            this.m_viewerCmd = new OZRViewerCmdImpl();
            this.nativeDocument(this.m_viewerCmd);
        }
        return this.m_viewerCmd.SetGlobal(string, object, n);
    }

    public String Document_GetTitle() {
        if (this.m_viewerCmd == null) {
            this.m_viewerCmd = new OZRViewerCmdImpl();
            this.nativeDocument(this.m_viewerCmd);
        }
        return this.m_viewerCmd.GetTitle();
    }

    public float Document_GetPaperWidth() {
        if (this.m_viewerCmd == null) {
            this.m_viewerCmd = new OZRViewerCmdImpl();
            this.nativeDocument(this.m_viewerCmd);
        }
        return this.m_viewerCmd.GetPaperWidth();
    }

    public float Document_GetPaperHeight() {
        if (this.m_viewerCmd == null) {
            this.m_viewerCmd = new OZRViewerCmdImpl();
            this.nativeDocument(this.m_viewerCmd);
        }
        return this.m_viewerCmd.GetPaperHeight();
    }

    public String Document_TriggerExternalEvent() {
        if (this.m_viewerCmd == null) {
            this.m_viewerCmd = new OZRViewerCmdImpl();
            this.nativeDocument(this.m_viewerCmd);
        }
        return this.m_viewerCmd.TriggerExternalEvent();
    }

    public String Document_TriggerExternalEvent(String string) {
        if (this.m_viewerCmd == null) {
            this.m_viewerCmd = new OZRViewerCmdImpl();
            this.nativeDocument(this.m_viewerCmd);
        }
        return this.m_viewerCmd.TriggerExternalEvent(string);
    }

    public String Document_TriggerExternalEvent(String string, String string2) {
        if (this.m_viewerCmd == null) {
            this.m_viewerCmd = new OZRViewerCmdImpl();
            this.nativeDocument(this.m_viewerCmd);
        }
        return this.m_viewerCmd.TriggerExternalEvent(string, string2);
    }

    public String Document_TriggerExternalEvent(String string, String string2, String string3) {
        if (this.m_viewerCmd == null) {
            this.m_viewerCmd = new OZRViewerCmdImpl();
            this.nativeDocument(this.m_viewerCmd);
        }
        return this.m_viewerCmd.TriggerExternalEvent(string, string2, string3);
    }

    public String Document_TriggerExternalEvent(String string, String string2, String string3, String string4) {
        if (this.m_viewerCmd == null) {
            this.m_viewerCmd = new OZRViewerCmdImpl();
            this.nativeDocument(this.m_viewerCmd);
        }
        return this.m_viewerCmd.TriggerExternalEvent(string, string2, string3, string4);
    }

    public String Document_TriggerExternalEventByDocIndex(int n) {
        if (this.m_viewerCmd == null) {
            this.m_viewerCmd = new OZRViewerCmdImpl();
            this.nativeDocument(this.m_viewerCmd);
        }
        return this.m_viewerCmd.TriggerExternalEventByDocIndex(n);
    }

    public String Document_TriggerExternalEventByDocIndex(int n, String string) {
        if (this.m_viewerCmd == null) {
            this.m_viewerCmd = new OZRViewerCmdImpl();
            this.nativeDocument(this.m_viewerCmd);
        }
        return this.m_viewerCmd.TriggerExternalEventByDocIndex(n, string);
    }

    public String Document_TriggerExternalEventByDocIndex(int n, String string, String string2) {
        if (this.m_viewerCmd == null) {
            this.m_viewerCmd = new OZRViewerCmdImpl();
            this.nativeDocument(this.m_viewerCmd);
        }
        return this.m_viewerCmd.TriggerExternalEventByDocIndex(n, string, string2);
    }

    public String Document_TriggerExternalEventByDocIndex(int n, String string, String string2, String string3) {
        if (this.m_viewerCmd == null) {
            this.m_viewerCmd = new OZRViewerCmdImpl();
            this.nativeDocument(this.m_viewerCmd);
        }
        return this.m_viewerCmd.TriggerExternalEventByDocIndex(n, string, string2, string3);
    }

    public String Document_TriggerExternalEventByDocIndex(int n, String string, String string2, String string3, String string4) {
        if (this.m_viewerCmd == null) {
            this.m_viewerCmd = new OZRViewerCmdImpl();
            this.nativeDocument(this.m_viewerCmd);
        }
        return this.m_viewerCmd.TriggerExternalEventByDocIndex(n, string, string2, string3, string4);
    }

    public String Document_TriggerLocationUpdated(String string, String string2) {
        if (this.m_viewerCmd == null) {
            this.m_viewerCmd = new OZRViewerCmdImpl();
            this.nativeDocument(this.m_viewerCmd);
        }
        return this.m_viewerCmd.TriggerLocationUpdated(string, string2);
    }

    public String Document_TriggerLocationUpdatedByDocIndex(int n, String string, String string2) {
        if (this.m_viewerCmd == null) {
            this.m_viewerCmd = new OZRViewerCmdImpl();
            this.nativeDocument(this.m_viewerCmd);
        }
        return this.m_viewerCmd.TriggerLocationUpdatedByDocIndex(n, string, string2);
    }

    private void processingAttachmentFile(Activity activity, Uri uri, OZReportViewerImpl$ActivityResultReturnData oZReportViewerImpl$ActivityResultReturnData) {
        int n;
        boolean bl = false;
        byte[] byArray = null;
        String string = "";
        String string2 = "";
        InputStream inputStream = null;
        ParcelFileDescriptor parcelFileDescriptor = null;
        int n2 = 0;
        try {
            if (uri != null) {
                parcelFileDescriptor = this._parentView.getContext().getContentResolver().openFileDescriptor(uri, "r");
                inputStream = new ParcelFileDescriptor.AutoCloseInputStream(parcelFileDescriptor);
                string = this.getFileName(uri);
            }
            if (inputStream != null) {
                n = inputStream.available();
                byArray = new byte[n];
                inputStream.read(byArray, 0, n);
                inputStream.close();
                bl = true;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        if (bl && (string2 = MimeTypeMap.getSingleton().getExtensionFromMimeType(activity.getContentResolver().getType(uri))).equalsIgnoreCase("jpg")) {
            String string3;
            n = uri.toString().contains("/document/image") ? 1 : 0;
            Uri uri2 = uri;
            String string4 = null;
            String[] stringArray = null;
            if (n != 0) {
                uri2 = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                string4 = "_id=?";
                try {
                    string3 = DocumentsContract.getDocumentId((Uri)uri);
                    stringArray = new String[]{string3};
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    uri2 = uri;
                    string4 = null;
                    stringArray = null;
                }
            }
            if ((string3 = activity.getContentResolver().query(uri2, null, string4, stringArray, null)) != null && string3.moveToFirst()) {
                int n3 = string3.getColumnIndex("_data");
                if (n3 == -1) {
                    n3 = string3.getColumnIndex("_display_name");
                }
                int n4 = string3.getColumnIndex("orientation");
                if (n3 > -1) {
                    string = string3.getString(n3);
                }
                if (n4 > -1) {
                    n2 = string3.getInt(n4);
                }
            }
            byArray = this.getBitmap2ByteArray(this.getRotateBitmap(byArray, n2));
        }
        oZReportViewerImpl$ActivityResultReturnData.data = byArray;
        oZReportViewerImpl$ActivityResultReturnData.isPng = false;
        oZReportViewerImpl$ActivityResultReturnData.fileName = string;
        oZReportViewerImpl$ActivityResultReturnData.rotate = n2;
    }

    private void processPickImageData(Activity activity, int n, Uri uri, OZReportViewerImpl$ActivityResultReturnData oZReportViewerImpl$ActivityResultReturnData) {
        Object object;
        String string = null;
        int n2 = 0;
        boolean bl = false;
        InputStream inputStream = null;
        byte[] byArray = null;
        if (uri != null) {
            int n3;
            object = activity.getContentResolver().query(uri, null, null, null, null);
            if (object != null && object.moveToFirst()) {
                String string2;
                int n4;
                n3 = object.getColumnIndex("_data");
                if (n3 == -1) {
                    n3 = object.getColumnIndex("_display_name");
                }
                int n5 = object.getColumnIndex("orientation");
                if (n3 > -1 && (n4 = (string = object.getString(n3)).lastIndexOf("/")) > -1) {
                    string = string.substring(n4 + 1);
                }
                if (n5 > -1) {
                    n2 = object.getInt(n5);
                }
                if ((n4 = object.getColumnIndex("mime_type")) > -1 && (string2 = object.getString(n4)).equalsIgnoreCase("image/png")) {
                    bl = true;
                }
            }
            if (string == null) {
                string = uri.getPath();
            }
            if (object != null) {
                object.close();
            }
            try {
                inputStream = activity.getContentResolver().openInputStream(uri);
                if (inputStream != null) {
                    n3 = inputStream.available();
                    byArray = new byte[n3];
                    inputStream.read(byArray, 0, n3);
                    inputStream.close();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
                return;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return;
            }
        }
        switch (n) {
            case 13001: 
            case 13006: 
            case 13203: 
            case 13205: 
            case 13303: {
                object = MimeTypeMap.getSingleton().getExtensionFromMimeType(activity.getContentResolver().getType(uri));
                if (!((String)object).equalsIgnoreCase("jpg") || byArray == null) break;
                byArray = this.getBitmap2ByteArray(this.getRotateBitmap(byArray, n2));
            }
        }
        oZReportViewerImpl$ActivityResultReturnData.data = byArray;
        oZReportViewerImpl$ActivityResultReturnData.fileName = string;
        oZReportViewerImpl$ActivityResultReturnData.rotate = n2;
        oZReportViewerImpl$ActivityResultReturnData.isPng = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTakeImageData(Activity activity, int n, int n2, OZReportViewerImpl$ActivityResultReturnData oZReportViewerImpl$ActivityResultReturnData) {
        int n3;
        String string;
        byte[] byArray;
        block29: {
            byArray = null;
            string = null;
            n3 = 0;
            boolean bl = false;
            InputStream inputStream = null;
            try {
                File file = activity.getExternalFilesDir(Environment.DIRECTORY_PICTURES);
                File file2 = new File(file, "OZ_TMP_IMAGE");
                if (!file2.exists()) break block29;
                string = file2.toString();
                try {
                    ExifInterface exifInterface = new ExifInterface(string);
                    int n4 = exifInterface.getAttributeInt("Orientation", -65535);
                    if (n4 != -65535) {
                        switch (n4) {
                            default: {
                                n3 = 0;
                                break;
                            }
                            case 6: {
                                n3 = 90;
                                break;
                            }
                            case 3: {
                                n3 = 180;
                                break;
                            }
                            case 8: {
                                n3 = 270;
                            }
                        }
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                inputStream = new FileInputStream(file2);
                if (inputStream != null) {
                    int n5 = inputStream.available();
                    byArray = new byte[n5];
                    inputStream.read(byArray, 0, n5);
                    inputStream.close();
                }
                file2.delete();
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        }
        oZReportViewerImpl$ActivityResultReturnData.data = this.getBitmap2ByteArray(this.getRotateBitmap(byArray, n3));
        oZReportViewerImpl$ActivityResultReturnData.fileName = string;
        oZReportViewerImpl$ActivityResultReturnData.rotate = n3;
    }

    public void onActivityResult(Activity activity, int n, int n2, Intent intent) {
        switch (n) {
            case 13201: 
            case 13203: 
            case 13301: 
            case 13303: {
                if (n2 != -1) break;
                ClipData clipData = null;
                int n3 = 1;
                if (intent != null && (clipData = intent.getClipData()) != null) {
                    n3 = clipData.getItemCount();
                }
                for (int j = 0; j < n3; ++j) {
                    OZReportViewerImpl$ActivityResultReturnData oZReportViewerImpl$ActivityResultReturnData = new OZReportViewerImpl$ActivityResultReturnData(this);
                    Uri uri = null;
                    uri = clipData != null ? clipData.getItemAt(j).getUri() : intent.getData();
                    this.processingAttachmentFile(activity, uri, oZReportViewerImpl$ActivityResultReturnData);
                    this.performAttachFile(activity, n, uri, oZReportViewerImpl$ActivityResultReturnData, j, n3);
                }
                break;
            }
            case 13202: 
            case 13302: {
                OZReportViewerImpl$ActivityResultReturnData oZReportViewerImpl$ActivityResultReturnData = new OZReportViewerImpl$ActivityResultReturnData(this);
                this.processTakeImageData(activity, n, n2, oZReportViewerImpl$ActivityResultReturnData);
                if (oZReportViewerImpl$ActivityResultReturnData.data == null) break;
                this.performAttachFile(activity, n, null, oZReportViewerImpl$ActivityResultReturnData, 0, 1);
                break;
            }
            case 13205: {
                if (intent == null) break;
                Uri uri = intent.getData();
                OZReportViewerImpl$ActivityResultReturnData oZReportViewerImpl$ActivityResultReturnData = new OZReportViewerImpl$ActivityResultReturnData(this);
                this.processPickImageData(activity, n, uri, oZReportViewerImpl$ActivityResultReturnData);
                if (oZReportViewerImpl$ActivityResultReturnData.data == null) break;
                String string = MimeTypeMap.getSingleton().getExtensionFromMimeType(activity.getContentResolver().getType(intent.getData()));
                this.performSetAttachmentActivityResult(activity, string, oZReportViewerImpl$ActivityResultReturnData);
                break;
            }
            case 13204: {
                OZReportViewerImpl$ActivityResultReturnData oZReportViewerImpl$ActivityResultReturnData = new OZReportViewerImpl$ActivityResultReturnData(this);
                this.processTakeImageData(activity, n, n2, oZReportViewerImpl$ActivityResultReturnData);
                this.performSetAttachmentActivityResult(activity, "jpg", oZReportViewerImpl$ActivityResultReturnData);
                break;
            }
            case 13004: {
                OZReportViewerImpl$ActivityResultReturnData oZReportViewerImpl$ActivityResultReturnData = new OZReportViewerImpl$ActivityResultReturnData(this);
                this.processTakeImageData(activity, n, n2, oZReportViewerImpl$ActivityResultReturnData);
                if (oZReportViewerImpl$ActivityResultReturnData.data == null) break;
                Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])oZReportViewerImpl$ActivityResultReturnData.data, (int)0, (int)oZReportViewerImpl$ActivityResultReturnData.data.length);
                View view = activity.findViewById(52520725);
                if (view == null || !(view instanceof MainFrameView)) break;
                ((MainFrameView)view).getOverlayLayout().getCommentManager().openImage(bitmap);
                break;
            }
            case 13003: {
                OZReportViewerImpl$ActivityResultReturnData oZReportViewerImpl$ActivityResultReturnData = new OZReportViewerImpl$ActivityResultReturnData(this);
                this.processTakeImageData(activity, n, n2, oZReportViewerImpl$ActivityResultReturnData);
                if (oZReportViewerImpl$ActivityResultReturnData.data != null) {
                    this.SetImagePickerImage(false, oZReportViewerImpl$ActivityResultReturnData.data, oZReportViewerImpl$ActivityResultReturnData.data.length, oZReportViewerImpl$ActivityResultReturnData.fileName, oZReportViewerImpl$ActivityResultReturnData.rotate, "jpg");
                } else {
                    this.SetImagePickerImage(true, null, 0, null, 0, null);
                }
                ICImagePickerWnd.isStartGallay = false;
                break;
            }
            case 13001: 
            case 13005: 
            case 13006: {
                if (intent == null) {
                    if (n != 13001) break;
                    this.SetImagePickerImage(true, null, 0, null, 0, null);
                    break;
                }
                Uri uri = intent.getData();
                OZReportViewerImpl$ActivityResultReturnData oZReportViewerImpl$ActivityResultReturnData = new OZReportViewerImpl$ActivityResultReturnData(this);
                this.processPickImageData(activity, n, uri, oZReportViewerImpl$ActivityResultReturnData);
                if (n == 13001) {
                    if (oZReportViewerImpl$ActivityResultReturnData.data != null) {
                        String string = MimeTypeMap.getSingleton().getExtensionFromMimeType(activity.getContentResolver().getType(uri));
                        this.SetImagePickerImage(false, oZReportViewerImpl$ActivityResultReturnData.data, oZReportViewerImpl$ActivityResultReturnData.data.length, oZReportViewerImpl$ActivityResultReturnData.fileName, oZReportViewerImpl$ActivityResultReturnData.rotate, string);
                    } else {
                        this.SetImagePickerImage(true, null, 0, null, 0, null);
                    }
                    ICImagePickerWnd.isStartGallay = false;
                    return;
                }
                if (n == 13006) {
                    View view = activity.findViewById(52520725);
                    if (view == null || !(view instanceof MainFrameView)) break;
                    ((MainFrameView)view).getOverlayLayout().getDFController().imagePickerGallery(oZReportViewerImpl$ActivityResultReturnData.data == null, oZReportViewerImpl$ActivityResultReturnData.data);
                    break;
                }
                try {
                    View view;
                    Bitmap bitmap = this.getRotateBitmap(oZReportViewerImpl$ActivityResultReturnData.data, oZReportViewerImpl$ActivityResultReturnData.rotate);
                    if (bitmap == null || (view = activity.findViewById(52520725)) == null || !(view instanceof MainFrameView)) break;
                    ((MainFrameView)view).m_isPng = oZReportViewerImpl$ActivityResultReturnData.isPng;
                    ((MainFrameView)view).getOverlayLayout().getCommentManager().openImage(bitmap);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break;
            }
            case 13101: {
                File file = new File(OZStorage.tmpCacheDir + "/OZVoiceRecorder_history.m4a");
                if (!file.exists()) break;
                file.delete();
                break;
            }
            case 13102: {
                File file = new File(OZStorage.tmpCacheDir + "/OZAttachment_history.pdf");
                if (!file.exists()) break;
                file.delete();
                break;
            }
        }
    }

    public boolean performAttachFile(Activity activity, int n, Uri uri, OZReportViewerImpl$ActivityResultReturnData oZReportViewerImpl$ActivityResultReturnData, int n2, int n3) {
        boolean bl = false;
        if (oZReportViewerImpl$ActivityResultReturnData != null) {
            String string = "jpg";
            if (uri != null) {
                string = MimeTypeMap.getSingleton().getExtensionFromMimeType(activity.getContentResolver().getType(uri));
            }
            if (this.IsDialogueFlow()) {
                View view = activity.findViewById(52520725);
                if (view != null && view instanceof MainFrameView) {
                    bl = ((MainFrameView)view).getOverlayLayout().getDFController().attachComponentUpdate(oZReportViewerImpl$ActivityResultReturnData, string, n2, n3);
                }
            } else {
                bl = this.nativeAddAttachment(bl, n, oZReportViewerImpl$ActivityResultReturnData.data, oZReportViewerImpl$ActivityResultReturnData.data.length, oZReportViewerImpl$ActivityResultReturnData.fileName, string, n2, n3);
            }
        } else {
            this.nativeAddAttachment(false, n, null, 0, "", "", n2, n3);
        }
        return bl;
    }

    public void performSetAttachmentActivityResult(Activity activity, String string, OZReportViewerImpl$ActivityResultReturnData oZReportViewerImpl$ActivityResultReturnData) {
        if (this.IsDialogueFlow()) {
            View view = activity.findViewById(52520725);
            if (view != null && view instanceof MainFrameView) {
                ((MainFrameView)view).getOverlayLayout().getDFController().attachComponentUpdate(oZReportViewerImpl$ActivityResultReturnData, string, 0, 1);
            }
        } else if (oZReportViewerImpl$ActivityResultReturnData.data != null) {
            this.nativeSetAttachmentActivityResult(false, oZReportViewerImpl$ActivityResultReturnData.data, string);
        } else {
            this.nativeSetAttachmentActivityResult(true, oZReportViewerImpl$ActivityResultReturnData.data, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFileName(Uri uri) {
        int n;
        String string = null;
        if (uri.getScheme().equals("content")) {
            Cursor cursor = this._parentView.getContext().getContentResolver().query(uri, null, null, null, null);
            try {
                if (cursor != null && cursor.moveToFirst()) {
                    string = cursor.getString(cursor.getColumnIndex("_display_name"));
                }
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
        if (string == null && (n = (string = uri.getPath()).lastIndexOf(47)) != -1) {
            string = string.substring(n + 1);
        }
        return string;
    }

    private void copyFileParcel(Uri uri, String string) {
        ParcelFileDescriptor parcelFileDescriptor = null;
        File file = new File(string);
        try {
            if (uri != null) {
                parcelFileDescriptor = this._parentView.getContext().getContentResolver().openFileDescriptor(uri, "r");
                ParcelFileDescriptor.AutoCloseInputStream autoCloseInputStream = new ParcelFileDescriptor.AutoCloseInputStream(parcelFileDescriptor);
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                byte[] byArray = new byte[1024];
                int n = 0;
                while ((n = autoCloseInputStream.read(byArray)) > 0) {
                    ((OutputStream)fileOutputStream).write(byArray, 0, n);
                }
                ((OutputStream)fileOutputStream).close();
                autoCloseInputStream.close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private String makeAddPDFParam(String string) {
        String string2 = "repository_agent.type=local";
        int n = string.lastIndexOf("/");
        if (n > -1) {
            string2 = string2 + "\nrepository_agent.local.root_path=" + string.substring(0, n);
            string2 = string2 + "\nconnection.reportname=" + string.substring(n + 1);
        }
        return string2;
    }

    private Bitmap getRotateBitmap(byte[] byArray, int n) {
        if (byArray != null) {
            Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length);
            if (bitmap != null && n != 0) {
                Matrix matrix = new Matrix();
                matrix.setRotate((float)n);
                Bitmap bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
                bitmap.recycle();
                bitmap = bitmap2;
            }
            return bitmap;
        }
        return null;
    }

    private byte[] getBitmap2ByteArray(Bitmap bitmap) {
        if (bitmap != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)byteArrayOutputStream);
            return byteArrayOutputStream.toByteArray();
        }
        return null;
    }
}

