/*
 * Decompiled with CFR 0.152.
 */
package oz.api.custom;

import org.json.JSONObject;
import oz.api.custom.IOZCheckBoxInfo;
import oz.api.custom.OZInputCompCmd;
import oz.api.custom.OZInputCompInfo;

public class OZCheckBoxInfo
extends OZInputCompInfo
implements IOZCheckBoxInfo {
    private static final String DEF_CHECKED_VALUE = "::true";
    private static final String DEF_UNCHECKED_VALUE = "::false";
    public static final String K_CB_CHECKED_VALUE = "cb_chk_value";
    public static final String K_CB_UNCHECKED_VALUE = "cb_uchk_value";

    public OZCheckBoxInfo(OZInputCompCmd oZInputCompCmd, int n, JSONObject jSONObject, JSONObject jSONObject2) {
        super(oZInputCompCmd, n, jSONObject, jSONObject2);
    }

    public String getCheckedValueAttr() {
        return this.getObject().optString(K_CB_CHECKED_VALUE, DEF_CHECKED_VALUE);
    }

    public String getUncheckedValueAttr() {
        return this.getObject().optString(K_CB_UNCHECKED_VALUE, DEF_UNCHECKED_VALUE);
    }

    public String makeValueString(boolean bl) {
        return bl ? this.makeCheckedValue() : this.makeUncheckedValue();
    }

    private String makeCheckedValue() {
        String string = this.getCheckedValueAttr();
        if (string == null || string.isEmpty() || string.equals(DEF_CHECKED_VALUE)) {
            return this.getText() + DEF_CHECKED_VALUE;
        }
        return string;
    }

    private String makeUncheckedValue() {
        String string = this.getUncheckedValueAttr();
        if (string == null || string.isEmpty() || string.equals(DEF_UNCHECKED_VALUE)) {
            return this.getText() + DEF_UNCHECKED_VALUE;
        }
        return string;
    }

    public boolean isChecked() {
        String string = this.getValue();
        if (string != null && !string.isEmpty()) {
            String string2 = this.makeCheckedValue();
            return string2 != null && string2.equals(string);
        }
        return false;
    }

    public void setChecked(boolean bl) {
        this.setValue(this.makeValueString(bl));
    }
}

