/*
 * Decompiled with CFR 0.152.
 */
package oz.api.custom;

import android.util.Base64;
import java.io.ByteArrayInputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import org.json.JSONObject;
import oz.api.custom.IOZInputCompInfo;
import oz.api.custom.OZInputCompCmd;

public class OZInputCompInfo
implements IOZInputCompInfo {
    public static final String K_DOCINDEX = "docindex";
    public static final String K_PAGEINDEX = "pageindex";
    public static final String K_FORMID = "formid";
    public static final String K_TYPE = "type";
    public static final String K_MEANINGCODE = "meaningcode";
    public static final String K_WIDTH = "width";
    public static final String K_HEIGHT = "height";
    public static final String K_BGCOLOR = "bgcolor";
    public static final String K_TEXT = "text";
    public static final String K_FONTCOLOR = "fontcolor";
    public static final String K_FONTSIZE = "fontsize";
    public static final String K_TOOLTIP = "tooltip";
    public static final String K_REQUIRED = "required";
    public static final String K_ALLOWEMPTY = "allowempty";
    public static final String K_DESCRIPT = "descript";
    public static final String K_FOCUS_METHOD = "focus_method";
    public static final String K_PLACEHOLDER = "placeholder";
    private OZInputCompCmd mCmd;
    private int mIndex;
    private JSONObject mObj;
    private JSONObject mCommonObj;

    public OZInputCompInfo(OZInputCompCmd oZInputCompCmd, int n, JSONObject jSONObject, JSONObject jSONObject2) {
        this.mCmd = oZInputCompCmd;
        this.mIndex = n;
        this.mObj = jSONObject;
        this.mCommonObj = jSONObject2;
    }

    public JSONObject getObject() {
        return this.mObj;
    }

    public JSONObject getCommonObject() {
        return this.mCommonObj;
    }

    public OZInputCompCmd getCmd() {
        return this.mCmd;
    }

    public int getDocIndex() {
        return this.getObject().optInt(K_DOCINDEX, 0);
    }

    public int getPageIndex() {
        return this.getObject().optInt(K_PAGEINDEX, 0);
    }

    public float getCompWidth() {
        return (float)this.getObject().optDouble(K_WIDTH, 0.0);
    }

    public float getCompHeight() {
        return (float)this.getObject().optDouble(K_HEIGHT, 0.0);
    }

    public String getFormID() {
        return this.getObject().optString(K_FORMID);
    }

    public String getCompType() {
        return this.getObject().optString(K_TYPE);
    }

    public String getText() {
        return this.getObject().optString(K_TEXT);
    }

    public int getTextColor() {
        return this.getObject().optInt(K_FONTCOLOR, 0);
    }

    public float getTextSize() {
        return (float)this.getObject().optDouble(K_FONTSIZE, 0.0);
    }

    public int getBackgroundColor() {
        return this.getObject().optInt(K_BGCOLOR, 0);
    }

    public String getTooltipText() {
        return this.getObject().optString(K_TOOLTIP);
    }

    public int getValueMeaningCode() {
        return this.getObject().optInt(K_MEANINGCODE, 0);
    }

    public boolean isRequired() {
        return this.getObject().optBoolean(K_REQUIRED, false);
    }

    public boolean isEmptyAllowed() {
        return this.getObject().optBoolean(K_ALLOWEMPTY, true);
    }

    public String getDescription() {
        return this.getObject().optString(K_DESCRIPT);
    }

    public String getPlaceholderText() {
        return this.getObject().optString(K_PLACEHOLDER);
    }

    public String getValue() {
        return this.mCmd.getValue(this.mIndex);
    }

    public void setValue(String string) {
        this.mCmd.setValue(this.mIndex, string);
    }

    public String getFocusMethod() {
        return this.getCommonObject().optString(K_FOCUS_METHOD);
    }

    public String encodeBase64Value(byte[] byArray, String string) {
        if (byArray != null) {
            String string2 = Base64.encodeToString((byte[])byArray, (int)1);
            return String.format("data:%s;base64,%s", string == null ? "" : string, string2);
        }
        return null;
    }

    public byte[] decodeBase64Value(String string) {
        block7: {
            int n;
            if (string != null && string.startsWith("data:") && (n = string.indexOf("base64,")) > 0) {
                try {
                    byte[] byArray = Base64.decode((String)string.substring(n + 7), (int)1);
                    if (byArray == null) break block7;
                    if (string.startsWith("data:application/x-gzip-compressed;")) {
                        int n2;
                        InflaterInputStream inflaterInputStream = null;
                        try {
                            inflaterInputStream = new GZIPInputStream(new ByteArrayInputStream(byArray));
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        if (inflaterInputStream != null && (n2 = inflaterInputStream.available()) > 0) {
                            byte[] byArray2 = new byte[n2];
                            inflaterInputStream.read(byArray2);
                            return byArray2;
                        }
                    }
                    return byArray;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
        return null;
    }

    public void setBytesValue(byte[] byArray, String string) {
        String string2 = null;
        if (byArray != null) {
            string2 = this.encodeBase64Value(byArray, string);
        }
        if (string2 == null) {
            string2 = "";
        }
        this.setValue(string2);
    }

    public byte[] getBytesValue() {
        return this.decodeBase64Value(this.getValue());
    }
}

