/*
 * Decompiled with CFR 0.152.
 */
package oz.api.custom;

import java.util.Arrays;
import java.util.HashSet;
import org.json.JSONArray;
import org.json.JSONObject;
import oz.api.custom.IOZListItemInfo;
import oz.api.custom.OZInputCompCmd;
import oz.api.custom.OZInputCompInfo;

public class OZListItemInfo
extends OZInputCompInfo
implements IOZListItemInfo {
    public static final String K_SA_MULTISEL = "sa_multisel";
    public static final String K_SA_ITEMS_NAME = "sa_items_name";
    public static final String K_SA_ITEMS_ENABLE = "sa_items_enable";
    public static final String K_SA_ITEMS_VISIBLE = "sa_items_visible";
    private String[] mItemsName;
    private String[] mItemsValue;
    private boolean[] mItemsEnabled;
    private boolean[] mItemsVisible;

    public OZListItemInfo(OZInputCompCmd oZInputCompCmd, int n, JSONObject jSONObject, JSONObject jSONObject2) {
        super(oZInputCompCmd, n, jSONObject, jSONObject2);
    }

    public boolean isMultiSelectable() {
        return this.getObject().optBoolean(K_SA_MULTISEL, false);
    }

    public String[] getItems() {
        if (this.mItemsName == null) {
            int n;
            int n2;
            JSONArray jSONArray = this.getObject().optJSONArray(K_SA_ITEMS_NAME);
            int n3 = jSONArray.length() / 2;
            if (jSONArray == null || jSONArray.length() == 0 || jSONArray.length() % 2 == 1) {
                this.mItemsName = new String[0];
                this.mItemsValue = new String[0];
            } else {
                this.mItemsName = new String[n3];
                this.mItemsValue = new String[n3];
                for (int j = 0; j < n3; ++j) {
                    this.mItemsName[j] = jSONArray.optString(j * 2);
                    this.mItemsValue[j] = jSONArray.optString(j * 2 + 1);
                }
            }
            if (this.supportEnabled()) {
                this.mItemsEnabled = new boolean[n3];
                JSONArray jSONArray2 = this.getObject().optJSONArray(K_SA_ITEMS_ENABLE);
                if (jSONArray2 != null) {
                    n2 = jSONArray2.length();
                    for (n = 0; n < n2; ++n) {
                        this.mItemsEnabled[n] = jSONArray2.optBoolean(n);
                    }
                }
            }
            if (this.supportVisible()) {
                this.mItemsVisible = new boolean[n3];
                JSONArray jSONArray3 = this.getObject().optJSONArray(K_SA_ITEMS_VISIBLE);
                if (jSONArray3 != null) {
                    n2 = jSONArray3.length();
                    for (n = 0; n < n2; ++n) {
                        this.mItemsVisible[n] = jSONArray3.optBoolean(n);
                    }
                }
            }
        }
        return this.mItemsName;
    }

    public String[] getItemsValue() {
        if (this.mItemsValue == null) {
            this.getItems();
        }
        return this.mItemsValue;
    }

    public int getItemCount() {
        return this.getItems().length;
    }

    public int[] getSelectedItemsIndex() {
        String string = this.getValue();
        String[] stringArray = this.getCmd().parseCSVReadFirstRow(string);
        if (stringArray != null && stringArray.length > 0) {
            int n = this.getItemCount();
            String[] stringArray2 = this.getItems();
            String[] stringArray3 = this.getItemsValue();
            HashSet<Integer> hashSet = new HashSet<Integer>();
            boolean bl = this.supportMultiselectable();
            block0: for (String string2 : stringArray) {
                for (int j = 0; j < n; ++j) {
                    String string3 = stringArray3[j];
                    if (string3 == null || string3.isEmpty()) {
                        string3 = stringArray2[j];
                    }
                    if (!string3.equals(string2)) continue;
                    hashSet.add(j);
                    if (!bl) continue block0;
                }
            }
            if (!hashSet.isEmpty()) {
                int n2 = hashSet.size();
                Integer[] integerArray = hashSet.toArray(new Integer[n2]);
                int[] nArray = new int[n2];
                for (int j = 0; j < n2; ++j) {
                    nArray[j] = integerArray[j];
                }
                Arrays.sort(nArray);
                return nArray;
            }
        }
        return new int[0];
    }

    public boolean isItemEnabled(int n) {
        if (this.mItemsValue == null) {
            this.getItems();
        }
        if (this.mItemsEnabled != null) {
            if (n >= 0 && n < this.getItemCount()) {
                return this.mItemsEnabled[n];
            }
            return false;
        }
        return true;
    }

    public boolean isItemVisible(int n) {
        if (this.mItemsValue == null) {
            this.getItems();
        }
        if (this.mItemsVisible != null) {
            if (n >= 0 && n < this.getItemCount()) {
                return this.mItemsVisible[n];
            }
            return false;
        }
        return true;
    }

    protected boolean isIndexBaseValue() {
        return true;
    }

    public String makeValueString(int[] nArray) {
        if (nArray != null && nArray.length > 0) {
            int[] nArray2 = Arrays.copyOf(nArray, nArray.length);
            Arrays.sort(nArray2);
            StringBuilder stringBuilder = new StringBuilder();
            int n = this.getItemCount();
            String[] stringArray = this.getItems();
            String[] stringArray2 = this.getItemsValue();
            HashSet<Integer> hashSet = new HashSet<Integer>();
            boolean bl = true;
            boolean bl2 = this.supportMultiselectable();
            boolean bl3 = this.isIndexBaseValue();
            for (int n2 : nArray2) {
                if (n2 < 0 || n2 >= n || hashSet.contains(n2)) continue;
                hashSet.add(n2);
                String string = stringArray2[n2];
                if (string == null || string.isEmpty()) {
                    string = stringArray[n2];
                }
                if (!bl) {
                    stringBuilder.append(',');
                } else {
                    bl = false;
                }
                if (bl3) {
                    stringBuilder.append(n2);
                } else {
                    stringBuilder.append(OZListItemInfo.wrapCSV(string));
                }
                if (!bl2) break;
            }
            if (stringBuilder.length() > 0) {
                return stringBuilder.toString();
            }
        }
        return "";
    }

    protected boolean supportMultiselectable() {
        return true;
    }

    protected boolean supportEnabled() {
        return false;
    }

    protected boolean supportVisible() {
        return false;
    }

    public static String wrapCSV(String string) {
        if (string != null) {
            boolean bl;
            String string2 = string;
            boolean bl2 = bl = string2.indexOf(44) != -1;
            if (string2.indexOf(34) != -1) {
                string2 = string2.replaceAll("\"", "\"\"");
                bl = true;
            }
            if (string2.indexOf(10) != -1) {
                string2 = string2.replaceAll("\r", "");
                bl = true;
            }
            if (bl) {
                return String.format("\"%s\"", string2);
            }
        }
        return string;
    }

    public int getSelectedIndex() {
        int[] nArray = this.getSelectedItemsIndex();
        if (nArray != null && nArray.length > 0) {
            return nArray[0];
        }
        return -1;
    }

    public void setSelectedIndex(int n) {
        if (n > -1) {
            this.setValue(this.makeValueString(new int[]{n}));
        } else {
            this.setValue("");
        }
    }

    public int[] getSelectedIndexes() {
        return this.getSelectedItemsIndex();
    }

    public void setSelectedIndexes(int[] nArray) {
        if (nArray != null && nArray.length > 0) {
            this.setValue(this.makeValueString(nArray));
        } else {
            this.setValue("");
        }
    }
}

