/*
 * Decompiled with CFR 0.152.
 */
package oz.api.custom;

import android.content.Context;
import android.graphics.Rect;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import java.util.StringTokenizer;
import oz.api.custom.IOZSignPadInfo;
import oz.api.custom.IOZSignPadViewCtrl;
import oz.api.custom.IOZSignPadViewListener;
import oz.api.custom.SignPadViewCtrl$IOZSignPadInfoWithOZSignView;
import oz.api.custom.SignPadViewCtrl$OZSignPadInfoWithOZSignViewDefault;
import oz.client.shape.ui.data.OZSignPadGuideLineData;
import oz.util.AutoSizeTextDrawHelper;
import oz.util.signpath.OZSignPath;
import oz.util.signpath.view.SignPathView;
import oz.util.signpath.view.SignPathView$onPathValueChangedListener;
import oz.util.signpath.view.SignPathView$onSignAreaChangedListener;
import oz.util.signpath.view.model.ISignPathValue;
import oz.util.signpath.view.model.SignPathSetting;
import oz.util.signpath.view.model.SignPathValue;
import oz.util.signpath.view.util.OZCustomUILoader;

public class SignPadViewCtrl
implements IOZSignPadViewCtrl,
SignPathView$onPathValueChangedListener,
SignPathView$onSignAreaChangedListener {
    private FrameLayout mSignPathRootView;
    private SignPathView mSignPathView;
    private final SignPathSetting mSignPathViewSetting;
    private final IOZSignPadInfo mInfo;
    private String mLastValue;
    private IOZSignPadViewListener mListener;
    private float mTextSize;
    private float mTextScale;
    private boolean mCustomTextSize;

    public SignPadViewCtrl(IOZSignPadInfo iOZSignPadInfo) {
        this.mInfo = iOZSignPadInfo;
        this.mSignPathViewSetting = new SignPathSetting();
        this.initSetting();
    }

    private void initSetting() {
        Object object;
        SignPadViewCtrl$IOZSignPadInfoWithOZSignView signPadViewCtrl$IOZSignPadInfoWithOZSignView = null;
        signPadViewCtrl$IOZSignPadInfoWithOZSignView = this.mInfo instanceof SignPadViewCtrl$IOZSignPadInfoWithOZSignView ? (SignPadViewCtrl$IOZSignPadInfoWithOZSignView)((Object)this.mInfo) : new SignPadViewCtrl$OZSignPadInfoWithOZSignViewDefault(null);
        String string = this.mInfo.getText();
        if (string != null && !string.isEmpty()) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
            object = new String[stringTokenizer.countTokens()];
            boolean bl = false;
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                object[n] = stringTokenizer.nextToken();
                if (object[n] != null && !object[n].isEmpty()) {
                    bl = true;
                }
                ++n;
            }
            if (bl) {
                this.mSignPathViewSetting.setTexts((String[])object);
            }
        }
        if (signPadViewCtrl$IOZSignPadInfoWithOZSignView.isKeepBackgroundColor()) {
            this.mSignPathViewSetting.setBackgroundColor(0xFF000000 | this.mInfo.getBackgroundColor());
        }
        if (signPadViewCtrl$IOZSignPadInfoWithOZSignView.isOnlyDrawWithStylusPen()) {
            this.mSignPathViewSetting.setAllowHandInput(false);
        }
        this.mSignPathViewSetting.setAllowTouchPressure(signPadViewCtrl$IOZSignPadInfoWithOZSignView.isUsePenPressure());
        this.mSignPathViewSetting.setTextColor(0x33FFFFFF & this.mInfo.getTextColor());
        this.mCustomTextSize = false;
        this.mTextScale = 1.0f;
        this.mSignPathViewSetting.setTextGravity(17);
        if (signPadViewCtrl$IOZSignPadInfoWithOZSignView.isTracingOutline()) {
            this.mSignPathViewSetting.setShowTextWithValue(true);
            this.mTextSize = 0.0f;
        } else {
            this.mSignPathViewSetting.setShowTextWithValue(false);
            this.mTextSize = this.mInfo.getTextSize();
        }
        this.mSignPathViewSetting.setTextSize(this.mTextSize);
        this.mSignPathViewSetting.setThickness(signPadViewCtrl$IOZSignPadInfoWithOZSignView.getSignPenThickness());
        this.mSignPathViewSetting.setThicknessColor(signPadViewCtrl$IOZSignPadInfoWithOZSignView.getSignPenColor());
        this.mSignPathViewSetting.setMetaThickness(signPadViewCtrl$IOZSignPadInfoWithOZSignView.getSignPenParamThickness());
        this.mSignPathViewSetting.setMetaThicknessScale(7.0f);
        int n = signPadViewCtrl$IOZSignPadInfoWithOZSignView.getGuideLineShapeType();
        if (n != 0) {
            object = new OZSignPadGuideLineData(signPadViewCtrl$IOZSignPadInfoWithOZSignView.getGuideLineJSON());
            if (n == 2) {
                ((OZSignPadGuideLineData)object).setShapeType(2);
            }
            if (((OZSignPadGuideLineData)object).getShapeType() != 0) {
                this.mSignPathViewSetting.setGuideLineData((OZSignPadGuideLineData)object);
            }
        }
        if ((string = signPadViewCtrl$IOZSignPadInfoWithOZSignView.getCustomUI()) != null && !string.isEmpty()) {
            object = new OZCustomUILoader(string);
            if (((OZCustomUILoader)object).success && ((OZCustomUILoader)object).signpad_border_thickness > 0.0f) {
                this.mSignPathViewSetting.setSignAreaBorderThickness(((OZCustomUILoader)object).signpad_border_thickness * 2.0f);
                this.mSignPathViewSetting.setSignAreaBorderColor(((OZCustomUILoader)object).signpad_border_color);
            }
        }
        this.mLastValue = this.mInfo.getValue();
    }

    public View getView(Context context) {
        if (context != null && this.mSignPathView == null) {
            SignPathValue signPathValue;
            this.mSignPathRootView = new FrameLayout(context);
            this.mSignPathView = new SignPathView(context);
            this.mSignPathView.setSetting(this.mSignPathViewSetting);
            if (this.mLastValue != null && !this.mLastValue.isEmpty() && (signPathValue = SignPathValue.parse(this.mLastValue)) != null) {
                this.mSignPathView.setSignValue(signPathValue);
            }
            this.mSignPathView.setOnSignAreaChangedListener(this);
            this.mSignPathView.setOnValueChangedListener(this);
            this.mSignPathRootView.addView((View)this.mSignPathView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            this.mSignPathView.setNotChanged();
        }
        return this.mSignPathRootView;
    }

    private void updateView() {
        if (this.mSignPathView != null) {
            this.mSignPathView.needFullInvalidate();
        }
    }

    public void setSignSize(int n, int n2) {
        if (n > 0 && n2 > 0) {
            this.mSignPathViewSetting.setSignArea(new Rect(0, 0, n, n2));
        } else {
            this.mSignPathViewSetting.setSignArea(null);
        }
        this.updateView();
    }

    public void setValue(String string) {
        boolean bl;
        boolean bl2 = bl = !this.mLastValue.equals(string);
        if (bl) {
            this.mLastValue = string;
            if (this.mSignPathView != null) {
                SignPathValue signPathValue = SignPathValue.parse(string);
                if (signPathValue == null) {
                    this.clear();
                } else {
                    this.mSignPathView.setSignValue(signPathValue);
                    this.mSignPathView.setNotChanged();
                }
            }
        }
    }

    public String getValue() {
        if (this.mSignPathView != null && this.mSignPathView.isChanged()) {
            ISignPathValue iSignPathValue = this.mSignPathView.getSignValue();
            if (iSignPathValue != null && iSignPathValue.getValueAsSignPath() != null) {
                OZSignPath oZSignPath = new OZSignPath(iSignPathValue.getValueAsSignPath().getPathString());
                String string = this.mInfo.getSignPadViewType();
                if (string.equals("KeepRatio") || string.equals("Scrollable")) {
                    oZSignPath.toKeepRatio(this.mInfo.getCompWidth(), this.mInfo.getCompHeight());
                } else {
                    oZSignPath.toFitToFrame();
                }
                String string2 = oZSignPath.getPathString();
                oZSignPath.recycle();
                return string2;
            }
            return "";
        }
        return this.mLastValue;
    }

    public void setDrawMode() {
        if (this.mSignPathView != null) {
            this.mSignPathView.setDrawMode();
        }
    }

    public void setEraseMode() {
        if (this.mSignPathView != null) {
            this.mSignPathView.setEraseMode();
        }
    }

    public boolean isDrawMode() {
        return !this.isEraseMode();
    }

    public boolean isEraseMode() {
        if (this.mSignPathView != null) {
            return this.mSignPathView.isEraseMode();
        }
        return false;
    }

    public void setTextSize(float f2) {
        if (f2 > 0.0f) {
            this.mSignPathViewSetting.setTextSize(f2);
            this.mSignPathViewSetting.setTextSizeScale(1.0f);
            this.mCustomTextSize = true;
        } else {
            this.mSignPathViewSetting.setTextSize(this.mTextSize);
            this.mSignPathViewSetting.setTextSizeScale(this.mTextScale);
            this.mCustomTextSize = false;
        }
        this.updateView();
    }

    public float measureTextSizeAsTracingOutline(int n, int n2) {
        boolean bl;
        Rect rect = new Rect(0, 0, n, n2);
        String[] stringArray = this.mSignPathViewSetting.getTexts();
        boolean bl2 = bl = !rect.isEmpty() && stringArray != null;
        if (bl) {
            return new AutoSizeTextDrawHelper().getTextFullAutoSize(stringArray, rect.left, rect.top, rect.right, rect.bottom);
        }
        return 0.0f;
    }

    public void setSignPadViewListener(IOZSignPadViewListener iOZSignPadViewListener) {
        this.mListener = iOZSignPadViewListener;
    }

    public void clear() {
        if (this.mSignPathView != null) {
            this.mSignPathView.clearSignValue();
        }
    }

    public void onSignAreaChanged(SignPathView signPathView, float f2, float f3, float f4, float f5) {
        float f6 = f4 - f2;
        float f7 = f5 - f3;
        float f8 = this.mInfo.getCompWidth();
        float f9 = this.mInfo.getCompHeight();
        if (f6 > 0.0f && f7 > 0.0f && f8 > 0.0f && f9 > 0.0f) {
            float f10 = f6 / f8;
            float f11 = f7 / f9;
            float f12 = Math.min(f10, f11);
            this.mSignPathViewSetting.setThicknessScale(f12);
            this.mTextScale = f12;
            if (this.mCustomTextSize) {
                this.mSignPathViewSetting.setTextSizeScale(1.0f);
            } else {
                this.mSignPathViewSetting.setTextSizeScale(f12);
            }
        } else {
            this.mSignPathViewSetting.setThicknessScale(1.0f);
            this.mSignPathViewSetting.setTextSizeScale(1.0f);
        }
        this.updateView();
    }

    private void callOnValueChanged() {
        if (this.mListener != null) {
            this.mListener.onValueChanged();
        }
    }

    public void onChanged(SignPathView signPathView, ISignPathValue iSignPathValue, ISignPathValue iSignPathValue2) {
        this.callOnValueChanged();
    }

    public void onAppend(SignPathView signPathView) {
        this.callOnValueChanged();
    }

    public void onClear(SignPathView signPathView) {
    }

    public void onDeleted(SignPathView signPathView) {
        this.callOnValueChanged();
    }
}

