/*
 * Decompiled with CFR 0.152.
 */
package oz.client.shape.ui;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Configuration;
import android.graphics.Canvas;
import android.graphics.Typeface;
import android.os.Build;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.DatePicker;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.TimePicker;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import oz.client.shape.ui.ICDateTimePickerWnd$1;
import oz.client.shape.ui.ICDateTimePickerWnd$10;
import oz.client.shape.ui.ICDateTimePickerWnd$11;
import oz.client.shape.ui.ICDateTimePickerWnd$2;
import oz.client.shape.ui.ICDateTimePickerWnd$3;
import oz.client.shape.ui.ICDateTimePickerWnd$4;
import oz.client.shape.ui.ICDateTimePickerWnd$5;
import oz.client.shape.ui.ICDateTimePickerWnd$6;
import oz.client.shape.ui.ICDateTimePickerWnd$7;
import oz.client.shape.ui.ICDateTimePickerWnd$8;
import oz.client.shape.ui.ICDateTimePickerWnd$9;
import oz.client.shape.ui.OZInputComponent;
import oz.client.shape.ui.OZInputComponent$OZInputComponentDialogBuilder;
import oz.client.shape.ui.OZInputComponent$ToolbarButtonInfo;
import oz.main.OZStorage;
import oz.resource.OZAndroidResource;

public class ICDateTimePickerWnd
extends OZInputComponent {
    boolean m_timePicker;
    String m_maxDate;
    String m_minDate;
    String m_pattern;
    int m_nYear;
    int m_nMonth;
    int m_nDay;
    int m_nHour;
    int m_nMinute;
    int maxYear;
    int maxMonth;
    int maxDay;
    int minYear;
    int minMonth;
    int minDay;
    boolean m_isAllowedEmpty;
    boolean isClickedDateTimePicker;
    boolean m_isEmpty;
    int m_popupDlgHeight;
    int m_popupDlgWidth;
    private final String TEXT_RES_EMPTY_MSG = "datetimepicker.empty.msg";
    Dialog mPopupDlg;
    boolean isClosedPopup = true;
    DatePicker dp;
    TimePicker tp;
    TextView tv;

    public ICDateTimePickerWnd(Context context) {
        super(context, 59);
        this.setBackgroundColor(0);
        this.bringToFront();
        this.realDraw_paint = ICDateTimePickerWnd.createPaintGraphicType();
    }

    protected void setMaxDate(String string) {
        this.m_maxDate = string;
        int[] nArray = this.splitDate(this.m_maxDate, this.getMinMaxPattern(this.m_maxDate));
        this.maxYear = nArray[0];
        this.maxMonth = nArray[1];
        this.maxDay = nArray[2];
    }

    protected void setMinDate(String string) {
        this.m_minDate = string;
        int[] nArray = this.splitDate(this.m_minDate, this.getMinMaxPattern(this.m_minDate));
        this.minYear = nArray[0];
        this.minMonth = nArray[1];
        this.minDay = nArray[2];
    }

    protected void setAllowedEmpty(boolean bl) {
        this.m_isAllowedEmpty = bl;
    }

    private String getMinMaxPattern(String string) {
        if (string.matches("^[0-9]{2}/[0-9]{2}/[0-9]{4}$")) {
            return "MM/dd/yyyy";
        }
        return this.m_pattern;
    }

    protected void setComponentText(String string, long l, boolean bl) {
        if (string.startsWith("date_")) {
            string = string.substring(5);
        } else if (string.startsWith("d_") || string.startsWith("D_")) {
            string = string.substring(2);
        } else if ("STRING".equals(string)) {
            string = "yyyy-MM-dd";
        }
        if (string.startsWith("ggge") || string.startsWith("ge")) {
            string = "yyyy-MM-dd";
        }
        this.m_pattern = string;
        this.m_isEmpty = bl;
        Date date = new Date(l);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int[] nArray = new int[]{calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12)};
        this.m_nYear = nArray[0];
        this.m_nMonth = nArray[1];
        this.m_nDay = nArray[2];
        if (this.isExistTimePattern(string)) {
            this.m_timePicker = true;
            this.m_nHour = nArray[3];
            this.m_nMinute = nArray[4];
        } else {
            this.m_timePicker = false;
        }
    }

    private boolean isExistTimePattern(String string) {
        StringBuilder stringBuilder = new StringBuilder(string);
        int n = stringBuilder.indexOf("'");
        while (n > -1) {
            int n2 = stringBuilder.indexOf("'", n + 1);
            if (n2 > -1) {
                stringBuilder.delete(n, n2 + 1);
            } else {
                stringBuilder.delete(n, stringBuilder.length());
            }
            n = stringBuilder.indexOf("'");
        }
        string = stringBuilder.toString();
        return !string.equalsIgnoreCase("STRING") && (string.indexOf("H") >= 0 || string.indexOf("h") >= 0 || string.indexOf("m") >= 0 || string.indexOf("S") >= 0 || string.indexOf("s") >= 0);
    }

    private int[] splitDate(String string, String object) {
        Object object2;
        int[] nArray = new int[5];
        Date date = null;
        try {
            object2 = "";
            if (!(((String)object).equalsIgnoreCase("STRING") || ((String)object).indexOf("yy") >= 0 && ((String)object).indexOf("MM") >= 0 && ((String)object).indexOf("dd") >= 0)) {
                String string2;
                object2 = "yyyy-MM-dd";
                int n = -1;
                int n2 = ((String)object).indexOf("H");
                n = n2 == -1 ? Math.min(((String)object).indexOf("h"), ((String)object).indexOf("m")) : Math.min(((String)object).indexOf("H"), ((String)object).indexOf("m"));
                if (n != -1 && !"".equals(string2 = ((String)object).substring(n))) {
                    object2 = (String)object2 + string2;
                }
                object = object2;
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat((String)object, OZStorage.getViewerLocale());
            date = !"".equals(string) ? simpleDateFormat.parse(string) : new Date();
        }
        catch (Exception exception) {
            Log.e((String)"OZViewer", (String)("Not supported pattern : " + exception.getLocalizedMessage()));
            object = "yyyy-MM-dd";
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat((String)object, OZStorage.getViewerLocale());
            try {
                date = simpleDateFormat.parse(string);
            }
            catch (ParseException parseException) {
                Log.e((String)"OZViewer", (String)("Not supported text : " + parseException.getLocalizedMessage()));
                date = new Date();
            }
        }
        object2 = Calendar.getInstance();
        ((Calendar)object2).setTime(date);
        nArray[0] = ((Calendar)object2).get(1);
        nArray[1] = ((Calendar)object2).get(2) + 1;
        nArray[2] = ((Calendar)object2).get(5);
        nArray[3] = ((Calendar)object2).get(11);
        nArray[4] = ((Calendar)object2).get(12);
        return nArray;
    }

    public void onClick() {
        if (this.isEform() && this.getComponentEnabled() && this.nativeEnableInputAll()) {
            if (this.mPopupDlg == null && this.isClosedPopup && this.ableOpenInputComponentDialog()) {
                this.openInputComponentDialog(this);
                this.isClosedPopup = false;
                this.nativeOnFocus(true);
                if (this.isStatus(new int[]{64, 32})) {
                    this.nativeOnFocus(false);
                    this.closeInputComponentDialog();
                    return;
                }
                this.updateHighlightRect();
                this.mPopupDlg = this.initDateTimePickerDialog();
                this.mPopupDlg.setOnDismissListener((DialogInterface.OnDismissListener)new ICDateTimePickerWnd$1(this));
                this.mPopupDlg.show();
                View view = this.mPopupDlg.findViewById(9999);
                view.setFocusable(true);
                view.setFocusableInTouchMode(true);
                view.requestFocus();
                this.onDialogChangeOrientation(this.mPopupDlg);
                if (this.ableUseCalendar()) {
                    this.setCalendarDirection();
                } else if (this.m_timePicker) {
                    this.setTimePickerOrientation();
                }
                this.dp.measure(0, 0);
                int n = this.dp.getMeasuredWidth();
                int n2 = this.dp.getMeasuredHeight();
                if (this.tp.getParent() != null) {
                    boolean bl;
                    this.tp.measure(0, 0);
                    boolean bl2 = bl = ((LinearLayout)this.mPopupDlg.findViewById(12000)).getOrientation() != 0;
                    if (bl) {
                        n2 += this.tp.getMeasuredHeight();
                    } else {
                        n += this.tp.getMeasuredWidth();
                    }
                }
                this.mPopupDlg.findViewById(12000).setMinimumWidth(n + OZStorage.padding_20);
                this.mPopupDlg.findViewById(12000).setMinimumHeight(n2 + OZStorage.padding_20);
            } else if (this.isInputRender() && !this.ableOpenInputComponentDialog() && this.getOpenDialogComponent() != this) {
                this.onCloseInputComponent(false);
            }
        }
        if (this.mPopupDlg == null) {
            this.setStatus(0);
            this.clearHighlightRect();
        }
    }

    private Dialog initDateTimePickerDialog() {
        this.dp = new DatePicker(this.getContext());
        this.tp = new TimePicker(this.getContext());
        this.tv = new TextView(this.getContext());
        this.dp.setPadding(OZStorage.padding_10, OZStorage.padding_10, OZStorage.padding_10, OZStorage.padding_10);
        this.dp.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        this.setDatePickerMinMax();
        this.tp.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        this.tp.setCurrentHour(Integer.valueOf(this.m_nHour));
        this.tp.setCurrentMinute(Integer.valueOf(this.m_nMinute));
        this.tv.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        int n = this.m_nYear;
        int n2 = this.m_nMonth;
        int n3 = this.m_nDay;
        if (n > this.maxYear) {
            n = this.maxYear;
            n2 = this.maxMonth;
            n3 = this.maxDay;
        } else if (n == this.maxYear && n2 > this.maxMonth) {
            n2 = this.maxMonth;
            n3 = this.maxDay;
        } else if (n == this.maxYear && n2 == this.maxMonth && n3 > this.maxDay) {
            n3 = this.maxDay;
        }
        if (this.maxDay >= 10) {
            this.dp.init(n, n2 - 1, n3, null);
        } else {
            this.dp.init(n, n2 - 1, n3, (DatePicker.OnDateChangedListener)new ICDateTimePickerWnd$2(this));
            if (n == this.maxYear && n2 == this.maxMonth && n3 == this.maxDay) {
                this.dp.updateDate(this.maxYear, this.maxMonth, this.maxDay);
            }
        }
        this.setUseCalendar();
        this.initProp();
        ArrayList<OZInputComponent$ToolbarButtonInfo> arrayList = new ArrayList<OZInputComponent$ToolbarButtonInfo>();
        OZInputComponent$OZInputComponentDialogBuilder oZInputComponent$OZInputComponentDialogBuilder = new OZInputComponent$OZInputComponentDialogBuilder(this, this.getContext());
        oZInputComponent$OZInputComponentDialogBuilder.setTitle(this.getTooltip());
        oZInputComponent$OZInputComponentDialogBuilder.setMinWidth(OZStorage.DpToPx(this.getContext(), 550.0f, true, true, true));
        oZInputComponent$OZInputComponentDialogBuilder.addView((View)this.dp, 12000);
        if (this.m_timePicker) {
            this.tp.setPadding(OZStorage.padding_10, 0, OZStorage.padding_10, OZStorage.padding_10);
            oZInputComponent$OZInputComponentDialogBuilder.addView((View)this.tp, 12000);
        }
        if (this.isClickedDateTimePicker) {
            this.tv.setVisibility(8);
        } else if (this.m_isAllowedEmpty && this.m_isEmpty) {
            this.dp.setVisibility(8);
            if (this.m_timePicker) {
                this.tp.setVisibility(8);
            }
        } else {
            this.tv.setVisibility(8);
        }
        this.setEnableInitBtn(this.dp.getVisibility() == 0);
        this.isClickedDateTimePicker = false;
        if (this.m_isIconType || this.isEnablePrevNext()) {
            Object object;
            oZInputComponent$OZInputComponentDialogBuilder.setUseCustomView(true);
            this.initBtn = this.getInitButton(!this.isEnableInitBtn());
            if (this.m_isAllowedEmpty) {
                this.tv.setGravity(17);
                this.tv.setText((CharSequence)OZAndroidResource.getResource("datetimepicker.empty.msg"));
                this.tv.setTextSize(20.0f);
                this.tv.setOnClickListener((View.OnClickListener)new ICDateTimePickerWnd$3(this));
                oZInputComponent$OZInputComponentDialogBuilder.addView((View)this.tv, 12000);
                object = new ICDateTimePickerWnd$4(this);
                arrayList.add(new OZInputComponent$ToolbarButtonInfo(this, (View)this.initBtn, 2, (View.OnClickListener)object));
            }
            object = new ICDateTimePickerWnd$5(this);
            arrayList.add(new OZInputComponent$ToolbarButtonInfo(this, (View)this.getCancelButton(), 4, (View.OnClickListener)object));
            ICDateTimePickerWnd$6 iCDateTimePickerWnd$6 = new ICDateTimePickerWnd$6(this);
            arrayList.add(new OZInputComponent$ToolbarButtonInfo(this, (View)this.getConfirmButton(), 3, iCDateTimePickerWnd$6));
            if (this.isEnablePrevNext() && this.isShowPrevNextBtn()) {
                ICDateTimePickerWnd$7 iCDateTimePickerWnd$7 = new ICDateTimePickerWnd$7(this);
                ICDateTimePickerWnd$8 iCDateTimePickerWnd$8 = new ICDateTimePickerWnd$8(this);
                arrayList.add(new OZInputComponent$ToolbarButtonInfo(this, (View)this.getPrevButton(), 0, iCDateTimePickerWnd$7));
                arrayList.add(new OZInputComponent$ToolbarButtonInfo(this, (View)this.getNextButton(), 1, iCDateTimePickerWnd$8));
            }
        } else {
            if (!this.hasTooltip()) {
                oZInputComponent$OZInputComponentDialogBuilder.getBuilder().setTitle((CharSequence)"DateTimePicker");
                oZInputComponent$OZInputComponentDialogBuilder.getBuilder().setIcon(17301659);
                oZInputComponent$OZInputComponentDialogBuilder.setUseCustomTitle(0);
            } else {
                oZInputComponent$OZInputComponentDialogBuilder.setUseCustomTitle(240);
            }
            oZInputComponent$OZInputComponentDialogBuilder.getBuilder().setPositiveButton((CharSequence)OZAndroidResource.getResource(60014), (DialogInterface.OnClickListener)new ICDateTimePickerWnd$9(this));
            oZInputComponent$OZInputComponentDialogBuilder.getBuilder().setNegativeButton((CharSequence)OZAndroidResource.getResource(60015), (DialogInterface.OnClickListener)new ICDateTimePickerWnd$10(this));
            oZInputComponent$OZInputComponentDialogBuilder.getBuilder().setView(oZInputComponent$OZInputComponentDialogBuilder.createCustomView());
        }
        this.addToolbarButtons(oZInputComponent$OZInputComponentDialogBuilder, arrayList);
        return oZInputComponent$OZInputComponentDialogBuilder.create();
    }

    private void setUseCalendar() {
        if (Build.VERSION.SDK_INT > 10) {
            try {
                Method method = this.dp.getClass().getMethod("setCalendarViewShown", Boolean.TYPE);
                if (this.ableUseCalendar()) {
                    method.invoke((Object)this.dp, true);
                } else {
                    method.invoke((Object)this.dp, false);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private boolean ableUseCalendar() {
        block9: {
            if (Build.VERSION.SDK_INT > 10) {
                try {
                    long l = 1209600000L;
                    Method method = this.dp.getClass().getMethod("getMaxDate", new Class[0]);
                    long l2 = (Long)method.invoke((Object)this.dp, new Object[0]);
                    method = this.dp.getClass().getMethod("getMinDate", new Class[0]);
                    long l3 = (Long)method.invoke((Object)this.dp, new Object[0]);
                    if (l2 - l3 < l) break block9;
                    if (this.m_timePicker) {
                        if (OZStorage.isSmallDevice(this.getContext())) {
                            return false;
                        }
                        method = this.dp.getClass().getMethod("getCalendarView", new Class[0]);
                        ViewGroup viewGroup = (ViewGroup)method.invoke((Object)this.dp, new Object[0]);
                        LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)viewGroup.getLayoutParams();
                        layoutParams.height = OZStorage.DpToPx(this.getContext(), 200.0f, false);
                        viewGroup.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                        if (Build.VERSION.SDK_INT >= 16) {
                            try {
                                method = viewGroup.getClass().getMethod("setShownWeekCount", Integer.TYPE);
                                if (method != null) {
                                    method.invoke((Object)viewGroup, 4);
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    return true;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return false;
    }

    private void setCalendarDirection() {
        block9: {
            if (!this.isClosedPopup && Build.VERSION.SDK_INT > 10) {
                float f2;
                boolean bl = OZStorage.IsDisplayLandscape(this.getContext());
                float f3 = (float)(bl ? OZStorage.getScreenSize((Context)this.getContext()).y : OZStorage.getScreenSize((Context)this.getContext()).x) / OZStorage.DpPerPx(this.getContext(), true);
                float f4 = f2 = bl ? 550.0f : 550.0f + OZStorage.PxToDp(this.getContext(), OZStorage.getStatusBarHeight(this.getContext()), false);
                if (f3 < f2) {
                    try {
                        LinearLayout linearLayout = (LinearLayout)this.dp.getChildAt(0);
                        linearLayout.setGravity(16);
                        linearLayout.setPadding(OZStorage.DpToPx(this.getContext(), 10.0f, true), 0, 0, 0);
                        ViewGroup viewGroup = (ViewGroup)linearLayout.getChildAt(1);
                        LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)viewGroup.getLayoutParams();
                        layoutParams.leftMargin = 0;
                        layoutParams.height = OZStorage.DpToPx(this.getContext(), f3 * 0.9f, false, true, true);
                        if (bl) {
                            linearLayout.setOrientation(0);
                            layoutParams.bottomMargin = 0;
                        } else {
                            linearLayout.setOrientation(1);
                            layoutParams.bottomMargin = OZStorage.DpToPx(this.getContext(), 20.0f, false);
                        }
                        if (Build.VERSION.SDK_INT < 16) break block9;
                        try {
                            Method method = viewGroup.getClass().getMethod("setShownWeekCount", Integer.TYPE);
                            if (method != null) {
                                method.invoke((Object)viewGroup, 4);
                            }
                        }
                        catch (Exception exception) {}
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }
    }

    private void setDatePickerMinMax() {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            Date date = simpleDateFormat.parse(this.maxYear + "-" + this.maxMonth + "-" + this.maxDay + " 23:59:59.999");
            Date date2 = simpleDateFormat.parse(this.minYear + "-" + this.minMonth + "-" + this.minDay + " 00:00:00.000");
            if (date.getTime() < date2.getTime()) {
                date = simpleDateFormat.parse("9998-12-31 23:59:59.999");
                date2 = simpleDateFormat.parse("1753-01-01 00:00:00.000");
            }
            Method method = this.dp.getClass().getMethod("setMaxDate", Long.TYPE);
            method.invoke((Object)this.dp, date.getTime());
            method = this.dp.getClass().getMethod("setMinDate", Long.TYPE);
            method.invoke((Object)this.dp, date2.getTime());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void setTimePickerOrientation() {
        if (this.mPopupDlg != null && this.m_timePicker && OZStorage.isSmallDevice(this.getContext())) {
            ((LinearLayout)this.mPopupDlg.findViewById(12000)).setOrientation(OZStorage.IsDisplayLandscape(this.getContext()) ? 0 : 1);
        }
    }

    public native void nativeOnClick(long var1, boolean var3);

    protected void realDraw(Canvas canvas, float f2, float f3, float f4, float f5, float f6, int n, Typeface typeface) {
        this.setComponentBounds(f2, f3, f4, f5, f6);
        if (this.isHighlightMode() && !this._isDispose) {
            this.drawHighlightRect(canvas, f2, f3, f4, f5, f6, n, typeface);
        }
    }

    private void confirm() {
        Date date;
        if (this.mPopupDlg != null && this.mPopupDlg.getCurrentFocus() != null) {
            this.mPopupDlg.getCurrentFocus().clearFocus();
        }
        String string = String.format("%s-%s-%s", this.dp.getYear(), String.format("%02d", this.dp.getMonth() + 1), String.format("%02d", this.dp.getDayOfMonth()));
        String string2 = String.format("%s:%s:00", String.format("%02d", this.tp.getCurrentHour()), String.format("%02d", this.tp.getCurrentMinute()));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            date = simpleDateFormat.parse(String.format("%s %s", string, string2));
        }
        catch (ParseException parseException) {
            Log.e((String)"OZViewer", (String)("Not supported pattern(confirm) : " + parseException.getLocalizedMessage()));
            date = new Date();
        }
        if (this.tv.getVisibility() == 8) {
            this.nativeOnClick(date.getTime(), false);
        } else {
            this.nativeOnClick(date.getTime(), true);
        }
        this.UpdateValue();
    }

    protected void onConfigurationChanged(Configuration configuration) {
        if (!(this.isClosedPopup || configuration.orientation != 2 && configuration.orientation != 1)) {
            if (this.hasTooltip()) {
                this.onDialogChangeOrientation(this.mPopupDlg);
            }
            if (this.ableUseCalendar()) {
                this.setCalendarDirection();
            } else if (this.m_timePicker) {
                this.setTimePickerOrientation();
            }
            this.dp.measure(0, 0);
            int n = this.dp.getMeasuredWidth();
            int n2 = this.dp.getMeasuredHeight();
            if (this.tp.getParent() != null) {
                boolean bl;
                this.tp.measure(0, 0);
                boolean bl2 = bl = ((LinearLayout)this.mPopupDlg.findViewById(12000)).getOrientation() != 0;
                if (bl) {
                    n2 += this.tp.getMeasuredHeight();
                } else {
                    n += this.tp.getMeasuredWidth();
                }
            }
            this.mPopupDlg.findViewById(12000).setMinimumWidth(n + OZStorage.padding_20);
            this.mPopupDlg.findViewById(12000).setMinimumHeight(n2 + OZStorage.padding_20);
        }
        super.onConfigurationChanged(configuration);
    }

    protected void closeInputComponentDialog() {
        if (this.mPopupDlg != null) {
            this.mPopupDlg.dismiss();
        }
        super.closeInputComponentDialog();
    }

    protected void Open() {
        super.Open();
        if (this.isOpenKeyboard()) {
            this.removeKeyboardByDummy();
            this.beginIgnoreScrollEvent();
            this.postDelayed(new ICDateTimePickerWnd$11(this), 200L);
        } else {
            this.onClick();
        }
    }

    protected boolean OnTabKeyPress(KeyEvent keyEvent) {
        boolean bl = keyEvent.isShiftPressed();
        this.confirm();
        this.showPrevNextComp(bl ? this.getPrevCompId() : this.getNextCompId(), bl);
        this.closeInputComponentDialog();
        return true;
    }

    protected boolean OnEnterKeyPress(KeyEvent keyEvent) {
        this.confirm();
        this.endIgnoreScrollEvent();
        this.closeInputComponentDialog();
        return true;
    }

    protected boolean OnESCKeyPress(KeyEvent keyEvent) {
        this.UpdateValue();
        this.endIgnoreScrollEvent();
        this.closeInputComponentDialog();
        return true;
    }

    protected boolean OnDelKeyPress(KeyEvent keyEvent) {
        if (this.m_isAllowedEmpty) {
            this.tv.setVisibility(0);
            this.dp.setVisibility(8);
            if (this.m_timePicker) {
                this.tp.setVisibility(8);
            }
            this.initBtn.setClickable(false);
            this.changeDrawable(this.initBtn, "resource/default_btn_empty_d@2x.png", this.m_isIconType);
            return true;
        }
        return false;
    }

    protected boolean OnConfirmClick(Object object) {
        this.confirm();
        this.endIgnoreScrollEvent();
        this.mPopupDlg.dismiss();
        return true;
    }

    protected boolean OnNextClick(Object object) {
        this.confirm();
        this.showPrevNextComp(this.getNextCompId(), false);
        this.closeInputComponentDialog();
        return true;
    }

    static /* synthetic */ void access$000(ICDateTimePickerWnd iCDateTimePickerWnd) {
        iCDateTimePickerWnd.confirm();
    }
}

