/*
 * Decompiled with CFR 0.152.
 */
package oz.client.shape.ui;

import android.app.Dialog;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.util.Base64;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.json.JSONException;
import org.json.JSONObject;
import oz.client.shape.ui.EFormComponent2Base;
import oz.client.shape.ui.ICImagePickerEform$Options;
import oz.main.OZStorage;
import oz.util.view.camera.ImageSealView;
import oz.util.view.camera.ImageSealView$OnSealListener;
import oz.viewer.ui.df.ctrl.DFImageRecognitionData;

public class ICImagePickerEform
extends EFormComponent2Base
implements ImageSealView$OnSealListener {
    private static final int ID_SEAL = 1;
    private static final int CUSTOMSEAL_RESULT_FAIL = -1;
    private static final int CUSTOMSEAL_RESULT_CANCEL = 0;
    private static final int CUSTOMSEAL_RESULT_SUCCESS = 1;
    private ICImagePickerEform$Options mOptions;
    private final FrameLayout mView;
    private ImageSealView mImageSealView;
    private Bitmap mBitmap;
    private String mJPGBase64EncodingData;
    private int mAreaWidth;
    private int mAreaHeight;

    public native void nativeInitialize();

    public native void nativeDispose();

    public native int nativeOnCameraPreview(Bitmap var1, byte[] var2, int[] var3);

    public native int nativeOnCameraPicture(Bitmap var1, int[] var2);

    public ICImagePickerEform(Context context) {
        super(context);
        this.initDefaultOption();
        this.mView = new FrameLayout(this.getContext());
        this.nativeInitialize();
        OZStorage.initEnv(context);
    }

    private void initDefaultOption() {
        this.mOptions = new ICImagePickerEform$Options();
        this.mOptions.borderColor = -7829368;
        this.mOptions.backgroundColor = -1;
        this.mOptions.processType = "None";
        this.mOptions.jpgQuality = 90;
        this.mOptions.maxDpi = 300;
        this.mOptions.showBorder = true;
    }

    public void setOptions(ICImagePickerEform$Options iCImagePickerEform$Options) {
        if (iCImagePickerEform$Options != null) {
            this.mOptions = iCImagePickerEform$Options;
        }
    }

    public void setBitmapResult(Bitmap bitmap, String string, int n) {
        if (n == 999) {
            if (bitmap != null) {
                this.mBitmap = bitmap;
                this.mJPGBase64EncodingData = string;
            }
        } else if (n != 998 || bitmap != null) {
            // empty if block
        }
    }

    public void setAreaWH(int n, int n2) {
        this.mAreaWidth = n;
        this.mAreaHeight = n2;
    }

    public int getJpgQuality() {
        return this.mOptions == null ? 90 : Math.max(1, Math.min(this.mOptions.jpgQuality, 100));
    }

    public int getMaxDpi() {
        return this.mOptions == null ? 300 : Math.max(10, this.mOptions.maxDpi);
    }

    public int getImageProcessType() {
        String string = this.mOptions == null ? "none" : this.mOptions.processType;
        int n = 0;
        if (string.equalsIgnoreCase("None")) {
            n = 0;
        } else if (string.equalsIgnoreCase("BlackAndWhite")) {
            n = 1;
        } else if (string.equalsIgnoreCase("BlackAndBlank")) {
            n = 2;
        } else if (string.equalsIgnoreCase("RedAndWhite")) {
            n = 4;
        } else if (string.equalsIgnoreCase("RedAndBlank")) {
            n = 5;
        } else if (string.equalsIgnoreCase("GrayScale")) {
            n = 3;
        }
        return n;
    }

    public int getTargetWidth() {
        int n;
        int n2 = 75;
        if (this.mImageSealView != null && (n = this.mImageSealView.getWidth()) > 0) {
            n2 = n;
        }
        return n2;
    }

    public int getTargetHeight() {
        int n;
        int n2 = 75;
        if (this.mImageSealView != null && (n = this.mImageSealView.getHeight()) > 0) {
            n2 = n;
        }
        return n2;
    }

    public void getInputComponentViewDispose() {
        this.mView.removeAllViews();
    }

    public void clearInputComponentView() {
        if (this.isInputComponentViewCreated()) {
            ImageView imageView = (ImageView)this.mView.findViewById(1);
            imageView.setImageBitmap(null);
        }
    }

    public FrameLayout getInputComponentView(int n, int n2) {
        this.clearInputComponentView();
        this.getInputComponentViewDispose();
        int n3 = OZStorage.DpToPx(this.getContext(), 20.0f, true);
        int n4 = OZStorage.DpToPx(this.getContext(), 3.0f, true);
        boolean bl = this.getOptions().showBorder;
        Rect rect = new Rect(0, 0, n, n2);
        rect.inset(n3, n3);
        if (bl) {
            rect.inset(n4, n4);
        } else {
            n4 = 0;
        }
        if (rect.isEmpty()) {
            n3 = 0;
            rect.set(0, 0, n, n2);
        }
        FrameLayout frameLayout = new FrameLayout(this.getContext());
        frameLayout.setPadding(n3, n3, n3, n3);
        frameLayout.setBackgroundColor(0);
        FrameLayout frameLayout2 = new FrameLayout(this.getContext());
        frameLayout2.setPadding(n4, n4, n4, n4);
        frameLayout2.setBackgroundColor(bl ? this.getOptions().borderColor : 0);
        frameLayout.addView((View)frameLayout2);
        FrameLayout frameLayout3 = new FrameLayout(this.getContext());
        frameLayout3.setBackgroundColor(0);
        frameLayout2.addView((View)frameLayout3, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(rect.width(), rect.height()));
        this.mImageSealView = new ImageSealView(this.getContext());
        this.mImageSealView.setPictureRatio(1.0f);
        this.mImageSealView.setOnTakePictureListener(this);
        this.mImageSealView.setBackgroundColor(this.getOptions().backgroundColor);
        frameLayout3.addView((View)this.mImageSealView);
        this.mView.addView((View)frameLayout, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(n, n2));
        return this.mView;
    }

    public ICImagePickerEform$Options getOptions() {
        return this.mOptions;
    }

    public int getComponentType() {
        return 0;
    }

    public View getComponentView(int n, int n2) {
        this.updateLayout(n, n2);
        return this.mView;
    }

    public void updateLayout(int n, int n2) {
        this.getInputComponentView(n, n2);
    }

    public String script(String string) {
        String string2 = null;
        if ("clear".equalsIgnoreCase(string)) {
            this.clearInputComponentView();
        } else if ("openseal".equalsIgnoreCase(string)) {
            this.mImageSealView.runOnClick();
        } else if ("getimage".equalsIgnoreCase(string) && this.mBitmap != null) {
            string2 = this.getImageBase64(this.mBitmap);
        }
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    public void dispose() {
        this.getInputComponentViewDispose();
        this.nativeDispose();
        if (this.mImageSealView != null) {
            this.mImageSealView.dismiss();
        }
    }

    public boolean isInputComponentViewCreated() {
        return this.mView.findViewById(1) != null;
    }

    private String getImageBase64(Bitmap bitmap) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.mBitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)byteArrayOutputStream);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        String string = "data:image/png;base64," + Base64.encodeToString((byte[])byArray, (int)2);
        return string;
    }

    public void OnTakePicture(Bitmap bitmap) {
        boolean bl = false;
        if (this.mImageSealView != null && this.mBitmap != null && this.mJPGBase64EncodingData != null) {
            if (this.getCallback() != null) {
                JSONObject jSONObject = new JSONObject();
                try {
                    jSONObject.put("resultcode", 1);
                    jSONObject.put("imagedata", (Object)this.mJPGBase64EncodingData);
                    jSONObject.put("imagewidth", this.mBitmap.getWidth());
                    jSONObject.put("imageheight", this.mBitmap.getHeight());
                    jSONObject.put("scanareawidth", this.mAreaWidth);
                    jSONObject.put("scanareaheight", this.mAreaHeight);
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
                this.triggerEvent(0, jSONObject);
                bl = true;
            }
            this.mBitmap = null;
            this.mJPGBase64EncodingData = null;
        }
        if (!bl) {
            this.triggerFailEvent(-1);
        }
        this.mImageSealView.dismiss();
    }

    public void OnStopSpeech() {
    }

    public int OnTakePreview(DFImageRecognitionData dFImageRecognitionData) {
        int[] nArray = new int[14];
        nArray[0] = dFImageRecognitionData.mRectWidth;
        nArray[1] = dFImageRecognitionData.mRectHeight;
        nArray[2] = dFImageRecognitionData.mRectLeft;
        nArray[3] = dFImageRecognitionData.mRectTop;
        nArray[4] = dFImageRecognitionData.mBitmapWidth;
        nArray[5] = dFImageRecognitionData.mBitmapHeight;
        nArray[6] = dFImageRecognitionData.mRotation;
        nArray[7] = dFImageRecognitionData.mCameraType;
        nArray[8] = dFImageRecognitionData.mIsFocused;
        nArray[9] = dFImageRecognitionData.mIsOnceFocused;
        nArray[10] = dFImageRecognitionData.mIsForceShutter;
        nArray[11] = dFImageRecognitionData.mIsPreview;
        int n = this.nativeOnCameraPreview(dFImageRecognitionData.mBitmap, dFImageRecognitionData.mData, nArray);
        return n;
    }

    public void willShowDialog(Dialog dialog) {
    }

    public void willDismissDialog(Dialog dialog) {
    }

    public void OnCancel(int n) {
        this.triggerFailEvent(0);
    }

    private void triggerFailEvent(int n) {
        if (this.getCallback() != null) {
            JSONObject jSONObject = new JSONObject();
            try {
                jSONObject.put("resultcode", n);
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
            this.triggerEvent(0, jSONObject);
        }
    }

    public boolean isEnableOnClick() {
        return true;
    }
}

