/*
 * Decompiled with CFR 0.152.
 */
package oz.client.shape.ui;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import oz.client.shape.ui.EFormComponent;
import oz.client.shape.ui.ICSignPadWnd;
import oz.client.shape.ui.ICSignPadWndEform$Options;
import oz.client.shape.ui.OZSignView;
import oz.main.OZStorage;

public class ICSignPadWndEform
extends ICSignPadWnd
implements EFormComponent {
    private static final int ID_SIGN = 257464099;
    private ICSignPadWndEform$Options mOptions;
    private FrameLayout mView;
    private int mLastWidth;
    private int mLastHeight;

    public ICSignPadWndEform(Context context) {
        super(context);
        this.initDefaultOption();
        this.createEmptyComponent();
        this.mView = new FrameLayout(this.getContext());
        OZStorage.initEnv(context);
    }

    private void initDefaultOption() {
        this.mOptions = new ICSignPadWndEform$Options();
        this.mOptions.text = "";
        this.mOptions.textColor = -16777216;
        this.mOptions.textGravity = 17;
        this.mOptions.borderColor = -7829368;
        this.mOptions.backgroundColor = -1;
        this.mOptions.penColor = -16777216;
        this.mOptions.penThick = 1.0f;
        this.mOptions.textSizeScale = 1.0f;
        this.mOptions.showBorder = true;
    }

    public FrameLayout getInputComponentView(int n, int n2) {
        this.clearInputComponentView();
        this.getInputComponentViewDispose();
        int n3 = OZStorage.DpToPx(this.getContext(), 20.0f, true);
        int n4 = OZStorage.DpToPx(this.getContext(), 3.0f, true);
        boolean bl = this.getOptions().showBorder;
        Rect rect = new Rect(0, 0, n, n2);
        rect.inset(n3, n3);
        if (bl) {
            rect.inset(n4, n4);
        } else {
            n4 = 0;
        }
        if (rect.isEmpty()) {
            n3 = 0;
            rect.set(0, 0, n, n2);
        }
        this.setComponentText(this.getOptions().text);
        FrameLayout frameLayout = new FrameLayout(this.getContext());
        this.mLastWidth = n;
        this.mLastHeight = n2;
        frameLayout.setPadding(n3, n3, n3, n3);
        frameLayout.setBackgroundColor(0);
        FrameLayout frameLayout2 = new FrameLayout(this.getContext());
        frameLayout2.setPadding(n4, n4, n4, n4);
        frameLayout2.setBackgroundColor(bl ? this.getOptions().borderColor : 0);
        frameLayout.addView((View)frameLayout2);
        FrameLayout frameLayout3 = new FrameLayout(this.getContext());
        frameLayout3.setBackgroundColor(0);
        frameLayout2.addView((View)frameLayout3, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(rect.width(), rect.height()));
        OZSignView oZSignView = new OZSignView(this.getContext(), this, rect.width(), rect.height(), rect.width(), rect.height());
        oZSignView.setId(257464099);
        frameLayout3.addView((View)oZSignView);
        this.mView.addView((View)frameLayout, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(n, n2));
        return this.mView;
    }

    public void getInputComponentViewDispose() {
        this.mView.removeAllViews();
    }

    public boolean isInputComponentViewCreated() {
        return this.mView.findViewById(257464099) != null;
    }

    public void clearInputComponentView() {
        if (this.isInputComponentViewCreated()) {
            OZSignView oZSignView = (OZSignView)this.mView.findViewById(257464099);
            oZSignView.clear();
        }
    }

    public String getComponentData() {
        String string = null;
        if (this.hasSignPathData()) {
            string = this.makeFitToFrameString(0, this.getImagePathData(), this.mLastWidth, this.mLastHeight);
        }
        return string;
    }

    protected void onDraw(Canvas canvas) {
    }

    public void setOptions(ICSignPadWndEform$Options iCSignPadWndEform$Options) {
        if (iCSignPadWndEform$Options != null) {
            this.mOptions = iCSignPadWndEform$Options;
            this.updateOptions();
        }
    }

    public void updateOptions() {
        this.getSignPenThick().setThickness(0, this.getOptions().penThick, false);
    }

    public ICSignPadWndEform$Options getOptions() {
        return this.mOptions;
    }

    public int getSignDrawMode() {
        return 2;
    }

    public int getSignPenColor() {
        return this.getOptions().penColor;
    }

    public boolean isTextBold() {
        return false;
    }

    public int getSignModeType() {
        return 4;
    }

    public int getSignViewType() {
        return 2;
    }

    public boolean isTracingOutLine() {
        return false;
    }

    public float getSignTextSize() {
        return 10.0f;
    }

    public float getComponentTextScale() {
        return this.getOptions().textSizeScale;
    }

    public int getComponentTextColor() {
        return this.getOptions().textColor;
    }

    public int getComponentBackGroundColor() {
        return this.getOptions().backgroundColor;
    }

    public int getComponentGravity() {
        return this.getOptions().textGravity;
    }

    public boolean isInputRender() {
        return true;
    }

    public void clearNativeBitmap() {
    }

    public void flushInputControls() {
    }

    public int getComponentBackGroundAlpha() {
        return 255;
    }

    public boolean isSignPadKeepBackgroundColor() {
        return true;
    }

    public void setImageBitmap(boolean bl) {
    }

    public float getPageViewZoomScale() {
        return 1.0f;
    }

    public boolean isKeepRatioSign() {
        return true;
    }

    public View getComponentView(int n, int n2) {
        this.updateLayout(n, n2);
        return this.mView;
    }

    public void updateLayout(int n, int n2) {
        this.getInputComponentView(n, n2);
    }

    public String script(String string) {
        String string2 = null;
        if ("clear".equalsIgnoreCase(string)) {
            this.clearInputComponentView();
        } else if ("getpath".equalsIgnoreCase(string)) {
            string2 = this.getComponentData();
        }
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    public void dispose() {
        this.getInputComponentViewDispose();
        this.disposeEmptyComponent();
    }
}

