/*
 * Decompiled with CFR 0.152.
 */
package oz.client.shape.ui;

import android.app.ActionBar;
import android.app.Activity;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.content.res.Configuration;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.media.MediaPlayer;
import android.os.Build;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsoluteLayout;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import java.io.IOException;
import oz.client.shape.ui.ICVideoPlayerWnd$1;
import oz.client.shape.ui.ICVideoPlayerWnd$2;
import oz.client.shape.ui.ICVideoPlayerWnd$VideoPlayerHandler;
import oz.client.shape.ui.OZInputComponent;
import oz.client.shape.ui.controller.VideoWndController;
import oz.client.shape.ui.controller.VideoWndControllerGIF;
import oz.client.shape.ui.controller.VideoWndControllerMedia;
import oz.main.OZPageView;
import oz.main.OZStorage;
import oz.util.NativeInputStream;
import oz.util.gif.GifImageView;
import oz.util.gif.GifImageView$OnFrameChangeListener;
import oz.util.video.ResizeSurfaceView;
import oz.util.video.VideoControllerView;
import oz.util.video.VideoControllerView$Builder;
import oz.util.video.VideoControllerView$MediaPlayerControlListener;

public class ICVideoPlayerWnd
extends OZInputComponent
implements MediaPlayer.OnBufferingUpdateListener,
MediaPlayer.OnCompletionListener,
MediaPlayer.OnErrorListener,
MediaPlayer.OnPreparedListener,
MediaPlayer.OnVideoSizeChangedListener,
SurfaceHolder.Callback,
GifImageView$OnFrameChangeListener,
VideoControllerView$MediaPlayerControlListener {
    private static final int STATUS_CALL_CLOSE_FROM_SCRIPT = 0x8000000;
    private static final int IS_NOT_GIF = 0;
    private static boolean USE_GIFVIEW_DRAW_ANDROID = false;
    private String m_text = "";
    private String mSource;
    private String mPlaySource;
    private View mVideo;
    private ICVideoPlayerWnd$VideoPlayerHandler mVideoHandler;
    private ResizeSurfaceView mVideoSurface;
    private View mContentView;
    private View mLoadingView;
    MediaPlayer mMediaPlayer;
    private VideoControllerView mMediaPlayerController;
    private int mVideoWidth;
    private int mVideoHeight;
    private int mVideoBufferPercent;
    private boolean mCallCloseFromOnClick;
    private boolean mIsPrepare;
    private SurfaceHolder mLastHolder;
    private boolean mIsError;
    private boolean mIsComplete;
    private boolean mIsFullScreen;
    private boolean mIsControllerVisible;
    private int mLastPosition;
    private Rect mVideoArea;
    private Rect mSelfArea;
    private boolean mIsGIF;
    private GifImageView mGIFView;
    private AbsoluteLayout.LayoutParams mGIFViewLayoutParams;
    private VideoWndController mController;
    private String[] m_text_tokens;
    private Rect mSavedArea;
    private int mBackupUI;
    private boolean mBackupActionbar;

    public ICVideoPlayerWnd(Context context) {
        super(context, 88);
        this.init();
    }

    private void init() {
        this.realDraw_paint = ICVideoPlayerWnd.createPaintGraphicType();
        this.mVideoArea = new Rect();
        this.mSavedArea = new Rect();
        this.mSelfArea = new Rect();
        this.mIsGIF = false;
        this.mController = new VideoWndControllerMedia(this);
    }

    public void OnFrameChange() {
        OZPageView oZPageView = this.getPageView();
        if (oZPageView != null) {
            oZPageView.invalidate();
        }
    }

    private void gifClose() {
        if (this.mIsGIF && this.getGIFView() != null && this.mController != null) {
            this.mController.Close();
        }
    }

    public void setIsGif() {
        this.nativeSetIsGif();
    }

    private int setGIFImage(NativeInputStream nativeInputStream) {
        this.mIsGIF = true;
        int n = 0;
        if (this.getGIFView() == null) {
            this.mController = new VideoWndControllerGIF(this);
            this.setGIFView(new GifImageView(this.getContext()));
            this.getGIFView().setOnFrameChangeListener(this);
            this.getGIFView().setVisibility(8);
            this.mGIFViewLayoutParams = new AbsoluteLayout.LayoutParams(0, 0, 0, 0);
            this.addView((View)this.getGIFView(), (ViewGroup.LayoutParams)this.mGIFViewLayoutParams);
        } else {
            this.getGIFView().setImageDrawable(null);
        }
        byte[] byArray = null;
        if (nativeInputStream != null) {
            try {
                int n2 = nativeInputStream.available();
                if (n2 > 0) {
                    byArray = new byte[n2];
                    nativeInputStream.read(byArray);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (byArray == null) {
            byArray = new byte[]{};
        }
        this.getGIFView().setBytes(byArray);
        this.mController.Start();
        if (USE_GIFVIEW_DRAW_ANDROID) {
            this.requestUpdateGIFViewLayout();
        }
        if (this.getGIFView().getDecoder() != null) {
            n = this.getGIFView().getFrameCount();
        }
        if (n <= 0) {
            this.getGIFView().setBackgroundColor(-16777216);
        }
        return n;
    }

    private void requestUpdateGIFViewLayout() {
        if (USE_GIFVIEW_DRAW_ANDROID && this.getGIFView() != null) {
            if (this.getVideoHandler() == null) {
                this.mVideoHandler = new ICVideoPlayerWnd$VideoPlayerHandler(this);
            }
            this.getVideoHandler().removeMessages(1001);
            this.getVideoHandler().sendEmptyMessage(1001);
        }
    }

    private void updateGIFViewLayout() {
        this.updateGIFViewLayout(true);
    }

    private boolean updateGIFViewLayout(boolean bl) {
        if (this.getGIFView() != null) {
            boolean bl2;
            if (this.getVideoHandler() == null) {
                this.mVideoHandler = new ICVideoPlayerWnd$VideoPlayerHandler(this);
            }
            RectF rectF = this.getCompRect();
            this.mSelfArea.set(0, 0, this.getWidth(), this.getHeight());
            int n = this.getGIFView().getVisibility();
            boolean bl3 = bl2 = !rectF.isEmpty() && this.mSelfArea.intersect((int)rectF.left, (int)rectF.top, (int)rectF.right, (int)rectF.bottom);
            if (bl2) {
                this.mGIFViewLayoutParams.x = (int)rectF.left;
                this.mGIFViewLayoutParams.y = (int)rectF.top;
                this.mGIFViewLayoutParams.width = (int)rectF.width();
                this.mGIFViewLayoutParams.height = (int)rectF.height();
            }
            if (USE_GIFVIEW_DRAW_ANDROID && bl) {
                if (bl2 && n == 8) {
                    this.getGIFView().setVisibility(4);
                } else if (!bl2 && n == 4) {
                    this.getGIFView().setVisibility(8);
                } else if (bl2) {
                    this.getGIFView().requestLayout();
                }
            } else if (bl2) {
                this.getGIFView().layout(0, 0, (int)rectF.width(), (int)rectF.height());
            }
            return bl2;
        }
        return false;
    }

    public void setComponentBounds(float f2, float f3, float f4, float f5, float f6) {
        super.setComponentBounds(f2, f3, f4, f5, f6);
        if (USE_GIFVIEW_DRAW_ANDROID) {
            this.requestUpdateGIFViewLayout();
        }
    }

    public native void nativeOnClick();

    public native void nativeOnPlay();

    public native void nativeOnPause();

    public native void nativeOnStop();

    public native void nativeOnFinish();

    public native void nativeSetLastPosition(int var1);

    public native void nativeSetIsPlaying(boolean var1);

    private native boolean nativeIsPlaying();

    public native boolean nativeIsFullScreen();

    private native boolean nativeSetControllerVisible(boolean var1);

    private native void nativeSetIsGif();

    public boolean isNativePlaying() {
        return this.nativeIsPlaying();
    }

    private void setControllerVisible(boolean bl) {
        this.mController.setControllerVisible(bl);
    }

    public void initControllerVisible() {
        if (this.getMediaPlayerController() != null) {
            if (this.isComponentControllerVisible()) {
                this.getMediaPlayerController().setVisibility(0);
            } else {
                if (this.getMediaPlayerController().isShowing()) {
                    this.getMediaPlayerController().requestToggleController();
                }
                this.getMediaPlayerController().setVisibility(8);
            }
        }
    }

    public boolean isComponentControllerVisible() {
        return this.isControllerVisible();
    }

    protected void setComponentGravity(int n, boolean bl) {
        boolean bl2 = this.isReverseTextToken(this.getComponentGravity());
        this.setComponentTextGravity(n);
        boolean bl3 = this.isReverseTextToken(this.getComponentGravity());
        if (bl2 != bl3) {
            this.m_text_tokens = this.getTextToken(this.m_text, bl3);
        }
        this.setIsEform(bl);
    }

    protected void setComponentText(String string) {
        this.m_text = string;
        this.m_text_tokens = this.getTextToken(this.m_text, this.isReverseTextToken(this.getComponentGravity()));
    }

    private void setSource(String string) {
        this.mSource = string;
    }

    private void setLastPosition(int n) {
        this.mLastPosition = n;
    }

    private void updateVideoPlayerArea(Rect rect) {
        if (this.getPageView() != null) {
            Rect rect2 = this.getPageView().getCompClip(this);
            boolean bl = true;
            boolean bl2 = false;
            if (rect2 == null && rect != null || rect2 != null && rect != null && !rect2.equals((Object)rect)) {
                this.mSavedArea.set(rect);
                bl2 = !this.mSelfArea.isEmpty() && !this.mSavedArea.isEmpty() && Rect.intersects((Rect)this.mSelfArea, (Rect)this.mSavedArea);
            } else if (rect2 != null && rect == null) {
                this.getPageView().setCompClip(this, null);
            } else {
                bl = false;
            }
            if (bl) {
                this.getPageView().setCompClip(this, bl2 ? this.mSavedArea : null);
            }
        }
    }

    private boolean calcVideoPlayerArea(View view, Rect rect) {
        boolean bl = false;
        if (this.getMediaPlayerView() != null) {
            this.mSelfArea.set(0, 0, this.getWidth(), this.getHeight());
            if (rect != null && !this.mSelfArea.isEmpty() && !rect.isEmpty() && Rect.intersects((Rect)this.mSelfArea, (Rect)rect)) {
                if (view.getLayoutParams().width != rect.width() || view.getLayoutParams().height != rect.height()) {
                    this.updateVideoSize();
                    view.getLayoutParams().width = rect.width();
                    view.getLayoutParams().height = rect.height();
                    bl = true;
                }
                if (((AbsoluteLayout.LayoutParams)view.getLayoutParams()).x != rect.left || ((AbsoluteLayout.LayoutParams)view.getLayoutParams()).y != rect.top) {
                    ((AbsoluteLayout.LayoutParams)view.getLayoutParams()).x = rect.left;
                    ((AbsoluteLayout.LayoutParams)view.getLayoutParams()).y = rect.top;
                    bl = true;
                }
            } else if (this.getMediaPlayerView().getLayoutParams().width != 0 && ((AbsoluteLayout.LayoutParams)view.getLayoutParams()).x != -10000) {
                this.getMediaPlayerView().getLayoutParams().width = 0;
                this.getMediaPlayerView().getLayoutParams().height = 0;
                ((AbsoluteLayout.LayoutParams)view.getLayoutParams()).x = -10000;
                ((AbsoluteLayout.LayoutParams)view.getLayoutParams()).y = -10000;
                bl = true;
            }
        }
        if (bl) {
            if (this.getMediaPlayerView().getLayoutParams().width == 0) {
                this.getVideoHandler().sendEmptyMessage(4);
            }
            this.getVideoHandler().sendMessage(this.getVideoHandler().obtainMessage(5, view));
        }
        return !rect.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeVideoPlayer() {
        if (this.getMediaPlayerView() != null && this.getMediaPlayerView().getParent() != null) {
            this.getVideoHandler().stop();
            this.getVideoHandler().removeMessages(1);
            this.getVideoHandler().removeMessages(2);
            Object object = ICVideoPlayerWnd$VideoPlayerHandler.access$000(this.mVideoHandler);
            synchronized (object) {
                if (this.mContentView.getParent() != null) {
                    ((ViewGroup)this.mContentView.getParent()).removeView(this.mContentView);
                }
                this.exit();
                this.mVideoHandler = null;
                ViewGroup viewGroup = (ViewGroup)this.getMediaPlayerView().getParent();
                viewGroup.removeView(this.getMediaPlayerView());
            }
        }
        this.setMediaPlayerView(null);
        this.mVideoSurface = null;
        this.mContentView = null;
        this.mLoadingView = null;
        this.mMediaPlayerController = null;
        this.mPlaySource = null;
        this.mLastHolder = null;
        if (this.getPageView() != null) {
            this.updateVideoPlayerArea(null);
            this.getPageView().setFullScreenComp(this, false);
        }
    }

    public boolean initVideoPlayer() {
        this.removeVideoPlayer();
        this.mVideoHandler = new ICVideoPlayerWnd$VideoPlayerHandler(this);
        this.setMediaPlayerView(ICVideoPlayerWnd.getVideoView(this.getContext()));
        this.addView(this.getMediaPlayerView(), (ViewGroup.LayoutParams)new AbsoluteLayout.LayoutParams(0, 0, 0, 0));
        this.mVideoSurface = (ResizeSurfaceView)this.getMediaPlayerView().findViewById(585732);
        this.setSurfaceColorChange(false, false);
        this.mContentView = this.getMediaPlayerView().findViewById(585730);
        this.mContentView.setBackgroundColor(-16777216);
        this.mLoadingView = this.getMediaPlayerView().findViewById(585733);
        this.mLoadingView.setVisibility(0);
        SurfaceHolder surfaceHolder = this.mVideoSurface.getHolder();
        surfaceHolder.addCallback((SurfaceHolder.Callback)this);
        this.mMediaPlayer = new MediaPlayer();
        this.mMediaPlayer.setOnVideoSizeChangedListener((MediaPlayer.OnVideoSizeChangedListener)this);
        this.mMediaPlayer.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
        this.mMediaPlayer.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
        this.mMediaPlayer.setAudioStreamType(3);
        this.mMediaPlayer.setOnErrorListener((MediaPlayer.OnErrorListener)this);
        this.mMediaPlayerController = new VideoControllerView$Builder((Activity)this.getContext(), this).withVideoSurfaceView(this.mVideoSurface).build((ViewGroup)((FrameLayout)this.getMediaPlayerView().findViewById(585731)));
        this.initControllerVisible();
        this.mContentView.setOnTouchListener((View.OnTouchListener)this.getMediaPlayerController());
        this.mVideoBufferPercent = 0;
        this.mPlaySource = this.mSource;
        this.setMediaPrepare(false);
        this.mIsError = false;
        boolean bl = false;
        if (this.nativeIsFullScreen()) {
            this.setFullScreenMode();
        }
        if (this.mPlaySource != null) {
            try {
                String string = this.mPlaySource.toLowerCase();
                if (string.startsWith("res://")) {
                    AssetFileDescriptor assetFileDescriptor = this.getContext().getAssets().openFd(this.mPlaySource.substring(6));
                    this.mMediaPlayer.setDataSource(assetFileDescriptor.getFileDescriptor(), assetFileDescriptor.getStartOffset(), assetFileDescriptor.getLength());
                } else if (string.startsWith("file://")) {
                    this.mMediaPlayer.setDataSource(this.mPlaySource.substring(7));
                } else {
                    this.mMediaPlayer.setDataSource(this.mPlaySource);
                }
                this.mMediaPlayer.prepareAsync();
                this.setMediaPrepare(true);
                bl = true;
            }
            catch (Exception exception) {
                this.onError();
                exception.printStackTrace();
            }
        }
        return bl;
    }

    public void onClick() {
        this.updateHighlightRect();
        this.mController.OnClick();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void realDraw(Canvas canvas, float f2, float f3, float f4, float f5, float f6, int n, Typeface typeface) {
        if (this.mIsGIF) {
            GifImageView gifImageView = this.getGIFView();
            if (gifImageView != null) {
                GifImageView gifImageView2 = gifImageView;
                synchronized (gifImageView2) {
                    this.updateGIFViewLayout(false);
                    if (gifImageView.getAlpha() > 0.0f) {
                        canvas.save();
                        canvas.clipRect(f2, f3, f4, f5);
                        canvas.translate(f2, f3);
                        gifImageView.draw(canvas);
                        canvas.restore();
                    }
                }
            }
        } else {
            if (!this.isInputRender()) {
                ICVideoPlayerWnd.drawButton(this, canvas, f2, f3, f4, f5, f6, n, typeface, this.realDraw_paint, this.isComponentTransparent(), false, this.m_text_tokens, this.getComponentTextColor(), this.isTextBold(), this.getComponentGravity());
            } else {
                this.setComponentBounds(f2, f3, f4, f5, f6);
            }
            boolean bl = false;
            if (this.getMediaPlayerView() != null && !this.isFullScreen()) {
                this.mVideoArea.set((int)this.m_left, (int)this.m_top, (int)this.m_right, (int)this.m_bottom);
                bl = this.calcVideoPlayerArea(this.getMediaPlayerView(), this.mVideoArea);
            }
            this.updateVideoPlayerArea(bl ? this.mVideoArea : null);
        }
        if (this.isHighlightMode() && !this._isDispose) {
            this.drawHighlightRect(canvas, f2, f3, f4, f5, f6, n, typeface);
        }
    }

    protected void Open() {
        super.Open();
        if (this.isOpenKeyboard()) {
            this.removeKeyboardByDummy();
            this.beginIgnoreScrollEvent();
            this.postDelayed(new ICVideoPlayerWnd$1(this), 200L);
        } else {
            this.onClick();
        }
    }

    private void updateVideoSize() {
        if (this.getVideoHandler() != null) {
            this.getVideoHandler().removeMessages(1);
            this.getVideoHandler().sendEmptyMessageDelayed(1, 100L);
        }
    }

    public void onVideoSizeChanged(MediaPlayer mediaPlayer, int n, int n2) {
        this.mVideoWidth = mediaPlayer.getVideoWidth();
        this.mVideoHeight = mediaPlayer.getVideoHeight();
        this.updateVideoSize();
    }

    public void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        this.updateVideoSize();
    }

    public void surfaceChanged(SurfaceHolder surfaceHolder, int n, int n2, int n3) {
    }

    public void surfaceCreated(SurfaceHolder surfaceHolder) {
        try {
            if (this.mMediaPlayer != null) {
                this.mLastHolder = surfaceHolder;
                if (!this.isMediaPrepare()) {
                    this.mMediaPlayer.setDisplay(this.mLastHolder);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
        this.mLastHolder = null;
        if (!this.isMediaPrepare()) {
            this.mMediaPlayer.setDisplay(this.mLastHolder);
        }
    }

    private void onError() {
        this.nativeSetIsPlaying(false);
        this.setMediaPrepare(false);
        this.mIsError = true;
        this.mLoadingView.setVisibility(8);
        this.getMediaPlayerController().setEnabled(false);
    }

    public boolean onError(MediaPlayer mediaPlayer, int n, int n2) {
        Log.e((String)"OZViewer", (String)String.format("VideoPlayer: MediaPlayer OnError(what=%d, extra=%d)", n, n2));
        this.onError();
        return true;
    }

    private void setSurfaceColorChange(boolean bl) {
        this.setSurfaceColorChange(bl, true);
    }

    private void setSurfaceColorChange(boolean bl, boolean bl2) {
        ResizeSurfaceView resizeSurfaceView = this.mVideoSurface;
        ICVideoPlayerWnd$2 iCVideoPlayerWnd$2 = new ICVideoPlayerWnd$2(this, (View)resizeSurfaceView, bl);
        if (bl2) {
            this.postDelayed(iCVideoPlayerWnd$2, 200L);
        } else {
            iCVideoPlayerWnd$2.run();
        }
    }

    public void onPrepared(MediaPlayer mediaPlayer) {
        this.setMediaPrepare(false);
        this.mMediaPlayer.setDisplay(this.mLastHolder);
        this.mLoadingView.setVisibility(8);
        this.startFromScript();
        if (this.mLastPosition > 0) {
            this.seekTo(this.mLastPosition);
        }
    }

    public void onBufferingUpdate(MediaPlayer mediaPlayer, int n) {
        this.mVideoBufferPercent = n;
    }

    public int getBufferPercentage() {
        if (this.mMediaPlayer != null) {
            return this.mVideoBufferPercent;
        }
        return 0;
    }

    public int getCurrentPosition() {
        if (this.mMediaPlayer != null && !this.isMediaPrepare()) {
            return this.mMediaPlayer.getCurrentPosition();
        }
        return 0;
    }

    public int getDuration() {
        if (this.mMediaPlayer != null && !this.isMediaPrepare()) {
            return this.mMediaPlayer.getDuration();
        }
        return 0;
    }

    public boolean isPlaying() {
        if (this.mMediaPlayer != null) {
            return this.mMediaPlayer.isPlaying();
        }
        return false;
    }

    public boolean isComplete() {
        return this.mIsComplete;
    }

    private void pauseFromScript() {
        this.mController.Pause();
    }

    public void pause() {
        if (this.isPlaying()) {
            this.nativeSetIsPlaying(false);
            this.mMediaPlayer.pause();
            this.nativeOnPause();
        }
    }

    public void seekTo(int n) {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.seekTo(n);
        }
    }

    private void startFromScript() {
        this.mController.Start();
    }

    public void start() {
        if (!this.isPlaying()) {
            this.nativeSetIsPlaying(true);
            this.setSurfaceColorChange(true);
            this.mMediaPlayer.start();
            this.mIsComplete = false;
            this.nativeOnPlay();
        }
    }

    private void stopFromScript() {
        this.mController.Stop();
    }

    public void stop() {
        if (this.mMediaPlayer != null && this.isPlaying()) {
            this.nativeSetIsPlaying(false);
            this.mMediaPlayer.seekTo(0);
            this.mMediaPlayer.pause();
            this.mIsComplete = false;
            this.nativeOnStop();
        } else if (this.mMediaPlayer != null) {
            this.mMediaPlayer.seekTo(0);
            this.mIsComplete = false;
        }
    }

    public boolean isPrepare() {
        return this.isMediaPrepare();
    }

    public boolean isFullScreen() {
        if (this.getMediaPlayerView() != null && this.mContentView != null) {
            return this.getMediaPlayerView() != this.mContentView.getParent();
        }
        return false;
    }

    private void setWindowMode() {
        ViewGroup viewGroup = (ViewGroup)this.mContentView.getParent();
        if (viewGroup != null) {
            viewGroup.removeView(this.mContentView);
        }
        this.mVideoSurface.setZOrderMediaOverlay(false);
        if (Build.VERSION.SDK_INT < 16) {
            ((Activity)this.getContext()).getWindow().clearFlags(1024);
        } else {
            View view = ((Activity)this.getContext()).getWindow().getDecorView();
            view.setSystemUiVisibility(this.mBackupUI);
            ActionBar actionBar = ((Activity)this.getContext()).getActionBar();
            if (actionBar != null && this.mBackupActionbar) {
                actionBar.show();
            }
        }
        ((ViewGroup)this.getMediaPlayerView()).addView(this.mContentView, new ViewGroup.LayoutParams(-1, -1));
        this.getPageView().setFullScreenComp(this, false);
    }

    private void setFullScreenMode() {
        View view = this.mContentView;
        if (view != null) {
            View view2 = view.getRootView();
            ViewGroup viewGroup = (ViewGroup)view.getParent();
            if (viewGroup != null) {
                viewGroup.removeView(view);
            }
            this.mVideoSurface.setZOrderMediaOverlay(true);
            if (Build.VERSION.SDK_INT < 16) {
                ((Activity)this.getContext()).getWindow().setFlags(1024, 1024);
            } else {
                View view3 = ((Activity)this.getContext()).getWindow().getDecorView();
                int n = 4102;
                this.mBackupUI = view3.getSystemUiVisibility();
                view3.setSystemUiVisibility(n);
                ActionBar actionBar = ((Activity)this.getContext()).getActionBar();
                if (actionBar != null) {
                    this.mBackupActionbar = actionBar.isShowing();
                    actionBar.hide();
                } else {
                    this.mBackupActionbar = false;
                }
            }
            ((ViewGroup)view2).addView(view, new ViewGroup.LayoutParams(-1, -1));
            this.getPageView().setFullScreenComp(this, true);
        }
    }

    private void setFullScreen(boolean bl) {
        this.mController.setFullScreen(bl);
    }

    public void toggleFullScreen() {
        if (this.getVideoHandler() != null) {
            if (!this.getVideoHandler().hasMessages(2)) {
                this.getVideoHandler().sendEmptyMessageDelayed(2, 50L);
            } else {
                Log.e((String)"OZViewer", (String)"VideoPlayer: setFullScreen ignored because this method is already called");
            }
        }
    }

    public void exit() {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.reset();
            this.mMediaPlayer.release();
            this.mMediaPlayer = null;
        }
    }

    public void onCompletion(MediaPlayer mediaPlayer) {
        this.nativeSetIsPlaying(false);
        this.setSurfaceColorChange(false);
        this.mIsComplete = true;
        this.getMediaPlayerController().togglePausePlay();
        if (this.isFullScreen()) {
            if (!this.isComponentControllerVisible()) {
                this.nativeSetControllerVisible(true);
                this.setControllerVisible(true);
            }
            if (!this.getMediaPlayerController().isShowing()) {
                this.getMediaPlayerController().requestToggleController();
            }
        }
        this.nativeOnFinish();
    }

    protected void closeInputComponentDialog() {
        this.setCallCloseFromOnClick(true);
        if (!this.isMediaPrepare() && !this.mIsError) {
            int n = 0;
            if (!this.isComplete() && this.mPlaySource != null && this.mPlaySource.equals(this.mSource)) {
                n = this.getCurrentPosition();
            }
            this.setLastPosition(n);
            this.nativeSetLastPosition(n);
        }
        if (this.getPageView().getVideoPlayingComponent() == this) {
            this.getPageView().setVideoPlayingComponent(null);
        }
        this.removeVideoPlayer();
        this.nativeSetIsPlaying(false);
        this._closeDelay = this.IsFlushInputControls() ? 0 : 50;
        this.setStatus(0);
        this.onCloseInputComponent(true);
        this.clearHighlightRect();
    }

    public void requestClose() {
        this.closeInputComponentDialog();
    }

    private static View getVideoView(Context context) {
        RelativeLayout relativeLayout = new RelativeLayout(context);
        relativeLayout.setId(585729);
        relativeLayout.setBackgroundColor(-16777216);
        FrameLayout frameLayout = new FrameLayout(context);
        frameLayout.setId(585730);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -1);
        relativeLayout.addView((View)frameLayout, (ViewGroup.LayoutParams)layoutParams);
        FrameLayout frameLayout2 = new FrameLayout(context);
        frameLayout2.setId(585731);
        FrameLayout.LayoutParams layoutParams2 = new FrameLayout.LayoutParams(-1, -2, 17);
        frameLayout.addView((View)frameLayout2, (ViewGroup.LayoutParams)layoutParams2);
        ResizeSurfaceView resizeSurfaceView = new ResizeSurfaceView(context);
        resizeSurfaceView.setId(585732);
        layoutParams2 = new FrameLayout.LayoutParams(-1, OZStorage.DpToPx(context, 250.0f, true), 17);
        frameLayout2.addView((View)resizeSurfaceView, (ViewGroup.LayoutParams)layoutParams2);
        ProgressBar progressBar = new ProgressBar(context, null, 16843401);
        progressBar.setId(585733);
        layoutParams2 = new FrameLayout.LayoutParams(OZStorage.DpToPx(context, 40.0f, true), OZStorage.DpToPx(context, 40.0f, true), 17);
        frameLayout2.addView((View)progressBar, (ViewGroup.LayoutParams)layoutParams2);
        return relativeLayout;
    }

    public VideoControllerView getMediaPlayerController() {
        return this.mMediaPlayerController;
    }

    public ICVideoPlayerWnd$VideoPlayerHandler getVideoHandler() {
        return this.mVideoHandler;
    }

    public void setIsFullScreen(boolean bl) {
        this.mIsFullScreen = bl;
    }

    public boolean isControllerVisible() {
        return this.mIsControllerVisible;
    }

    public void setIsControllerVisible(boolean bl) {
        this.mIsControllerVisible = bl;
    }

    public boolean isMediaPrepare() {
        return this.mIsPrepare;
    }

    public void setMediaPrepare(boolean bl) {
        this.mIsPrepare = bl;
    }

    public boolean isCallCloseFromOnClick() {
        return this.mCallCloseFromOnClick;
    }

    public void setCallCloseFromOnClick(boolean bl) {
        this.mCallCloseFromOnClick = bl;
    }

    public View getMediaPlayerView() {
        return this.mVideo;
    }

    public void setMediaPlayerView(View view) {
        this.mVideo = view;
    }

    public GifImageView getGIFView() {
        return this.mGIFView;
    }

    public void setGIFView(GifImageView gifImageView) {
        this.mGIFView = gifImageView;
    }

    public boolean isFindable() {
        return !this.mIsGIF;
    }

    static /* synthetic */ View access$100(ICVideoPlayerWnd iCVideoPlayerWnd) {
        return iCVideoPlayerWnd.mContentView;
    }

    static /* synthetic */ ResizeSurfaceView access$200(ICVideoPlayerWnd iCVideoPlayerWnd) {
        return iCVideoPlayerWnd.mVideoSurface;
    }

    static /* synthetic */ int access$300(ICVideoPlayerWnd iCVideoPlayerWnd) {
        return iCVideoPlayerWnd.mVideoWidth;
    }

    static /* synthetic */ int access$400(ICVideoPlayerWnd iCVideoPlayerWnd) {
        return iCVideoPlayerWnd.mVideoHeight;
    }

    static /* synthetic */ void access$500(ICVideoPlayerWnd iCVideoPlayerWnd, boolean bl, boolean bl2) {
        iCVideoPlayerWnd.setSurfaceColorChange(bl, bl2);
    }

    static /* synthetic */ void access$600(ICVideoPlayerWnd iCVideoPlayerWnd) {
        iCVideoPlayerWnd.setFullScreenMode();
    }

    static /* synthetic */ void access$700(ICVideoPlayerWnd iCVideoPlayerWnd) {
        iCVideoPlayerWnd.setWindowMode();
    }

    static /* synthetic */ void access$800(ICVideoPlayerWnd iCVideoPlayerWnd) {
        iCVideoPlayerWnd.updateVideoSize();
    }

    static /* synthetic */ void access$900(ICVideoPlayerWnd iCVideoPlayerWnd) {
        iCVideoPlayerWnd.updateGIFViewLayout();
    }
}

