/*
 * Decompiled with CFR 0.152.
 */
package oz.client.shape.ui;

import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.RelativeLayout;
import android.widget.TextView;
import java.io.FileOutputStream;
import java.io.InputStream;
import oz.client.shape.ui.OZAttachmentFileManager;
import oz.client.shape.ui.OZAttachmentFileManager$FileInfo;
import oz.client.shape.ui.OZAttachmentListAdapter$1;
import oz.client.shape.ui.OZAttachmentListAdapter$10;
import oz.client.shape.ui.OZAttachmentListAdapter$2;
import oz.client.shape.ui.OZAttachmentListAdapter$3;
import oz.client.shape.ui.OZAttachmentListAdapter$4;
import oz.client.shape.ui.OZAttachmentListAdapter$5;
import oz.client.shape.ui.OZAttachmentListAdapter$6;
import oz.client.shape.ui.OZAttachmentListAdapter$7;
import oz.client.shape.ui.OZAttachmentListAdapter$8;
import oz.client.shape.ui.OZAttachmentListAdapter$9;
import oz.client.shape.ui.OZAttachmentMenuListener;
import oz.client.shape.ui.OZFileListView;
import oz.resource.OZAndroidResource;
import oz.util.android.FileProviderSupport;
import oz.viewer.ui.df.DFStyleManager;
import oz.viewer.ui.df.DFUtils;

public class OZAttachmentListAdapter
extends BaseAdapter {
    private static int ATTACHMENT_ITEM_VIEW_FILENAME = 0x10000001;
    private static int ATTACHMENT_ITEM_VIEW_FILESIZE = 0x10000002;
    private static int ATTACHMENT_ITEM_VIEW_HAMBURGER = 0x10000003;
    public static int ATTACHMENT_SUBMENU_BUTTON_HEIGHT = 60;
    public static int ATTACHMENT_SUBMENU_FONT_SIZE = 18;
    private OZAttachmentFileManager mFileManager;
    Context mContext = null;
    private View mParent;
    private OZFileListView mListView;
    private FrameLayout mDialogRoot;
    private int currentMode = -1;
    public int HEADER_SIZE;
    public int mMaxSize;
    public boolean mIsShowPageAfterAttach;
    OZAttachmentMenuListener mListener;
    OZAttachmentListAdapter _This;
    public boolean mIsDF;
    public boolean mIsShow;
    int titleBackGroundColor = Color.rgb((int)242, (int)242, (int)242);
    int titleFontColor = Color.rgb((int)0, (int)0, (int)0);
    int attachTextColor = Color.rgb((int)0, (int)112, (int)192);
    int fontColor = Color.rgb((int)0, (int)0, (int)0);
    int separatorColor = Color.rgb((int)166, (int)166, (int)166);
    int fileSizeColor = -3355444;
    private static final String ITEMVIEW_TAG = "item view";

    public void setCurrentMode(int n) {
        this.currentMode = n;
    }

    public int getCurrentMode() {
        return this.currentMode;
    }

    public int getCount() {
        if (this.mFileManager != null) {
            return this.mFileManager.getFileCount();
        }
        return 0;
    }

    public Object getItem(int n) {
        if (this.mFileManager != null && this.mFileManager.getFileCount() >= n + 1) {
            return this.mFileManager.getFile(n);
        }
        return null;
    }

    public long getItemId(int n) {
        return n;
    }

    public View getView(int n, View view, ViewGroup viewGroup) {
        if (view == null || this.mFileManager.getFileCount() == n + 1) {
            view = this.makeListItem(n);
        } else {
            this.updateView(view, n);
        }
        return view;
    }

    private void updateView(View view, int n) {
        TextView textView = (TextView)view.findViewById(ATTACHMENT_ITEM_VIEW_FILENAME);
        TextView textView2 = (TextView)view.findViewById(ATTACHMENT_ITEM_VIEW_FILESIZE);
        if (textView != null && textView2 != null) {
            String string;
            OZAttachmentFileManager$FileInfo oZAttachmentFileManager$FileInfo = (OZAttachmentFileManager$FileInfo)this.getItem(n);
            if (oZAttachmentFileManager$FileInfo != null) {
                string = this.getFileNameByPath(oZAttachmentFileManager$FileInfo.fileName);
                textView.setText((CharSequence)string);
                textView.setMaxLines(2);
                textView.setEllipsize(TextUtils.TruncateAt.END);
                textView2.setText((CharSequence)DFUtils.calcFileSize(oZAttachmentFileManager$FileInfo.fileSize));
            }
            view.setTag((Object)n);
            string = (ImageView)view.findViewById(ATTACHMENT_ITEM_VIEW_HAMBURGER);
            if (string != null) {
                string.setTag((Object)n);
            }
        }
    }

    public OZAttachmentListAdapter(Context context, FrameLayout frameLayout, View view, String string, int n, boolean bl, boolean bl2, boolean bl3) {
        this.mContext = context;
        this.mParent = view;
        this.mFileManager = new OZAttachmentFileManager();
        this.mFileManager.update(string);
        this.mDialogRoot = frameLayout;
        this.mMaxSize = n;
        this.HEADER_SIZE = DFUtils.toDP(context, 50.0f);
        this.mIsShowPageAfterAttach = bl;
        this.mIsDF = bl2;
        this.mIsShow = bl3;
        this._This = this;
        if (this.mIsDF) {
            DFStyleManager dFStyleManager = DFStyleManager.getInstance();
            this.titleBackGroundColor = DFUtils.getRGB((Integer)dFStyleManager.getStyle(DFStyleManager.POPUP_ATTACHMENT_TITLE_BACKGROUND_COLOR));
            this.titleFontColor = DFUtils.getRGB((Integer)dFStyleManager.getStyle(DFStyleManager.POPUP_ATTACHMENT_TITLE_FONT_COLOR));
            this.attachTextColor = DFUtils.getRGB((Integer)dFStyleManager.getStyle(DFStyleManager.POPUP_ATTACHMENT_ATTACH_TEXT_COLOR));
            this.fontColor = DFUtils.getRGB((Integer)dFStyleManager.getStyle(DFStyleManager.POPUP_ATTACHMENT_FONT_COLOR));
            this.separatorColor = DFUtils.getRGB((Integer)dFStyleManager.getStyle(DFStyleManager.POPUP_ATTACHMENT_SEPARATOR_COLOR));
            this.fileSizeColor = DFUtils.getRGB((Integer)dFStyleManager.getStyle(DFStyleManager.POPUP_ATTACHMENT_FILE_SIZE_COLOR));
        }
    }

    public void setOZAttachmentMenuListener(OZAttachmentMenuListener oZAttachmentMenuListener) {
        this.mListener = oZAttachmentMenuListener;
    }

    public OZAttachmentFileManager getFileManager() {
        return this.mFileManager;
    }

    public void update(String string) {
        this.mFileManager.update(string);
        this.notifyDataSetChanged();
    }

    private String getFileNameByPath(String string) {
        int n = string.lastIndexOf("/");
        if (n >= 0 && n < string.length()) {
            string = string.substring(n + 1);
        }
        return string;
    }

    public View makeListItem(int n) {
        String string;
        int n2 = 0;
        n2 = this.mParent == null ? this.mParent.getWidth() : this.mDialogRoot.getWidth();
        int n3 = DFUtils.toDP(this.mContext, 40.0f);
        int n4 = n2 - n3;
        RelativeLayout relativeLayout = new RelativeLayout(this.mContext);
        LinearLayout linearLayout = new LinearLayout(this.mContext);
        linearLayout.setOrientation(0);
        linearLayout.setGravity(16);
        linearLayout.setPadding(0, 15, n3 + 15, 15);
        LinearLayout linearLayout2 = new LinearLayout(this.mContext);
        linearLayout2.setOrientation(1);
        linearLayout2.setGravity(3);
        OZAttachmentFileManager$FileInfo oZAttachmentFileManager$FileInfo = (OZAttachmentFileManager$FileInfo)this.getItem(n);
        TextView textView = new TextView(this.mContext);
        textView.setId(ATTACHMENT_ITEM_VIEW_FILENAME);
        textView.setTextColor(this.fontColor);
        textView.setTextSize(1, 18.0f);
        textView.setMaxLines(2);
        textView.setEllipsize(TextUtils.TruncateAt.END);
        textView.setPadding(30, 0, 0, 0);
        TextView textView2 = new TextView(this.mContext);
        textView2.setId(ATTACHMENT_ITEM_VIEW_FILESIZE);
        textView2.setTextColor(this.fileSizeColor);
        textView2.setTextSize(1, 12.0f);
        textView2.setPadding(30, 0, 0, 0);
        if (oZAttachmentFileManager$FileInfo != null) {
            string = this.getFileNameByPath(oZAttachmentFileManager$FileInfo.fileName);
            textView.setText((CharSequence)string);
            textView2.setText((CharSequence)DFUtils.calcFileSize(oZAttachmentFileManager$FileInfo.fileSize));
        }
        linearLayout2.addView((View)textView);
        linearLayout2.addView((View)textView2);
        linearLayout.addView((View)linearLayout2, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        relativeLayout.addView((View)linearLayout);
        string = new LinearLayout(this.mContext);
        string.setGravity(5);
        ImageView imageView = new ImageView(this.mContext);
        Drawable drawable2 = null;
        try {
            drawable2 = this.mIsDF ? DFUtils.getMakeDrawable(this.mContext, DFUtils.getImageDrawable(this.mContext, 43), DFStyleManager.POPUP_ATTACHMENT_IS_USE_GRABBER_ICON_COLOR, DFStyleManager.POPUP_ATTACHMENT_GRABBER_ICON_COLOR, DFStyleManager.POPUP_ATTACHMENT_GRABBER_ICON_IMAGE) : DFUtils.getImageDrawable(this.mContext, 43);
        }
        catch (Exception exception) {
            // empty catch block
        }
        imageView.setImageDrawable(drawable2);
        string.addView((View)imageView);
        string.setPadding(0, 0, 30, 0);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(n3, n3);
        layoutParams.addRule(11);
        layoutParams.addRule(15);
        relativeLayout.addView((View)string, (ViewGroup.LayoutParams)layoutParams);
        linearLayout.setTag((Object)n);
        relativeLayout.setTag((Object)n);
        imageView.setTag((Object)n);
        imageView.setId(ATTACHMENT_ITEM_VIEW_HAMBURGER);
        if (!this.mIsShow) {
            imageView.setVisibility(4);
        }
        return relativeLayout;
    }

    public void dropItem(int n, int n2) {
        this.moveFile(n, n2);
    }

    private void moveFile(int n, int n2) {
        this.mListener.moveFile(n, n2);
    }

    public void deleteFile(int n) {
        if (this.mListener.deleteFile(n)) {
            this.mFileManager.removeFile(n);
            this.updatePopupUI(n);
        }
    }

    public void editFile(int n, boolean bl) {
        if (this.mIsShowPageAfterAttach) {
            if (bl) {
                this.setCurrentMode(-1);
            }
            if (this.mIsDF) {
                this.mListener.editFile(n);
                return;
            }
            String string = this.mListener.getFile(n);
            int n2 = string.indexOf(",");
            String string2 = string.substring(n2 + 1);
            byte[] byArray = Base64.decode((String)string2, (int)0);
            Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length);
            this.mListener.setBitmapActivityResult(bitmap, "jpg", n);
        }
    }

    public void updatePopupUI(int n) {
        String string = this.mListener.getInfoValue();
        this.getFileManager().update(string);
        this.notifyDataSetChanged();
        this.mListView.smoothScrollToPosition(n);
        View view = this.mDialogRoot.findViewById(1000002);
        View view2 = this.mDialogRoot.findViewById(1000003);
        if (view != null && view2 != null) {
            int n2 = this.getCount();
            if (n2 == 0) {
                view.setVisibility(0);
                view2.setVisibility(4);
            } else {
                view.setVisibility(4);
                view2.setVisibility(0);
            }
        }
        String string2 = OZAndroidResource.getResource("attachment.attach_count") + " : ";
        string2 = string2 + this.getCount();
        TextView textView = (TextView)this.mDialogRoot.findViewById(1000000);
        textView.setText((CharSequence)string2);
    }

    public void downloadFile(int n) {
        if (this.mIsDF) {
            this.mListener.downloadFile(n);
            return;
        }
        String string = this.mListener.getFile(n);
        String string2 = this.mContext.getExternalFilesDir(null).getPath();
        OZAttachmentFileManager$FileInfo oZAttachmentFileManager$FileInfo = this.mFileManager.getFile(n);
        if (oZAttachmentFileManager$FileInfo != null) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(string2 + "/" + oZAttachmentFileManager$FileInfo.fileName);
                int n2 = string.indexOf(",");
                if (n2 > 0) {
                    string = string.substring(n2 + 1);
                }
                byte[] byArray = Base64.decode((String)string, (int)0);
                fileOutputStream.write(byArray);
                fileOutputStream.close();
                Intent intent = new Intent("android.intent.action.SEND");
                try {
                    Uri uri = Build.VERSION.SDK_INT >= 29 ? FileProviderSupport.getUriForFileSimplePath(this.mContext, string2 + "/" + oZAttachmentFileManager$FileInfo.fileName) : Uri.parse((String)("file://" + string2 + "/" + oZAttachmentFileManager$FileInfo.fileName));
                    intent.setDataAndType(uri, "application/octet-stream");
                    intent.putExtra("android.intent.extra.STREAM", (Parcelable)uri);
                    intent.addFlags(1);
                    this.mContext.startActivity(Intent.createChooser((Intent)intent, (CharSequence)""));
                }
                catch (Exception exception) {
                    Log.e((String)"OZViewer", (String)"Not exists FileProvider or filePaths.xml");
                    exception.printStackTrace();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void showFileItemMenu(Context context, RelativeLayout relativeLayout, int n, boolean bl) {
        LinearLayout linearLayout;
        Dialog dialog = new Dialog(context);
        dialog.setCanceledOnTouchOutside(true);
        LinearLayout linearLayout2 = new LinearLayout(context);
        linearLayout2.setOrientation(1);
        linearLayout2.setBackgroundColor(-1);
        linearLayout2.setPadding(30, 0, 30, 0);
        LinearLayout linearLayout3 = this.makeSubMenuButton(context, "resource/attachment_icon_download.png", "save.label");
        linearLayout2.addView((View)linearLayout3);
        linearLayout3.setOnClickListener((View.OnClickListener)new OZAttachmentListAdapter$1(this, n, dialog));
        linearLayout2.addView((View)this.makeSubMenuDivider(context));
        if (this.mIsShow && this.mIsShowPageAfterAttach && bl) {
            linearLayout = this.makeSubMenuButton(context, "resource/attachment_icon_edit.png", "attachment.edit");
            linearLayout2.addView((View)linearLayout);
            linearLayout.setOnClickListener((View.OnClickListener)new OZAttachmentListAdapter$2(this, n, dialog));
            linearLayout2.addView((View)this.makeSubMenuDivider(context));
        }
        if (this.mIsShow) {
            linearLayout = this.makeSubMenuButton(context, "resource/attachment_icon_delete.png", "attachment.delete");
            linearLayout2.addView((View)linearLayout);
            linearLayout.setOnClickListener((View.OnClickListener)new OZAttachmentListAdapter$3(this, n, dialog));
            linearLayout2.addView((View)this.makeSubMenuDivider(context));
        }
        this.showSubMenuWindow(context, relativeLayout, dialog, linearLayout2);
    }

    private LinearLayout makeSubMenuDivider(Context context) {
        LinearLayout linearLayout = new LinearLayout(context);
        linearLayout.setBackgroundColor(-16777216);
        linearLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, 1));
        linearLayout.setPadding(30, 0, 30, 0);
        return linearLayout;
    }

    private LinearLayout makeSubMenuButton(Context context, String string, String string2) {
        LinearLayout linearLayout = new LinearLayout(context);
        linearLayout.setMinimumHeight(DFUtils.toDP(context, ATTACHMENT_SUBMENU_BUTTON_HEIGHT));
        linearLayout.setGravity(19);
        linearLayout.setOrientation(0);
        ImageView imageView = this.makeImageView(context, string);
        int n = DFUtils.toDP(context, 40.0f);
        linearLayout.addView((View)imageView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(n, n));
        TextView textView = new TextView(context);
        textView.setGravity(19);
        textView.setText((CharSequence)OZAndroidResource.getResource(string2));
        textView.setTextColor(-16777216);
        textView.setTextSize(2, (float)ATTACHMENT_SUBMENU_FONT_SIZE);
        linearLayout.addView((View)textView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        return linearLayout;
    }

    private ImageView makeImageView(Context context, String string) {
        ImageView imageView = new ImageView(context);
        try {
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)context.getAssets().open(string));
            imageView.setImageBitmap(bitmap);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return imageView;
    }

    private void showSubMenuWindow(Context context, RelativeLayout relativeLayout, Dialog dialog, LinearLayout linearLayout) {
        linearLayout.setMinimumWidth(DFUtils.toDP(context, 220.0f));
        dialog.setContentView((View)linearLayout);
        dialog.show();
    }

    public void showSubMenuForAddFile(Context context, RelativeLayout relativeLayout) {
        Dialog dialog = new Dialog(context);
        dialog.setCanceledOnTouchOutside(true);
        LinearLayout linearLayout = new LinearLayout(context);
        linearLayout.setOrientation(1);
        linearLayout.setBackgroundColor(-1);
        linearLayout.setPadding(30, 0, 30, 0);
        LinearLayout linearLayout2 = this.makeSubMenuButton(context, "resource/attachment_icon_file.png", "file.menu.label");
        linearLayout.addView((View)linearLayout2);
        linearLayout2.setOnClickListener((View.OnClickListener)new OZAttachmentListAdapter$4(this, dialog));
        linearLayout.addView((View)this.makeSubMenuDivider(context));
        LinearLayout linearLayout3 = this.makeSubMenuButton(context, "resource/attachment_icon_camera.png", "attachment.camera");
        linearLayout.addView((View)linearLayout3);
        linearLayout3.setOnClickListener((View.OnClickListener)new OZAttachmentListAdapter$5(this, dialog));
        linearLayout.addView((View)this.makeSubMenuDivider(context));
        LinearLayout linearLayout4 = this.makeSubMenuButton(context, "resource/attachment_icon_gallery.png", "attachment.gallery");
        linearLayout.addView((View)linearLayout4);
        linearLayout4.setOnClickListener((View.OnClickListener)new OZAttachmentListAdapter$6(this, dialog));
        linearLayout.addView((View)this.makeSubMenuDivider(context));
        if (this.mIsShowPageAfterAttach) {
            LinearLayout linearLayout5 = this.makeSubMenuButton(context, "resource/attachment_icon_merge.png", "image.merge.item");
            linearLayout5.setOnClickListener((View.OnClickListener)new OZAttachmentListAdapter$7(this, dialog));
            linearLayout.addView((View)linearLayout5);
        }
        this.showSubMenuWindow(context, relativeLayout, dialog, linearLayout);
    }

    public void makeAttachmentHeader(Context context, RelativeLayout relativeLayout) {
        TextView textView;
        int n = DFUtils.toDP(context, 1.0f);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, n);
        LinearLayout linearLayout = new LinearLayout(context);
        linearLayout.setBackgroundColor(this.separatorColor);
        relativeLayout.addView((View)linearLayout, (ViewGroup.LayoutParams)layoutParams);
        LinearLayout linearLayout2 = new LinearLayout(context);
        linearLayout2.setGravity(16);
        linearLayout2.setOrientation(0);
        linearLayout2.setBackgroundColor(this.titleBackGroundColor);
        RelativeLayout.LayoutParams layoutParams2 = new RelativeLayout.LayoutParams(-1, this.HEADER_SIZE);
        layoutParams2.addRule(10, 1);
        layoutParams2.topMargin = n;
        relativeLayout.addView((View)linearLayout2, (ViewGroup.LayoutParams)layoutParams2);
        LinearLayout linearLayout3 = new LinearLayout(context);
        LinearLayout linearLayout4 = new LinearLayout(context);
        linearLayout4.setGravity(5);
        TextView textView2 = new TextView(context);
        textView2.setPadding(30, 0, 0, 0);
        textView2.setId(1000000);
        textView2.setTextColor(this.titleFontColor);
        linearLayout3.addView((View)textView2);
        if (this.mIsShow) {
            textView = new TextView(context);
            textView.setText((CharSequence)OZAndroidResource.getResource("attachment.add"));
            textView.setPaintFlags(textView.getPaintFlags() | 0x20);
            textView.setTextColor(this.attachTextColor);
            textView.setPadding(0, 0, 30, 0);
            textView.setId(1000001);
            textView.setOnClickListener((View.OnClickListener)new OZAttachmentListAdapter$8(this, context, relativeLayout));
            linearLayout4.addView((View)textView);
        }
        linearLayout2.addView((View)linearLayout3, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2, 4.0f));
        linearLayout2.addView((View)linearLayout4, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2, 1.0f));
        linearLayout2.setWeightSum(5.0f);
        linearLayout2.setMinimumHeight(this.HEADER_SIZE);
        textView = new LinearLayout(context);
        textView.setBackgroundColor(this.separatorColor);
        RelativeLayout.LayoutParams layoutParams3 = new RelativeLayout.LayoutParams(-1, n);
        layoutParams3.topMargin = this.HEADER_SIZE - n;
        relativeLayout.addView((View)textView, (ViewGroup.LayoutParams)layoutParams3);
    }

    public void makeAttachmentContent(Context context, RelativeLayout relativeLayout, OZFileListView oZFileListView) {
        this.mListView = oZFileListView;
        LinearLayout linearLayout = new LinearLayout(context);
        linearLayout.setOrientation(1);
        linearLayout.setId(1000002);
        ImageView imageView = this.makeImageView(context, "resource/attachment_icon_addfile.png");
        TextView textView = new TextView(context);
        textView.setText((CharSequence)OZAndroidResource.getResource("attachment.empty_msg"));
        textView.setPadding(0, 0, 0, 0);
        textView.setTextAlignment(4);
        textView.setTextColor(-16777216);
        textView.setTextSize(2, 18.0f);
        int n = DFUtils.toDP(context, 180.0f);
        int n2 = DFUtils.toDP(context, 50.0f);
        linearLayout.addView((View)imageView, new ViewGroup.LayoutParams(-1, n - n2));
        linearLayout.addView((View)textView, new ViewGroup.LayoutParams(-1, n2));
        imageView.setOnTouchListener((View.OnTouchListener)new OZAttachmentListAdapter$9(this, context, relativeLayout));
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(n, n);
        layoutParams.addRule(13);
        relativeLayout.addView((View)linearLayout, (ViewGroup.LayoutParams)layoutParams);
        LinearLayout linearLayout2 = new LinearLayout(context);
        linearLayout2.setOrientation(1);
        linearLayout2.setGravity(16);
        linearLayout2.setBackgroundColor(-1);
        linearLayout2.setId(1000003);
        oZFileListView.setAdapter((ListAdapter)this);
        oZFileListView.setScrollingCacheEnabled(false);
        oZFileListView.setDivider((Drawable)new ColorDrawable(this.separatorColor));
        oZFileListView.setDividerHeight(DFUtils.toDP(context, 1.0f));
        oZFileListView.setClickable(true);
        oZFileListView.setOnItemClickListener(new OZAttachmentListAdapter$10(this, context, relativeLayout));
        linearLayout2.addView((View)oZFileListView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        RelativeLayout.LayoutParams layoutParams2 = new RelativeLayout.LayoutParams(-1, -1);
        layoutParams2.addRule(10);
        layoutParams2.topMargin = this.HEADER_SIZE;
        linearLayout.setVisibility(4);
        linearLayout2.setVisibility(4);
        relativeLayout.addView((View)linearLayout2, (ViewGroup.LayoutParams)layoutParams2);
    }
}

