/*
 * Decompiled with CFR 0.152.
 */
package oz.client.shape.ui;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.widget.FrameLayout;
import oz.client.shape.ui.OZCanvasView$OZGestureListener;
import oz.client.shape.ui.OZCanvasView$OZScaleListener;

public class OZCanvasView
extends FrameLayout {
    private GestureDetector mGestureDetector;
    private ScaleGestureDetector mScaleDetector;
    private static final float TOUCH_TOLERANCE = 4.0f;
    private float mX;
    private float mY;
    Paint paint = null;
    Path path = null;
    int m_alphaValue = 255;

    public OZCanvasView(Context context) {
        super(context);
        this.setBackgroundColor(-1);
        this.mGestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new OZCanvasView$OZGestureListener(this, null), null, false);
        this.mScaleDetector = new ScaleGestureDetector(context, (ScaleGestureDetector.OnScaleGestureListener)new OZCanvasView$OZScaleListener(this, null));
    }

    public FrameLayout getCanvasView() {
        return this;
    }

    protected void onDraw(Canvas canvas) {
        if (this.path == null) {
            return;
        }
        this.paint = new Paint();
        this.path = new Path();
        this.paint.setARGB(255, 255, 0, 0);
        this.paint.setStrokeWidth(10.0f);
        super.onDraw(canvas);
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        this.mGestureDetector.onTouchEvent(motionEvent);
        this.mScaleDetector.onTouchEvent(motionEvent);
        int n = motionEvent.getPointerCount();
        float f2 = motionEvent.getX();
        float f3 = motionEvent.getY();
        long l = System.currentTimeMillis();
        boolean bl = false;
        switch (motionEvent.getAction()) {
            case 0: {
                this.mX = f2;
                this.mY = f3;
                break;
            }
            case 2: {
                float f4 = Math.abs(f2 - this.mX);
                float f5 = Math.abs(f3 - this.mY);
                if (!(f4 >= 4.0f) && !(f5 >= 4.0f)) break;
                this.mX = f2;
                this.mY = f3;
                break;
            }
        }
        return true;
    }
}

