/*
 * Decompiled with CFR 0.152.
 */
package oz.client.shape.ui;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.view.View;
import android.widget.ProgressBar;
import oz.client.shape.ui.ICImagePickerWnd;
import oz.client.shape.ui.OZImagePickerIDGuideView$1;
import oz.client.shape.ui.OZImagePickerIDGuideView$2;
import oz.main.OZStorage;

public class OZImagePickerIDGuideView
extends View {
    Paint guide_paint;
    Paint mosaic_paint;
    Paint mosaicFill_paint;
    float m_left;
    float m_top;
    float m_right;
    float m_bottom;
    ICImagePickerWnd parent;
    ProgressBar mprogressBar;
    int gX1;
    int gY1;
    int gX2;
    int gY2;
    int gcolor = 0;
    int[] gmX;
    int[] gmY;
    int[] gmW;
    int[] gmH;
    int[] colors;

    public OZImagePickerIDGuideView(Context context, ICImagePickerWnd iCImagePickerWnd, ProgressBar progressBar) {
        super(context);
        this.parent = iCImagePickerWnd;
        this.mprogressBar = progressBar;
        this.colors = new int[]{-1, Color.rgb((int)255, (int)178, (int)150), Color.rgb((int)255, (int)178, (int)150), Color.rgb((int)254, (int)100, (int)46)};
        this.guide_paint = new Paint(1);
        this.guide_paint.setColor(-1);
        this.guide_paint.setStyle(Paint.Style.STROKE);
        this.guide_paint.setStrokeWidth(1.5f * OZStorage.m_scaledDensity);
        this.mosaic_paint = new Paint(1);
        this.mosaic_paint.setColor(Color.rgb((int)66, (int)133, (int)244));
        this.mosaic_paint.setStyle(Paint.Style.STROKE);
        this.mosaic_paint.setStrokeWidth(1.5f * OZStorage.m_scaledDensity);
        this.mosaicFill_paint = new Paint(1);
        this.mosaicFill_paint.setColor(0x3300FF00);
        this.mosaicFill_paint.setStyle(Paint.Style.FILL);
        this.mosaicFill_paint.setStrokeWidth(1.5f * OZStorage.m_scaledDensity);
    }

    public void setComponentPos(float f2, float f3, float f4, float f5) {
        this.m_left = f2;
        this.m_top = f3;
        this.m_right = f4;
        this.m_bottom = f5;
    }

    public void setIDGuideInfo(int n, int n2, int n3, int n4, int n5, float f2) {
        this.gX1 = (int)((float)n * f2);
        this.gY1 = (int)((float)n2 * f2);
        this.gX2 = (int)((float)n3 * f2);
        this.gY2 = (int)((float)n4 * f2);
        this.gcolor = n5;
        this.postInvalidate();
    }

    public void clearIDGuideInfo() {
        this.gX1 = 0;
        this.gY1 = 0;
        this.gX2 = 0;
        this.gY2 = 0;
        this.gcolor = 0;
        this.postInvalidate();
    }

    protected void onDraw(Canvas canvas) {
        if (this.parent == null) {
            return;
        }
        if (this.mprogressBar.getVisibility() == 0) {
            return;
        }
        if (this.gX1 > 0 && this.parent.startPreview) {
            canvas.save();
            canvas.translate(this.m_left, this.m_top);
            if (this.gcolor == 3) {
                this.guide_paint.setColor(this.colors[2]);
            } else if (this.gcolor == 2) {
                this.guide_paint.setColor(this.colors[1]);
            } else {
                this.guide_paint.setColor(this.colors[0]);
            }
            this.drawFrameRect(canvas, this.gX1, this.gX2, this.gY1, this.gY2);
            if (this.parent.isShowMark) {
                this.drawMask(canvas, this.gmX, this.gmY, this.gmW, this.gmH);
            }
            canvas.restore();
        }
    }

    private void drawFrameRect(Canvas canvas, int n, int n2, int n3, int n4) {
        canvas.drawRect((float)n, (float)n3, (float)n2, (float)n4, this.guide_paint);
    }

    private void drawMask(Canvas canvas, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        if (nArray != null && nArray.length > 0) {
            for (int j = 0; j < nArray.length; ++j) {
                canvas.drawRect((float)(nArray[j] + this.gX1), (float)(nArray2[j] + this.gY1), (float)(nArray[j] + nArray3[j] + this.gX1), (float)(nArray2[j] + nArray4[j] + this.gY1), this.mosaicFill_paint);
                canvas.drawRect((float)(nArray[j] + this.gX1), (float)(nArray2[j] + this.gY1), (float)(nArray[j] + nArray3[j] + this.gX1), (float)(nArray2[j] + nArray4[j] + this.gY1), this.mosaic_paint);
            }
        }
    }

    public void startPictures() {
        this.post(new OZImagePickerIDGuideView$1(this));
    }

    public void stopPictures(boolean bl) {
        this.post(new OZImagePickerIDGuideView$2(this, bl));
    }

    public void btnTouchEnable(boolean bl) {
        if (this.parent.OZButton1 != null) {
            this.parent.OZButton1.setNotTouch(bl);
        }
        if (this.parent.OZButton2 != null) {
            this.parent.OZButton2.setNotTouch(bl);
        }
        if (this.parent.OZButton3 != null) {
            this.parent.OZButton3.setNotTouch(bl);
        }
        if (this.parent.OZButton4 != null) {
            this.parent.OZButton4.setNotTouch(bl);
        }
        if (this.parent.OZImagePickerPrevButton != null) {
            this.parent.OZImagePickerPrevButton.setNotTouch(bl);
        }
        if (this.parent.OZImagePickerNextButton != null) {
            this.parent.OZImagePickerNextButton.setNotTouch(bl);
        }
    }

    public void setIDGuideMosaicInfo(int n, String string, float f2) {
        this.gmX = new int[n];
        this.gmY = new int[n];
        this.gmW = new int[n];
        this.gmH = new int[n];
        String[] stringArray = string.split(",");
        int n2 = 0;
        for (int j = 0; j < n; ++j) {
            try {
                this.gmX[j] = (int)((float)Integer.parseInt(stringArray[n2++]) * f2);
                this.gmY[j] = (int)((float)Integer.parseInt(stringArray[n2++]) * f2);
                this.gmW[j] = (int)((float)Integer.parseInt(stringArray[n2++]) * f2);
                this.gmH[j] = (int)((float)Integer.parseInt(stringArray[n2++]) * f2);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

