/*
 * Decompiled with CFR 0.152.
 */
package oz.client.shape.ui;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.Rect;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import oz.client.shape.ui.OZImagePickerSealGuideView$1;
import oz.client.shape.ui.OZImagePickerSealGuideView$SealGuideView;
import oz.main.OZStorage;

public class OZImagePickerSealGuideView
extends RelativeLayout {
    private static final int TEXT_VIEW_ID = 15803205;
    public String text = null;
    public int textSize = 20;
    private int textColor = -1;
    private int textBGColor = Color.argb((int)128, (int)0, (int)0, (int)0);
    private Rect textInsets;
    private int textAreaMaxHeight;
    private TextView textView;
    private OZImagePickerSealGuideView$SealGuideView guideView;
    private ImageView imageView;

    public OZImagePickerSealGuideView(Context context) {
        super(context);
        int n = OZStorage.getPaddingInt(10.0f);
        this.textInsets = new Rect(n, n, n, n);
        this.textAreaMaxHeight = 0;
        this.imageView = new ImageView(context);
        this.addView((View)this.imageView, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        this.textView = new TextView(context);
        this.textView.setId(15803205);
        this.textView.setGravity(49);
        this.textView.setSingleLine(false);
        this.textView.setMaxLines(0);
        this.textView.setEllipsize(TextUtils.TruncateAt.END);
        this.addView((View)this.textView, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -2));
        this.guideView = new OZImagePickerSealGuideView$SealGuideView(context);
        this.guideView.bgColor = this.textBGColor;
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -2);
        layoutParams.addRule(9);
        layoutParams.addRule(3, 15803205);
        layoutParams.addRule(12);
        this.addView(this.guideView, (ViewGroup.LayoutParams)layoutParams);
        this.hide();
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        super.onSizeChanged(n, n2, n3, n4);
        this.textAreaMaxHeight = (int)((double)n2 * 0.33);
        if (n == 0 || n2 == 0) {
            this.hide();
        } else {
            this.post(new OZImagePickerSealGuideView$1(this));
        }
    }

    public void setImage(Bitmap bitmap) {
        this.imageView.setImageBitmap(bitmap);
    }

    public void hide() {
        this.textView.setVisibility(8);
        this.guideView.setVisibility(4);
    }

    public void show() {
        if (this.textView.getText() != null && this.textView.getText().length() > 0) {
            this.textView.setVisibility(0);
        } else {
            this.textView.setVisibility(8);
        }
        this.guideView.setVisibility(0);
    }

    public void update() {
        this.textView.setTextSize((float)this.textSize);
        this.textView.setTextColor(this.textColor);
        this.textView.setBackgroundColor(this.textBGColor);
        this.textView.setPadding(this.textInsets.left, this.textInsets.top, this.textInsets.right, this.textInsets.bottom);
        if (this.text != null && !this.text.isEmpty()) {
            this.textView.setText((CharSequence)this.text);
            this.textView.setMaxHeight(this.textAreaMaxHeight);
            this.textView.setVisibility(0);
        }
        this.show();
        this.forceLayout();
        this.requestLayout();
        this.postInvalidate();
    }
}

