/*
 * Decompiled with CFR 0.152.
 */
package oz.client.shape.ui;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Picture;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.view.View;
import oz.main.OZStorage;

class OZSignPadSealGuideView$SealGuideView
extends View {
    public float lineWidth = OZStorage.getPadding(2.0f);
    public int lineColor = -16711936;
    public int bgColor;
    public RectF insets = new RectF(0.3f, 0.3f, 0.3f, 0.3f);
    private Picture cachePicture;

    public OZSignPadSealGuideView$SealGuideView(Context context) {
        super(context);
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        super.onSizeChanged(n, n2, n3, n4);
    }

    private void drawGuideRect(Path path, float f2, float f3, float f4) {
        path.addRect(f2, f3, f2 + f4, f3 + f4, Path.Direction.CW);
    }

    private void drawGuide3Rects(Path path, float f2, float f3, float f4, float f5, float f6, float f7) {
        boolean bl;
        boolean bl2 = f6 >= 0.0f;
        boolean bl3 = f7 >= 0.0f;
        float f8 = f2 + f6;
        float f9 = f3 + f7;
        float f10 = f4 + f5;
        float f11 = f4 + f5;
        if (!bl2) {
            f8 -= f10 + f4;
        }
        if (!bl3) {
            f9 -= f11 + f4;
        }
        boolean bl4 = bl2 || bl3;
        boolean bl5 = !bl2 || bl3;
        boolean bl6 = !bl2 || !bl3;
        boolean bl7 = bl = bl2 || !bl3;
        if (bl4) {
            this.drawGuideRect(path, f8, f9, f4);
        }
        if (bl5) {
            this.drawGuideRect(path, f8 + f10, f9, f4);
        }
        if (bl6) {
            this.drawGuideRect(path, f8 + f10, f9 + f11, f4);
        }
        if (bl) {
            this.drawGuideRect(path, f8, f9 + f11, f4);
        }
    }

    private void pathUpdate(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            this.cachePicture = null;
        } else {
            Rect rect = new Rect(0, 0, (int)((float)n * (1.0f - this.insets.left - this.insets.right)), (int)((float)n2 * (1.0f - this.insets.top - this.insets.bottom)));
            float f2 = this.lineWidth * 2.0f + 20.0f;
            float f3 = Math.min(rect.width(), rect.height());
            if (f3 < f2) {
                f3 = f2;
            }
            float f4 = ((float)n - f3) / 2.0f;
            float f5 = ((float)n2 - f3) / 2.0f;
            float f6 = f3 * 0.08f;
            float f7 = f3 * 0.03f;
            float f8 = this.lineWidth + f7;
            this.cachePicture = new Picture();
            Canvas canvas = this.cachePicture.beginRecording(n, n2);
            if (this.bgColor != 0) {
                canvas.save();
                canvas.clipRect(new Rect((int)f4, (int)f5, (int)(f4 + f3), (int)(f5 + f3)), Region.Op.DIFFERENCE);
                canvas.drawColor(this.bgColor);
                canvas.restore();
            }
            if (this.lineWidth > 0.0f && this.lineColor != 0) {
                Paint paint = new Paint(1);
                paint.setStrokeWidth(this.lineWidth);
                paint.setColor(this.lineColor);
                paint.setStyle(Paint.Style.STROKE);
                Path path = new Path();
                this.drawGuide3Rects(path, f4, f5, f6, f8, f7, f7);
                this.drawGuide3Rects(path, f4 + f3, f5, f6, f8, -f7, f7);
                this.drawGuide3Rects(path, f4, f5 + f3, f6, f8, f7, -f7);
                this.drawGuide3Rects(path, f4 + f3, f5 + f3, f6, f8, -f7, -f7);
                canvas.drawPath(path, paint);
            }
            this.cachePicture.endRecording();
        }
        this.postInvalidate();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        Picture picture = this.cachePicture;
        if (picture != null) {
            canvas.save();
            canvas.drawPicture(picture);
            canvas.restore();
        }
    }
}

