/*
 * Decompiled with CFR 0.152.
 */
package oz.client.shape.ui;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import oz.client.shape.ui.OZSignPadManagerInterface;
import oz.client.shape.ui.OZSignPadSealGuideView$1;
import oz.client.shape.ui.OZSignPadSealGuideView$2;
import oz.client.shape.ui.OZSignPadSealGuideView$SealGuideView;
import oz.main.OZStorage;
import oz.viewer.ui.df.DFUtils;

public class OZSignPadSealGuideView
extends RelativeLayout {
    private static final int TEXT_VIEW_ID = 15803205;
    public String text = null;
    public int textSize = 20;
    private int textColor = -1;
    private int textBGColor;
    private Rect textInsets;
    private int textAreaMaxHeight;
    private TextView textView;
    private OZSignPadSealGuideView$SealGuideView guideView;
    private ImageView imageView;
    private ImageView closeImageView;
    OZSignPadManagerInterface mListener;

    public OZSignPadSealGuideView(Context context) {
        super(context);
        int n = OZStorage.getPaddingInt(10.0f);
        this.textInsets = new Rect(n, n, n, n);
        this.textAreaMaxHeight = 0;
        this.imageView = new ImageView(context);
        this.addView((View)this.imageView, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        LinearLayout linearLayout = new LinearLayout(this.getContext());
        linearLayout.setOrientation(0);
        linearLayout.setBackgroundColor(Color.argb((int)128, (int)0, (int)0, (int)0));
        linearLayout.setPadding(OZStorage.padding_10, OZStorage.padding_10, OZStorage.padding_10, OZStorage.padding_10);
        this.textView = new TextView(context);
        this.textView.setId(15803205);
        this.textView.setGravity(17);
        this.textView.setSingleLine(false);
        this.textView.setMaxLines(0);
        this.textView.setEllipsize(TextUtils.TruncateAt.END);
        linearLayout.addView((View)this.textView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -2, 1.0f));
        this.closeImageView = new ImageView(context);
        Drawable drawable2 = DFUtils.getImageDrawable(context, 9);
        if (drawable2 != null) {
            drawable2.setColorFilter(-1, PorterDuff.Mode.SRC_IN);
            this.closeImageView.setImageDrawable(drawable2);
        }
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-2, -2);
        layoutParams.gravity = 17;
        linearLayout.addView((View)this.closeImageView, (ViewGroup.LayoutParams)layoutParams);
        this.addView((View)linearLayout, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -2));
        this.closeImageView.setOnTouchListener((View.OnTouchListener)new OZSignPadSealGuideView$1(this));
        this.guideView = new OZSignPadSealGuideView$SealGuideView(context);
        RelativeLayout.LayoutParams layoutParams2 = new RelativeLayout.LayoutParams(-1, -2);
        layoutParams2.addRule(9);
        layoutParams2.addRule(3, 15803205);
        layoutParams2.addRule(12);
        this.addView(this.guideView, (ViewGroup.LayoutParams)layoutParams2);
        this.hide();
    }

    public void setListener(OZSignPadManagerInterface oZSignPadManagerInterface) {
        this.mListener = oZSignPadManagerInterface;
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        super.onSizeChanged(n, n2, n3, n4);
        this.textAreaMaxHeight = (int)((double)n2 * 0.33);
        if (n == 0 || n2 == 0) {
            this.hide();
        } else {
            this.post(new OZSignPadSealGuideView$2(this));
        }
    }

    public void setImage(Bitmap bitmap) {
        this.imageView.setImageBitmap(bitmap);
        this.imageView.setBackgroundColor(-16777216);
    }

    public void hide() {
        this.textView.setVisibility(8);
        this.guideView.setVisibility(4);
    }

    public void show() {
        if (this.textView.getText() != null && this.textView.getText().length() > 0) {
            this.textView.setVisibility(0);
        } else {
            this.textView.setVisibility(8);
        }
        this.guideView.setVisibility(0);
    }

    public void update() {
        this.textView.setTextSize((float)this.textSize);
        this.textView.setTextColor(this.textColor);
        this.textView.setPadding(this.textInsets.left, this.textInsets.top, this.textInsets.right, this.textInsets.bottom);
        if (this.text != null && !this.text.isEmpty()) {
            this.textView.setText((CharSequence)this.text);
            this.textView.setMaxHeight(this.textAreaMaxHeight);
            this.textView.setVisibility(0);
        }
        this.show();
        this.forceLayout();
        this.requestLayout();
        this.postInvalidate();
    }
}

