/*
 * Decompiled with CFR 0.152.
 */
package oz.client.shape.ui;

import android.content.Context;
import android.graphics.Bitmap;
import android.hardware.Camera;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import java.util.concurrent.locks.ReentrantLock;
import oz.client.shape.ui.ICSignPadWnd;
import oz.client.shape.ui.OZSignPadManagerInterface;
import oz.client.shape.ui.OZSignPadSealGuideView;
import oz.client.shape.ui.OZSignpadSealManager$1;
import oz.client.shape.ui.OZSignpadSealManager$2;
import oz.client.shape.ui.OZSignpadSealManager$3;
import oz.client.shape.ui.OZSignpadSealManager$4;
import oz.client.shape.ui.OZSignpadSealManager$5;
import oz.client.shape.ui.OZSignpadSealManager$6;
import oz.client.shape.ui.OZSignpadSealManager$7;
import oz.client.shape.ui.OZSignpadSealManager$8;
import oz.client.shape.ui.OZSignpadSealManager$9;
import oz.client.shape.ui.OZSignpadSealThread;
import oz.client.shape.ui.OZSignpadSealView;
import oz.util.camera.DefaultOZCamera;
import oz.viewer.ui.df.DFUtils;

public class OZSignpadSealManager
extends FrameLayout
implements Camera.PreviewCallback {
    Camera mCamera;
    Camera.CameraInfo mCameraInfo;
    protected OZSignpadSealView mPreview;
    public ICSignPadWnd mParent;
    boolean m_isFound = false;
    OZSignpadSealThread sealThread;
    private Handler sealHandler;
    private int sealMessage;
    boolean isCloseHandler = false;
    public float m_sWidth;
    public float m_sHeight;
    public boolean startPreview;
    public boolean m_pictureSuccess;
    public Bitmap preview_bitmap = null;
    byte[] previewBuffer = null;
    byte[] previewCopiedBuffer = null;
    byte[] previewSealOKBuffer = null;
    public boolean isShow = false;
    final ReentrantLock frameLock = new ReentrantLock();
    OZSignPadSealGuideView sealGuideView;
    private int preview_width;
    private int preview_height;
    private int preview_bitmap_width;
    private int preview_bitmap_height;
    private int previewOffsetLeft;
    private int previewOffsetTop;
    int m_isFocused = 0;
    int m_isOnceFocused = 0;
    boolean m_isCameraOpened = true;
    public boolean autoFocus = true;
    public boolean onShutter = false;
    public Bitmap bitmap = null;
    int __x;
    int __y;
    int __finalWidth;
    int __finalHeight;
    float bmpWidth;
    float bmpHeight;
    public float m_left;
    public float m_top;
    public float m_right;
    public float m_bottom;
    public boolean m_isScanComplated;
    public boolean m_isReTryScan;
    public boolean mIsValueEmpty;
    private OZSignPadManagerInterface mListener;
    Camera.AutoFocusCallback myAutoFocusCallback = new OZSignpadSealManager$7(this);
    public Camera.PictureCallback mPictureListener = new OZSignpadSealManager$8(this);
    private boolean __autoFocusCallBackFlag = false;
    public Camera.ShutterCallback mShutterListener = new OZSignpadSealManager$9(this);

    public OZSignpadSealManager(Context context, ICSignPadWnd iCSignPadWnd) {
        super(context);
        this.mParent = iCSignPadWnd;
        this.m_isScanComplated = false;
        this.m_isReTryScan = false;
    }

    public void setListener(OZSignPadManagerInterface oZSignPadManagerInterface) {
        this.mListener = oZSignPadManagerInterface;
    }

    public void releaseCamera() {
        if (this.mCamera != null) {
            this.mCamera.setPreviewCallbackWithBuffer(null);
            this.mCamera.release();
            this.mCamera = null;
            if (this.preview_bitmap != null) {
                this.preview_bitmap.recycle();
            }
            this.preview_bitmap = null;
        }
        this.closeHandler();
        this.startPreview = false;
    }

    public Camera getCamera() {
        return this.mCamera;
    }

    public Camera.CameraInfo getCameraInfo() {
        return this.mCameraInfo;
    }

    public void cameraOpen() {
        this.createCamera();
        this.initPreviewView();
        this.signPadSealThreadRun();
        this.isShow = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createCamera() {
        block15: {
            this.mCameraInfo = null;
            try {
                DefaultOZCamera defaultOZCamera;
                DefaultOZCamera defaultOZCamera2 = null;
                defaultOZCamera2 = defaultOZCamera = new DefaultOZCamera();
                this.mCamera = defaultOZCamera2.open(true);
                if (this.mCamera != null) {
                    this.mCameraInfo = defaultOZCamera2.getCameraInfo();
                    break block15;
                }
                Log.d((String)"OZViewer", (String)"Camera open retry.");
                try {
                    Thread.sleep(100L);
                    this.mCamera = Camera.open();
                }
                catch (Throwable throwable) {
                    Log.d((String)"OZViewer", (String)("Camera open error:" + throwable.getLocalizedMessage()), (Throwable)throwable);
                    this.mCamera = null;
                }
                finally {
                    this.mCameraInfo = null;
                }
            }
            catch (Throwable throwable) {
                Log.d((String)"OZViewer", (String)"Camera open retry.");
                try {
                    Thread.sleep(100L);
                    this.mCamera = Camera.open();
                }
                catch (Throwable throwable2) {
                    Log.d((String)"OZViewer", (String)("Camera open error:" + throwable.getLocalizedMessage()), (Throwable)throwable);
                    this.mCamera = null;
                }
                finally {
                    this.mCameraInfo = null;
                }
            }
        }
        if (this.mCamera != null) {
            this.mCamera.setErrorCallback((Camera.ErrorCallback)new OZSignpadSealManager$1(this));
        } else {
            this.mCameraInfo = null;
        }
    }

    public void initPreviewView() {
        if (this.mPreview != null && this.mPreview.getParent() != null) {
            ((ViewGroup)this.mPreview.getParent()).removeView((View)this.mPreview);
        }
        this.mPreview = new OZSignpadSealView(this.getContext(), this);
        this.mPreview.setFocusable(true);
        this.mPreview.setFocusableInTouchMode(true);
        this.mPreview.setCamera(this.mCamera);
    }

    public void setPreviewView() {
        if (this.mPreview != null) {
            if (this.mPreview.getParent() == null) {
                int n;
                int n2;
                this.addView((View)this.mPreview);
                ViewGroup.LayoutParams layoutParams = this.mPreview.getLayoutParams();
                if (this.getResources().getConfiguration().orientation == 2) {
                    n2 = 1920;
                    n = 1080;
                } else {
                    n2 = 1080;
                    n = 1920;
                }
                int n3 = this.getResources().getDisplayMetrics().widthPixels;
                int n4 = this.getResources().getDisplayMetrics().heightPixels;
                float f2 = (float)n3 / (float)n4;
                float f3 = (float)n2 / (float)n;
                if (f2 > f3) {
                    layoutParams.width = n3;
                    layoutParams.height = (int)((float)n3 / f3);
                } else {
                    layoutParams.height = n4;
                    layoutParams.width = (int)((float)n4 * f3);
                }
                this.mPreview.setLayoutParams(layoutParams);
                this.mPreview.setTranslationX((n3 - layoutParams.width) / 2);
                this.mPreview.setTranslationY((n4 - layoutParams.height) / 2);
            }
            this.mPreview.requestFocus();
        }
    }

    public OZSignpadSealView getPreview() {
        return this.mPreview;
    }

    public void signPadSealThreadRun() {
        this.m_isFound = false;
        if (this.sealThread == null || this.isCloseHandler) {
            this.sealThread = new OZSignpadSealThread(this);
            this.sealThread.start();
        }
        this.isCloseHandler = false;
        this.setHandler(this.sealThread.getHandler(), 2131230720);
        this.sealThread.getHandler().sendMessage(this.sealThread.getHandler().obtainMessage(2131230720));
    }

    public void setHandler(Handler handler, int n) {
        this.sealHandler = handler;
        this.sealMessage = n;
    }

    public void closeHandler() {
        if (this.isCloseHandler) {
            return;
        }
        try {
            this.isCloseHandler = true;
            Message message = Message.obtain((Handler)this.sealThread.getHandler(), (int)2131230724);
            message.sendToTarget();
            this.sealThread.join(300L);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void requestHideSealGuide() {
        this.releaseCamera();
    }

    public void requestShowSealGuide() {
        this.readySealGuide();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPreviewFrameInternal(byte[] byArray) {
        if (!this.isShow) {
            return;
        }
        if (!this.startPreview) {
            return;
        }
        if (this.mPreview != null && this.mPreview.getPreviewSize() != null) {
            int n;
            if (this.preview_bitmap == null) {
                int n2;
                this.preview_width = this.mPreview.getPreviewSize().width;
                this.preview_height = this.mPreview.getPreviewSize().height;
                n = DFUtils.isMobile(this.getContext()) ? 1 : 0;
                if (n != 0) {
                    this.previewOffsetTop = 0;
                    this.previewOffsetLeft = 0;
                    if (this.mPreview.rotationResult == 90 || this.mPreview.rotationResult == 270) {
                        this.preview_bitmap_width = this.mPreview.getPreviewSize().height;
                        this.preview_bitmap_height = this.mPreview.getPreviewSize().width;
                    } else {
                        this.preview_bitmap_width = this.mPreview.getPreviewSize().width;
                        this.preview_bitmap_height = this.mPreview.getPreviewSize().height;
                    }
                } else if (this.mPreview.rotationResult == 90 || this.mPreview.rotationResult == 270) {
                    n2 = Math.min(this.mPreview.getPreviewSize().width, this.mPreview.getPreviewSize().height);
                    this.previewOffsetLeft = (this.mPreview.getPreviewSize().height - n2) / 2;
                    this.previewOffsetTop = (this.mPreview.getPreviewSize().width - n2) / 2;
                    this.preview_bitmap_width = this.mPreview.getPreviewSize().height - this.previewOffsetLeft * 2;
                    this.preview_bitmap_height = this.mPreview.getPreviewSize().width - this.previewOffsetTop * 2;
                } else {
                    n2 = Math.min(this.mPreview.getPreviewSize().width, this.mPreview.getPreviewSize().height);
                    this.previewOffsetLeft = (this.mPreview.getPreviewSize().width - n2) / 2;
                    this.previewOffsetTop = (this.mPreview.getPreviewSize().height - n2) / 2;
                    this.preview_bitmap_width = this.mPreview.getPreviewSize().width - this.previewOffsetLeft * 2;
                    this.preview_bitmap_height = this.mPreview.getPreviewSize().height - this.previewOffsetTop * 2;
                }
                this.preview_bitmap = Bitmap.createBitmap((int)this.preview_bitmap_width, (int)this.preview_bitmap_height, (Bitmap.Config)Bitmap.Config.RGB_565);
                Log.d((String)"OZViewer", (String)("preview_bitmap_width=" + this.preview_bitmap_width + ", preview_bitmap_height=" + this.preview_bitmap_height));
            }
            if ((n = this.m_isOnceFocused) == 1) {
                this.m_isOnceFocused = 0;
            }
            OZSignpadSealManager oZSignpadSealManager = this;
            synchronized (oZSignpadSealManager) {
                this.frameLock.lock();
                boolean bl = false;
                try {
                    this.mParent.nativeSignpadCameraPreview(this.preview_bitmap, byArray, this.preview_width, this.preview_height, this.previewOffsetLeft, this.previewOffsetTop, this.preview_bitmap_width, this.preview_bitmap_height, this.mPreview.rotationResult, 4, this.m_isFocused, n, 0, 1);
                    if (this.mParent.nativeIsSealOK()) {
                        this.previewSealOKBuffer = byArray;
                    }
                    bl = true;
                }
                finally {
                    this.frameLock.unlock();
                    if (bl) {
                        this.post(new OZSignpadSealManager$2(this));
                    }
                }
            }
            this.mParent.repaint();
        }
    }

    public void computeCenterSize() {
        float f2;
        float f3;
        float f4;
        float f5;
        float f6;
        float f7;
        float f8 = this.m_left;
        float f9 = this.m_top;
        float f10 = this.m_right - this.m_left;
        float f11 = this.m_bottom - this.m_top;
        if (f10 > f11) {
            f8 += (f10 - f11) / 2.0f;
            f10 = f11;
        } else if (f10 < f11) {
            f9 += (f11 - f10) / 2.0f;
            f11 = f10;
        }
        float f12 = Math.min(this.mPreview.pictureRatioW, this.mPreview.pictureRatioH);
        float f13 = (float)this.mPreview.previewWidth * f12;
        float f14 = (float)this.mPreview.previewHeight * f12;
        this.bmpWidth = this.mPreview.pictureWidth;
        this.bmpHeight = this.mPreview.pictureHeight;
        if (this.mPreview.rotationResult == 90 || this.mPreview.rotationResult == 270) {
            this.bmpWidth = this.mPreview.pictureHeight;
            this.bmpHeight = this.mPreview.pictureWidth;
        }
        if (f10 * (f7 = this.bmpHeight - (f6 = this.bmpHeight - f14)) > f11 * (f5 = this.bmpWidth - (f4 = this.bmpWidth - f13))) {
            f3 = f5;
            f2 = f11 * f5 / f10;
        } else {
            f3 = f10 * f7 / f11;
            f2 = f7;
        }
        f8 = (f5 - f3) / 2.0f;
        f9 = (f7 - f2) / 2.0f;
        float f15 = f8 + f4 / 2.0f;
        float f16 = f9 + f6 / 2.0f;
        float f17 = f3;
        float f18 = f2;
        if (f15 < 0.0f) {
            f17 += f15;
            f15 = 0.0f;
        }
        if (f16 < 0.0f) {
            f18 += f16;
            f16 = 0.0f;
        }
        int n = (int)f15;
        int n2 = (int)f16;
        int n3 = Math.round(f17);
        int n4 = Math.round(f18);
        if (n + n3 > (int)this.bmpWidth) {
            n3 = (int)this.bmpWidth - n;
        }
        if (n2 + n4 > (int)this.bmpHeight) {
            n4 = (int)this.bmpHeight - n2;
        }
        this.__x = n;
        this.__y = n2;
        this.__finalWidth = n3;
        this.__finalHeight = n4;
    }

    public void readySealGuide() {
        OZSignpadSealManager oZSignpadSealManager = this;
        this.post(new OZSignpadSealManager$3(this));
    }

    public OZSignPadSealGuideView getSealGuideView() {
        return this.sealGuideView;
    }

    public void startCameraPreview() {
        this.startCameraPreview(false);
    }

    public void startCameraPreview(boolean bl) {
        if (this.mCamera == null) {
            return;
        }
        this.m_pictureSuccess = false;
        if (!bl) {
            if (this.preview_bitmap != null) {
                this.preview_bitmap.recycle();
            }
            this.preview_bitmap = null;
            this.signPadSealThreadRun();
        }
        this.mCamera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)this);
        Camera.Size size = this.mCamera.getParameters().getPreviewSize();
        this.previewBuffer = new byte[size.width * size.height * 2];
        this.previewCopiedBuffer = new byte[size.width * size.height * 2];
        this.mCamera.addCallbackBuffer(this.previewBuffer);
        this.startPreview();
    }

    protected void startPreview() {
        if (this.mCamera != null) {
            this.startPreview(this.mCamera);
        }
    }

    protected void startPreview(Camera camera) {
        if (camera != null) {
            try {
                camera.startPreview();
            }
            catch (Throwable throwable) {
                Log.d((String)"OZViewer", (String)("Camera is start preview error. one more retry :" + throwable.getLocalizedMessage()));
                try {
                    camera.startPreview();
                }
                catch (Throwable throwable2) {
                    Log.e((String)"OZViewer", (String)("Camera is start preview error : :" + throwable.getLocalizedMessage()));
                }
            }
            this.startPreview = true;
        }
    }

    public void stopPreview() {
        this.stopPreview(true);
    }

    public void stopPreview(boolean bl) {
        if (bl) {
            this.startPreview = false;
        }
        if (this.mCamera != null) {
            this.mCamera.stopPreview();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPreviewFrame(byte[] byArray, Camera camera) {
        block11: {
            if (!this.isShow) {
                return;
            }
            if (!this.startPreview) {
                return;
            }
            Camera.Size size = camera.getParameters().getPreviewSize();
            int n = size.width;
            int n2 = size.height;
            Handler handler = this.sealHandler;
            if (handler != null && !this.isCloseHandler) {
                try {
                    if (this.frameLock.tryLock()) {
                        try {
                            System.arraycopy(byArray, 0, this.previewCopiedBuffer, 0, byArray.length);
                            Message message = handler.obtainMessage(this.sealMessage, (Object)this.previewCopiedBuffer);
                            message.sendToTarget();
                            break block11;
                        }
                        finally {
                            this.frameLock.unlock();
                        }
                    }
                    Log.w((String)"OZViewer", (String)"[WARN] deplicate call on preview frame.");
                }
                catch (RuntimeException runtimeException) {}
            } else if (!this.m_isFound) {
                this.mParent.post(new OZSignpadSealManager$4(this));
            }
        }
    }

    public void SetFound(int n, int n2, int n3) {
        if (this.preview_bitmap == null) {
            this.sealGuideView.setImage(null);
        } else if (n == 1) {
            this.sealGuideView.post(new OZSignpadSealManager$5(this));
        } else if (n == 0) {
            this.autoFocus();
        }
        this.m_isFocused = n3;
        if (n == 1) {
            this.sealGuideView.post(new OZSignpadSealManager$6(this));
        } else if (n2 == 1 && this.startPreview) {
            this.autoFocus();
        }
    }

    private void autoFocus() {
        this.m_isFocused = 0;
        this.setAutoFocusCallBackFlag(true);
        try {
            if (this.mCamera != null) {
                this.mCamera.autoFocus(this.myAutoFocusCallback);
            }
        }
        catch (Throwable throwable) {
            System.out.println("autoFocus() failed :" + throwable.getLocalizedMessage());
            this.setAutoFocusCallBackFlag(false);
        }
    }

    public synchronized void setAutoFocusCallBackFlag(boolean bl) {
        this.__autoFocusCallBackFlag = bl;
    }

    static /* synthetic */ OZSignPadManagerInterface access$000(OZSignpadSealManager oZSignpadSealManager) {
        return oZSignpadSealManager.mListener;
    }

    static /* synthetic */ int access$100(OZSignpadSealManager oZSignpadSealManager) {
        return oZSignpadSealManager.previewOffsetLeft;
    }

    static /* synthetic */ int access$200(OZSignpadSealManager oZSignpadSealManager) {
        return oZSignpadSealManager.previewOffsetTop;
    }

    static /* synthetic */ int access$300(OZSignpadSealManager oZSignpadSealManager) {
        return oZSignpadSealManager.preview_bitmap_width;
    }

    static /* synthetic */ int access$400(OZSignpadSealManager oZSignpadSealManager) {
        return oZSignpadSealManager.preview_bitmap_height;
    }
}

