/*
 * Decompiled with CFR 0.152.
 */
package oz.client.shape.ui.imgmerge;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.view.View;

public class ImageMergeDashLineView
extends View {
    private Paint mPaint;
    private Path mPath;
    private int mColor;
    private int mDashLineWidth;
    private int mDashWidth;
    private int mDashGap;
    private boolean mIsVertical;
    private boolean mIsHorizontal;

    public ImageMergeDashLineView(Context context, int n, int n2, int n3, int n4) {
        super(context);
        this.mColor = n;
        this.mDashLineWidth = n2;
        this.mDashWidth = n3;
        this.mDashGap = n4;
        this.initPaint();
    }

    public void requestRedraw() {
        if (this.mPath != null) {
            this.mPath = null;
        }
        this.postInvalidate();
    }

    public void setVerticalLine(boolean bl) {
        if (this.mIsVertical != bl) {
            this.mIsVertical = bl;
            this.requestRedraw();
        }
    }

    public void setHorizontalLine(boolean bl) {
        if (this.mIsHorizontal != bl) {
            this.mIsHorizontal = bl;
            this.requestRedraw();
        }
    }

    private void initPaint() {
        this.mPaint = new Paint();
        this.mPaint.setStrokeWidth((float)this.mDashLineWidth);
        this.mPaint.setColor(this.mColor);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setPathEffect((PathEffect)new DashPathEffect(new float[]{this.mDashWidth, this.mDashGap}, 0.0f));
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        super.onSizeChanged(n, n2, n3, n4);
        this.requestRedraw();
    }

    private void createPath() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = (int)((float)n / 2.0f);
        int n4 = (int)((float)n2 / 2.0f);
        this.mPath = new Path();
        if (this.mIsHorizontal) {
            this.mPath.moveTo(0.0f, (float)n4);
            this.mPath.lineTo((float)n, (float)n4);
            this.mPath.moveTo((float)n, (float)n4);
        }
        if (this.mIsVertical) {
            this.mPath.moveTo((float)n3, 0.0f);
            this.mPath.lineTo((float)n3, (float)n2);
            this.mPath.moveTo((float)n3, (float)n2);
        }
        this.mPath.close();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mPath == null) {
            this.createPath();
        }
        canvas.drawPath(this.mPath, this.mPaint);
    }
}

