/*
 * Decompiled with CFR 0.152.
 */
package oz.client.shape.ui.imgmerge;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.Parcelable;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.io.File;
import java.io.IOException;
import oz.client.shape.ui.imgmerge.ImageMergeItemBitmap;
import oz.client.shape.ui.imgmerge.ImageMergeItemImageView$1;
import oz.client.shape.ui.imgmerge.ImageMergeItemImageView$2;
import oz.client.shape.ui.imgmerge.ImageMergeView;
import oz.resource.OZAndroidResource;
import oz.util.android.FileProviderSupport;
import oz.viewer.ui.df.DFUtils;

public class ImageMergeItemImageView
extends ImageView {
    private boolean mIgnoreDefaultBitmapDraw = false;
    private ImageMergeItemBitmap mItem = null;
    private Dialog mDialog;

    public ImageMergeItemImageView(Context context) {
        super(context);
        this.setDefaultImage();
        this.setSelected(false);
        this.initDialog();
    }

    private void initDialog() {
        if (this.mDialog == null) {
            this.mDialog = new Dialog(this.getContext());
            this.mDialog.requestWindowFeature(1);
        }
        LinearLayout linearLayout = new LinearLayout(this.getContext());
        linearLayout.setOrientation(1);
        TextView textView = new TextView(this.getContext());
        textView.setText((CharSequence)OZAndroidResource.getResource("camera.shutter"));
        textView.setTextSize(2, 20.0f);
        textView.setGravity(17);
        textView.setOnClickListener((View.OnClickListener)new ImageMergeItemImageView$1(this));
        TextView textView2 = new TextView(this.getContext());
        textView2.setText((CharSequence)OZAndroidResource.getResource("camera.gallery"));
        textView2.setTextSize(2, 20.0f);
        textView2.setGravity(17);
        textView2.setOnClickListener((View.OnClickListener)new ImageMergeItemImageView$2(this));
        int n = DFUtils.toDP(this.getContext(), 130.0f);
        int n2 = DFUtils.toDP(this.getContext(), 60.0f);
        linearLayout.addView((View)textView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(n, n2));
        linearLayout.addView((View)textView2, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(n, n2));
        this.mDialog.setContentView((View)linearLayout);
    }

    public void showSelectDialog() {
        if (this.mDialog != null && !this.mDialog.isShowing()) {
            this.mDialog.show();
        }
    }

    public void dismissSelectDialog() {
        if (this.mDialog != null && this.mDialog.isShowing()) {
            this.mDialog.dismiss();
        }
    }

    private boolean isItemValid() {
        return this.mItem != null;
    }

    public void setDefaultImage() {
        this.setScaleType(ImageView.ScaleType.CENTER);
        Drawable drawable2 = ImageMergeView.getImageDrawable(this.getContext(), "icon_addimage@2x.png");
        int n = this.getContext().getResources().getDisplayMetrics().densityDpi;
        ((BitmapDrawable)drawable2).getBitmap().setDensity(n);
        this.setImageBitmap(((BitmapDrawable)drawable2).getBitmap());
    }

    public void setBitmap(Bitmap bitmap) {
        if (this.isItemValid()) {
            this.setRotate(this.mItem.getDegree());
            this.setScaleType(this.mItem.getAspectStyle());
        } else {
            this.setImageBitmap(bitmap);
        }
    }

    public void clearBitmap() {
        this.setDefaultImage();
    }

    public void setDegree(int n) {
        if (this.isItemValid()) {
            this.mItem.setDegree(n);
        }
    }

    public int getDegree() {
        if (this.isItemValid()) {
            return this.mItem.getDegree();
        }
        return 0;
    }

    public void setAspectStyle(ImageView.ScaleType scaleType) {
        if (this.isItemValid()) {
            this.mItem.setAspectStyle(scaleType);
        }
    }

    public ImageView.ScaleType getAspectStyle() {
        if (this.isItemValid()) {
            return this.mItem.getAspectStyle();
        }
        return ImageView.ScaleType.FIT_CENTER;
    }

    public void setImageBitmap(Bitmap bitmap) {
        super.setImageBitmap(bitmap);
    }

    public void rotateClockWise() {
        this.rotateImage(true);
    }

    public void rotateCounterClockWise() {
        this.rotateImage(false);
    }

    public void aspectFit() {
        this.setAspectStyle(ImageView.ScaleType.FIT_CENTER);
        this.setScaleType(this.getAspectStyle());
    }

    public void aspectFill() {
        this.setAspectStyle(ImageView.ScaleType.CENTER_CROP);
        this.setScaleType(this.getAspectStyle());
    }

    private void rotateImage(boolean bl) {
        if (this.isItemValid() && this.mItem.isValid()) {
            if (bl) {
                this.setDegree((this.getDegree() + 90) % 360);
                this.setRotate(this.getDegree());
            } else {
                this.setDegree((this.getDegree() - 90) % 360);
                this.setRotate(this.getDegree());
            }
        }
    }

    private void setRotate(int n) {
        if (this.isItemValid() && this.mItem.isValid()) {
            Matrix matrix = new Matrix();
            matrix.postRotate((float)n);
            Bitmap bitmap = this.mItem.getBitmap();
            Bitmap bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
            this.setImageBitmap(bitmap2);
        }
    }

    private void imageCapture() {
        File file;
        File file2 = this.getContext().getExternalFilesDir(Environment.DIRECTORY_PICTURES);
        if (!file2.exists()) {
            file2.mkdirs();
        }
        if ((file = new File(file2, "OZ_TMP_IMAGE")).exists()) {
            file.delete();
        }
        try {
            file.createNewFile();
            file.deleteOnExit();
        }
        catch (IOException iOException) {
            file = null;
            iOException.printStackTrace();
        }
        if (file != null) {
            Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
            Uri uri = null;
            try {
                uri = Build.VERSION.SDK_INT >= 29 ? FileProviderSupport.getUriForFileSimpleFile(this.getContext(), file) : Uri.fromFile((File)file);
            }
            catch (Exception exception) {
                Log.e((String)"OZViewer", (String)"Not exists FileProvider or filePaths.xml");
                exception.printStackTrace();
            }
            intent.putExtra("output", (Parcelable)uri);
            intent.addFlags(2);
            ((Activity)this.getContext()).startActivityForResult(intent, 13204);
        } else {
            Log.e((String)"OZViewer", (String)"invalid path");
        }
    }

    public void showGallery() {
        Intent intent = new Intent("android.intent.action.PICK");
        intent.setType("image/*");
        ((Activity)this.getContext()).startActivityForResult(Intent.createChooser((Intent)intent, (CharSequence)"Select picture"), 13205);
    }

    public void updateWithItem(ImageMergeItemBitmap imageMergeItemBitmap) {
        if (imageMergeItemBitmap == null || !imageMergeItemBitmap.isValid()) {
            this.setDefaultImage();
        } else {
            this.mItem = imageMergeItemBitmap;
            this.setBitmap(imageMergeItemBitmap.getBitmap());
        }
        this.setTag(imageMergeItemBitmap);
        this.postInvalidate();
    }

    public void setIgnoreDefaultBitmapDraw(boolean bl) {
        this.mIgnoreDefaultBitmapDraw = bl;
    }

    protected void onDraw(Canvas canvas) {
        Object object = this.getTag();
        if (!this.mIgnoreDefaultBitmapDraw || object != null && object instanceof ImageMergeItemBitmap && ((ImageMergeItemBitmap)object).isValid()) {
            super.onDraw(canvas);
        }
    }

    static /* synthetic */ void access$000(ImageMergeItemImageView imageMergeItemImageView) {
        imageMergeItemImageView.imageCapture();
    }
}

