/*
 * Decompiled with CFR 0.152.
 */
package oz.client.shape.ui.imgmerge;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import java.util.List;
import oz.client.shape.ui.imgmerge.ImageMergeFrameLayout;
import oz.client.shape.ui.imgmerge.ImageMergeItemBitmap;
import oz.client.shape.ui.imgmerge.ImageMergeItemImageView;
import oz.client.shape.ui.imgmerge.ImageMergeItemLayoutBase$1;
import oz.client.shape.ui.imgmerge.ImageMergeItemLayoutBase$ImageMergeRootArea;
import oz.client.shape.ui.imgmerge.ImageMergeManager;
import oz.client.shape.ui.imgmerge.ImageMergeView;
import oz.viewer.ui.df.DFUtils;

public abstract class ImageMergeItemLayoutBase {
    protected ImageMergeFrameLayout mParent;
    private ImageMergeItemLayoutBase$ImageMergeRootArea mRoot;
    private ImageMergeFrameLayout mSelectedBorder;
    private ViewGroup mPaperView;
    private View mPaperBorder;
    private Rect mValidRect;
    protected boolean mIsVertical;
    protected int mMaxSize;
    private float mTargetWidth;
    private float mTargetHeight;
    private int mPaperColor;
    private int mDivision;
    public static final int DIVISION_1 = 0;
    public static final int DIVISION_2V = 1;
    public static final int DIVISION_2H = 2;
    public static final int DIVISION_4 = 3;
    public static final int DP_GUIDE_LINE_WIDTH = 2;
    public static final int DP_GUIDE_DASH_LINE_WIDTH = 2;
    public static final int DP_GUIDE_DASH_WIDTH = 4;
    public static final int DP_GUIDE_DASH_GAP = 2;

    public ImageMergeItemLayoutBase(ImageMergeFrameLayout imageMergeFrameLayout, boolean bl) {
        this.mParent = imageMergeFrameLayout;
        this.mRoot = new ImageMergeItemLayoutBase$ImageMergeRootArea(this, this.getContext(), this);
        this.mPaperView = new FrameLayout(this.getContext());
        this.mPaperBorder = new View(this.getContext());
        this.mSelectedBorder = new ImageMergeFrameLayout(this.getContext());
        this.mValidRect = new Rect();
        this.mIsVertical = bl;
        this.mMaxSize = 2;
        this.mPaperColor = 0;
    }

    protected void setDivision(int n) {
        this.mDivision = n;
    }

    public int getDivision() {
        return this.mDivision;
    }

    public void setPaperColor(int n) {
        this.mPaperColor = n;
    }

    public int getPaperColor() {
        return this.mPaperColor;
    }

    public ViewGroup getMyRootView() {
        return this.mRoot;
    }

    public ViewGroup getMyPaperView() {
        return this.mPaperView;
    }

    public ImageMergeFrameLayout getMySelectedBorder() {
        return this.mSelectedBorder;
    }

    public Context getContext() {
        return this.mParent.getContext();
    }

    public int getLineWidth() {
        return DFUtils.toDP(this.getContext(), 2.0f);
    }

    protected ImageMergeItemImageView[] getItemImageViews(ImageMergeManager imageMergeManager) {
        ImageMergeItemImageView[] imageMergeItemImageViewArray = new ImageMergeItemImageView[this.mMaxSize];
        List list = imageMergeManager.getItems();
        for (int j = 0; j < this.mMaxSize; ++j) {
            ImageMergeItemBitmap imageMergeItemBitmap = null;
            if (list.size() > j) {
                imageMergeItemBitmap = (ImageMergeItemBitmap)list.get(j);
            }
            imageMergeItemImageViewArray[j] = new ImageMergeItemImageView(this.getContext());
            imageMergeItemImageViewArray[j].setOnClickListener(new ImageMergeItemLayoutBase$1(this, imageMergeManager));
            if (imageMergeItemBitmap != null) {
                imageMergeItemImageViewArray[j].updateWithItem(imageMergeItemBitmap);
                continue;
            }
            Drawable drawable2 = ImageMergeView.getImageDrawable(this.getContext(), "btn_history_attachment.png");
            imageMergeItemImageViewArray[j].setBitmap(((BitmapDrawable)drawable2).getBitmap());
        }
        return imageMergeItemImageViewArray;
    }

    public void addItemLayout(ImageMergeManager imageMergeManager, float f2, float f3) {
        this.mTargetWidth = f2;
        this.mTargetHeight = f3;
        this.mParent.removeAllViewsInLayout();
        ViewGroup viewGroup = this.getMyRootView();
        this.mParent.addView((View)viewGroup, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        ViewGroup viewGroup2 = this.getMyPaperView();
        viewGroup2.setBackgroundColor(this.getPaperColor());
        viewGroup2.setVisibility(8);
        viewGroup.addView((View)viewGroup2);
        this.updateBorderView(this.mPaperBorder);
        this.mPaperBorder.setVisibility(8);
        viewGroup.addView(this.mPaperBorder);
        this.mSelectedBorder.drawSelectedRect(null);
        this.mSelectedBorder.setWillNotDraw(false);
        viewGroup.addView((View)this.mSelectedBorder, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
    }

    public void removeItemLayout(ImageMergeManager imageMergeManager) {
    }

    public int getRootTopBottomMargin() {
        return DFUtils.toDP(this.getContext(), 20.0f);
    }

    public int getRootLeftRightMargin() {
        return DFUtils.toDP(this.getContext(), 20.0f);
    }

    public void calcValidRect(Rect rect, float f2, float f3) {
        int n = rect.width();
        int n2 = rect.height();
        if (f2 == 0.0f) {
            f2 = 1.0f;
        }
        if (f3 == 0.0f) {
            f3 = 1.0f;
        }
        float f4 = Math.min((float)n / f2, (float)n2 / f3);
        RectF rectF = new RectF(0.0f, 0.0f, f2, f3);
        rectF.right = f2 * f4;
        rectF.bottom = f3 * f4;
        rectF.offset(((float)n - rectF.width()) / 2.0f, ((float)n2 - rectF.height()) / 2.0f);
        rectF.round(rect);
    }

    public void updateSize(int n, int n2) {
        if (this.mTargetWidth > 0.0f && this.mTargetHeight > 0.0f && n > 0 && n2 > 0) {
            int n3 = this.getRootTopBottomMargin();
            int n4 = this.getRootLeftRightMargin();
            this.mValidRect.set(0, 0, n, n2);
            this.mValidRect.inset(n4, n3);
            if (!this.mValidRect.isEmpty()) {
                this.calcValidRect(this.mValidRect, this.mTargetWidth, this.mTargetHeight);
                if (!this.mValidRect.isEmpty()) {
                    this.updateMyLayout(this.mValidRect);
                }
            }
        } else {
            this.mValidRect.setEmpty();
        }
    }

    public void updateMyLayout(Rect rect) {
        ViewGroup viewGroup = this.getMyRootView();
        if (viewGroup.getParent() != null) {
            ViewGroup viewGroup2 = this.getMyPaperView();
            viewGroup2.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(rect.width(), rect.height(), 17));
            if (!viewGroup2.isShown()) {
                viewGroup2.setVisibility(0);
                this.mPaperBorder.setVisibility(0);
            }
            Rect rect2 = new Rect(rect);
            int n = this.getLineWidth();
            rect2.inset(-n, -n);
            this.mPaperBorder.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(rect2.width(), rect2.height(), 17));
        }
    }

    public void updateBorderView(View view) {
        GradientDrawable gradientDrawable = new GradientDrawable();
        gradientDrawable.setColor(0);
        gradientDrawable.setStroke(this.getLineWidth(), -16777216);
        view.setBackground((Drawable)gradientDrawable);
    }

    public boolean supportSelect() {
        return false;
    }

    public void select(View view) {
        if (this.supportSelect() && view != null) {
            float f2 = view.getX();
            float f3 = view.getY();
            Rect rect = new Rect(0, 0, view.getWidth(), view.getHeight());
            boolean bl = false;
            View view2 = view;
            ViewGroup viewGroup = this.getMyRootView();
            while ((view2 = (View)view2.getParent()) != null) {
                boolean bl2 = bl = view2 == viewGroup;
                if (bl) break;
                f2 += view2.getX();
                f3 += view2.getY();
            }
            if (bl) {
                rect.offset(Math.round(f2), Math.round(f3));
            } else {
                rect = null;
            }
            this.getMySelectedBorder().drawSelectedRect(rect);
        } else {
            this.getMySelectedBorder().drawSelectedRect(null);
        }
    }
}

