/*
 * Decompiled with CFR 0.152.
 */
package oz.lottie.parser;

import java.util.List;
import oz.lottie.LottieComposition;
import oz.lottie.model.animatable.AnimatableColorValue;
import oz.lottie.model.animatable.AnimatableFloatValue;
import oz.lottie.model.animatable.AnimatableGradientColorValue;
import oz.lottie.model.animatable.AnimatableIntegerValue;
import oz.lottie.model.animatable.AnimatablePointValue;
import oz.lottie.model.animatable.AnimatableScaleValue;
import oz.lottie.model.animatable.AnimatableShapeValue;
import oz.lottie.model.animatable.AnimatableTextFrame;
import oz.lottie.parser.ColorParser;
import oz.lottie.parser.DocumentDataParser;
import oz.lottie.parser.FloatParser;
import oz.lottie.parser.GradientColorParser;
import oz.lottie.parser.IntegerParser;
import oz.lottie.parser.KeyframesParser;
import oz.lottie.parser.PointFParser;
import oz.lottie.parser.ScaleXYParser;
import oz.lottie.parser.ShapeDataParser;
import oz.lottie.parser.ValueParser;
import oz.lottie.parser.moshi.JsonReader;
import oz.lottie.utils.Utils;

public class AnimatableValueParser {
    private AnimatableValueParser() {
    }

    public static AnimatableFloatValue parseFloat(JsonReader jsonReader, LottieComposition lottieComposition) {
        return AnimatableValueParser.parseFloat(jsonReader, lottieComposition, true);
    }

    public static AnimatableFloatValue parseFloat(JsonReader jsonReader, LottieComposition lottieComposition, boolean bl) {
        return new AnimatableFloatValue(AnimatableValueParser.parse(jsonReader, bl ? Utils.dpScale() : 1.0f, lottieComposition, FloatParser.INSTANCE));
    }

    static AnimatableIntegerValue parseInteger(JsonReader jsonReader, LottieComposition lottieComposition) {
        return new AnimatableIntegerValue(AnimatableValueParser.parse(jsonReader, lottieComposition, IntegerParser.INSTANCE));
    }

    static AnimatablePointValue parsePoint(JsonReader jsonReader, LottieComposition lottieComposition) {
        return new AnimatablePointValue(AnimatableValueParser.parse(jsonReader, Utils.dpScale(), lottieComposition, PointFParser.INSTANCE));
    }

    static AnimatableScaleValue parseScale(JsonReader jsonReader, LottieComposition lottieComposition) {
        return new AnimatableScaleValue(AnimatableValueParser.parse(jsonReader, lottieComposition, ScaleXYParser.INSTANCE));
    }

    static AnimatableShapeValue parseShapeData(JsonReader jsonReader, LottieComposition lottieComposition) {
        return new AnimatableShapeValue(AnimatableValueParser.parse(jsonReader, Utils.dpScale(), lottieComposition, ShapeDataParser.INSTANCE));
    }

    static AnimatableTextFrame parseDocumentData(JsonReader jsonReader, LottieComposition lottieComposition) {
        return new AnimatableTextFrame(AnimatableValueParser.parse(jsonReader, lottieComposition, DocumentDataParser.INSTANCE));
    }

    static AnimatableColorValue parseColor(JsonReader jsonReader, LottieComposition lottieComposition) {
        return new AnimatableColorValue(AnimatableValueParser.parse(jsonReader, lottieComposition, ColorParser.INSTANCE));
    }

    static AnimatableGradientColorValue parseGradientColor(JsonReader jsonReader, LottieComposition lottieComposition, int n) {
        return new AnimatableGradientColorValue(AnimatableValueParser.parse(jsonReader, lottieComposition, new GradientColorParser(n)));
    }

    private static List parse(JsonReader jsonReader, LottieComposition lottieComposition, ValueParser valueParser) {
        return KeyframesParser.parse(jsonReader, lottieComposition, 1.0f, valueParser);
    }

    private static List parse(JsonReader jsonReader, float f2, LottieComposition lottieComposition, ValueParser valueParser) {
        return KeyframesParser.parse(jsonReader, lottieComposition, f2, valueParser);
    }
}

