/*
 * Decompiled with CFR 0.152.
 */
package oz.lottie.parser;

import android.graphics.Path;
import oz.lottie.LottieComposition;
import oz.lottie.model.animatable.AnimatableGradientColorValue;
import oz.lottie.model.animatable.AnimatableIntegerValue;
import oz.lottie.model.animatable.AnimatablePointValue;
import oz.lottie.model.content.GradientFill;
import oz.lottie.model.content.GradientType;
import oz.lottie.parser.AnimatableValueParser;
import oz.lottie.parser.moshi.JsonReader;
import oz.lottie.parser.moshi.JsonReader$Options;

class GradientFillParser {
    private static final JsonReader$Options NAMES = JsonReader$Options.of("nm", "g", "o", "t", "s", "e", "r", "hd");
    private static final JsonReader$Options GRADIENT_NAMES = JsonReader$Options.of("p", "k");

    private GradientFillParser() {
    }

    static GradientFill parse(JsonReader jsonReader, LottieComposition lottieComposition) {
        String string = null;
        AnimatableGradientColorValue animatableGradientColorValue = null;
        AnimatableIntegerValue animatableIntegerValue = null;
        GradientType gradientType = null;
        AnimatablePointValue animatablePointValue = null;
        AnimatablePointValue animatablePointValue2 = null;
        Path.FillType fillType = Path.FillType.WINDING;
        boolean bl = false;
        while (jsonReader.hasNext()) {
            switch (jsonReader.selectName(NAMES)) {
                case 0: {
                    string = jsonReader.nextString();
                    break;
                }
                case 1: {
                    int n = -1;
                    jsonReader.beginObject();
                    while (jsonReader.hasNext()) {
                        switch (jsonReader.selectName(GRADIENT_NAMES)) {
                            case 0: {
                                n = jsonReader.nextInt();
                                break;
                            }
                            case 1: {
                                animatableGradientColorValue = AnimatableValueParser.parseGradientColor(jsonReader, lottieComposition, n);
                                break;
                            }
                            default: {
                                jsonReader.skipName();
                                jsonReader.skipValue();
                            }
                        }
                    }
                    jsonReader.endObject();
                    break;
                }
                case 2: {
                    animatableIntegerValue = AnimatableValueParser.parseInteger(jsonReader, lottieComposition);
                    break;
                }
                case 3: {
                    gradientType = jsonReader.nextInt() == 1 ? GradientType.LINEAR : GradientType.RADIAL;
                    break;
                }
                case 4: {
                    animatablePointValue = AnimatableValueParser.parsePoint(jsonReader, lottieComposition);
                    break;
                }
                case 5: {
                    animatablePointValue2 = AnimatableValueParser.parsePoint(jsonReader, lottieComposition);
                    break;
                }
                case 6: {
                    fillType = jsonReader.nextInt() == 1 ? Path.FillType.WINDING : Path.FillType.EVEN_ODD;
                    break;
                }
                case 7: {
                    bl = jsonReader.nextBoolean();
                    break;
                }
                default: {
                    jsonReader.skipName();
                    jsonReader.skipValue();
                }
            }
        }
        return new GradientFill(string, gradientType, fillType, animatableGradientColorValue, animatableIntegerValue, animatablePointValue, animatablePointValue2, null, null, bl);
    }
}

