/*
 * Decompiled with CFR 0.152.
 */
package oz.materialcalendarview;

import android.view.View;
import android.view.ViewGroup;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oz.materialcalendarview.CalendarDay;
import oz.materialcalendarview.CalendarPagerView;
import oz.materialcalendarview.DateRangeIndex;
import oz.materialcalendarview.DayViewDecorator;
import oz.materialcalendarview.DayViewFacade;
import oz.materialcalendarview.DecoratorResult;
import oz.materialcalendarview.MaterialCalendarView;
import oz.materialcalendarview.format.DayFormatter;
import oz.materialcalendarview.format.TitleFormatter;
import oz.materialcalendarview.format.WeekDayFormatter;
import oz.threeten.bp.LocalDate;
import oz.util.android.PagerAdapterSupport;

abstract class CalendarPagerAdapter
extends PagerAdapterSupport {
    private final ArrayDeque currentViews;
    protected final MaterialCalendarView mcv;
    private final CalendarDay today;
    private TitleFormatter titleFormatter = TitleFormatter.DEFAULT;
    private Integer color = null;
    private Integer dateTextAppearance = null;
    private Integer weekDayTextAppearance = null;
    private int showOtherDates = 4;
    private CalendarDay minDate = null;
    private CalendarDay maxDate = null;
    private DateRangeIndex rangeIndex;
    private List selectedDates = new ArrayList();
    private WeekDayFormatter weekDayFormatter = WeekDayFormatter.DEFAULT;
    private DayFormatter dayFormatter;
    private DayFormatter dayFormatterContentDescription = this.dayFormatter = DayFormatter.DEFAULT;
    private List decorators = new ArrayList();
    private List decoratorResults = null;
    private boolean selectionEnabled = true;
    boolean showWeekDays;

    CalendarPagerAdapter(MaterialCalendarView materialCalendarView) {
        this.mcv = materialCalendarView;
        this.today = CalendarDay.today();
        this.currentViews = new ArrayDeque();
        this.currentViews.iterator();
        this.setRangeDates(null, null);
    }

    public void setDecorators(List list) {
        this.decorators = list;
        this.invalidateDecorators();
    }

    public void invalidateDecorators() {
        this.decoratorResults = new ArrayList();
        for (Object object : this.decorators) {
            DayViewFacade dayViewFacade = new DayViewFacade();
            object.decorate(dayViewFacade);
            if (!dayViewFacade.isDecorated()) continue;
            this.decoratorResults.add(new DecoratorResult((DayViewDecorator)object, dayViewFacade));
        }
        for (Object object : this.currentViews) {
            ((CalendarPagerView)((Object)object)).setDayViewDecorators(this.decoratorResults);
        }
    }

    public int getCount() {
        return this.rangeIndex.getCount();
    }

    public CharSequence getPageTitle(int n) {
        return this.titleFormatter.format(this.getItem(n));
    }

    public CalendarPagerAdapter migrateStateAndReturn(CalendarPagerAdapter calendarPagerAdapter) {
        calendarPagerAdapter.titleFormatter = this.titleFormatter;
        calendarPagerAdapter.color = this.color;
        calendarPagerAdapter.dateTextAppearance = this.dateTextAppearance;
        calendarPagerAdapter.weekDayTextAppearance = this.weekDayTextAppearance;
        calendarPagerAdapter.showOtherDates = this.showOtherDates;
        calendarPagerAdapter.minDate = this.minDate;
        calendarPagerAdapter.maxDate = this.maxDate;
        calendarPagerAdapter.selectedDates = this.selectedDates;
        calendarPagerAdapter.weekDayFormatter = this.weekDayFormatter;
        calendarPagerAdapter.dayFormatter = this.dayFormatter;
        calendarPagerAdapter.dayFormatterContentDescription = this.dayFormatterContentDescription;
        calendarPagerAdapter.decorators = this.decorators;
        calendarPagerAdapter.decoratorResults = this.decoratorResults;
        calendarPagerAdapter.selectionEnabled = this.selectionEnabled;
        return calendarPagerAdapter;
    }

    public int getIndexForDay(CalendarDay calendarDay) {
        if (calendarDay == null) {
            return this.getCount() / 2;
        }
        if (this.minDate != null && calendarDay.isBefore(this.minDate)) {
            return 0;
        }
        if (this.maxDate != null && calendarDay.isAfter(this.maxDate)) {
            return this.getCount() - 1;
        }
        return this.rangeIndex.indexOf(calendarDay);
    }

    protected abstract CalendarPagerView createView(int var1);

    protected abstract int indexOf(CalendarPagerView var1);

    protected abstract boolean isInstanceOfView(Object var1);

    protected abstract DateRangeIndex createRangeIndex(CalendarDay var1, CalendarDay var2);

    public int getItemPosition(Object object) {
        if (!this.isInstanceOfView(object)) {
            return -2;
        }
        CalendarPagerView calendarPagerView = (CalendarPagerView)((Object)object);
        CalendarDay calendarDay = calendarPagerView.getFirstViewDay();
        if (calendarDay == null) {
            return -2;
        }
        int n = this.indexOf((CalendarPagerView)((Object)object));
        if (n < 0) {
            return -2;
        }
        return n;
    }

    public Object instantiateItem(ViewGroup viewGroup, int n) {
        CalendarPagerView calendarPagerView = this.createView(n);
        calendarPagerView.setContentDescription(this.mcv.getCalendarContentDescription());
        calendarPagerView.setAlpha(0.0f);
        calendarPagerView.setSelectionEnabled(this.selectionEnabled);
        calendarPagerView.setWeekDayFormatter(this.weekDayFormatter);
        calendarPagerView.setDayFormatter(this.dayFormatter);
        calendarPagerView.setDayFormatterContentDescription(this.dayFormatterContentDescription);
        if (this.color != null) {
            calendarPagerView.setSelectionColor(this.color);
        }
        if (this.dateTextAppearance != null) {
            calendarPagerView.setDateTextAppearance(this.dateTextAppearance);
        }
        if (this.weekDayTextAppearance != null) {
            calendarPagerView.setWeekDayTextAppearance(this.weekDayTextAppearance);
        }
        calendarPagerView.setShowOtherDates(this.showOtherDates);
        calendarPagerView.setMinimumDate(this.minDate);
        calendarPagerView.setMaximumDate(this.maxDate);
        calendarPagerView.setSelectedDates(this.selectedDates);
        viewGroup.addView((View)calendarPagerView);
        this.currentViews.add(calendarPagerView);
        calendarPagerView.setDayViewDecorators(this.decoratorResults);
        return calendarPagerView;
    }

    public void setShowWeekDays(boolean bl) {
        this.showWeekDays = bl;
    }

    public boolean isShowWeekDays() {
        return this.showWeekDays;
    }

    public void setSelectionEnabled(boolean bl) {
        this.selectionEnabled = bl;
        for (CalendarPagerView calendarPagerView : this.currentViews) {
            calendarPagerView.setSelectionEnabled(this.selectionEnabled);
        }
    }

    public void destroyItem(ViewGroup viewGroup, int n, Object object) {
        CalendarPagerView calendarPagerView = (CalendarPagerView)((Object)object);
        this.currentViews.remove((Object)calendarPagerView);
        viewGroup.removeView((View)calendarPagerView);
    }

    public boolean isViewFromObject(View view, Object object) {
        return view == object;
    }

    public void setTitleFormatter(TitleFormatter titleFormatter) {
        this.titleFormatter = titleFormatter == null ? TitleFormatter.DEFAULT : titleFormatter;
    }

    public void setSelectionColor(int n) {
        this.color = n;
        for (CalendarPagerView calendarPagerView : this.currentViews) {
            calendarPagerView.setSelectionColor(n);
        }
    }

    public void setDateTextAppearance(int n) {
        if (n == 0) {
            return;
        }
        this.dateTextAppearance = n;
        for (CalendarPagerView calendarPagerView : this.currentViews) {
            calendarPagerView.setDateTextAppearance(n);
        }
    }

    public void setShowOtherDates(int n) {
        this.showOtherDates = n;
        for (CalendarPagerView calendarPagerView : this.currentViews) {
            calendarPagerView.setShowOtherDates(n);
        }
    }

    public void setWeekDayFormatter(WeekDayFormatter weekDayFormatter) {
        this.weekDayFormatter = weekDayFormatter;
        for (CalendarPagerView calendarPagerView : this.currentViews) {
            calendarPagerView.setWeekDayFormatter(weekDayFormatter);
        }
    }

    public void setDayFormatter(DayFormatter dayFormatter) {
        this.dayFormatterContentDescription = this.dayFormatterContentDescription == this.dayFormatter ? dayFormatter : this.dayFormatterContentDescription;
        this.dayFormatter = dayFormatter;
        for (CalendarPagerView calendarPagerView : this.currentViews) {
            calendarPagerView.setDayFormatter(dayFormatter);
        }
    }

    public void setDayFormatterContentDescription(DayFormatter dayFormatter) {
        this.dayFormatterContentDescription = dayFormatter;
        for (CalendarPagerView calendarPagerView : this.currentViews) {
            calendarPagerView.setDayFormatterContentDescription(dayFormatter);
        }
    }

    public int getShowOtherDates() {
        return this.showOtherDates;
    }

    public void setWeekDayTextAppearance(int n) {
        if (n == 0) {
            return;
        }
        this.weekDayTextAppearance = n;
        for (CalendarPagerView calendarPagerView : this.currentViews) {
            calendarPagerView.setWeekDayTextAppearance(n);
        }
    }

    public void setRangeDates(CalendarDay calendarDay, CalendarDay calendarDay2) {
        this.minDate = calendarDay;
        this.maxDate = calendarDay2;
        for (CalendarPagerView calendarPagerView : this.currentViews) {
            calendarPagerView.setMinimumDate(calendarDay);
            calendarPagerView.setMaximumDate(calendarDay2);
        }
        if (calendarDay == null) {
            calendarDay = CalendarDay.from(this.today.getYear() - 200, this.today.getMonth(), this.today.getDay());
        }
        if (calendarDay2 == null) {
            calendarDay2 = CalendarDay.from(this.today.getYear() + 200, this.today.getMonth(), this.today.getDay());
        }
        this.rangeIndex = this.createRangeIndex(calendarDay, calendarDay2);
        this.notifyDataSetChanged();
        this.invalidateSelectedDates();
    }

    public DateRangeIndex getRangeIndex() {
        return this.rangeIndex;
    }

    public void clearSelections() {
        this.selectedDates.clear();
        this.invalidateSelectedDates();
    }

    public void setDateSelected(CalendarDay calendarDay, boolean bl) {
        if (bl) {
            if (!this.selectedDates.contains(calendarDay)) {
                this.selectedDates.add(calendarDay);
                this.invalidateSelectedDates();
            }
        } else if (this.selectedDates.contains(calendarDay)) {
            this.selectedDates.remove(calendarDay);
            this.invalidateSelectedDates();
        }
    }

    public void selectRange(CalendarDay calendarDay, CalendarDay calendarDay2) {
        this.selectedDates.clear();
        LocalDate localDate = LocalDate.of(calendarDay.getYear(), calendarDay.getMonth(), calendarDay.getDay());
        LocalDate localDate2 = calendarDay2.getDate();
        while (localDate.isBefore(localDate2) || localDate.equals(localDate2)) {
            this.selectedDates.add(CalendarDay.from(localDate));
            localDate = localDate.plusDays(1L);
        }
        this.invalidateSelectedDates();
    }

    private void invalidateSelectedDates() {
        this.validateSelectedDates();
        for (CalendarPagerView calendarPagerView : this.currentViews) {
            calendarPagerView.setSelectedDates(this.selectedDates);
        }
    }

    private void validateSelectedDates() {
        for (int j = 0; j < this.selectedDates.size(); ++j) {
            CalendarDay calendarDay = (CalendarDay)this.selectedDates.get(j);
            if ((this.minDate == null || !this.minDate.isAfter(calendarDay)) && (this.maxDate == null || !this.maxDate.isBefore(calendarDay))) continue;
            this.selectedDates.remove(j);
            this.mcv.onDateUnselected(calendarDay);
            --j;
        }
    }

    public CalendarDay getItem(int n) {
        return this.rangeIndex.getItem(n);
    }

    public List getSelectedDates() {
        return Collections.unmodifiableList(this.selectedDates);
    }

    protected int getDateTextAppearance() {
        return this.dateTextAppearance == null ? 0 : this.dateTextAppearance;
    }

    protected int getWeekDayTextAppearance() {
        return this.weekDayTextAppearance == null ? 0 : this.weekDayTextAppearance;
    }
}

