/*
 * Decompiled with CFR 0.152.
 */
package oz.threeten.bp;

import java.io.Serializable;
import oz.threeten.bp.Clock;
import oz.threeten.bp.Duration;
import oz.threeten.bp.Instant;
import oz.threeten.bp.ZoneId;
import oz.threeten.bp.jdk8.Jdk8Methods;

final class Clock$TickClock
extends Clock
implements Serializable {
    private static final long serialVersionUID = 6504659149906368850L;
    private final Clock baseClock;
    private final long tickNanos;

    Clock$TickClock(Clock clock, long l) {
        this.baseClock = clock;
        this.tickNanos = l;
    }

    public ZoneId getZone() {
        return this.baseClock.getZone();
    }

    public Clock withZone(ZoneId zoneId) {
        if (zoneId.equals(this.baseClock.getZone())) {
            return this;
        }
        return new Clock$TickClock(this.baseClock.withZone(zoneId), this.tickNanos);
    }

    public long millis() {
        long l = this.baseClock.millis();
        return l - Jdk8Methods.floorMod(l, this.tickNanos / 1000000L);
    }

    public Instant instant() {
        if (this.tickNanos % 1000000L == 0L) {
            long l = this.baseClock.millis();
            return Instant.ofEpochMilli(l - Jdk8Methods.floorMod(l, this.tickNanos / 1000000L));
        }
        Instant instant = this.baseClock.instant();
        long l = instant.getNano();
        long l2 = Jdk8Methods.floorMod(l, this.tickNanos);
        return instant.minusNanos(l2);
    }

    public boolean equals(Object object) {
        if (object instanceof Clock$TickClock) {
            Clock$TickClock clock$TickClock = (Clock$TickClock)object;
            return this.baseClock.equals(clock$TickClock.baseClock) && this.tickNanos == clock$TickClock.tickNanos;
        }
        return false;
    }

    public int hashCode() {
        return this.baseClock.hashCode() ^ (int)(this.tickNanos ^ this.tickNanos >>> 32);
    }

    public String toString() {
        return "TickClock[" + this.baseClock + "," + Duration.ofNanos(this.tickNanos) + "]";
    }
}

