/*
 * Decompiled with CFR 0.152.
 */
package oz.threeten.bp;

import oz.threeten.bp.Clock$FixedClock;
import oz.threeten.bp.Clock$OffsetClock;
import oz.threeten.bp.Clock$SystemClock;
import oz.threeten.bp.Clock$TickClock;
import oz.threeten.bp.Duration;
import oz.threeten.bp.Instant;
import oz.threeten.bp.ZoneId;
import oz.threeten.bp.ZoneOffset;
import oz.threeten.bp.jdk8.Jdk8Methods;

public abstract class Clock {
    public static Clock systemUTC() {
        return new Clock$SystemClock(ZoneOffset.UTC);
    }

    public static Clock systemDefaultZone() {
        return new Clock$SystemClock(ZoneId.systemDefault());
    }

    public static Clock system(ZoneId zoneId) {
        Jdk8Methods.requireNonNull(zoneId, "zone");
        return new Clock$SystemClock(zoneId);
    }

    public static Clock tickSeconds(ZoneId zoneId) {
        return new Clock$TickClock(Clock.system(zoneId), 1000000000L);
    }

    public static Clock tickMinutes(ZoneId zoneId) {
        return new Clock$TickClock(Clock.system(zoneId), 60000000000L);
    }

    public static Clock tick(Clock clock, Duration duration) {
        Jdk8Methods.requireNonNull(clock, "baseClock");
        Jdk8Methods.requireNonNull(duration, "tickDuration");
        if (duration.isNegative()) {
            throw new IllegalArgumentException("Tick duration must not be negative");
        }
        long l = duration.toNanos();
        if (l % 1000000L != 0L && 1000000000L % l != 0L) {
            throw new IllegalArgumentException("Invalid tick duration");
        }
        if (l <= 1L) {
            return clock;
        }
        return new Clock$TickClock(clock, l);
    }

    public static Clock fixed(Instant instant, ZoneId zoneId) {
        Jdk8Methods.requireNonNull(instant, "fixedInstant");
        Jdk8Methods.requireNonNull(zoneId, "zone");
        return new Clock$FixedClock(instant, zoneId);
    }

    public static Clock offset(Clock clock, Duration duration) {
        Jdk8Methods.requireNonNull(clock, "baseClock");
        Jdk8Methods.requireNonNull(duration, "offsetDuration");
        if (duration.equals(Duration.ZERO)) {
            return clock;
        }
        return new Clock$OffsetClock(clock, duration);
    }

    protected Clock() {
    }

    public abstract ZoneId getZone();

    public abstract Clock withZone(ZoneId var1);

    public long millis() {
        return this.instant().toEpochMilli();
    }

    public abstract Instant instant();

    public boolean equals(Object object) {
        return super.equals(object);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

