/*
 * Decompiled with CFR 0.152.
 */
package oz.threeten.bp;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import oz.threeten.bp.Instant;
import oz.threeten.bp.LocalDate;
import oz.threeten.bp.LocalDateTime;
import oz.threeten.bp.LocalTime;
import oz.threeten.bp.ZoneId;
import oz.threeten.bp.ZonedDateTime;

public final class DateTimeUtils {
    private DateTimeUtils() {
    }

    public static Instant toInstant(Date date) {
        return Instant.ofEpochMilli(date.getTime());
    }

    public static Date toDate(Instant instant) {
        try {
            return new Date(instant.toEpochMilli());
        }
        catch (ArithmeticException arithmeticException) {
            throw new IllegalArgumentException(arithmeticException);
        }
    }

    public static Instant toInstant(Calendar calendar) {
        return Instant.ofEpochMilli(calendar.getTimeInMillis());
    }

    public static ZonedDateTime toZonedDateTime(Calendar calendar) {
        Instant instant = Instant.ofEpochMilli(calendar.getTimeInMillis());
        ZoneId zoneId = DateTimeUtils.toZoneId(calendar.getTimeZone());
        return ZonedDateTime.ofInstant(instant, zoneId);
    }

    public static GregorianCalendar toGregorianCalendar(ZonedDateTime zonedDateTime) {
        TimeZone timeZone = DateTimeUtils.toTimeZone(zonedDateTime.getZone());
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
        gregorianCalendar.setGregorianChange(new Date(Long.MIN_VALUE));
        gregorianCalendar.setFirstDayOfWeek(2);
        gregorianCalendar.setMinimalDaysInFirstWeek(4);
        try {
            gregorianCalendar.setTimeInMillis(zonedDateTime.toInstant().toEpochMilli());
        }
        catch (ArithmeticException arithmeticException) {
            throw new IllegalArgumentException(arithmeticException);
        }
        return gregorianCalendar;
    }

    public static ZoneId toZoneId(TimeZone timeZone) {
        return ZoneId.of(timeZone.getID(), ZoneId.SHORT_IDS);
    }

    public static TimeZone toTimeZone(ZoneId zoneId) {
        String string = zoneId.getId();
        if (string.startsWith("+") || string.startsWith("-")) {
            string = "GMT" + string;
        } else if (string.equals("Z")) {
            string = "UTC";
        }
        return TimeZone.getTimeZone(string);
    }

    public static LocalDate toLocalDate(java.sql.Date date) {
        return LocalDate.of(date.getYear() + 1900, date.getMonth() + 1, date.getDate());
    }

    public static java.sql.Date toSqlDate(LocalDate localDate) {
        return new java.sql.Date(localDate.getYear() - 1900, localDate.getMonthValue() - 1, localDate.getDayOfMonth());
    }

    public static LocalTime toLocalTime(Time time) {
        return LocalTime.of(time.getHours(), time.getMinutes(), time.getSeconds());
    }

    public static Time toSqlTime(LocalTime localTime) {
        return new Time(localTime.getHour(), localTime.getMinute(), localTime.getSecond());
    }

    public static Timestamp toSqlTimestamp(LocalDateTime localDateTime) {
        return new Timestamp(localDateTime.getYear() - 1900, localDateTime.getMonthValue() - 1, localDateTime.getDayOfMonth(), localDateTime.getHour(), localDateTime.getMinute(), localDateTime.getSecond(), localDateTime.getNano());
    }

    public static LocalDateTime toLocalDateTime(Timestamp timestamp) {
        return LocalDateTime.of(timestamp.getYear() + 1900, timestamp.getMonth() + 1, timestamp.getDate(), timestamp.getHours(), timestamp.getMinutes(), timestamp.getSeconds(), timestamp.getNanos());
    }

    public static Timestamp toSqlTimestamp(Instant instant) {
        try {
            Timestamp timestamp = new Timestamp(instant.getEpochSecond() * 1000L);
            timestamp.setNanos(instant.getNano());
            return timestamp;
        }
        catch (ArithmeticException arithmeticException) {
            throw new IllegalArgumentException(arithmeticException);
        }
    }

    public static Instant toInstant(Timestamp timestamp) {
        return Instant.ofEpochSecond(timestamp.getTime() / 1000L, timestamp.getNanos());
    }
}

