/*
 * Decompiled with CFR 0.152.
 */
package oz.threeten.bp;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.InvalidObjectException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oz.threeten.bp.DateTimeException;
import oz.threeten.bp.Ser;
import oz.threeten.bp.format.DateTimeParseException;
import oz.threeten.bp.jdk8.Jdk8Methods;
import oz.threeten.bp.temporal.ChronoField;
import oz.threeten.bp.temporal.ChronoUnit;
import oz.threeten.bp.temporal.Temporal;
import oz.threeten.bp.temporal.TemporalAmount;
import oz.threeten.bp.temporal.TemporalUnit;
import oz.threeten.bp.temporal.UnsupportedTemporalTypeException;

public final class Duration
implements Serializable,
Comparable,
TemporalAmount {
    public static final Duration ZERO = new Duration(0L, 0);
    private static final long serialVersionUID = 3078945930695997490L;
    private static final int NANOS_PER_SECOND = 1000000000;
    private static final int NANOS_PER_MILLI = 1000000;
    private static final BigInteger BI_NANOS_PER_SECOND = BigInteger.valueOf(1000000000L);
    private static final Pattern PATTERN = Pattern.compile("([-+]?)P(?:([-+]?[0-9]+)D)?(T(?:([-+]?[0-9]+)H)?(?:([-+]?[0-9]+)M)?(?:([-+]?[0-9]+)(?:[.,]([0-9]{0,9}))?S)?)?", 2);
    private final long seconds;
    private final int nanos;

    public static Duration ofDays(long l) {
        return Duration.create(Jdk8Methods.safeMultiply(l, 86400), 0);
    }

    public static Duration ofHours(long l) {
        return Duration.create(Jdk8Methods.safeMultiply(l, 3600), 0);
    }

    public static Duration ofMinutes(long l) {
        return Duration.create(Jdk8Methods.safeMultiply(l, 60), 0);
    }

    public static Duration ofSeconds(long l) {
        return Duration.create(l, 0);
    }

    public static Duration ofSeconds(long l, long l2) {
        long l3 = Jdk8Methods.safeAdd(l, Jdk8Methods.floorDiv(l2, 1000000000L));
        int n = Jdk8Methods.floorMod(l2, 1000000000);
        return Duration.create(l3, n);
    }

    public static Duration ofMillis(long l) {
        long l2 = l / 1000L;
        int n = (int)(l % 1000L);
        if (n < 0) {
            n += 1000;
            --l2;
        }
        return Duration.create(l2, n * 1000000);
    }

    public static Duration ofNanos(long l) {
        long l2 = l / 1000000000L;
        int n = (int)(l % 1000000000L);
        if (n < 0) {
            n += 1000000000;
            --l2;
        }
        return Duration.create(l2, n);
    }

    public static Duration of(long l, TemporalUnit temporalUnit) {
        return ZERO.plus(l, temporalUnit);
    }

    public static Duration from(TemporalAmount temporalAmount) {
        Jdk8Methods.requireNonNull(temporalAmount, "amount");
        Duration duration = ZERO;
        for (TemporalUnit temporalUnit : temporalAmount.getUnits()) {
            duration = duration.plus(temporalAmount.get(temporalUnit), temporalUnit);
        }
        return duration;
    }

    public static Duration between(Temporal temporal, Temporal temporal2) {
        long l = temporal.until(temporal2, ChronoUnit.SECONDS);
        long l2 = 0L;
        if (temporal.isSupported(ChronoField.NANO_OF_SECOND) && temporal2.isSupported(ChronoField.NANO_OF_SECOND)) {
            try {
                long l3 = temporal.getLong(ChronoField.NANO_OF_SECOND);
                l2 = temporal2.getLong(ChronoField.NANO_OF_SECOND) - l3;
                if (l > 0L && l2 < 0L) {
                    l2 += 1000000000L;
                } else if (l < 0L && l2 > 0L) {
                    l2 -= 1000000000L;
                } else if (l == 0L && l2 != 0L) {
                    Temporal temporal3 = temporal2.with(ChronoField.NANO_OF_SECOND, l3);
                    l = temporal.until(temporal3, ChronoUnit.SECONDS);
                }
            }
            catch (DateTimeException dateTimeException) {
            }
            catch (ArithmeticException arithmeticException) {
                // empty catch block
            }
        }
        return Duration.ofSeconds(l, l2);
    }

    public static Duration parse(CharSequence charSequence) {
        Jdk8Methods.requireNonNull(charSequence, "text");
        Matcher matcher = PATTERN.matcher(charSequence);
        if (matcher.matches() && !"T".equals(matcher.group(3))) {
            boolean bl = "-".equals(matcher.group(1));
            String string = matcher.group(2);
            String string2 = matcher.group(4);
            String string3 = matcher.group(5);
            String string4 = matcher.group(6);
            String string5 = matcher.group(7);
            if (string != null || string2 != null || string3 != null || string4 != null) {
                long l = Duration.parseNumber(charSequence, string, 86400, "days");
                long l2 = Duration.parseNumber(charSequence, string2, 3600, "hours");
                long l3 = Duration.parseNumber(charSequence, string3, 60, "minutes");
                long l4 = Duration.parseNumber(charSequence, string4, 1, "seconds");
                boolean bl2 = string4 != null && string4.charAt(0) == '-';
                int n = Duration.parseFraction(charSequence, string5, bl2 ? -1 : 1);
                try {
                    return Duration.create(bl, l, l2, l3, l4, n);
                }
                catch (ArithmeticException arithmeticException) {
                    throw (DateTimeParseException)new DateTimeParseException("Text cannot be parsed to a Duration: overflow", charSequence, 0).initCause(arithmeticException);
                }
            }
        }
        throw new DateTimeParseException("Text cannot be parsed to a Duration", charSequence, 0);
    }

    private static long parseNumber(CharSequence charSequence, String string, int n, String string2) {
        if (string == null) {
            return 0L;
        }
        try {
            if (string.startsWith("+")) {
                string = string.substring(1);
            }
            long l = Long.parseLong(string);
            return Jdk8Methods.safeMultiply(l, n);
        }
        catch (NumberFormatException numberFormatException) {
            throw (DateTimeParseException)new DateTimeParseException("Text cannot be parsed to a Duration: " + string2, charSequence, 0).initCause(numberFormatException);
        }
        catch (ArithmeticException arithmeticException) {
            throw (DateTimeParseException)new DateTimeParseException("Text cannot be parsed to a Duration: " + string2, charSequence, 0).initCause(arithmeticException);
        }
    }

    private static int parseFraction(CharSequence charSequence, String string, int n) {
        if (string == null || string.length() == 0) {
            return 0;
        }
        try {
            string = (string + "000000000").substring(0, 9);
            return Integer.parseInt(string) * n;
        }
        catch (NumberFormatException numberFormatException) {
            throw (DateTimeParseException)new DateTimeParseException("Text cannot be parsed to a Duration: fraction", charSequence, 0).initCause(numberFormatException);
        }
        catch (ArithmeticException arithmeticException) {
            throw (DateTimeParseException)new DateTimeParseException("Text cannot be parsed to a Duration: fraction", charSequence, 0).initCause(arithmeticException);
        }
    }

    private static Duration create(boolean bl, long l, long l2, long l3, long l4, int n) {
        long l5 = Jdk8Methods.safeAdd(l, Jdk8Methods.safeAdd(l2, Jdk8Methods.safeAdd(l3, l4)));
        if (bl) {
            return Duration.ofSeconds(l5, n).negated();
        }
        return Duration.ofSeconds(l5, n);
    }

    private static Duration create(long l, int n) {
        if ((l | (long)n) == 0L) {
            return ZERO;
        }
        return new Duration(l, n);
    }

    private Duration(long l, int n) {
        this.seconds = l;
        this.nanos = n;
    }

    public List getUnits() {
        return Collections.unmodifiableList(Arrays.asList(ChronoUnit.SECONDS, ChronoUnit.NANOS));
    }

    public long get(TemporalUnit temporalUnit) {
        if (temporalUnit == ChronoUnit.SECONDS) {
            return this.seconds;
        }
        if (temporalUnit == ChronoUnit.NANOS) {
            return this.nanos;
        }
        throw new UnsupportedTemporalTypeException("Unsupported unit: " + temporalUnit);
    }

    public boolean isZero() {
        return (this.seconds | (long)this.nanos) == 0L;
    }

    public boolean isNegative() {
        return this.seconds < 0L;
    }

    public long getSeconds() {
        return this.seconds;
    }

    public int getNano() {
        return this.nanos;
    }

    public Duration withSeconds(long l) {
        return Duration.create(l, this.nanos);
    }

    public Duration withNanos(int n) {
        ChronoField.NANO_OF_SECOND.checkValidIntValue(n);
        return Duration.create(this.seconds, n);
    }

    public Duration plus(Duration duration) {
        return this.plus(duration.getSeconds(), duration.getNano());
    }

    public Duration plus(long l, TemporalUnit temporalUnit) {
        Jdk8Methods.requireNonNull(temporalUnit, "unit");
        if (temporalUnit == ChronoUnit.DAYS) {
            return this.plus(Jdk8Methods.safeMultiply(l, 86400), 0L);
        }
        if (temporalUnit.isDurationEstimated()) {
            throw new DateTimeException("Unit must not have an estimated duration");
        }
        if (l == 0L) {
            return this;
        }
        if (temporalUnit instanceof ChronoUnit) {
            switch ((ChronoUnit)temporalUnit) {
                case NANOS: {
                    return this.plusNanos(l);
                }
                case MICROS: {
                    return this.plusSeconds(l / 1000000000L * 1000L).plusNanos(l % 1000000000L * 1000L);
                }
                case MILLIS: {
                    return this.plusMillis(l);
                }
                case SECONDS: {
                    return this.plusSeconds(l);
                }
            }
            return this.plusSeconds(Jdk8Methods.safeMultiply(temporalUnit.getDuration().seconds, l));
        }
        Duration duration = temporalUnit.getDuration().multipliedBy(l);
        return this.plusSeconds(duration.getSeconds()).plusNanos(duration.getNano());
    }

    public Duration plusDays(long l) {
        return this.plus(Jdk8Methods.safeMultiply(l, 86400), 0L);
    }

    public Duration plusHours(long l) {
        return this.plus(Jdk8Methods.safeMultiply(l, 3600), 0L);
    }

    public Duration plusMinutes(long l) {
        return this.plus(Jdk8Methods.safeMultiply(l, 60), 0L);
    }

    public Duration plusSeconds(long l) {
        return this.plus(l, 0L);
    }

    public Duration plusMillis(long l) {
        return this.plus(l / 1000L, l % 1000L * 1000000L);
    }

    public Duration plusNanos(long l) {
        return this.plus(0L, l);
    }

    private Duration plus(long l, long l2) {
        if ((l | l2) == 0L) {
            return this;
        }
        long l3 = Jdk8Methods.safeAdd(this.seconds, l);
        l3 = Jdk8Methods.safeAdd(l3, l2 / 1000000000L);
        long l4 = (long)this.nanos + (l2 %= 1000000000L);
        return Duration.ofSeconds(l3, l4);
    }

    public Duration minus(Duration duration) {
        long l = duration.getSeconds();
        int n = duration.getNano();
        if (l == Long.MIN_VALUE) {
            return this.plus(Long.MAX_VALUE, -n).plus(1L, 0L);
        }
        return this.plus(-l, -n);
    }

    public Duration minus(long l, TemporalUnit temporalUnit) {
        return l == Long.MIN_VALUE ? this.plus(Long.MAX_VALUE, temporalUnit).plus(1L, temporalUnit) : this.plus(-l, temporalUnit);
    }

    public Duration minusDays(long l) {
        return l == Long.MIN_VALUE ? this.plusDays(Long.MAX_VALUE).plusDays(1L) : this.plusDays(-l);
    }

    public Duration minusHours(long l) {
        return l == Long.MIN_VALUE ? this.plusHours(Long.MAX_VALUE).plusHours(1L) : this.plusHours(-l);
    }

    public Duration minusMinutes(long l) {
        return l == Long.MIN_VALUE ? this.plusMinutes(Long.MAX_VALUE).plusMinutes(1L) : this.plusMinutes(-l);
    }

    public Duration minusSeconds(long l) {
        return l == Long.MIN_VALUE ? this.plusSeconds(Long.MAX_VALUE).plusSeconds(1L) : this.plusSeconds(-l);
    }

    public Duration minusMillis(long l) {
        return l == Long.MIN_VALUE ? this.plusMillis(Long.MAX_VALUE).plusMillis(1L) : this.plusMillis(-l);
    }

    public Duration minusNanos(long l) {
        return l == Long.MIN_VALUE ? this.plusNanos(Long.MAX_VALUE).plusNanos(1L) : this.plusNanos(-l);
    }

    public Duration multipliedBy(long l) {
        if (l == 0L) {
            return ZERO;
        }
        if (l == 1L) {
            return this;
        }
        return Duration.create(this.toSeconds().multiply(BigDecimal.valueOf(l)));
    }

    public Duration dividedBy(long l) {
        if (l == 0L) {
            throw new ArithmeticException("Cannot divide by zero");
        }
        if (l == 1L) {
            return this;
        }
        return Duration.create(this.toSeconds().divide(BigDecimal.valueOf(l), RoundingMode.DOWN));
    }

    private BigDecimal toSeconds() {
        return BigDecimal.valueOf(this.seconds).add(BigDecimal.valueOf(this.nanos, 9));
    }

    private static Duration create(BigDecimal bigDecimal) {
        BigInteger bigInteger = bigDecimal.movePointRight(9).toBigIntegerExact();
        BigInteger[] bigIntegerArray = bigInteger.divideAndRemainder(BI_NANOS_PER_SECOND);
        if (bigIntegerArray[0].bitLength() > 63) {
            throw new ArithmeticException("Exceeds capacity of Duration: " + bigInteger);
        }
        return Duration.ofSeconds(bigIntegerArray[0].longValue(), bigIntegerArray[1].intValue());
    }

    public Duration negated() {
        return this.multipliedBy(-1L);
    }

    public Duration abs() {
        return this.isNegative() ? this.negated() : this;
    }

    public Temporal addTo(Temporal temporal) {
        if (this.seconds != 0L) {
            temporal = temporal.plus(this.seconds, ChronoUnit.SECONDS);
        }
        if (this.nanos != 0) {
            temporal = temporal.plus(this.nanos, ChronoUnit.NANOS);
        }
        return temporal;
    }

    public Temporal subtractFrom(Temporal temporal) {
        if (this.seconds != 0L) {
            temporal = temporal.minus(this.seconds, ChronoUnit.SECONDS);
        }
        if (this.nanos != 0) {
            temporal = temporal.minus(this.nanos, ChronoUnit.NANOS);
        }
        return temporal;
    }

    public long toDays() {
        return this.seconds / 86400L;
    }

    public long toHours() {
        return this.seconds / 3600L;
    }

    public long toMinutes() {
        return this.seconds / 60L;
    }

    public long toMillis() {
        long l = Jdk8Methods.safeMultiply(this.seconds, 1000);
        l = Jdk8Methods.safeAdd(l, (long)(this.nanos / 1000000));
        return l;
    }

    public long toNanos() {
        long l = Jdk8Methods.safeMultiply(this.seconds, 1000000000);
        l = Jdk8Methods.safeAdd(l, (long)this.nanos);
        return l;
    }

    public long toDaysPart() {
        return this.seconds / 86400L;
    }

    public int toHoursPart() {
        return (int)(this.toHours() % 24L);
    }

    public int toMinutesPart() {
        return (int)(this.toMinutes() % 60L);
    }

    public int toSecondsPart() {
        return (int)(this.seconds % 60L);
    }

    public int toMillisPart() {
        return this.nanos / 1000000;
    }

    public int toNanosPart() {
        return this.nanos;
    }

    public int compareTo(Duration duration) {
        int n = Jdk8Methods.compareLongs(this.seconds, duration.seconds);
        if (n != 0) {
            return n;
        }
        return this.nanos - duration.nanos;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Duration) {
            Duration duration = (Duration)object;
            return this.seconds == duration.seconds && this.nanos == duration.nanos;
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.seconds ^ this.seconds >>> 32) + 51 * this.nanos;
    }

    public String toString() {
        if (this == ZERO) {
            return "PT0S";
        }
        long l = this.seconds / 3600L;
        int n = (int)(this.seconds % 3600L / 60L);
        int n2 = (int)(this.seconds % 60L);
        StringBuilder stringBuilder = new StringBuilder(24);
        stringBuilder.append("PT");
        if (l != 0L) {
            stringBuilder.append(l).append('H');
        }
        if (n != 0) {
            stringBuilder.append(n).append('M');
        }
        if (n2 == 0 && this.nanos == 0 && stringBuilder.length() > 2) {
            return stringBuilder.toString();
        }
        if (n2 < 0 && this.nanos > 0) {
            if (n2 == -1) {
                stringBuilder.append("-0");
            } else {
                stringBuilder.append(n2 + 1);
            }
        } else {
            stringBuilder.append(n2);
        }
        if (this.nanos > 0) {
            int n3 = stringBuilder.length();
            if (n2 < 0) {
                stringBuilder.append(2000000000 - this.nanos);
            } else {
                stringBuilder.append(this.nanos + 1000000000);
            }
            while (stringBuilder.charAt(stringBuilder.length() - 1) == '0') {
                stringBuilder.setLength(stringBuilder.length() - 1);
            }
            stringBuilder.setCharAt(n3, '.');
        }
        stringBuilder.append('S');
        return stringBuilder.toString();
    }

    private Object writeReplace() {
        return new Ser(1, this);
    }

    private Object readResolve() {
        throw new InvalidObjectException("Deserialization via serialization delegate");
    }

    void writeExternal(DataOutput dataOutput) {
        dataOutput.writeLong(this.seconds);
        dataOutput.writeInt(this.nanos);
    }

    static Duration readExternal(DataInput dataInput) {
        long l = dataInput.readLong();
        int n = dataInput.readInt();
        return Duration.ofSeconds(l, n);
    }
}

