/*
 * Decompiled with CFR 0.152.
 */
package oz.threeten.bp;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.InvalidObjectException;
import java.io.Serializable;
import oz.threeten.bp.Clock;
import oz.threeten.bp.DateTimeException;
import oz.threeten.bp.DayOfWeek;
import oz.threeten.bp.Instant;
import oz.threeten.bp.LocalDate;
import oz.threeten.bp.LocalDateTime$1;
import oz.threeten.bp.LocalTime;
import oz.threeten.bp.Month;
import oz.threeten.bp.OffsetDateTime;
import oz.threeten.bp.Ser;
import oz.threeten.bp.ZoneId;
import oz.threeten.bp.ZoneOffset;
import oz.threeten.bp.ZonedDateTime;
import oz.threeten.bp.chrono.ChronoLocalDateTime;
import oz.threeten.bp.format.DateTimeFormatter;
import oz.threeten.bp.jdk8.Jdk8Methods;
import oz.threeten.bp.temporal.ChronoField;
import oz.threeten.bp.temporal.ChronoUnit;
import oz.threeten.bp.temporal.Temporal;
import oz.threeten.bp.temporal.TemporalAccessor;
import oz.threeten.bp.temporal.TemporalAdjuster;
import oz.threeten.bp.temporal.TemporalAmount;
import oz.threeten.bp.temporal.TemporalField;
import oz.threeten.bp.temporal.TemporalQueries;
import oz.threeten.bp.temporal.TemporalQuery;
import oz.threeten.bp.temporal.TemporalUnit;
import oz.threeten.bp.temporal.UnsupportedTemporalTypeException;
import oz.threeten.bp.temporal.ValueRange;
import oz.threeten.bp.zone.ZoneRules;

public final class LocalDateTime
extends ChronoLocalDateTime
implements Serializable,
Temporal,
TemporalAdjuster {
    public static final LocalDateTime MIN = LocalDateTime.of(LocalDate.MIN, LocalTime.MIN);
    public static final LocalDateTime MAX = LocalDateTime.of(LocalDate.MAX, LocalTime.MAX);
    public static final TemporalQuery FROM = new LocalDateTime$1();
    private static final long serialVersionUID = 6207766400415563566L;
    private final LocalDate date;
    private final LocalTime time;

    public static LocalDateTime now() {
        return LocalDateTime.now(Clock.systemDefaultZone());
    }

    public static LocalDateTime now(ZoneId zoneId) {
        return LocalDateTime.now(Clock.system(zoneId));
    }

    public static LocalDateTime now(Clock clock) {
        Jdk8Methods.requireNonNull(clock, "clock");
        Instant instant = clock.instant();
        ZoneOffset zoneOffset = clock.getZone().getRules().getOffset(instant);
        return LocalDateTime.ofEpochSecond(instant.getEpochSecond(), instant.getNano(), zoneOffset);
    }

    public static LocalDateTime of(int n, Month month, int n2, int n3, int n4) {
        LocalDate localDate = LocalDate.of(n, month, n2);
        LocalTime localTime = LocalTime.of(n3, n4);
        return new LocalDateTime(localDate, localTime);
    }

    public static LocalDateTime of(int n, Month month, int n2, int n3, int n4, int n5) {
        LocalDate localDate = LocalDate.of(n, month, n2);
        LocalTime localTime = LocalTime.of(n3, n4, n5);
        return new LocalDateTime(localDate, localTime);
    }

    public static LocalDateTime of(int n, Month month, int n2, int n3, int n4, int n5, int n6) {
        LocalDate localDate = LocalDate.of(n, month, n2);
        LocalTime localTime = LocalTime.of(n3, n4, n5, n6);
        return new LocalDateTime(localDate, localTime);
    }

    public static LocalDateTime of(int n, int n2, int n3, int n4, int n5) {
        LocalDate localDate = LocalDate.of(n, n2, n3);
        LocalTime localTime = LocalTime.of(n4, n5);
        return new LocalDateTime(localDate, localTime);
    }

    public static LocalDateTime of(int n, int n2, int n3, int n4, int n5, int n6) {
        LocalDate localDate = LocalDate.of(n, n2, n3);
        LocalTime localTime = LocalTime.of(n4, n5, n6);
        return new LocalDateTime(localDate, localTime);
    }

    public static LocalDateTime of(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        LocalDate localDate = LocalDate.of(n, n2, n3);
        LocalTime localTime = LocalTime.of(n4, n5, n6, n7);
        return new LocalDateTime(localDate, localTime);
    }

    public static LocalDateTime of(LocalDate localDate, LocalTime localTime) {
        Jdk8Methods.requireNonNull(localDate, "date");
        Jdk8Methods.requireNonNull(localTime, "time");
        return new LocalDateTime(localDate, localTime);
    }

    public static LocalDateTime ofInstant(Instant instant, ZoneId zoneId) {
        Jdk8Methods.requireNonNull(instant, "instant");
        Jdk8Methods.requireNonNull(zoneId, "zone");
        ZoneRules zoneRules = zoneId.getRules();
        ZoneOffset zoneOffset = zoneRules.getOffset(instant);
        return LocalDateTime.ofEpochSecond(instant.getEpochSecond(), instant.getNano(), zoneOffset);
    }

    public static LocalDateTime ofEpochSecond(long l, int n, ZoneOffset zoneOffset) {
        Jdk8Methods.requireNonNull(zoneOffset, "offset");
        long l2 = l + (long)zoneOffset.getTotalSeconds();
        long l3 = Jdk8Methods.floorDiv(l2, 86400L);
        int n2 = Jdk8Methods.floorMod(l2, 86400);
        LocalDate localDate = LocalDate.ofEpochDay(l3);
        LocalTime localTime = LocalTime.ofSecondOfDay(n2, n);
        return new LocalDateTime(localDate, localTime);
    }

    public static LocalDateTime from(TemporalAccessor temporalAccessor) {
        if (temporalAccessor instanceof LocalDateTime) {
            return (LocalDateTime)temporalAccessor;
        }
        if (temporalAccessor instanceof ZonedDateTime) {
            return ((ZonedDateTime)temporalAccessor).toLocalDateTime();
        }
        try {
            LocalDate localDate = LocalDate.from(temporalAccessor);
            LocalTime localTime = LocalTime.from(temporalAccessor);
            return new LocalDateTime(localDate, localTime);
        }
        catch (DateTimeException dateTimeException) {
            throw new DateTimeException("Unable to obtain LocalDateTime from TemporalAccessor: " + temporalAccessor + ", type " + temporalAccessor.getClass().getName());
        }
    }

    public static LocalDateTime parse(CharSequence charSequence) {
        return LocalDateTime.parse(charSequence, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
    }

    public static LocalDateTime parse(CharSequence charSequence, DateTimeFormatter dateTimeFormatter) {
        Jdk8Methods.requireNonNull(dateTimeFormatter, "formatter");
        return (LocalDateTime)dateTimeFormatter.parse(charSequence, FROM);
    }

    private LocalDateTime(LocalDate localDate, LocalTime localTime) {
        this.date = localDate;
        this.time = localTime;
    }

    private LocalDateTime with(LocalDate localDate, LocalTime localTime) {
        if (this.date == localDate && this.time == localTime) {
            return this;
        }
        return new LocalDateTime(localDate, localTime);
    }

    public boolean isSupported(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            return temporalField.isDateBased() || temporalField.isTimeBased();
        }
        return temporalField != null && temporalField.isSupportedBy(this);
    }

    public boolean isSupported(TemporalUnit temporalUnit) {
        if (temporalUnit instanceof ChronoUnit) {
            return temporalUnit.isDateBased() || temporalUnit.isTimeBased();
        }
        return temporalUnit != null && temporalUnit.isSupportedBy(this);
    }

    public ValueRange range(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            return temporalField.isTimeBased() ? this.time.range(temporalField) : this.date.range(temporalField);
        }
        return temporalField.rangeRefinedBy(this);
    }

    public int get(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            return temporalField.isTimeBased() ? this.time.get(temporalField) : this.date.get(temporalField);
        }
        return super.get(temporalField);
    }

    public long getLong(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            return temporalField.isTimeBased() ? this.time.getLong(temporalField) : this.date.getLong(temporalField);
        }
        return temporalField.getFrom(this);
    }

    public int getYear() {
        return this.date.getYear();
    }

    public int getMonthValue() {
        return this.date.getMonthValue();
    }

    public Month getMonth() {
        return this.date.getMonth();
    }

    public int getDayOfMonth() {
        return this.date.getDayOfMonth();
    }

    public int getDayOfYear() {
        return this.date.getDayOfYear();
    }

    public DayOfWeek getDayOfWeek() {
        return this.date.getDayOfWeek();
    }

    public int getHour() {
        return this.time.getHour();
    }

    public int getMinute() {
        return this.time.getMinute();
    }

    public int getSecond() {
        return this.time.getSecond();
    }

    public int getNano() {
        return this.time.getNano();
    }

    public LocalDateTime with(TemporalAdjuster temporalAdjuster) {
        if (temporalAdjuster instanceof LocalDate) {
            return this.with((LocalDate)temporalAdjuster, this.time);
        }
        if (temporalAdjuster instanceof LocalTime) {
            return this.with(this.date, (LocalTime)temporalAdjuster);
        }
        if (temporalAdjuster instanceof LocalDateTime) {
            return (LocalDateTime)temporalAdjuster;
        }
        return (LocalDateTime)temporalAdjuster.adjustInto(this);
    }

    public LocalDateTime with(TemporalField temporalField, long l) {
        if (temporalField instanceof ChronoField) {
            if (temporalField.isTimeBased()) {
                return this.with(this.date, this.time.with(temporalField, l));
            }
            return this.with(this.date.with(temporalField, l), this.time);
        }
        return (LocalDateTime)temporalField.adjustInto(this, l);
    }

    public LocalDateTime withYear(int n) {
        return this.with(this.date.withYear(n), this.time);
    }

    public LocalDateTime withMonth(int n) {
        return this.with(this.date.withMonth(n), this.time);
    }

    public LocalDateTime withDayOfMonth(int n) {
        return this.with(this.date.withDayOfMonth(n), this.time);
    }

    public LocalDateTime withDayOfYear(int n) {
        return this.with(this.date.withDayOfYear(n), this.time);
    }

    public LocalDateTime withHour(int n) {
        LocalTime localTime = this.time.withHour(n);
        return this.with(this.date, localTime);
    }

    public LocalDateTime withMinute(int n) {
        LocalTime localTime = this.time.withMinute(n);
        return this.with(this.date, localTime);
    }

    public LocalDateTime withSecond(int n) {
        LocalTime localTime = this.time.withSecond(n);
        return this.with(this.date, localTime);
    }

    public LocalDateTime withNano(int n) {
        LocalTime localTime = this.time.withNano(n);
        return this.with(this.date, localTime);
    }

    public LocalDateTime truncatedTo(TemporalUnit temporalUnit) {
        return this.with(this.date, this.time.truncatedTo(temporalUnit));
    }

    public LocalDateTime plus(TemporalAmount temporalAmount) {
        return (LocalDateTime)temporalAmount.addTo(this);
    }

    public LocalDateTime plus(long l, TemporalUnit temporalUnit) {
        if (temporalUnit instanceof ChronoUnit) {
            ChronoUnit chronoUnit = (ChronoUnit)temporalUnit;
            switch (chronoUnit) {
                case NANOS: {
                    return this.plusNanos(l);
                }
                case MICROS: {
                    return this.plusDays(l / 86400000000L).plusNanos(l % 86400000000L * 1000L);
                }
                case MILLIS: {
                    return this.plusDays(l / 86400000L).plusNanos(l % 86400000L * 1000000L);
                }
                case SECONDS: {
                    return this.plusSeconds(l);
                }
                case MINUTES: {
                    return this.plusMinutes(l);
                }
                case HOURS: {
                    return this.plusHours(l);
                }
                case HALF_DAYS: {
                    return this.plusDays(l / 256L).plusHours(l % 256L * 12L);
                }
            }
            return this.with(this.date.plus(l, temporalUnit), this.time);
        }
        return (LocalDateTime)temporalUnit.addTo(this, l);
    }

    public LocalDateTime plusYears(long l) {
        LocalDate localDate = this.date.plusYears(l);
        return this.with(localDate, this.time);
    }

    public LocalDateTime plusMonths(long l) {
        LocalDate localDate = this.date.plusMonths(l);
        return this.with(localDate, this.time);
    }

    public LocalDateTime plusWeeks(long l) {
        LocalDate localDate = this.date.plusWeeks(l);
        return this.with(localDate, this.time);
    }

    public LocalDateTime plusDays(long l) {
        LocalDate localDate = this.date.plusDays(l);
        return this.with(localDate, this.time);
    }

    public LocalDateTime plusHours(long l) {
        return this.plusWithOverflow(this.date, l, 0L, 0L, 0L, 1);
    }

    public LocalDateTime plusMinutes(long l) {
        return this.plusWithOverflow(this.date, 0L, l, 0L, 0L, 1);
    }

    public LocalDateTime plusSeconds(long l) {
        return this.plusWithOverflow(this.date, 0L, 0L, l, 0L, 1);
    }

    public LocalDateTime plusNanos(long l) {
        return this.plusWithOverflow(this.date, 0L, 0L, 0L, l, 1);
    }

    public LocalDateTime minus(TemporalAmount temporalAmount) {
        return (LocalDateTime)temporalAmount.subtractFrom(this);
    }

    public LocalDateTime minus(long l, TemporalUnit temporalUnit) {
        return l == Long.MIN_VALUE ? this.plus(Long.MAX_VALUE, temporalUnit).plus(1L, temporalUnit) : this.plus(-l, temporalUnit);
    }

    public LocalDateTime minusYears(long l) {
        return l == Long.MIN_VALUE ? this.plusYears(Long.MAX_VALUE).plusYears(1L) : this.plusYears(-l);
    }

    public LocalDateTime minusMonths(long l) {
        return l == Long.MIN_VALUE ? this.plusMonths(Long.MAX_VALUE).plusMonths(1L) : this.plusMonths(-l);
    }

    public LocalDateTime minusWeeks(long l) {
        return l == Long.MIN_VALUE ? this.plusWeeks(Long.MAX_VALUE).plusWeeks(1L) : this.plusWeeks(-l);
    }

    public LocalDateTime minusDays(long l) {
        return l == Long.MIN_VALUE ? this.plusDays(Long.MAX_VALUE).plusDays(1L) : this.plusDays(-l);
    }

    public LocalDateTime minusHours(long l) {
        return this.plusWithOverflow(this.date, l, 0L, 0L, 0L, -1);
    }

    public LocalDateTime minusMinutes(long l) {
        return this.plusWithOverflow(this.date, 0L, l, 0L, 0L, -1);
    }

    public LocalDateTime minusSeconds(long l) {
        return this.plusWithOverflow(this.date, 0L, 0L, l, 0L, -1);
    }

    public LocalDateTime minusNanos(long l) {
        return this.plusWithOverflow(this.date, 0L, 0L, 0L, l, -1);
    }

    private LocalDateTime plusWithOverflow(LocalDate localDate, long l, long l2, long l3, long l4, int n) {
        if ((l | l2 | l3 | l4) == 0L) {
            return this.with(localDate, this.time);
        }
        long l5 = l4 / 86400000000000L + l3 / 86400L + l2 / 1440L + l / 24L;
        l5 *= (long)n;
        long l6 = l4 % 86400000000000L + l3 % 86400L * 1000000000L + l2 % 1440L * 60000000000L + l % 24L * 3600000000000L;
        long l7 = this.time.toNanoOfDay();
        l6 = l6 * (long)n + l7;
        long l8 = Jdk8Methods.floorMod(l6, 86400000000000L);
        LocalTime localTime = l8 == l7 ? this.time : LocalTime.ofNanoOfDay(l8);
        return this.with(localDate.plusDays(l5 += Jdk8Methods.floorDiv(l6, 86400000000000L)), localTime);
    }

    public Object query(TemporalQuery temporalQuery) {
        if (temporalQuery == TemporalQueries.localDate()) {
            return this.toLocalDate();
        }
        return super.query(temporalQuery);
    }

    public Temporal adjustInto(Temporal temporal) {
        return super.adjustInto(temporal);
    }

    public long until(Temporal temporal, TemporalUnit temporalUnit) {
        LocalDateTime localDateTime = LocalDateTime.from(temporal);
        if (temporalUnit instanceof ChronoUnit) {
            ChronoUnit chronoUnit = (ChronoUnit)temporalUnit;
            if (chronoUnit.isTimeBased()) {
                long l = this.date.daysUntil(localDateTime.date);
                long l2 = localDateTime.time.toNanoOfDay() - this.time.toNanoOfDay();
                if (l > 0L && l2 < 0L) {
                    --l;
                    l2 += 86400000000000L;
                } else if (l < 0L && l2 > 0L) {
                    ++l;
                    l2 -= 86400000000000L;
                }
                long l3 = l;
                switch (chronoUnit) {
                    case NANOS: {
                        l3 = Jdk8Methods.safeMultiply(l3, 86400000000000L);
                        return Jdk8Methods.safeAdd(l3, l2);
                    }
                    case MICROS: {
                        l3 = Jdk8Methods.safeMultiply(l3, 86400000000L);
                        return Jdk8Methods.safeAdd(l3, l2 / 1000L);
                    }
                    case MILLIS: {
                        l3 = Jdk8Methods.safeMultiply(l3, 86400000L);
                        return Jdk8Methods.safeAdd(l3, l2 / 1000000L);
                    }
                    case SECONDS: {
                        l3 = Jdk8Methods.safeMultiply(l3, 86400);
                        return Jdk8Methods.safeAdd(l3, l2 / 1000000000L);
                    }
                    case MINUTES: {
                        l3 = Jdk8Methods.safeMultiply(l3, 1440);
                        return Jdk8Methods.safeAdd(l3, l2 / 60000000000L);
                    }
                    case HOURS: {
                        l3 = Jdk8Methods.safeMultiply(l3, 24);
                        return Jdk8Methods.safeAdd(l3, l2 / 3600000000000L);
                    }
                    case HALF_DAYS: {
                        l3 = Jdk8Methods.safeMultiply(l3, 2);
                        return Jdk8Methods.safeAdd(l3, l2 / 43200000000000L);
                    }
                }
                throw new UnsupportedTemporalTypeException("Unsupported unit: " + temporalUnit);
            }
            LocalDate localDate = localDateTime.date;
            if (localDate.isAfter(this.date) && localDateTime.time.isBefore(this.time)) {
                localDate = localDate.minusDays(1L);
            } else if (localDate.isBefore(this.date) && localDateTime.time.isAfter(this.time)) {
                localDate = localDate.plusDays(1L);
            }
            return this.date.until(localDate, temporalUnit);
        }
        return temporalUnit.between(this, localDateTime);
    }

    public OffsetDateTime atOffset(ZoneOffset zoneOffset) {
        return OffsetDateTime.of(this, zoneOffset);
    }

    public ZonedDateTime atZone(ZoneId zoneId) {
        return ZonedDateTime.of(this, zoneId);
    }

    public LocalDate toLocalDate() {
        return this.date;
    }

    public LocalTime toLocalTime() {
        return this.time;
    }

    public int compareTo(ChronoLocalDateTime chronoLocalDateTime) {
        if (chronoLocalDateTime instanceof LocalDateTime) {
            return this.compareTo0((LocalDateTime)chronoLocalDateTime);
        }
        return super.compareTo(chronoLocalDateTime);
    }

    private int compareTo0(LocalDateTime localDateTime) {
        int n = this.date.compareTo0(localDateTime.toLocalDate());
        if (n == 0) {
            n = this.time.compareTo(localDateTime.toLocalTime());
        }
        return n;
    }

    public boolean isAfter(ChronoLocalDateTime chronoLocalDateTime) {
        if (chronoLocalDateTime instanceof LocalDateTime) {
            return this.compareTo0((LocalDateTime)chronoLocalDateTime) > 0;
        }
        return super.isAfter(chronoLocalDateTime);
    }

    public boolean isBefore(ChronoLocalDateTime chronoLocalDateTime) {
        if (chronoLocalDateTime instanceof LocalDateTime) {
            return this.compareTo0((LocalDateTime)chronoLocalDateTime) < 0;
        }
        return super.isBefore(chronoLocalDateTime);
    }

    public boolean isEqual(ChronoLocalDateTime chronoLocalDateTime) {
        if (chronoLocalDateTime instanceof LocalDateTime) {
            return this.compareTo0((LocalDateTime)chronoLocalDateTime) == 0;
        }
        return super.isEqual(chronoLocalDateTime);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)object;
            return this.date.equals(localDateTime.date) && this.time.equals(localDateTime.time);
        }
        return false;
    }

    public int hashCode() {
        return this.date.hashCode() ^ this.time.hashCode();
    }

    public String toString() {
        return this.date.toString() + 'T' + this.time.toString();
    }

    public String format(DateTimeFormatter dateTimeFormatter) {
        return super.format(dateTimeFormatter);
    }

    private Object writeReplace() {
        return new Ser(4, this);
    }

    private Object readResolve() {
        throw new InvalidObjectException("Deserialization via serialization delegate");
    }

    void writeExternal(DataOutput dataOutput) {
        this.date.writeExternal(dataOutput);
        this.time.writeExternal(dataOutput);
    }

    static LocalDateTime readExternal(DataInput dataInput) {
        LocalDate localDate = LocalDate.readExternal(dataInput);
        LocalTime localTime = LocalTime.readExternal(dataInput);
        return LocalDateTime.of(localDate, localTime);
    }
}

