/*
 * Decompiled with CFR 0.152.
 */
package oz.threeten.bp;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.InvalidObjectException;
import java.io.Serializable;
import oz.threeten.bp.Clock;
import oz.threeten.bp.DateTimeException;
import oz.threeten.bp.LocalDate;
import oz.threeten.bp.Month;
import oz.threeten.bp.MonthDay$1;
import oz.threeten.bp.Ser;
import oz.threeten.bp.Year;
import oz.threeten.bp.ZoneId;
import oz.threeten.bp.chrono.Chronology;
import oz.threeten.bp.chrono.IsoChronology;
import oz.threeten.bp.format.DateTimeFormatter;
import oz.threeten.bp.format.DateTimeFormatterBuilder;
import oz.threeten.bp.jdk8.DefaultInterfaceTemporalAccessor;
import oz.threeten.bp.jdk8.Jdk8Methods;
import oz.threeten.bp.temporal.ChronoField;
import oz.threeten.bp.temporal.Temporal;
import oz.threeten.bp.temporal.TemporalAccessor;
import oz.threeten.bp.temporal.TemporalAdjuster;
import oz.threeten.bp.temporal.TemporalField;
import oz.threeten.bp.temporal.TemporalQueries;
import oz.threeten.bp.temporal.TemporalQuery;
import oz.threeten.bp.temporal.UnsupportedTemporalTypeException;
import oz.threeten.bp.temporal.ValueRange;

public final class MonthDay
extends DefaultInterfaceTemporalAccessor
implements Serializable,
Comparable,
TemporalAccessor,
TemporalAdjuster {
    public static final TemporalQuery FROM = new MonthDay$1();
    private static final long serialVersionUID = -939150713474957432L;
    private static final DateTimeFormatter PARSER = new DateTimeFormatterBuilder().appendLiteral("--").appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).toFormatter();
    private final int month;
    private final int day;

    public static MonthDay now() {
        return MonthDay.now(Clock.systemDefaultZone());
    }

    public static MonthDay now(ZoneId zoneId) {
        return MonthDay.now(Clock.system(zoneId));
    }

    public static MonthDay now(Clock clock) {
        LocalDate localDate = LocalDate.now(clock);
        return MonthDay.of(localDate.getMonth(), localDate.getDayOfMonth());
    }

    public static MonthDay of(Month month, int n) {
        Jdk8Methods.requireNonNull(month, "month");
        ChronoField.DAY_OF_MONTH.checkValidValue(n);
        if (n > month.maxLength()) {
            throw new DateTimeException("Illegal value for DayOfMonth field, value " + n + " is not valid for month " + month.name());
        }
        return new MonthDay(month.getValue(), n);
    }

    public static MonthDay of(int n, int n2) {
        return MonthDay.of(Month.of(n), n2);
    }

    public static MonthDay from(TemporalAccessor temporalAccessor) {
        if (temporalAccessor instanceof MonthDay) {
            return (MonthDay)temporalAccessor;
        }
        try {
            if (!IsoChronology.INSTANCE.equals(Chronology.from(temporalAccessor))) {
                temporalAccessor = LocalDate.from(temporalAccessor);
            }
            return MonthDay.of(temporalAccessor.get(ChronoField.MONTH_OF_YEAR), temporalAccessor.get(ChronoField.DAY_OF_MONTH));
        }
        catch (DateTimeException dateTimeException) {
            throw new DateTimeException("Unable to obtain MonthDay from TemporalAccessor: " + temporalAccessor + ", type " + temporalAccessor.getClass().getName());
        }
    }

    public static MonthDay parse(CharSequence charSequence) {
        return MonthDay.parse(charSequence, PARSER);
    }

    public static MonthDay parse(CharSequence charSequence, DateTimeFormatter dateTimeFormatter) {
        Jdk8Methods.requireNonNull(dateTimeFormatter, "formatter");
        return (MonthDay)dateTimeFormatter.parse(charSequence, FROM);
    }

    private MonthDay(int n, int n2) {
        this.month = n;
        this.day = n2;
    }

    public boolean isSupported(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            return temporalField == ChronoField.MONTH_OF_YEAR || temporalField == ChronoField.DAY_OF_MONTH;
        }
        return temporalField != null && temporalField.isSupportedBy(this);
    }

    public ValueRange range(TemporalField temporalField) {
        if (temporalField == ChronoField.MONTH_OF_YEAR) {
            return temporalField.range();
        }
        if (temporalField == ChronoField.DAY_OF_MONTH) {
            return ValueRange.of(1L, this.getMonth().minLength(), this.getMonth().maxLength());
        }
        return super.range(temporalField);
    }

    public int get(TemporalField temporalField) {
        return this.range(temporalField).checkValidIntValue(this.getLong(temporalField), temporalField);
    }

    public long getLong(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            switch ((ChronoField)temporalField) {
                case DAY_OF_MONTH: {
                    return this.day;
                }
                case MONTH_OF_YEAR: {
                    return this.month;
                }
            }
            throw new UnsupportedTemporalTypeException("Unsupported field: " + temporalField);
        }
        return temporalField.getFrom(this);
    }

    public int getMonthValue() {
        return this.month;
    }

    public Month getMonth() {
        return Month.of(this.month);
    }

    public int getDayOfMonth() {
        return this.day;
    }

    public boolean isValidYear(int n) {
        return !(this.day == 29 && this.month == 2 && !Year.isLeap(n));
    }

    public MonthDay withMonth(int n) {
        return this.with(Month.of(n));
    }

    public MonthDay with(Month month) {
        Jdk8Methods.requireNonNull(month, "month");
        if (month.getValue() == this.month) {
            return this;
        }
        int n = Math.min(this.day, month.maxLength());
        return new MonthDay(month.getValue(), n);
    }

    public MonthDay withDayOfMonth(int n) {
        if (n == this.day) {
            return this;
        }
        return MonthDay.of(this.month, n);
    }

    public Object query(TemporalQuery temporalQuery) {
        if (temporalQuery == TemporalQueries.chronology()) {
            return IsoChronology.INSTANCE;
        }
        return super.query(temporalQuery);
    }

    public Temporal adjustInto(Temporal temporal) {
        if (!Chronology.from(temporal).equals(IsoChronology.INSTANCE)) {
            throw new DateTimeException("Adjustment only supported on ISO date-time");
        }
        temporal = temporal.with(ChronoField.MONTH_OF_YEAR, this.month);
        return temporal.with(ChronoField.DAY_OF_MONTH, Math.min(temporal.range(ChronoField.DAY_OF_MONTH).getMaximum(), (long)this.day));
    }

    public LocalDate atYear(int n) {
        return LocalDate.of(n, this.month, this.isValidYear(n) ? this.day : 28);
    }

    public int compareTo(MonthDay monthDay) {
        int n = this.month - monthDay.month;
        if (n == 0) {
            n = this.day - monthDay.day;
        }
        return n;
    }

    public boolean isAfter(MonthDay monthDay) {
        return this.compareTo(monthDay) > 0;
    }

    public boolean isBefore(MonthDay monthDay) {
        return this.compareTo(monthDay) < 0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof MonthDay) {
            MonthDay monthDay = (MonthDay)object;
            return this.month == monthDay.month && this.day == monthDay.day;
        }
        return false;
    }

    public int hashCode() {
        return (this.month << 6) + this.day;
    }

    public String toString() {
        return new StringBuilder(10).append("--").append(this.month < 10 ? "0" : "").append(this.month).append(this.day < 10 ? "-0" : "-").append(this.day).toString();
    }

    public String format(DateTimeFormatter dateTimeFormatter) {
        Jdk8Methods.requireNonNull(dateTimeFormatter, "formatter");
        return dateTimeFormatter.format(this);
    }

    private Object writeReplace() {
        return new Ser(64, this);
    }

    private Object readResolve() {
        throw new InvalidObjectException("Deserialization via serialization delegate");
    }

    void writeExternal(DataOutput dataOutput) {
        dataOutput.writeByte(this.month);
        dataOutput.writeByte(this.day);
    }

    static MonthDay readExternal(DataInput dataInput) {
        byte by = dataInput.readByte();
        byte by2 = dataInput.readByte();
        return MonthDay.of(by, (int)by2);
    }
}

