/*
 * Decompiled with CFR 0.152.
 */
package oz.threeten.bp;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.InvalidObjectException;
import java.io.Serializable;
import oz.threeten.bp.Clock;
import oz.threeten.bp.DateTimeException;
import oz.threeten.bp.LocalDate;
import oz.threeten.bp.Month;
import oz.threeten.bp.Ser;
import oz.threeten.bp.YearMonth$1;
import oz.threeten.bp.ZoneId;
import oz.threeten.bp.chrono.Chronology;
import oz.threeten.bp.chrono.IsoChronology;
import oz.threeten.bp.format.DateTimeFormatter;
import oz.threeten.bp.format.DateTimeFormatterBuilder;
import oz.threeten.bp.format.SignStyle;
import oz.threeten.bp.jdk8.DefaultInterfaceTemporalAccessor;
import oz.threeten.bp.jdk8.Jdk8Methods;
import oz.threeten.bp.temporal.ChronoField;
import oz.threeten.bp.temporal.ChronoUnit;
import oz.threeten.bp.temporal.Temporal;
import oz.threeten.bp.temporal.TemporalAccessor;
import oz.threeten.bp.temporal.TemporalAdjuster;
import oz.threeten.bp.temporal.TemporalAmount;
import oz.threeten.bp.temporal.TemporalField;
import oz.threeten.bp.temporal.TemporalQueries;
import oz.threeten.bp.temporal.TemporalQuery;
import oz.threeten.bp.temporal.TemporalUnit;
import oz.threeten.bp.temporal.UnsupportedTemporalTypeException;
import oz.threeten.bp.temporal.ValueRange;

public final class YearMonth
extends DefaultInterfaceTemporalAccessor
implements Serializable,
Comparable,
Temporal,
TemporalAdjuster {
    public static final TemporalQuery FROM = new YearMonth$1();
    private static final long serialVersionUID = 4183400860270640070L;
    private static final DateTimeFormatter PARSER = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).toFormatter();
    private final int year;
    private final int month;

    public static YearMonth now() {
        return YearMonth.now(Clock.systemDefaultZone());
    }

    public static YearMonth now(ZoneId zoneId) {
        return YearMonth.now(Clock.system(zoneId));
    }

    public static YearMonth now(Clock clock) {
        LocalDate localDate = LocalDate.now(clock);
        return YearMonth.of(localDate.getYear(), localDate.getMonth());
    }

    public static YearMonth of(int n, Month month) {
        Jdk8Methods.requireNonNull(month, "month");
        return YearMonth.of(n, month.getValue());
    }

    public static YearMonth of(int n, int n2) {
        ChronoField.YEAR.checkValidValue(n);
        ChronoField.MONTH_OF_YEAR.checkValidValue(n2);
        return new YearMonth(n, n2);
    }

    public static YearMonth from(TemporalAccessor temporalAccessor) {
        if (temporalAccessor instanceof YearMonth) {
            return (YearMonth)temporalAccessor;
        }
        try {
            if (!IsoChronology.INSTANCE.equals(Chronology.from(temporalAccessor))) {
                temporalAccessor = LocalDate.from(temporalAccessor);
            }
            return YearMonth.of(temporalAccessor.get(ChronoField.YEAR), temporalAccessor.get(ChronoField.MONTH_OF_YEAR));
        }
        catch (DateTimeException dateTimeException) {
            throw new DateTimeException("Unable to obtain YearMonth from TemporalAccessor: " + temporalAccessor + ", type " + temporalAccessor.getClass().getName());
        }
    }

    public static YearMonth parse(CharSequence charSequence) {
        return YearMonth.parse(charSequence, PARSER);
    }

    public static YearMonth parse(CharSequence charSequence, DateTimeFormatter dateTimeFormatter) {
        Jdk8Methods.requireNonNull(dateTimeFormatter, "formatter");
        return (YearMonth)dateTimeFormatter.parse(charSequence, FROM);
    }

    private YearMonth(int n, int n2) {
        this.year = n;
        this.month = n2;
    }

    private YearMonth with(int n, int n2) {
        if (this.year == n && this.month == n2) {
            return this;
        }
        return new YearMonth(n, n2);
    }

    public boolean isSupported(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            return temporalField == ChronoField.YEAR || temporalField == ChronoField.MONTH_OF_YEAR || temporalField == ChronoField.PROLEPTIC_MONTH || temporalField == ChronoField.YEAR_OF_ERA || temporalField == ChronoField.ERA;
        }
        return temporalField != null && temporalField.isSupportedBy(this);
    }

    public boolean isSupported(TemporalUnit temporalUnit) {
        if (temporalUnit instanceof ChronoUnit) {
            return temporalUnit == ChronoUnit.MONTHS || temporalUnit == ChronoUnit.YEARS || temporalUnit == ChronoUnit.DECADES || temporalUnit == ChronoUnit.CENTURIES || temporalUnit == ChronoUnit.MILLENNIA || temporalUnit == ChronoUnit.ERAS;
        }
        return temporalUnit != null && temporalUnit.isSupportedBy(this);
    }

    public ValueRange range(TemporalField temporalField) {
        if (temporalField == ChronoField.YEAR_OF_ERA) {
            return this.getYear() <= 0 ? ValueRange.of(1L, 1000000000L) : ValueRange.of(1L, 999999999L);
        }
        return super.range(temporalField);
    }

    public int get(TemporalField temporalField) {
        return this.range(temporalField).checkValidIntValue(this.getLong(temporalField), temporalField);
    }

    public long getLong(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            switch ((ChronoField)temporalField) {
                case MONTH_OF_YEAR: {
                    return this.month;
                }
                case PROLEPTIC_MONTH: {
                    return this.getProlepticMonth();
                }
                case YEAR_OF_ERA: {
                    return this.year < 1 ? 1 - this.year : this.year;
                }
                case YEAR: {
                    return this.year;
                }
                case ERA: {
                    return this.year < 1 ? 0 : 1;
                }
            }
            throw new UnsupportedTemporalTypeException("Unsupported field: " + temporalField);
        }
        return temporalField.getFrom(this);
    }

    private long getProlepticMonth() {
        return (long)this.year * 12L + (long)(this.month - 1);
    }

    public int getYear() {
        return this.year;
    }

    public int getMonthValue() {
        return this.month;
    }

    public Month getMonth() {
        return Month.of(this.month);
    }

    public boolean isLeapYear() {
        return IsoChronology.INSTANCE.isLeapYear(this.year);
    }

    public boolean isValidDay(int n) {
        return n >= 1 && n <= this.lengthOfMonth();
    }

    public int lengthOfMonth() {
        return this.getMonth().length(this.isLeapYear());
    }

    public int lengthOfYear() {
        return this.isLeapYear() ? 366 : 365;
    }

    public YearMonth with(TemporalAdjuster temporalAdjuster) {
        return (YearMonth)temporalAdjuster.adjustInto(this);
    }

    public YearMonth with(TemporalField temporalField, long l) {
        if (temporalField instanceof ChronoField) {
            ChronoField chronoField = (ChronoField)temporalField;
            chronoField.checkValidValue(l);
            switch (chronoField) {
                case MONTH_OF_YEAR: {
                    return this.withMonth((int)l);
                }
                case PROLEPTIC_MONTH: {
                    return this.plusMonths(l - this.getLong(ChronoField.PROLEPTIC_MONTH));
                }
                case YEAR_OF_ERA: {
                    return this.withYear((int)(this.year < 1 ? 1L - l : l));
                }
                case YEAR: {
                    return this.withYear((int)l);
                }
                case ERA: {
                    return this.getLong(ChronoField.ERA) == l ? this : this.withYear(1 - this.year);
                }
            }
            throw new UnsupportedTemporalTypeException("Unsupported field: " + temporalField);
        }
        return (YearMonth)temporalField.adjustInto(this, l);
    }

    public YearMonth withYear(int n) {
        ChronoField.YEAR.checkValidValue(n);
        return this.with(n, this.month);
    }

    public YearMonth withMonth(int n) {
        ChronoField.MONTH_OF_YEAR.checkValidValue(n);
        return this.with(this.year, n);
    }

    public YearMonth plus(TemporalAmount temporalAmount) {
        return (YearMonth)temporalAmount.addTo(this);
    }

    public YearMonth plus(long l, TemporalUnit temporalUnit) {
        if (temporalUnit instanceof ChronoUnit) {
            switch ((ChronoUnit)temporalUnit) {
                case MONTHS: {
                    return this.plusMonths(l);
                }
                case YEARS: {
                    return this.plusYears(l);
                }
                case DECADES: {
                    return this.plusYears(Jdk8Methods.safeMultiply(l, 10));
                }
                case CENTURIES: {
                    return this.plusYears(Jdk8Methods.safeMultiply(l, 100));
                }
                case MILLENNIA: {
                    return this.plusYears(Jdk8Methods.safeMultiply(l, 1000));
                }
                case ERAS: {
                    return this.with(ChronoField.ERA, Jdk8Methods.safeAdd(this.getLong(ChronoField.ERA), l));
                }
            }
            throw new UnsupportedTemporalTypeException("Unsupported unit: " + temporalUnit);
        }
        return (YearMonth)temporalUnit.addTo(this, l);
    }

    public YearMonth plusYears(long l) {
        if (l == 0L) {
            return this;
        }
        int n = ChronoField.YEAR.checkValidIntValue((long)this.year + l);
        return this.with(n, this.month);
    }

    public YearMonth plusMonths(long l) {
        if (l == 0L) {
            return this;
        }
        long l2 = (long)this.year * 12L + (long)(this.month - 1);
        long l3 = l2 + l;
        int n = ChronoField.YEAR.checkValidIntValue(Jdk8Methods.floorDiv(l3, 12L));
        int n2 = Jdk8Methods.floorMod(l3, 12) + 1;
        return this.with(n, n2);
    }

    public YearMonth minus(TemporalAmount temporalAmount) {
        return (YearMonth)temporalAmount.subtractFrom(this);
    }

    public YearMonth minus(long l, TemporalUnit temporalUnit) {
        return l == Long.MIN_VALUE ? this.plus(Long.MAX_VALUE, temporalUnit).plus(1L, temporalUnit) : this.plus(-l, temporalUnit);
    }

    public YearMonth minusYears(long l) {
        return l == Long.MIN_VALUE ? this.plusYears(Long.MAX_VALUE).plusYears(1L) : this.plusYears(-l);
    }

    public YearMonth minusMonths(long l) {
        return l == Long.MIN_VALUE ? this.plusMonths(Long.MAX_VALUE).plusMonths(1L) : this.plusMonths(-l);
    }

    public Object query(TemporalQuery temporalQuery) {
        if (temporalQuery == TemporalQueries.chronology()) {
            return IsoChronology.INSTANCE;
        }
        if (temporalQuery == TemporalQueries.precision()) {
            return ChronoUnit.MONTHS;
        }
        if (temporalQuery == TemporalQueries.localDate() || temporalQuery == TemporalQueries.localTime() || temporalQuery == TemporalQueries.zone() || temporalQuery == TemporalQueries.zoneId() || temporalQuery == TemporalQueries.offset()) {
            return null;
        }
        return super.query(temporalQuery);
    }

    public Temporal adjustInto(Temporal temporal) {
        if (!Chronology.from(temporal).equals(IsoChronology.INSTANCE)) {
            throw new DateTimeException("Adjustment only supported on ISO date-time");
        }
        return temporal.with(ChronoField.PROLEPTIC_MONTH, this.getProlepticMonth());
    }

    public long until(Temporal temporal, TemporalUnit temporalUnit) {
        YearMonth yearMonth = YearMonth.from(temporal);
        if (temporalUnit instanceof ChronoUnit) {
            long l = yearMonth.getProlepticMonth() - this.getProlepticMonth();
            switch ((ChronoUnit)temporalUnit) {
                case MONTHS: {
                    return l;
                }
                case YEARS: {
                    return l / 12L;
                }
                case DECADES: {
                    return l / 120L;
                }
                case CENTURIES: {
                    return l / 1200L;
                }
                case MILLENNIA: {
                    return l / 12000L;
                }
                case ERAS: {
                    return yearMonth.getLong(ChronoField.ERA) - this.getLong(ChronoField.ERA);
                }
            }
            throw new UnsupportedTemporalTypeException("Unsupported unit: " + temporalUnit);
        }
        return temporalUnit.between(this, yearMonth);
    }

    public LocalDate atDay(int n) {
        return LocalDate.of(this.year, this.month, n);
    }

    public LocalDate atEndOfMonth() {
        return LocalDate.of(this.year, this.month, this.lengthOfMonth());
    }

    public int compareTo(YearMonth yearMonth) {
        int n = this.year - yearMonth.year;
        if (n == 0) {
            n = this.month - yearMonth.month;
        }
        return n;
    }

    public boolean isAfter(YearMonth yearMonth) {
        return this.compareTo(yearMonth) > 0;
    }

    public boolean isBefore(YearMonth yearMonth) {
        return this.compareTo(yearMonth) < 0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof YearMonth) {
            YearMonth yearMonth = (YearMonth)object;
            return this.year == yearMonth.year && this.month == yearMonth.month;
        }
        return false;
    }

    public int hashCode() {
        return this.year ^ this.month << 27;
    }

    public String toString() {
        int n = Math.abs(this.year);
        StringBuilder stringBuilder = new StringBuilder(9);
        if (n < 1000) {
            if (this.year < 0) {
                stringBuilder.append(this.year - 10000).deleteCharAt(1);
            } else {
                stringBuilder.append(this.year + 10000).deleteCharAt(0);
            }
        } else {
            stringBuilder.append(this.year);
        }
        return stringBuilder.append(this.month < 10 ? "-0" : "-").append(this.month).toString();
    }

    public String format(DateTimeFormatter dateTimeFormatter) {
        Jdk8Methods.requireNonNull(dateTimeFormatter, "formatter");
        return dateTimeFormatter.format(this);
    }

    private Object writeReplace() {
        return new Ser(68, this);
    }

    private Object readResolve() {
        throw new InvalidObjectException("Deserialization via serialization delegate");
    }

    void writeExternal(DataOutput dataOutput) {
        dataOutput.writeInt(this.year);
        dataOutput.writeByte(this.month);
    }

    static YearMonth readExternal(DataInput dataInput) {
        int n = dataInput.readInt();
        byte by = dataInput.readByte();
        return YearMonth.of(n, by);
    }
}

